/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.query.Query;
import com.sas.query.models.Table;
import com.sas.query.visuals.DataFilterSection;
import com.sas.query.visuals.JReferableTreeView;
import com.sas.query.visuals.StandardView;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;

public class WhereBuilder
extends StandardView
implements Cloneable {
    private JSplitPane m_splitter;
    private JReferableTreeView m_referableTreeView;
    private DataFilterSection m_dataFilterSection;

    public WhereBuilder(Query query) {
        super(query);
        this._initialize();
    }

    protected void _initialize() {
        this.setBackground(SystemColor.control);
        this._constructPanel();
    }

    public void removeAllListeners() {
        if (this.m_splitter != null) {
            this.m_splitter.removeAll();
            this.m_splitter = null;
        }
        this.removeAll();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
        if (this.m_splitter != null) {
            this.m_splitter.removeAll();
            this.m_splitter = null;
        }
        if (this.m_referableTreeView != null) {
            this.m_referableTreeView.removeAll();
            this.m_referableTreeView = null;
        }
        if (this.m_dataFilterSection != null) {
            this.m_dataFilterSection.removeAll();
            this.m_dataFilterSection.closing();
            this.m_dataFilterSection = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WhereBuilder newObject = (WhereBuilder)super.clone();
        newObject.addNotify();
        newObject.m_query = (Query)this.m_query.clone();
        newObject._initialize();
        return newObject;
    }

    protected void _constructPanel() {
        this.m_splitter = new JSplitPane();
        this.m_splitter.setBorder(BorderFactory.createEmptyBorder());
        this.m_referableTreeView = new JReferableTreeView(this.m_query, 2);
        this.m_referableTreeView.setDefaultAction(1);
        this.m_splitter.setLeftComponent(this.m_referableTreeView);
        this.m_dataFilterSection = new DataFilterSection(this.m_query, 1L);
        this.m_splitter.setRightComponent(this.m_dataFilterSection);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gridBagLayout.setConstraints(this.m_splitter, gbc);
        this.add(this.m_splitter);
        this.m_splitter.setDividerLocation(210);
    }

    public Query getModel() {
        return this.m_query;
    }

    public void validateQuery() {
        this.m_query.validateQuery();
    }

    public String getSql() {
        return this.m_query.getSql();
    }

    public String getSelectedColumnString() {
        return this.m_query.getSelectedColumnString();
    }

    public String getWhereString() {
        return this.m_query.getWhereString();
    }

    public String getOrderByString() {
        return this.m_query.getOrderByString();
    }

    public String getGroupByString() {
        return this.m_query.getGroupByString();
    }

    public String getHavingString() {
        return this.m_query.getHavingString();
    }

    public Table setSelectedTable(String tableName) {
        return this.m_query.addTable(tableName);
    }

    public void addAllColumnsSelected(Table table) {
        this.m_query.addResultItems(table);
    }
}

