/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenList;
import com.sas.query.parser.Tokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

public class QueryUtils {
    static String QuoteChar = "'";
    static char QuoteCharChar = (char)39;
    static String DoubleQuoteChar = "'";
    static char DoubleQuoteCharChar = (char)39;
    public static final int MAX_FORMATED_LINE_LENGTH = 72;
    private static String cryType = "SASPROPRIETARY";

    public static int countOccurancesOfSubstring(String searchingIn, String searchingFor) {
        searchingIn = searchingIn.toUpperCase();
        searchingFor = searchingFor.toUpperCase();
        int count = 0;
        while (searchingIn.indexOf(searchingFor) > -1) {
            ++count;
            if (searchingIn.indexOf(searchingFor) + searchingFor.length() >= searchingIn.length()) {
                searchingIn = "";
                continue;
            }
            searchingIn = searchingIn.substring(searchingIn.indexOf(searchingFor) + searchingFor.length());
        }
        return count;
    }

    public static String unDoubleQuotes(String input, char charToUnDouble) {
        StringBuffer returnBuf = new StringBuffer();
        boolean bPreviousCharWasQuote = false;
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (bPreviousCharWasQuote && c == charToUnDouble) {
                bPreviousCharWasQuote = false;
                continue;
            }
            returnBuf.append(c);
            bPreviousCharWasQuote = c == charToUnDouble;
        }
        return returnBuf.toString();
    }

    public static String stripAndDouble(String input) {
        return QueryUtils.stripAndDouble(input, QuoteCharChar, QuoteChar);
    }

    public static String stripAndDouble(String input, char quoteChar, String quoteCharString) {
        int last;
        int first;
        String trimmedInput = input.trim();
        boolean wasQuotedString = false;
        char m_quoteChar = quoteChar;
        String m_quoteCharString = quoteCharString;
        if (trimmedInput.startsWith(QuoteChar) && trimmedInput.endsWith(QuoteChar)) {
            first = trimmedInput.indexOf(QuoteChar);
            if (first != (last = trimmedInput.lastIndexOf(QuoteChar))) {
                wasQuotedString = true;
                m_quoteChar = QuoteCharChar;
                m_quoteCharString = QuoteChar;
                input = first == last + 1 ? "" : trimmedInput.substring(first + 1, last);
            }
        } else if (trimmedInput.startsWith(DoubleQuoteChar) && trimmedInput.endsWith(DoubleQuoteChar) && (first = trimmedInput.indexOf(DoubleQuoteChar)) != (last = trimmedInput.lastIndexOf(DoubleQuoteChar))) {
            wasQuotedString = true;
            m_quoteChar = DoubleQuoteCharChar;
            m_quoteCharString = DoubleQuoteChar;
            input = first == last + 1 ? "" : trimmedInput.substring(first + 1, last);
        }
        StringBuffer buf = new StringBuffer();
        boolean deferredQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!wasQuotedString) {
                buf.append(c);
                if (c != m_quoteChar) continue;
                buf.append(c);
                continue;
            }
            if (!deferredQuote) {
                if (c == m_quoteChar) {
                    deferredQuote = true;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == m_quoteChar) {
                buf.append(c);
                buf.append(c);
                deferredQuote = false;
                continue;
            }
            buf.append(m_quoteChar);
            buf.append(m_quoteChar);
            deferredQuote = false;
            buf.append(c);
        }
        if (deferredQuote) {
            buf.append(m_quoteChar);
            buf.append(m_quoteChar);
            deferredQuote = false;
        }
        return buf.toString();
    }

    public static final boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public static final boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equalsIgnoreCase(s2);
    }

    public static byte[] convertHexStringToByteArray(String strValue) {
        byte[] byteArray = new byte[strValue.length() / 2];
        int byteIndex = 0;
        int length = strValue.length();
        byte[] charArray = strValue.getBytes();
        for (int index = 0; index < length; index += 2) {
            byteArray[byteIndex++] = QueryUtils.convertHexCharsToByte(charArray[index], charArray[index + 1]);
        }
        return byteArray;
    }

    protected static byte convertHexCharsToByte(byte leftChar, byte rightChar) {
        int result = 0;
        boolean negative = false;
        int limit = -2147483647;
        int multmin = limit / 16;
        int digit = leftChar >= 65 ? leftChar - 65 + 10 : leftChar - 48;
        result = -digit;
        digit = rightChar >= 65 ? rightChar - 65 + 10 : rightChar - 48;
        result *= 16;
        result -= digit;
        if (negative) {
            return (byte)result;
        }
        return (byte)(-result);
    }

    public static int[] convertHexStringToIntArray(String strValue) {
        int[] byteArray = new int[strValue.length() / 8];
        int byteIndex = 0;
        for (int index = 0; index < strValue.length(); index += 8) {
            try {
                String temp = strValue.substring(index, index + 8);
                byteArray[byteIndex++] = (int)Long.parseLong(temp, 16);
                continue;
            }
            catch (Exception e) {
                MessageHandler.addStaticError(e);
            }
        }
        return byteArray;
    }

    public static int[] convertStringToIntArray(String strValue) {
        int[] array = new int[strValue.length()];
        for (int i = 0; i < strValue.length(); ++i) {
            char c = strValue.charAt(i);
            array[i] = Character.getNumericValue(c);
        }
        return array;
    }

    public static String convertIntArrayToString(int[] intArray) {
        String retval = null;
        char[] charArray = new char[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            charArray[i] = (char)intArray[i];
        }
        retval = new String(charArray);
        return retval;
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        String returnValue = "";
        for (int index = 0; index < byteArray.length; ++index) {
            returnValue = returnValue + QueryUtils.getByteAsHexChar(byteArray[index], 1);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(byteArray[index], 0);
        }
        return returnValue;
    }

    public static String convertIntArrayToHexString(int[] intArray) {
        String returnValue = "";
        for (int index = 0; index < intArray.length; ++index) {
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 7);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 6);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 5);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 4);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 3);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 2);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 1);
            returnValue = returnValue + QueryUtils.getByteAsHexChar(intArray[index], 0);
        }
        return returnValue;
    }

    public static char getByteAsHexChar(int value, int index) {
        byte b = (byte)(value >> index * 4 & 0xF);
        char c = Character.forDigit(b, 16);
        if (c >= 'a' && c <= 'f') {
            c = (char)(c - 32);
        }
        return c;
    }

    public static void dumpEnvironment() {
        QueryUtils.dumpEnvironment(System.out);
    }

    public static void dumpEnvironment(PrintStream x) {
        Properties props = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        int i = 0;
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            x.println(propName + "=" + propValue);
            if (++i != 5) continue;
            x.println("");
            i = 0;
        }
    }

    public static String formatSql(String strSql, DataSource dataSource) {
        StringBuffer returnValue = new StringBuffer();
        StringBuffer formattedLine = new StringBuffer();
        StringBuffer buffer = new StringBuffer();
        Tokenizer tokenizer = new Tokenizer(dataSource, strSql, dataSource.getMessageHandler());
        TokenList tokenList = tokenizer.getSimpleTokens();
        int index = 0;
        while (index < tokenList.size()) {
            Token token = tokenList.elementAt(index++);
            Token nextToken = null;
            int length = token.getLength();
            if (index < tokenList.size()) {
                nextToken = tokenList.elementAt(index);
                length = nextToken.getStart() - token.getStart() + 1;
            } else {
                length = strSql.length() - token.getStart() + 1;
            }
            if (token.succeedingChar() == '\n') {
                length = token.getLength() + 1;
            }
            if (token.isKeyword("FROM") || token.isKeyword("WHERE") || token.isKeyword("GROUP") && nextToken != null && nextToken.isKeyword("BY") || token.isKeyword("HAVING") || token.isKeyword("ORDER") && nextToken != null && nextToken.isKeyword("BY") || token.isKeyword("UNION") || token.isKeyword("INNER") || token.isKeyword("LEFT") || token.isKeyword("RIGHT") || token.isKeyword("ON") || token.isKeyword("EXCEPT") || token.isKeyword("INTERCEPT")) {
                if (token.isKeyword("INNER") || token.isKeyword("LEFT") || token.isKeyword("RIGHT") || token.isKeyword("ON")) {
                    QueryUtils._pushFormatLine(true, returnValue, formattedLine, buffer);
                } else {
                    QueryUtils._pushFormatLine(false, returnValue, formattedLine, buffer);
                }
            }
            buffer.append(tokenizer.getInputString().substring(token.getStart(), token.getStart() + length - 1));
            if (!token.isOperator("OR") && !token.isOperator("AND") && !token.isType(13, 40)) continue;
            QueryUtils._pushFormatBuffer(true, returnValue, formattedLine, buffer);
        }
        formattedLine.append(buffer);
        returnValue.append(formattedLine);
        return returnValue.toString();
    }

    protected static void _pushFormatLine(boolean indent, StringBuffer returnValue, StringBuffer formattedLine, StringBuffer buffer) {
        if (buffer.length() > 0) {
            QueryUtils._pushFormatBuffer(true, returnValue, formattedLine, buffer);
        }
        if (formattedLine.length() > 0) {
            returnValue.append(formattedLine);
            char lastchar = returnValue.charAt(returnValue.length() - 1);
            if (lastchar != '\n' && lastchar != '\t') {
                returnValue.append("\n");
                if (indent) {
                    returnValue.append("\t");
                }
            }
            formattedLine.setLength(0);
        }
    }

    protected static void _pushFormatBuffer(boolean indent, StringBuffer returnValue, StringBuffer formattedLine, StringBuffer buffer) {
        if (buffer.length() < 72 && buffer.length() + formattedLine.length() > 72) {
            returnValue.append(formattedLine);
            char lastchar = returnValue.charAt(returnValue.length() - 1);
            if (lastchar != '\n' && lastchar != '\t') {
                returnValue.append("\n");
                if (returnValue.toString().endsWith("ON \n")) {
                    returnValue.append("\t");
                }
                if (indent) {
                    returnValue.append("\t");
                }
            }
            formattedLine.setLength(0);
            formattedLine.append(buffer);
        } else {
            formattedLine.append(buffer);
        }
        buffer.setLength(0);
    }

    public static void printStackTrace() {
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    public static int charCount(String parm, char targetChar) {
        String submittedString = parm;
        int charCount = 0;
        int previousIndex = 0;
        while (submittedString.indexOf(targetChar, previousIndex) > -1) {
            ++charCount;
            previousIndex = submittedString.indexOf(targetChar, previousIndex) + 1;
        }
        return charCount;
    }

    public static String doubleslashes(String target) {
        String outString = new String();
        int index = 0;
        index = target.indexOf("\\");
        if (index < 0) {
            return target;
        }
        while (index >= 0) {
            outString = outString.concat(target.substring(0, index + 1) + '\\');
            if (target.length() > index + 1) {
                target = target.substring(index + 1);
            } else {
                index = -1;
                target = "";
            }
            index = target.indexOf("\\");
        }
        if (target.length() > 0) {
            outString = outString.concat(target);
        }
        return outString;
    }

    public static String URLEncoder(String stringtoencode) {
        return URLEncoder.encode(stringtoencode);
    }

    public static String URLDecoder(String stringtodecode) {
        if (stringtodecode == null) {
            return null;
        }
        String returnStr = new String();
        int length = stringtodecode.length();
        for (int i = 0; i < length; ++i) {
            char curChar = stringtodecode.charAt(i);
            String curCharStr = stringtodecode.substring(i, i + 1);
            if (curChar == '+') {
                returnStr = returnStr.concat(" ");
                continue;
            }
            if (curChar >= 'a' && curChar <= 'z' || curChar >= 'A' && curChar <= 'Z' || curChar >= '0' && curChar <= '9') {
                returnStr = returnStr.concat(curCharStr);
                continue;
            }
            if (curChar == '%') {
                String hexstr = new String("0x").concat(stringtodecode.substring(i + 1, i + 3));
                i += 2;
                returnStr = returnStr.concat(String.valueOf((char)Integer.decode(hexstr).intValue()));
                continue;
            }
            returnStr = returnStr.concat(curCharStr);
        }
        return returnStr;
    }

    public static String safeEncrypt(String input) {
        String binaryEncrypted = QueryUtils.encrypt(input);
        if (binaryEncrypted == null) {
            return null;
        }
        byte[] expandedBinary = new byte[binaryEncrypted.length()];
        for (int i = 0; i < binaryEncrypted.length(); ++i) {
            expandedBinary[i] = (byte)binaryEncrypted.charAt(i);
        }
        String safeEncryption = QueryUtils.convertByteArrayToHexString(expandedBinary);
        return safeEncryption;
    }

    public static String safeDecrypt(String input) {
        if (input == null) {
            return null;
        }
        byte[] expandedBinary = QueryUtils.convertHexStringToByteArray(input);
        String ret = "";
        for (int i = 0; i < expandedBinary.length; ++i) {
            ret = ret + (char)expandedBinary[i];
        }
        ret = QueryUtils.decrypt(ret);
        return ret;
    }

    public static String encrypt(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = intext.getBytes();
            ByteArrayOutputStream outstr = new ByteArrayOutputStream(ci.getCipherTextLength(inbytes.length));
            int encryptLength = ci.encrypt(inbytes, 0, inbytes.length, (OutputStream)outstr);
            byte[] outbytes = outstr.toByteArray();
            ret = "";
            for (int i = 0; i < outbytes.length; ++i) {
                ret = ret + (char)outbytes[i];
            }
        }
        catch (Throwable t) {
            System.err.println("Internal error:  is netutil.jar installed?\n" + t);
        }
        return ret;
    }

    public static String decrypt(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = new byte[intext.length()];
            for (int i = 0; i < intext.length(); ++i) {
                char c = intext.charAt(i);
                inbytes[i] = (byte)c;
            }
            ByteArrayInputStream instr = new ByteArrayInputStream(inbytes);
            byte[] result = new byte[ci.getMaxPlainTextLength(inbytes.length)];
            int returnLength = ci.decrypt((InputStream)instr, inbytes.length, result, 0);
            ret = new String(result, 0, returnLength);
        }
        catch (Throwable t) {
            System.err.println("Internal error:  is netutil.jar installed?\n" + t);
            ret = null;
        }
        return ret;
    }

    public static void main(String[] args) {
        String start = "heABCDEFGHLKJSOIJWERLKWJ LDSFJ SF SAFSF person ";
        for (int j = 0; j < 20; ++j) {
            System.out.println(start);
            String r = QueryUtils.safeEncrypt(start);
            System.out.println(r);
            String t = QueryUtils.safeDecrypt(r);
            System.out.println(t);
            if (t != null) {
                System.out.println(" compare gives                     RESULT:" + start.compareTo(t));
            } else {
                System.out.println("ERROR:  NULL return from decrypt    ERROR");
            }
            start = start + "a";
        }
    }
}

