/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.awt.Button;
import com.sas.awt.Container;
import com.sas.awt.TextArea;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.StringDataInterface;
import com.sas.query.JQueryDialog;
import com.sas.query.QueryEvent;
import com.sas.query.QueryEventListener;
import com.sas.query.QueryString;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import com.sas.rmi.Connection;
import com.sas.util.Util;
import com.sas.visuals.CompositePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class QueryTextArea
extends CompositePanel
implements ActionListener,
TextListener,
QueryEventListener,
PropertyChangeListener,
StringDataInterface {
    static final long serialVersionUID = -4473625631484032470L;
    static final String RB_KEY = "QueryTextArea.";
    static final String RB_KEY_BEAN = "QueryTextAreaBeanInfo.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.query.QueryStringInterface"};
    static QueryResource bundle = new QueryResource(QueryTextArea.class);
    protected QueryString m_queryString;
    protected Button m_queryEditButton;
    protected Button m_queryApplyButton;
    protected TextArea m_sqlText;
    protected String m_viewName = "_qtxtvw";
    protected JQueryDialog m_editDialog;
    protected boolean m_unappliedChangesFlag = false;
    protected static int defaultWidth = 320;
    protected static int defaultHeight = 70;

    public QueryTextArea() {
    }

    public QueryTextArea(QueryString qString) {
        this();
        this.setModel(qString);
        this.m_viewName = "_qtxtvw";
    }

    public void initializeComponent() {
        super.initializeComponent();
        this._createComponents();
    }

    public String getEditButtonText() {
        return this.m_queryEditButton.getText();
    }

    public String getApplyButtonText() {
        return this.m_queryApplyButton.getText();
    }

    public void setEditButtonText(String newText) {
        this.setButtonText(this.m_queryEditButton, newText);
    }

    public void setApplyButtonText(String newText) {
        this.setButtonText(this.m_queryApplyButton, newText);
    }

    private void setButtonText(Button b, String newText) {
        b.setText(newText);
        this.invalidate();
        this.getParent().validate();
    }

    public String getText() {
        String retText = null;
        if (this.m_sqlText != null) {
            retText = this.m_sqlText.getText();
        }
        if (retText == null) {
            retText = "";
        }
        return retText;
    }

    public void setText(String param0) {
        String oldValue = this.getText();
        if (Util.unequal((Object)param0, (Object)oldValue)) {
            if (this.m_sqlText != null) {
                this.m_sqlText.setText(param0);
                this.setDirtyFlag();
            }
            this.firePropertyChange("text", oldValue, param0);
        }
    }

    public void setDefaultViewName(String name) {
        this.m_viewName = name;
    }

    public String getDefaultViewName() {
        if (this.m_viewName == null) {
            this.setDefaultViewName(this.m_queryString.getViewName());
        }
        return this.m_viewName;
    }

    private void _createComponents() {
        Container m_queryContainer = new Container();
        m_queryContainer.setInsets(9, 4, 4, 4);
        GridBagLayout qLayout = new GridBagLayout();
        m_queryContainer.setLayout((LayoutManager)qLayout);
        this.m_queryEditButton = new Button(bundle.getString("QueryTextArea.EditButton.txt"));
        this.m_queryEditButton.setEnabled(this.m_queryString != null);
        this.m_queryApplyButton = new Button(bundle.getString("QueryTextArea.ApplyButton.txt"));
        this.m_queryApplyButton.setEnabled(this.m_queryString != null);
        this.m_sqlText = new TextArea("", 4, 40, 1);
        this.m_sqlText.setColumns(40);
        this.m_sqlText.setKeystrokeUpdate(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.05;
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 4, 4, 4);
        m_queryContainer.add((Component)this.m_queryEditButton, (Object)gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.05;
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        m_queryContainer.add((Component)this.m_queryApplyButton, (Object)gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 4, 4, 4);
        m_queryContainer.add((Component)this.m_sqlText, (Object)gbc);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 1;
        gbc.gridheight = 4;
        gbc.gridwidth = 8;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)m_queryContainer, gbc);
        this.m_queryEditButton.addActionListener((ActionListener)this);
        this.m_queryApplyButton.addActionListener((ActionListener)this);
        this.m_sqlText.addTextListener((TextListener)this);
    }

    private Connection getConnection() {
        Connection retCon = null;
        if (this.m_queryString != null) {
            retCon = this.m_queryString.getConnection();
        }
        return retCon;
    }

    private void p(Object t) {
        System.out.println((String)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEdit() {
        Frame pFrame = WindowUtil.getParentFrame((Component)((Object)this));
        Cursor curCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.m_editDialog == null) {
                this.m_editDialog = new JQueryDialog(pFrame, this.m_queryString, bundle.getString("QueryTextArea.EditorTitle.txt"));
                Dimension dialogSize = this.m_editDialog.getPreferredSize();
                this.m_editDialog.setSize(dialogSize);
            } else {
                this.m_editDialog.setQueryString(this.m_queryString);
            }
            if (this.m_queryString.getConnection().isConnected()) {
                this.m_editDialog.setVisible(true);
            }
            if (this.m_editDialog.getReturnValue() == 1) {
                this.m_sqlText.setText(this.m_queryString.getFormattedSQL());
                this.setDirtyFlag();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.setCursor(curCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onApply() {
        if (this.m_queryString != null) {
            Cursor curCursor = this.getCursor();
            String sql = this.m_sqlText.getText();
            if (!sql.equalsIgnoreCase("SELECT  \nFROM") && !sql.equals("")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.m_queryString.setSQL(this.m_sqlText.getText());
                    this.clearDirtyFlag();
                    this.m_queryString.saveQueryToView(this.m_viewName);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    this.setCursor(curCursor);
                }
            }
            if (this.m_queryEditButton.isVisible()) {
                this.m_queryEditButton.requestFocus();
            }
        }
    }

    public void setCursor(Cursor tmpCursor) {
        super.setCursor(tmpCursor);
        this.m_queryApplyButton.setCursor(tmpCursor);
        this.m_queryEditButton.setCursor(tmpCursor);
        this.m_sqlText.setCursor(tmpCursor);
    }

    public void setEditState(boolean s) {
        boolean oldVal = this.m_queryEditButton.isEnabled();
        if (s != oldVal) {
            this.m_queryEditButton.setEnabled(s);
            this.firePropertyChange("editState", null, null);
        }
    }

    public void setEditState() {
        if (this.m_queryString != null) {
            boolean state = this.m_queryString.getConnection() != null;
            this.setEditState(state);
        }
    }

    public void setApplyState() {
        boolean isPossibleToEnable = false;
        if (this.m_queryString != null && this.isConnected()) {
            isPossibleToEnable = true;
        }
        if (isPossibleToEnable) {
            this.setApplyState(this.getDirtyFlag());
        } else {
            this.setApplyState(false);
        }
    }

    public void setApplyState(boolean s) {
        boolean oldVal = this.m_queryApplyButton.isEnabled();
        if (s != oldVal) {
            this.m_queryApplyButton.setEnabled(s);
            this.firePropertyChange("applyState", null, null);
        }
    }

    public boolean isConnected() {
        boolean isIt = false;
        if (this.getConnection() != null) {
            isIt = this.getConnection().isConnected();
        }
        return isIt;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public void setEnabled(boolean param0) {
        Component[] allcomps = this.getComponents();
        boolean oldValue = this.isEnabled();
        if (param0 != oldValue) {
            super.setEnabled(param0);
            for (int i = 0; i < allcomps.length; ++i) {
                allcomps[i].setEnabled(param0);
            }
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"enabled", (boolean)param0);
        }
    }

    public void setApplyButtonVisible(boolean visible) {
        this.m_queryApplyButton.setVisible(visible);
    }

    public void setModel(QueryString newModel) {
        QueryString oldModel = this.m_queryString;
        String oldView = "";
        if (this.m_queryString != null) {
            this.m_queryString.removeQueryEventListener(this);
            this.m_queryString.removePropertyChangeListener(this);
            this.m_queryString = null;
        } else if (oldModel != null) {
            oldView = oldModel.getViewName();
        }
        if (newModel != null) {
            this.m_queryString = newModel;
            this.m_queryString.addPropertyChangeListener(this);
            this.m_queryString.addQueryEventListener(this);
            String view1 = this.m_queryString.getViewName();
            if (view1 != null) {
                this.setDefaultViewName(view1);
            }
            if (this.getConnection() == null) {
                this.p(bundle.getString("QueryTextArea.NoConnectionMessage.fmt.txt"));
            } else {
                this.m_sqlText.setText(this.m_queryString.getFormattedSQL());
                this.clearDirtyFlag();
                this.setEditState(true);
                this.setApplyState(false);
            }
        }
        this.firePropertyChange("model", oldModel, newModel);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "text"}, {"Bound", "true"}, {"Description", bundle.getString("QueryTextAreaBeanInfo.SqlTextDesc.txt")}}, {{"Name", "model"}, {"Expert", "true"}, {"Bound", "true"}, {"Description", bundle.getString("QueryTextAreaBeanInfo.QueryStringDesc.txt")}}};
        ExtendedBeanInfo ebi = TextArea.getExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = bundle.getString("QueryTextAreaBeanInfo.ShortDesc.txt");
        return ebi;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredI = new Vector<String[]>();
        requiredI.addElement(requiredInterfacesString);
        return requiredI;
    }

    public void refresh(ModelInterface tmpModel) {
        boolean isTextBlank;
        super.refresh(tmpModel);
        boolean bl = isTextBlank = this.getText() == null || this.getText().equals("");
        if (this.isDesignTime() && isTextBlank && tmpModel == null) {
            this.setText("");
        }
    }

    public void detachModel(ModelInterface tmpModel) {
        if (tmpModel != null) {
            super.detachModel(tmpModel);
            try {
                this.setModel(null);
            }
            catch (ClassCastException e) {
                this.p(e.getLocalizedMessage());
            }
        }
    }

    public void attachModel(ModelInterface tmpModel) {
        if (tmpModel != null) {
            super.attachModel(tmpModel);
            try {
                QueryString x = (QueryString)tmpModel;
                this.setModel(x);
            }
            catch (ClassCastException e) {
                this.p(e.getLocalizedMessage());
            }
        } else {
            this.setModel(null);
        }
    }

    protected void applyToModelIfPendingChanges() {
        String viewerSQL;
        if (this.m_queryString != null && !(viewerSQL = this.m_sqlText.getText()).equalsIgnoreCase(this.m_queryString.getSQL())) {
            this.m_queryString.setSQL(viewerSQL);
            this.clearDirtyFlag();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Button source = (Button)e.getSource();
        if (source == this.m_queryEditButton) {
            this.applyToModelIfPendingChanges();
            this.onEdit();
        } else if (source == this.m_queryApplyButton) {
            this.onApply();
        }
    }

    protected void setDirtyFlag() {
        if (this.m_unappliedChangesFlag) {
            return;
        }
        this.m_unappliedChangesFlag = true;
        this.setApplyState();
    }

    protected void clearDirtyFlag() {
        if (!this.m_unappliedChangesFlag) {
            return;
        }
        this.m_unappliedChangesFlag = false;
        this.setApplyState();
    }

    protected boolean getDirtyFlag() {
        return this.m_unappliedChangesFlag;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        Object source = e.getSource();
        if (source == this.m_sqlText) {
            this.setDirtyFlag();
        }
        this.setEditState();
        this.setApplyState();
    }

    public void modelChangeCallback(ModelChangeEvent event) {
        this.setText(this.m_queryString.getFormattedSQL());
        this.clearDirtyFlag();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getSource() == this.m_queryString) {
            String property = e.getPropertyName();
            if (property.equals("connection")) {
                this.setEditState();
                this.setApplyState();
            } else if (property.equals("sql")) {
                QueryString model = (QueryString)e.getSource();
                this.setText(model.getFormattedSQL());
            }
        }
    }

    @Override
    public void queryActionPerformed(QueryEvent event) {
        String actionName = event.getActionName();
        if (actionName == QueryEvent.SAVE_VIEW_EVENT || actionName == QueryEvent.OPEN_VIEW_EVENT) {
            // empty if block
        }
    }
}

