/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.query.Query;
import com.sas.query.QueryEvent;
import com.sas.query.QueryEventListener;
import com.sas.query.QueryException;
import com.sas.query.QueryStringInterface;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.visuals.QueryResource;
import com.sas.rmi.Connection;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Vector;

public class QueryString
extends Component
implements QueryStringInterface {
    static final long serialVersionUID = -635446912160718601L;
    public static final String connectionProperty = "connection";
    public static final String sqlProperty = "sql";
    static QueryResource bundle = new QueryResource(QueryString.class);
    static final String RB_KEY = "QueryString.";
    private String m_sql;
    private Connection m_connection;
    private transient Query m_query;
    private transient MessageHandler m_messages;
    private transient Vector m_queryListeners;
    private transient ModelChangeListener m_changeSupport;
    protected String m_viewName;
    protected String m_fileName;
    private transient PropertyChangeSupport m_propertyChangeSupport;

    public QueryString() {
        this._initializeAllData();
    }

    public QueryString(String sql) {
        this();
        this.setSQL(sql);
    }

    public QueryString(Connection conn) {
        this();
        this.setConnection(conn);
    }

    public QueryString(Connection conn, String sql) {
        this();
        this.setConnection(conn);
        this.setSQL(sql);
    }

    @Override
    public String getSQL() {
        if (this.m_query != null) {
            this.m_sql = this.m_query.getSql();
        }
        if (this.m_sql == null) {
            this.m_sql = "";
        }
        return this.m_sql;
    }

    private String getFormattedSQL(String sql) {
        if (this.m_query != null) {
            this.m_sql = QueryUtils.formatSql(sql, this.m_query.getDataSource());
        }
        if (this.m_sql == null) {
            this.m_sql = "";
        }
        return this.m_sql;
    }

    @Override
    public String getFormattedSQL() {
        return this.getFormattedSQL(this.getSQL());
    }

    @Override
    public void setSQL(String sql) {
        boolean fireIt;
        String oldVal = this.m_sql;
        boolean bl = fireIt = this.m_sql == null;
        if (!fireIt && !this.m_sql.equals(sql)) {
            this.m_sql = sql;
            fireIt = true;
        }
        if (fireIt) {
            if (this.m_query != null) {
                if (sql == null || sql.equals("")) {
                    this.m_query.clear();
                } else {
                    this.m_query.setSQL(sql);
                }
                this.m_messages.firePropertyChanges();
            }
            this.m_sql = sql;
            this.firePropertyChange(sqlProperty, oldVal, sql);
        }
    }

    @Override
    public boolean isValidSQL() {
        boolean isIt = true;
        if (this.m_query != null) {
            isIt = this.m_query.isValidSql();
        }
        return isIt;
    }

    public void connect() {
        if (this.m_connection == null) {
            return;
        }
        try {
            if (!this.m_connection.isConnected()) {
                this.m_connection.connect();
            }
            if (this.m_query == null) {
                this._newDataSource(this.m_connection);
            }
        }
        catch (Exception e) {
            String errMsg = bundle.messageString("QueryString.ConnectionError", this.m_connection.getHost());
            if (this.m_messages != null) {
                this.m_messages.addError(errMsg);
            }
            System.out.println(errMsg);
            e.printStackTrace();
        }
    }

    @Override
    public void setConnection(Connection conn) {
        boolean doNew;
        Connection oldConn = this.m_connection;
        boolean bl = doNew = oldConn != null;
        if (doNew = doNew ? !oldConn.equals((Object)conn) : true) {
            this.m_connection = conn;
            this.connect();
            this.firePropertyChange(connectionProperty, oldConn, conn);
        }
    }

    @Override
    public Connection getConnection() {
        return this.m_connection;
    }

    void setQuery(Query query) {
        this.m_query = query;
        if (query != null) {
            this.m_query.addPropertyListener(this.getChangeSupport(), 65535);
            this.m_messages = this.m_query.getMessageHandler();
        }
    }

    private ModelChangeListener getChangeSupport() {
        if (this.m_changeSupport == null) {
            this.m_changeSupport = new ModelChangeListener(){

                @Override
                public void modelChangeCallback(ModelChangeEvent event) {
                    String newsql = QueryString.this.getSQL();
                    QueryString.this.firePropertyChange(QueryString.sqlProperty, "", newsql);
                }
            };
        }
        return this.m_changeSupport;
    }

    Query getQuery() {
        if (this.m_query == null && this.m_connection != null) {
            this._initializeAllData();
            this.connect();
        }
        return this.m_query;
    }

    private void setViewName(String newView) {
        this.m_viewName = newView;
    }

    @Override
    public String getViewName() {
        return this.m_viewName;
    }

    private void setFileName(String newFile) {
        this.m_fileName = newFile;
    }

    @Override
    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public void openQueryFromView(String viewName) throws IOException {
        this.openQueryFromView(viewName, null);
    }

    public void openQueryFromView(String viewName, String password) throws IOException {
        this.setViewName(viewName);
        if (this.m_query == null) {
            this.connect();
        }
        if (this.m_query != null) {
            this.m_query.openQueryFromView(viewName, password);
            if (!this.m_messages.failureHasOccurred()) {
                this.m_messages.firePropertyChanges();
                this.queryNotify(QueryEvent.OPEN_VIEW_EVENT);
            }
        } else {
            String errMsg = bundle.messageString("QueryString.IOException", "openQueryFromView");
            throw new IOException(errMsg);
        }
    }

    public void saveQueryToView(String viewName, String viewPassword) throws IOException {
        this.setViewName(viewName);
        if (this.m_query == null) {
            this.connect();
        }
        if (this.m_query != null) {
            this.m_query.saveQueryToView(viewName, viewPassword);
            if (!this.m_messages.failureHasOccurred()) {
                this.m_messages.firePropertyChanges();
                this.queryNotify(QueryEvent.SAVE_VIEW_EVENT);
            }
        } else {
            String errMsg = bundle.messageString("QueryString.IOException", "saveQueryToView");
            throw new IOException(errMsg);
        }
    }

    @Override
    public void saveQueryToView(String viewName) throws IOException {
        this.saveQueryToView(viewName, null);
    }

    @Override
    public void openQueryFromFile(String fileName) throws IOException {
        this.setFileName(fileName);
        if (this.m_query == null) {
            this.connect();
        }
        if (this.m_query != null) {
            this.m_query.openQueryFromFile(fileName);
            if (!this.m_messages.failureHasOccurred()) {
                this.m_messages.firePropertyChanges();
                this.queryNotify(QueryEvent.OPEN_FILE_EVENT);
            }
        } else {
            String errMsg = bundle.messageString("QueryString.IOException", "openQueryFromFile");
            throw new IOException(errMsg);
        }
    }

    @Override
    public void saveQueryToFile(String fileName) throws IOException {
        this.setFileName(fileName);
        if (this.m_query == null) {
            this.connect();
        }
        if (this.m_query != null) {
            this.m_query.saveQueryToFile(fileName);
            if (!this.m_messages.failureHasOccurred()) {
                this.m_messages.firePropertyChanges();
                this.queryNotify(QueryEvent.SAVE_FILE_EVENT);
            }
        } else {
            String errMsg = bundle.messageString("QueryString.IOException", "saveQueryToFile");
            throw new IOException(errMsg);
        }
    }

    @Override
    public void addQueryEventListener(QueryEventListener listener) {
        if (this.m_queryListeners == null) {
            this.m_queryListeners = new Vector();
        }
        if (!this.m_queryListeners.contains(listener)) {
            this.m_queryListeners.addElement(listener);
        }
    }

    @Override
    public synchronized void removeQueryEventListener(QueryEventListener listener) {
        if (this.m_queryListeners != null && this.m_queryListeners.contains(listener)) {
            this.m_queryListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryNotify(String actionName) {
        QueryEvent evt = new QueryEvent(this, actionName);
        if (this.m_queryListeners != null) {
            Vector v;
            QueryString queryString = this;
            synchronized (queryString) {
                v = (Vector)this.m_queryListeners.clone();
            }
            if (v != null) {
                int count = v.size();
                for (int i = 0; i < count; ++i) {
                    QueryEventListener q = (QueryEventListener)v.elementAt(i);
                    q.queryActionPerformed(evt);
                }
            }
        }
    }

    private void _newDataSource(Connection conn) {
        try {
            if (this.m_messages == null) {
                this.m_messages = new MessageHandler();
            }
            this.setQuery(new Query(new WebAfDataSource(conn, this.m_messages)));
            if (this.m_sql == null) {
                this.m_sql = "";
            }
            this.m_query.setSQL(this.m_sql);
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "text"}, {"Description", bundle.getString("QueryStringBeanInfo.SqlDesc.txt")}}, {{"Name", connectionProperty}, {"Description", bundle.getString("QueryStringBeanInfo.ConnectionDesc.txt")}}, {{"Name", "viewName"}, {"Expert", "true"}, {"Description", bundle.getString("QueryStringBeanInfo.ViewNameDesc.txt")}}, {{"Name", "isValidSql"}, {"Expert", "true"}, {"Description", bundle.getString("QueryStringBeanInfo.IsValidDesc.txt")}, {"Bound", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = bundle.getString("QueryStringBeanInfo.ShortDesc.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    private void p(Object t) {
        System.out.println(t);
    }

    private void _initializeAllData() {
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
        this.getChangeSupport();
    }
}

