/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.Table;
import com.sas.query.visuals.DataFilterSection;
import com.sas.query.visuals.DataItemListView;
import com.sas.query.visuals.GroupFilterSection;
import com.sas.query.visuals.JDataSourceTreeView;
import com.sas.query.visuals.JReferableTreeView;
import com.sas.query.visuals.OrderItemListView;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.TablesAndRelsSection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class QueryDefiner
extends StandardView
implements Cloneable {
    public static final int NO_LIMITS = 0;
    public static final int READ_ONLY = 1;
    public static final int ONE_TABLE = 2;
    public static final int DISPLAY_ONLY = 512;
    public static final int WHERE = 1;
    public static final int COLUMNLIST = 2;
    public static final int ORDERBY = 8;
    public static final int FORMAT = 16;
    public static final int METADATA_TREE = 32;
    public static final int REFERABLE_TREE = 64;
    public static final int DATA_ITEMS = 256;
    public static final int HAVING = 512;
    public static final int STANDARD_FEATURES = 603;
    protected int m_features = 0;
    protected int m_limits = 0;
    protected JReferableTreeView m_referableTreeView;
    protected JDataSourceTreeView m_dataSourceTreeView;
    protected JPanel m_columnListSection;

    public QueryDefiner(DataSource dataSource, MessageHandler messages) {
        super(new Query(dataSource, messages));
        this._initialize(603, 0);
    }

    public QueryDefiner(DataSource dataSource, MessageHandler messages, int features, int limits) {
        super(new Query(dataSource, messages, limits));
        this._initialize(features, limits);
    }

    public QueryDefiner(Query query) {
        super(query);
        this._initialize(603, query.getLimits());
    }

    public QueryDefiner(Query query, int features, int limits) {
        super(query);
        this._initialize(features, query.getLimits() | limits);
    }

    protected void _initialize(int features, int limits) {
        this.m_features = features;
        this.m_limits = limits;
        this.setBackground(SystemColor.control);
        this._constructPanel();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    public Object clone() throws CloneNotSupportedException {
        QueryDefiner newObject = (QueryDefiner)super.clone();
        newObject.addNotify();
        newObject.m_query = (Query)this.m_query.clone();
        newObject._initialize(this.m_features, this.m_limits);
        return newObject;
    }

    protected void _constructPanel() {
        JSplitPane splitter = new JSplitPane();
        splitter.setBorder(BorderFactory.createEmptyBorder());
        if ((this.m_features & 0x40) != 0) {
            this.m_referableTreeView = new JReferableTreeView(this.m_query);
            splitter.setLeftComponent(this.m_referableTreeView);
        } else {
            JDataSourceTree dataSourceTree = new JDataSourceTree(this.m_query, this.m_query.getDataSource(), false);
            this.m_dataSourceTreeView = new JDataSourceTreeView(this.m_query, dataSourceTree);
            splitter.setLeftComponent(this.m_dataSourceTreeView);
        }
        JSplitPane parent = splitter;
        int nPosition = 0;
        if (this._getCountOfSections() > 1) {
            parent = new JSplitPane(0);
            parent.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((this.m_features & 2) != 0) {
            this.m_columnListSection = new TablesAndRelsSection(this.m_query, 1L);
            this._addSection(parent, nPosition++, this.m_columnListSection);
        }
        if ((this.m_features & 1) != 0) {
            DataFilterSection dataFilterSection = new DataFilterSection(this.m_query, 1L);
            this._addSection(parent, nPosition++, dataFilterSection);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(1);
            }
        }
        if ((this.m_features & 8) != 0) {
            OrderItemListView orderItemListView = new OrderItemListView(this.m_query);
            this._addSection(parent, nPosition++, orderItemListView);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(5);
            }
        }
        if ((this.m_features & 0x100) != 0) {
            DataItemListView dataItemListView = new DataItemListView(this.m_query);
            this._addSection(parent, nPosition++, dataItemListView);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(3);
            }
        }
        if ((this.m_features & 0x200) != 0) {
            GroupFilterSection groupFilterSection = new GroupFilterSection(this.m_query, 1L);
            this._addSection(parent, nPosition++, groupFilterSection);
            if (this.m_referableTreeView != null) {
                this.m_referableTreeView.setDefaultAction(2);
            }
        }
        if (this._getCountOfSections() > 1) {
            parent.setBorder(BorderFactory.createEmptyBorder());
            splitter.setRightComponent(parent);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(splitter, gbc);
        this.add(splitter);
        splitter.setDividerLocation(170);
        parent.setDividerLocation(170);
    }

    protected void _addSection(JSplitPane parent, int position, Component section) {
        if (this._getCountOfSections() > 1) {
            if (position == 0) {
                parent.setTopComponent(section);
            } else {
                parent.setBottomComponent(section);
            }
        } else {
            parent.setRightComponent(section);
        }
    }

    protected int _getCountOfSections() {
        int cSections = 0;
        if ((this.m_features & 2) != 0) {
            ++cSections;
        }
        if ((this.m_features & 1) != 0) {
            ++cSections;
        }
        if ((this.m_features & 8) != 0) {
            ++cSections;
        }
        if ((this.m_features & 0x10) != 0) {
            ++cSections;
        }
        if ((this.m_features & 0x100) != 0) {
            ++cSections;
        }
        if ((this.m_features & 0x200) != 0) {
            ++cSections;
        }
        return cSections;
    }

    public TablesAndRelsSection getTablesAndRelsSection() {
        return (TablesAndRelsSection)this.m_columnListSection;
    }

    public Query getModel() {
        return this.m_query;
    }

    public int getLimits() {
        return this.m_query.getLimits();
    }

    public boolean getLimit(int requestedLimit) {
        return this.m_query.getLimit(requestedLimit);
    }

    public void validateQuery() {
        this.m_query.validateQuery();
    }

    public String getSql() {
        return this.m_query.getSql();
    }

    public String getSelectedColumnString() {
        return this.m_query.getSelectedColumnString();
    }

    public String getWhereString() {
        return this.m_query.getWhereString();
    }

    public String getOrderByString() {
        return this.m_query.getOrderByString();
    }

    public String getGroupByString() {
        return this.m_query.getGroupByString();
    }

    public String getHavingString() {
        return this.m_query.getHavingString();
    }

    public Table setSelectedTable(String tableName) {
        return this.m_query.addTable(tableName);
    }

    public void addAllColumnsSelected(Table table) {
        this.m_query.addResultItems(table);
    }
}

