/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.query.QueryConfiguration;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.DataSourceTableList;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.Relationship;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.Join;
import com.sas.query.models.JoinConstants;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.PropertyChangeHandler;
import com.sas.query.models.RefreshInterface;
import com.sas.query.models.RefreshInterfaceList;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.StandardModel;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.models.XmlUtil;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.QueryResource;
import java.awt.Frame;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Query
extends StandardModel
implements JoinConstants,
ExpressionConstants {
    static final long serialVersionUID = 2022867522507307343L;
    public static final int NO_LIMITS = 0;
    public static final int READ_ONLY = 1;
    public static final int ONE_TABLE = 2;
    public static final int MAX_LIMIT = 256;
    public static final int DR_DISTINCT = 0;
    public static final int DR_DEFAULT = 1;
    public static final int DR_ALL = 2;
    public static final int DOUBLE_CLICK_SENSITIVITY_INTERVAL = 900;
    public static final int MAX_FORMATED_LINE_LENGTH = 72;
    public static final String DataSourcePropertyChange = "dataSource";
    public static final String DuplicateRowsPropertyChange = "duplicate rows";
    static QueryResource bundle = new QueryResource(Query.class);
    protected String m_strSql = null;
    protected int m_duplicateRows = 1;
    protected transient ResultItemList m_resultItems = new ResultItemList();
    protected transient JoinRelationshipList m_joinRelationships = new JoinRelationshipList();
    protected transient JoinList m_joins = new JoinList();
    protected transient TableList m_tables = new TableList();
    protected transient FilterTree m_whereFilterTree = new FilterTree(this);
    protected transient FilterTree m_havingFilterTree = new FilterTree(this);
    protected transient GroupItemList m_groupItems = new GroupItemList();
    protected transient OrderItemList m_orderItems = new OrderItemList();
    protected int m_limits;
    protected boolean m_bAutoJoin = true;
    protected boolean m_showLabels = false;
    protected boolean m_bAutoGroup = true;
    protected transient DataSource m_dataSource;
    protected Query m_primaryQuery = null;
    protected Query m_secondaryQuery = null;
    protected int m_nSecondaryQueryType;
    protected transient MessageHandler m_messageHandler = null;
    public static Query currentlyCreatingQuery;

    public Query(DataSource dataSource) {
        super(null);
        this._initialize(dataSource, null, 0);
    }

    public Query(DataSource dataSource, int limits) {
        super(null);
        this._initialize(dataSource, null, limits);
    }

    public Query(DataSource dataSource, MessageHandler messageHandler) {
        super(null);
        this._initialize(dataSource, messageHandler, 0);
    }

    public Query(DataSource dataSource, MessageHandler messageHandler, int limits) {
        super(null);
        this._initialize(dataSource, messageHandler, limits);
    }

    protected void _initialize(DataSource dataSource, MessageHandler messageHandler, int limits) {
        this.m_dataSource = dataSource;
        dataSource.setLimits(limits);
        this.m_messageHandler = messageHandler;
        if (this.m_messageHandler == null) {
            this.m_messageHandler = this.m_dataSource.getMessageHandler();
        }
        if (this.m_messageHandler == null) {
            this.m_messageHandler = new MessageHandler();
            this.m_dataSource.setMessageHandler(this.m_messageHandler);
        }
        this.m_limits = limits;
    }

    public void clear() {
        this.m_strSql = null;
        this.m_duplicateRows = 1;
        this.m_resultItems.removeAllElements();
        this.m_tables = new TableList();
        this.m_joins = new JoinList();
        this.m_joinRelationships = new JoinRelationshipList();
        this.m_whereFilterTree.setRoot(null);
        this.m_havingFilterTree.setRoot(null);
        this.m_groupItems.removeAllElements();
        this.m_orderItems.removeAllElements();
        this.queueStructureChange(65535);
        this.m_primaryQuery = null;
        this.m_secondaryQuery = null;
    }

    public boolean isAutoJoinEnabled() {
        return this.m_bAutoJoin;
    }

    public void enableAutoJoin(boolean val) {
        this.m_bAutoJoin = val;
    }

    public boolean isParsable() {
        return this.m_strSql == null;
    }

    public boolean getDuplicateRows() {
        return this.m_duplicateRows != 0;
    }

    public int getDuplicateRowsRule() {
        return this.m_duplicateRows;
    }

    public void setDuplicateRowsRule(int duplicateRows) {
        if (this.m_duplicateRows != duplicateRows) {
            int oldnum = this.m_duplicateRows;
            this.m_duplicateRows = duplicateRows;
            this.queueDataChange(4, DuplicateRowsPropertyChange, new Integer(oldnum));
        }
    }

    public ResultItem addResultItem(Expression expression) {
        ResultItem resultItem = new ResultItem(this, expression);
        if (expression instanceof ColumnExpression) {
            Column columnToAdd = ((ColumnExpression)expression).getColumn();
            String uniqueName = this.m_query.getUniqueResultName(columnToAdd.getName());
            if (!this.getSqlLogic().identifierEquals(uniqueName, columnToAdd.getName())) {
                resultItem.setAlias(uniqueName);
            }
        }
        this.addResultItem(resultItem);
        return resultItem;
    }

    public ResultItem addResultItem(Column columnToAdd) {
        ColumnExpression columnExpression = new ColumnExpression(columnToAdd);
        ResultItem resultItem = new ResultItem(this, columnExpression);
        String uniqueName = this.getUniqueResultName(columnToAdd.getName());
        if (!this.getSqlLogic().identifierEquals(uniqueName, columnToAdd.getName())) {
            resultItem.setAlias(uniqueName);
        }
        this.addResultItem(resultItem);
        return resultItem;
    }

    public ResultItem addResultItem(Column columnToAdd, int position) {
        ColumnExpression columnExpression = new ColumnExpression(columnToAdd);
        ResultItem resultItem = new ResultItem(this, columnExpression);
        String uniqueName = this.getUniqueResultName(columnToAdd.getName());
        if (!this.getSqlLogic().identifierEquals(uniqueName, columnToAdd.getName())) {
            resultItem.setAlias(uniqueName);
        }
        this.addResultItem(resultItem, position);
        return resultItem;
    }

    public String getUniqueResultName(String strRequestedName) {
        String tempName = strRequestedName;
        int maxLength = this.getSqlProperties().getMaxColumnNameLength();
        if (tempName.length() > maxLength) {
            tempName = tempName.substring(0, maxLength);
        }
        return this._findUniqueResultName(tempName, 0);
    }

    protected String _findUniqueResultName(String strRequestedName, int suffix) {
        String strReturnName = strRequestedName;
        if (suffix > 0) {
            int suffixLength = new Integer(suffix).toString().length();
            int maxLength = this.getSqlProperties().getMaxColumnNameLength();
            strReturnName = suffixLength + strRequestedName.length() < maxLength ? strRequestedName + suffix : strRequestedName.substring(0, maxLength - suffixLength) + suffix;
        }
        for (int index = 0; index < this.m_resultItems.size(); ++index) {
            if (!this.getSqlLogic().identifierEquals(strReturnName, this.m_resultItems.elementAt(index).getDisplayName())) continue;
            strReturnName = this._findUniqueResultName(strRequestedName, suffix + 1);
            break;
        }
        return strReturnName;
    }

    public boolean autoGroup() {
        return this.m_bAutoGroup;
    }

    public void setAutoGroup(boolean newVal) {
        this.m_bAutoGroup = newVal;
    }

    public boolean hasAggregatedRI() {
        for (int i = 0; i < this.m_resultItems.size(); ++i) {
            ResultItem ri = this.m_resultItems.elementAt(i);
            if (!ri.getExpression().hasAggregation()) continue;
            return true;
        }
        return false;
    }

    public void addResultItem(ResultItem itemToAdd) {
        this.shareExpressionWithResultItem(itemToAdd.getExpression(), null);
        this.m_resultItems.addElement(itemToAdd);
        this._orderItemResyncAdded(itemToAdd);
        GroupItem groupItem = this._groupItemResyncAdded(itemToAdd);
        if (this.autoGroup() && this.hasAggregatedRI() && groupItem == null && !itemToAdd.getExpression().hasAggregation()) {
            this.addGroupItem(itemToAdd);
        }
        this.queueStructureChange(4, 1, itemToAdd);
    }

    public void addResultItem(ResultItem itemToAdd, int position) {
        this.shareExpressionWithResultItem(itemToAdd.getExpression(), null);
        this.m_resultItems.insertElementAt(itemToAdd, position);
        this._orderItemResyncAdded(itemToAdd);
        GroupItem groupItem = this._groupItemResyncAdded(itemToAdd);
        if (this.autoGroup() && this.hasAggregatedRI() && groupItem == null && !itemToAdd.getExpression().hasAggregation()) {
            this.addGroupItem(itemToAdd);
        }
        this.queueStructureChange(4, 1, itemToAdd);
    }

    public void addResultItems(Table table) {
        if (table == null) {
            return;
        }
        ColumnList columnList = table.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            this.addResultItem(columnList.elementAt(index));
        }
    }

    public void deleteResultItem(ResultItem itemToDelete) {
        if (itemToDelete == null) {
            return;
        }
        for (int index = 0; index < this.m_resultItems.size(); ++index) {
            if (this.m_resultItems.elementAt(index) != itemToDelete) continue;
            this.m_resultItems.removeElementAt(index);
            this._orderItemResyncDeleted(itemToDelete);
            this._groupItemResyncDeleted(itemToDelete);
            this.queueStructureChange(4, 2, itemToDelete);
            break;
        }
    }

    public void moveResultItem(int oldPosition, int newPosition) {
        ResultItem itemToMove = this.m_resultItems.elementAt(oldPosition);
        if (oldPosition == newPosition) {
            return;
        }
        if (newPosition < oldPosition) {
            this.m_resultItems.insertElementAt(itemToMove, newPosition);
            this.m_resultItems.removeElementAt(oldPosition + 1);
        } else if (oldPosition < newPosition) {
            this.m_resultItems.removeElementAt(oldPosition);
            this.m_resultItems.insertElementAt(itemToMove, newPosition);
        }
        this.queueStructureChange(4, 4, itemToMove);
    }

    public int getPositionForResultItem(ResultItem itemToFind) {
        for (int index = 0; index < this.m_resultItems.size(); ++index) {
            ResultItem resultItem = this.m_resultItems.elementAt(index);
            if (resultItem != itemToFind) continue;
            return index;
        }
        return -1;
    }

    public ResultItem getResultItem(int position) {
        return this.getResultItems().elementAt(position);
    }

    public ResultItemList getResultItems() {
        return this.m_resultItems;
    }

    public ResultItemList getResultItems(Table table) {
        ResultItemList resultItems = new ResultItemList();
        for (int index = 0; index < this.m_resultItems.size(); ++index) {
            ResultItem resultItem = this.m_resultItems.elementAt(index);
            if (!(resultItem.getExpression() instanceof ColumnExpression) || ((ColumnExpression)resultItem.getExpression()).getColumn().getParent() != table) continue;
            resultItems.addElement(this.m_resultItems.elementAt(index));
        }
        return resultItems;
    }

    public int getResultItemCount() {
        return this.m_resultItems.size();
    }

    public ResultItem getResultItem(Expression expressionToFind) {
        ResultItem returnItem = null;
        for (int i = 0; i < this.m_resultItems.size(); ++i) {
            Expression expression = this.m_resultItems.elementAt(i).getExpression();
            if (expression != expressionToFind) continue;
            returnItem = this.m_resultItems.elementAt(i);
            break;
        }
        return returnItem;
    }

    public Table addTable(String strQualifiedTableName) {
        DataSourceTable table = this.m_dataSource.getTable(strQualifiedTableName);
        return this.addTable(table);
    }

    public Table addTable(DataSourceTable tableToAdd) {
        if (tableToAdd == null) {
            return null;
        }
        Table table = new Table(this, tableToAdd);
        table.getColumnCount();
        if (!this.m_messageHandler.failureHasOccurred()) {
            this.addTable(table);
            return table;
        }
        return null;
    }

    public void addTable(Table tableToAdd) {
        if (tableToAdd == null) {
            return;
        }
        if (this.getLimit(2) && this.m_tables.size() != 0) {
            this.addError(bundle.getString("Message.Query.OneTableLimit.txt"));
            return;
        }
        if (this.m_tables.size() == this.m_dataSource.getProperties().getMaxTablesInSelect()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxTables.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxTablesInSelect())));
            return;
        }
        if (tableToAdd.getCorrelationName() == null) {
            String strUniqueTableName = this._findUniqueTableName(tableToAdd.getName(), 0);
            if (!strUniqueTableName.equals(tableToAdd.getName())) {
                tableToAdd.setCorrelationName(strUniqueTableName);
            }
        } else if (tableToAdd.getCorrelationName().length() > this.m_dataSource.getProperties().getMaxTableNameLength()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxNameLen.fmt.txt", new Integer(this.getSqlProperties().getMaxTableNameLength())));
            return;
        }
        this.m_tables.addElement(tableToAdd);
        Join newJoin = new Join(this.m_query, tableToAdd);
        this.m_joins.addElement(newJoin);
        if (this.m_bAutoJoin && this.m_joins.size() > 1) {
            this._autoJoin(tableToAdd);
        }
        this.queueStructureChange(8, 1, tableToAdd);
    }

    protected String _findUniqueTableName(String strRequestedName, int suffix) {
        String strReturnName = strRequestedName;
        if (suffix > 0) {
            int suffixLength = new Integer(suffix).toString().length();
            int maxLength = this.getSqlProperties().getMaxTableNameLength();
            strReturnName = suffixLength + strRequestedName.length() < maxLength ? strRequestedName + suffix : strRequestedName.substring(0, maxLength - suffixLength) + suffix;
        }
        for (int index = 0; index < this.m_tables.size(); ++index) {
            if (!this.getSqlLogic().identifierEquals(strReturnName, this.m_tables.elementAt(index).getDisplayName())) continue;
            strReturnName = this._findUniqueTableName(strRequestedName, suffix + 1);
            break;
        }
        return strReturnName;
    }

    protected void _autoJoin(Table newTable) {
        TableList referableTables = this.getReferableTables();
        RelationshipList relationshipList = newTable.getRelationships();
        if (relationshipList == null || relationshipList.size() == 0) {
            this._autoJoinByName(newTable);
            return;
        }
        for (int referableIndex = 0; referableIndex < referableTables.size(); ++referableIndex) {
            Table referableTable = referableTables.elementAt(referableIndex);
            for (int relIndex = 0; relIndex < relationshipList.size(); ++relIndex) {
                Relationship relationship = relationshipList.elementAt(relIndex);
                String strForeignTable = relationship.getForeignTableName();
                if (!strForeignTable.equals(referableTable.getName())) continue;
                JoinRelationship newJoin = new JoinRelationship(this, newTable, referableTable, 4, relationship.getComparisonDetails(this.m_dataSource, newTable, referableTable));
                this.addJoinRelationship(newJoin);
                return;
            }
        }
    }

    protected void _autoJoinByName(Table newTable) {
        JoinRelationship newJoinRelationship = null;
        newJoinRelationship = this._getBestJoinRelationshipForColumn(newTable, this.m_tables);
        if (newJoinRelationship != null) {
            this.addJoinRelationship(newJoinRelationship);
        }
        TableList isolatedTables = this._getIsolatedTables();
        TableList newTableList = new TableList(1);
        newTableList.addElement(newTable);
        for (int index = 0; index < isolatedTables.size(); ++index) {
            Table table = isolatedTables.elementAt(index);
            newJoinRelationship = this._getBestJoinRelationshipForColumn(table, newTableList);
            if (newJoinRelationship == null) continue;
            this.addJoinRelationship(newJoinRelationship);
        }
    }

    protected JoinRelationship _getBestJoinRelationshipForColumn(Table newTable, TableList possibleTables) {
        JoinRelationship returnValue = null;
        SqlLogic sqlLogic = this.getSqlLogic();
        int confidence = 0;
        int cNewColumns = newTable.getColumnCount();
        ColumnList newColumns = newTable.getColumns();
        for (int newColumnIndex = 0; newColumnIndex < cNewColumns; ++newColumnIndex) {
            Column newColumn = newColumns.elementAt(newColumnIndex);
            int cTables = possibleTables.size();
            block1: for (int tableIndex = cTables - 1; tableIndex >= 0; --tableIndex) {
                Table table = possibleTables.elementAt(tableIndex);
                if (table == newTable) continue;
                int cColumns = table.getColumnCount();
                ColumnList existingColumns = table.getColumns();
                for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
                    Column existingColumn = existingColumns.elementAt(columnIndex);
                    if (!this.getSqlLogic().identifierEquals(existingColumn.getName(), newColumn.getName()) || existingColumn.getSqlType() != newColumn.getSqlType()) continue;
                    int testConfidence = sqlLogic.getJoinSuitability(existingColumn) + sqlLogic.getJoinSuitability(newColumn) + 1;
                    if (testConfidence > confidence) {
                        confidence = testConfidence;
                        returnValue = new JoinRelationship(this, existingColumn, newColumn);
                    }
                    if (confidence == SqlLogic.JS_HIGHEST_CONFIDENCE) continue block1;
                }
            }
        }
        return returnValue;
    }

    public void deleteTable(Table tableToDelete) {
        int colIndex;
        int index;
        this.m_tables.removeElement(tableToDelete);
        this.queueStructureChange(8, 2, tableToDelete);
        for (int i = 0; i < this.m_joins.size(); ++i) {
            if (this.m_joins.elementAt(i).getTable() != tableToDelete) continue;
            this.queueStructureChange(16, 2, this.m_joins.elementAt(i));
            this.m_joins.removeElementAt(i);
            break;
        }
        block1: for (int index2 = this.m_resultItems.size() - 1; index2 >= 0; --index2) {
            Expression expression = this.m_resultItems.elementAt(index2).getExpression();
            ColumnList columnList = expression.getReferencedColumns();
            for (int colIndex2 = 0; colIndex2 < columnList.size(); ++colIndex2) {
                if (columnList.elementAt(colIndex2).getParent() != tableToDelete) continue;
                this.deleteResultItem(this.m_resultItems.elementAt(index2));
                continue block1;
            }
        }
        FilterTree tree = this.getWhereFilterTree();
        FilterNode[] nodeArray = tree.getNodesArray();
        block3: for (index = 0; index < nodeArray.length; ++index) {
            ColumnList columnList = nodeArray[index].getNodeData().getReferencedColumns();
            for (int colIndex3 = 0; colIndex3 < columnList.size(); ++colIndex3) {
                if (columnList.elementAt(colIndex3).getParent() != tableToDelete) continue;
                tree.removeNode(nodeArray[index]);
                continue block3;
            }
        }
        block5: for (index = this.m_orderItems.size() - 1; index >= 0; --index) {
            Expression expression = this.m_orderItems.elementAt(index).getExpression();
            ColumnList columnList = null;
            if (expression == null) {
                ResultItem item = this.m_orderItems.elementAt(index).getResultItem();
                columnList = item.getExpression().getReferencedColumns();
            } else {
                columnList = expression.getReferencedColumns();
            }
            for (colIndex = 0; columnList != null && colIndex < columnList.size(); ++colIndex) {
                if (columnList.elementAt(colIndex).getParent() != tableToDelete) continue;
                this.deleteOrderItem(this.m_orderItems.elementAt(index));
                continue block5;
            }
        }
        block7: for (index = this.m_groupItems.size() - 1; index >= 0; --index) {
            Expression expression = this.m_groupItems.elementAt(index).getExpression();
            ColumnList columnList = null;
            if (expression == null) {
                ResultItem item = this.m_groupItems.elementAt(index).getResultItem();
                columnList = item.getExpression().getReferencedColumns();
            } else {
                columnList = expression.getReferencedColumns();
            }
            for (colIndex = 0; columnList != null && colIndex < columnList.size(); ++colIndex) {
                if (columnList.elementAt(colIndex).getParent() != tableToDelete) continue;
                this.deleteGroupItem(this.m_groupItems.elementAt(index));
                continue block7;
            }
        }
        tree = this.getHavingFilterTree();
        nodeArray = tree.getNodesArray();
        block9: for (index = 0; index < nodeArray.length; ++index) {
            ColumnList columnList = nodeArray[index].getNodeData().getReferencedColumns();
            for (int colIndex4 = 0; colIndex4 < columnList.size(); ++colIndex4) {
                if (columnList.elementAt(colIndex4).getParent() != tableToDelete) continue;
                tree.removeNode(nodeArray[index]);
                continue block9;
            }
        }
        JoinRelationshipList joinList = this.getJoinRelationships();
        for (int index3 = joinList.size() - 1; index3 >= 0; --index3) {
            JoinRelationship joinRelationship = this.m_joinRelationships.elementAt(index3);
            if (joinRelationship.getLeftTable() == tableToDelete || joinRelationship.getRightTable() == tableToDelete) {
                this._deleteJoinRelationship(joinRelationship);
            }
            if (index3 != 0) continue;
            this.m_joins.groupJoinsFromList(this.m_joinRelationships);
        }
    }

    public int getTableCount() {
        return this.m_tables.size();
    }

    public TableList getTables() {
        return this.m_tables;
    }

    protected TableList _getIsolatedTables() {
        TableList returnValue = new TableList();
        for (int index = 0; index < this.m_joins.size(); ++index) {
            Join join = this.m_joins.elementAt(index);
            if (!join.getNewJoinGroupValue()) continue;
            if (index == this.m_joins.size() - 1) {
                returnValue.addElement(join.getTable());
                continue;
            }
            Join nextJoin = this.m_joins.elementAt(index + 1);
            if (!nextJoin.getNewJoinGroupValue()) continue;
            returnValue.addElement(join.getTable());
        }
        return returnValue;
    }

    public TableList getReferableTables() {
        return this.m_tables;
    }

    public ColumnList getReferableColumns() {
        ColumnList returnList = new ColumnList();
        for (int index = 0; index < this.m_tables.size(); ++index) {
            returnList.add(this.m_tables.elementAt(index).getColumns());
        }
        return returnList;
    }

    public ColumnList getReferableColumns(Table context) {
        ColumnList allCols = this.getReferableColumns();
        ColumnList retVals = new ColumnList();
        for (int i = 0; i < allCols.size(); ++i) {
            if (allCols.elementAt(i).getParent() != context) continue;
            retVals.addElement(allCols.elementAt(i));
        }
        return retVals;
    }

    public ColumnList getReferableColumnsOfType(int desiredExpType) {
        return this.getReferableColumns().getSubsetByType(desiredExpType);
    }

    public ColumnList getReferableColumnsOfType(Table context, int desired_exp_type) {
        return this.getReferableColumns(context).getSubsetByType(desired_exp_type);
    }

    public ResultItemList getComputedResultColumns() {
        ResultItemList returnList = new ResultItemList();
        for (int index = 0; index < this.m_resultItems.size(); ++index) {
            ResultItem item = this.m_resultItems.elementAt(index);
            if (item.getExpression() instanceof ColumnExpression) continue;
            returnList.addElement(item);
        }
        return returnList;
    }

    public DataSourceTableList getDataSourceTables() {
        TableList tableList = this.getTables();
        DataSourceTableList returnList = new DataSourceTableList(tableList.size());
        for (int index = 0; index < tableList.size(); ++index) {
            DataSourceTable dataSourceTable = tableList.elementAt(index).getDataSourceTable();
            if (returnList.contains(dataSourceTable)) continue;
            returnList.addElement(dataSourceTable);
        }
        return returnList;
    }

    public void addJoinRelationship(Column firstColumn, Column otherColumn) {
        JoinRelationship newRelationship = new JoinRelationship(this, firstColumn, otherColumn);
        this.addJoinRelationship(newRelationship);
    }

    public void addJoinRelationship(Table firstTable, Table otherTable, int comparisonType, String strComparisonDetail) {
        JoinRelationship newRelationship = new JoinRelationship(this, firstTable, otherTable, comparisonType, strComparisonDetail);
        this.addJoinRelationship(newRelationship);
    }

    public void addJoinRelationship(Table firstTable, Table otherTable, int comparisonType, Object comparisonDetail) {
        JoinRelationship newRelationship = new JoinRelationship(this, firstTable, otherTable, comparisonType, comparisonDetail);
        this.addJoinRelationship(newRelationship);
    }

    public void addJoinRelationship(JoinRelationship newRelationship) {
        this.m_joinRelationships.addElement(newRelationship);
        this.m_joins.groupJoinsFromAdd(newRelationship.getLeftTable(), newRelationship.getRightTable(), this.m_joinRelationships);
        this.queueStructureChange(16, 1, newRelationship);
    }

    public JoinList getJoins() {
        return this.m_joins;
    }

    public void setJoins(JoinList newJoinList) {
        this.m_joins = newJoinList;
        this.m_joins.setAllRelationships(this.m_joinRelationships);
        this.queueStructureChange(16, 16, null);
    }

    public void setJoinsAndRelationships(JoinList newJoinList, JoinRelationshipList joinRelationshipList) {
        this.m_joins = newJoinList;
        this.m_joinRelationships = joinRelationshipList;
        this.m_joins.setAllRelationships(this.m_joinRelationships);
        this.m_joins.groupJoinsFromList(this.m_joinRelationships);
        this.queueStructureChange(16, 16, null);
    }

    public Join getJoin(Table table) {
        return this.m_joins.getJoin(table);
    }

    public JoinRelationshipList getJoinRelationships() {
        return this.m_joinRelationships;
    }

    public void setJoinRelationships(JoinRelationshipList joinRelationshipList) {
        this.m_joinRelationships = joinRelationshipList;
        this.m_joins.setAllRelationships(this.m_joinRelationships);
        this.queueStructureChange(16, 16, null);
    }

    public void deleteJoinRelationship(JoinRelationship joinToDelete) {
        this.m_joinRelationships.removeElement(joinToDelete);
        this.m_joins.groupJoinsFromList(this.m_joinRelationships);
        this.queueStructureChange(16, 2, joinToDelete);
    }

    protected void _deleteJoinRelationship(JoinRelationship joinToDelete) {
        this.m_joinRelationships.removeElement(joinToDelete);
        this.queueStructureChange(16, 2, joinToDelete);
    }

    public FilterNode addAndFilter(Expression expressionToBaseFilterOn) {
        return this.getWhereFilterTree().addAnd(expressionToBaseFilterOn);
    }

    public FilterTree addAndFilter(FilterNode filterToAdd) {
        Expression curExp = filterToAdd.getNodeData();
        if (curExp.hasAggregation()) {
            String msg = bundle.messageString("Message.Query.AggregateMovedToHaving.fmt.txt", curExp.getDisplayString());
            this.m_messageHandler.addWarning(msg);
            this.addHavingAndFilter(filterToAdd);
            return this.getHavingFilterTree();
        }
        if (this.getWhereFilterTree().getSelectedNode() != null) {
            this.getWhereFilterTree().getSelectedNode().addAnd(filterToAdd);
        } else {
            this.getWhereFilterTree().addAnd(filterToAdd);
        }
        return this.getWhereFilterTree();
    }

    public void addAndFilter(FilterNode filterToAdd, FilterNode filterToAddTo) {
        filterToAddTo.addAnd(filterToAdd);
    }

    public void addOrFilter(FilterNode filterToAdd) {
        Expression curExp = filterToAdd.getNodeData();
        if (curExp.hasAggregation()) {
            String msg = bundle.messageString("Message.Query.AggregateMovedToHaving.fmt.txt", curExp.getDisplayString());
            this.m_messageHandler.addError(msg);
            this.addHavingOrFilter(filterToAdd);
        } else if (this.getWhereFilterTree().getSelectedNode() != null) {
            this.getWhereFilterTree().getSelectedNode().addOr(filterToAdd);
        } else {
            this.getWhereFilterTree().addOr(filterToAdd);
        }
    }

    public void addOrFilter(FilterNode filterToAdd, FilterNode filterToAddTo) {
        filterToAddTo.addOr(filterToAdd);
    }

    public void deleteFilter(FilterNode filterToDelete) {
        this.getWhereFilterTree().removeNode(filterToDelete);
    }

    public void setSelectedFilter(FilterNode filterToSelect) {
        this.getWhereFilterTree().setSelectedNode(filterToSelect);
    }

    public FilterNode getSelectedFilter() {
        return this.getWhereFilterTree().getSelectedNode();
    }

    public FilterTree getWhereFilterTree() {
        return this.m_whereFilterTree;
    }

    public OrderItem addOrderItem(Expression expression) {
        OrderItem orderItem = new OrderItem(this, expression);
        this.addOrderItem(orderItem);
        return orderItem;
    }

    public OrderItem addOrderItem(Column columnToAdd) {
        if (this.m_orderItems.size() == this.m_dataSource.getProperties().getMaxColumnsInOrderBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxOrderBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInOrderBy())));
            return null;
        }
        ColumnExpression expression = new ColumnExpression(columnToAdd);
        OrderItem orderItem = new OrderItem(this, expression);
        this.addOrderItem(orderItem);
        return orderItem;
    }

    public OrderItem addOrderItem(ResultItem resultItemToAdd) {
        if (this.m_orderItems.size() == this.m_dataSource.getProperties().getMaxColumnsInOrderBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxOrderBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInOrderBy())));
            return null;
        }
        OrderItem orderItem = new OrderItem(resultItemToAdd);
        this.addOrderItem(orderItem);
        return orderItem;
    }

    public void addOrderItem(OrderItem itemToAdd) {
        if (this.m_orderItems.size() == this.m_dataSource.getProperties().getMaxColumnsInOrderBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxOrderBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInOrderBy())));
            return;
        }
        this.m_orderItems.addElement(itemToAdd);
        this._shareWithResultItem(itemToAdd);
        this.queueStructureChange(256, 1, itemToAdd);
    }

    public void addOrderItem(OrderItem itemToAdd, int position) {
        if (this.m_orderItems.size() == this.m_dataSource.getProperties().getMaxColumnsInOrderBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxOrderBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInOrderBy())));
            return;
        }
        this.m_orderItems.insertElementAt(itemToAdd, position);
        this._shareWithResultItem(itemToAdd);
        this.queueStructureChange(256, 1, itemToAdd);
    }

    public void deleteOrderItem(OrderItem itemToDelete) {
        if (itemToDelete == null) {
            return;
        }
        for (int index = 0; index < this.m_orderItems.size(); ++index) {
            if (this.m_orderItems.elementAt(index) != itemToDelete) continue;
            this.m_orderItems.removeElementAt(index);
            this.queueStructureChange(256, 2, itemToDelete);
            break;
        }
    }

    public void moveOrderItem(int oldPosition, int newPosition) {
        OrderItem itemToMove = this.m_orderItems.elementAt(oldPosition);
        if (oldPosition == newPosition) {
            return;
        }
        if (newPosition < oldPosition) {
            this.m_orderItems.insertElementAt(itemToMove, newPosition);
            this.m_orderItems.removeElementAt(oldPosition + 1);
        } else if (oldPosition < newPosition) {
            this.m_orderItems.removeElementAt(oldPosition);
            this.m_orderItems.insertElementAt(itemToMove, newPosition);
        }
        this.queueStructureChange(256, 4, itemToMove);
    }

    public OrderItemList getOrderItems() {
        return this.m_orderItems;
    }

    public OrderItem getOrderItem(int position) {
        return this.m_orderItems.elementAt(position);
    }

    public int getOrderItemCount() {
        return this.m_orderItems.size();
    }

    public int getPositionForOrderItem(OrderItem itemToFind) {
        for (int index = 0; index < this.m_orderItems.size(); ++index) {
            OrderItem orderItem = this.m_orderItems.elementAt(index);
            if (orderItem != itemToFind) continue;
            return index;
        }
        return -1;
    }

    public GroupItem addGroupItem(Expression expression) {
        GroupItem groupItem = new GroupItem(this, expression);
        this.addGroupItem(groupItem);
        return groupItem;
    }

    public GroupItem addGroupItem(Column columnToAdd) {
        if (this.m_groupItems.size() == this.m_dataSource.getProperties().getMaxColumnsInGroupBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxGroupBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInGroupBy())));
            return null;
        }
        ColumnExpression expression = new ColumnExpression(columnToAdd);
        GroupItem groupItem = new GroupItem(this, expression);
        this.addGroupItem(groupItem);
        return groupItem;
    }

    public GroupItem addGroupItem(ResultItem resultItemToAdd) {
        if (this.m_groupItems.size() == this.m_dataSource.getProperties().getMaxColumnsInGroupBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxGroupBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInGroupBy())));
            return null;
        }
        GroupItem groupItem = new GroupItem(resultItemToAdd);
        this.addGroupItem(groupItem);
        return groupItem;
    }

    public void addGroupItem(GroupItem itemToAdd) {
        if (this.m_groupItems.size() == this.m_dataSource.getProperties().getMaxColumnsInGroupBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxGroupBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInGroupBy())));
            return;
        }
        this.m_groupItems.addElement(itemToAdd);
        this._shareWithResultItem(itemToAdd);
        this.queueStructureChange(64, 1, itemToAdd);
    }

    public void addGroupItem(GroupItem itemToAdd, int position) {
        if (this.m_groupItems.size() == this.m_dataSource.getProperties().getMaxColumnsInGroupBy()) {
            this.addError(bundle.messageString("Message.Query.ExceedMaxGroupBy.fmt.txt", new Integer(this.m_dataSource.getProperties().getMaxColumnsInGroupBy())));
            return;
        }
        this.m_groupItems.insertElementAt(itemToAdd, position);
        this._shareWithResultItem(itemToAdd);
        this.queueStructureChange(64, 1, itemToAdd);
    }

    public void deleteGroupItem(GroupItem itemToDelete) {
        if (itemToDelete == null) {
            return;
        }
        for (int index = 0; index < this.m_groupItems.size(); ++index) {
            if (this.m_groupItems.elementAt(index) != itemToDelete) continue;
            this.m_groupItems.removeElementAt(index);
            this.queueStructureChange(64, 2, itemToDelete);
            break;
        }
    }

    public void moveGroupItem(int oldPosition, int newPosition) {
        GroupItem itemToMove = this.m_groupItems.elementAt(oldPosition);
        if (oldPosition == newPosition) {
            return;
        }
        if (newPosition < oldPosition) {
            this.m_groupItems.insertElementAt(itemToMove, newPosition);
            this.m_groupItems.removeElementAt(oldPosition + 1);
        } else if (oldPosition < newPosition) {
            this.m_groupItems.removeElementAt(oldPosition);
            this.m_groupItems.insertElementAt(itemToMove, newPosition);
        }
        this.queueStructureChange(64, 4, itemToMove);
    }

    public GroupItemList getGroupItems() {
        return this.m_groupItems;
    }

    public GroupItem getGroupItem(int position) {
        return this.m_groupItems.elementAt(position);
    }

    public int getGroupItemCount() {
        return this.m_groupItems.size();
    }

    public int getPositionForGroupItem(GroupItem itemToFind) {
        for (int index = 0; index < this.m_groupItems.size(); ++index) {
            GroupItem groupItem = this.m_groupItems.elementAt(index);
            if (groupItem != itemToFind) continue;
            return index;
        }
        return -1;
    }

    public FilterNode addHavingAndFilter(Expression expressionToBaseFilterOn) {
        return this.getHavingFilterTree().addAnd(expressionToBaseFilterOn);
    }

    public void addHavingAndFilter(FilterNode filterToAdd) {
        if (this.getHavingFilterTree().getSelectedNode() != null) {
            this.getHavingFilterTree().getSelectedNode().addAnd(filterToAdd);
        } else {
            this.getHavingFilterTree().addAnd(filterToAdd);
        }
    }

    public void addHavingAndFilter(FilterNode filterToAdd, FilterNode filterToAddTo) {
        filterToAddTo.addAnd(filterToAdd);
    }

    public void addHavingOrFilter(FilterNode filterToAdd) {
        if (this.getHavingFilterTree().getSelectedNode() != null) {
            this.getHavingFilterTree().getSelectedNode().addOr(filterToAdd);
        } else {
            this.getHavingFilterTree().addOr(filterToAdd);
        }
    }

    public void addHavingOrFilter(FilterNode filterToAdd, FilterNode filterToAddTo) {
        filterToAddTo.addOr(filterToAdd);
    }

    public void deleteHavingFilter(FilterNode filterToDelete) {
        this.getHavingFilterTree().removeNode(filterToDelete);
    }

    public void setHavingSelectedFilter(FilterNode filterToSelect) {
        this.getHavingFilterTree().setSelectedNode(filterToSelect);
    }

    public FilterNode getHavingSelectedFilter() {
        return this.getHavingFilterTree().getSelectedNode();
    }

    public FilterTree getHavingFilterTree() {
        return this.m_havingFilterTree;
    }

    @Override
    public SqlLogic getSqlLogic() {
        return this.getDataSource().getSqlLogic(this);
    }

    public void validateQuery() {
        if (!this.isParsable()) {
            return;
        }
        boolean fErrorFound = false;
        Vector nodesInTree = new Vector();
        this.getWhereFilterTree().getNodesVector(nodesInTree, this.getWhereFilterTree().getRoot());
        for (int index = 0; index < nodesInTree.size(); ++index) {
            FilterNode node = (FilterNode)nodesInTree.elementAt(index);
            if (node.getLimitString() != null) continue;
            fErrorFound = true;
            break;
        }
        if (fErrorFound) {
            this.addError(bundle.messageString("message.query.invalidNode"));
            return;
        }
    }

    public boolean canResultsBeGotten() {
        boolean bResultsCanBeGotten = true;
        if (this.m_query.isParsable() && (this.m_query.getTableCount() < 1 || this.m_query.getResultItemCount() < 1)) {
            bResultsCanBeGotten = false;
        }
        return bResultsCanBeGotten;
    }

    public String getSql() {
        if (this.m_strSql != null) {
            return this.m_strSql;
        }
        String strQuery = this.getSqlLogic().genQuery(this);
        if (this.failureHasOccurred()) {
            this.addError(bundle.getString("Message.Query.invalidQuery.txt"));
        }
        return strQuery;
    }

    public String getSql(FilterNode finalWhereNode, FilterNode finalHavingNode) {
        if (this.m_strSql != null) {
            return this.m_strSql;
        }
        String strQuery = this.getSqlLogic().genQuery(this, finalWhereNode, finalHavingNode);
        if (this.failureHasOccurred()) {
            this.addError(bundle.getString("Message.Query.invalidQuery.txt"));
        }
        return strQuery;
    }

    public boolean isValidSql() {
        boolean bReturnValue = true;
        boolean bGoToServer = QueryConfiguration.getConfigurationBoolean("ValidateSqlBySendingToServer.notrans", true);
        if (bGoToServer) {
            bReturnValue = this.m_dataSource.isValidSql(this);
        }
        return bReturnValue;
    }

    public String getSelectedColumnString() {
        return this.getSqlLogic().genSelectedColumnList();
    }

    public String getFromString() {
        return this.getSqlLogic().genFromClause();
    }

    public String getWhereString() {
        return this.getSqlLogic().genWhereClause();
    }

    public String getOrderByString() {
        return this.getSqlLogic().genOrderByClause();
    }

    public String getGroupByString() {
        return this.getSqlLogic().genGroupByClause();
    }

    public String getHavingString() {
        return this.getSqlLogic().genHavingClause();
    }

    public void setSQL(String strSql) {
        Parser parser = new Parser();
        this.clear();
        try {
            parser.parseQuery(this, strSql, this.getMessageHandler());
            if (this.failureHasOccurred()) {
                this.clear();
                this.m_strSql = strSql;
            }
        }
        catch (Exception e) {
            this.m_strSql = strSql;
        }
    }

    public void setWhereString(String strWhere) {
        Parser parser = new Parser();
        parser.parseWhere(this, strWhere);
    }

    public void setHavingString(String strHaving) {
        Parser parser = new Parser();
        parser.parseHaving(this, strHaving);
    }

    public Query getUnion() {
        return this.m_secondaryQuery;
    }

    public int getUnionType() {
        return this.m_nSecondaryQueryType;
    }

    public void setUnionType(int type) {
        this.m_nSecondaryQueryType = type;
        this.queueDataChange(512, null, new Integer(type));
    }

    public static int getUnionIndex(Query query) {
        Query tempQuery = query.getPrimaryQuery();
        if (tempQuery == null) {
            return 1;
        }
        int index = 1;
        while (tempQuery != null) {
            if (tempQuery == query) {
                return index;
            }
            ++index;
            tempQuery = tempQuery.getUnion();
        }
        return -1;
    }

    public void setPrimaryQuery(Query primaryQuery) {
        this.m_primaryQuery = primaryQuery;
        this.queueStructureChange(512);
    }

    public Query getPrimaryQuery() {
        return this.m_primaryQuery;
    }

    public void setUnion(Query primaryQuery, Query nextQuery, int type) {
        this.m_primaryQuery = primaryQuery;
        this.m_secondaryQuery = nextQuery;
        this.m_nSecondaryQueryType = type;
        this.queueStructureChange(512, 1, nextQuery);
    }

    public void addUnion(Query nextQuery, int type) {
        if (this.m_secondaryQuery != null) {
            nextQuery.setUnion(this.m_primaryQuery, this.m_secondaryQuery, this.m_nSecondaryQueryType);
        }
        this.m_secondaryQuery = nextQuery;
        this.m_nSecondaryQueryType = type;
        nextQuery.setPrimaryQuery(this.m_primaryQuery == null ? this : this.m_primaryQuery);
        this.queueStructureChange(512, 1, nextQuery);
    }

    public void deleteUnion() {
        this.m_secondaryQuery = this.m_secondaryQuery.getUnion();
        this.m_nSecondaryQueryType = this.m_secondaryQuery.getUnionType();
        if (this.m_primaryQuery == this && this.m_secondaryQuery == null) {
            this.m_primaryQuery = null;
        }
        this.queueStructureChange(512, 2, this.m_secondaryQuery);
    }

    public void deleteFromUnion() {
        Query parent;
        for (parent = this.getPrimaryQuery(); parent != null && parent.getUnion() != this; parent = parent.getUnion()) {
        }
        if (parent == this.getPrimaryQuery()) {
            this.setPrimaryQuery(this.m_secondaryQuery);
            for (Query tempQuery = this.m_secondaryQuery; tempQuery != null; tempQuery = tempQuery.getUnion()) {
                tempQuery.setPrimaryQuery(this.m_secondaryQuery);
            }
        }
        if (this.m_secondaryQuery != null) {
            parent.setUnion(this.m_primaryQuery, this.m_secondaryQuery.getUnion(), this.m_secondaryQuery.getUnionType());
        } else {
            parent.setUnion(this.m_primaryQuery, null, 0);
        }
        if (this.m_primaryQuery == this && this.m_secondaryQuery == null) {
            this.m_primaryQuery = null;
        }
        this.queueStructureChange(512, 2, this);
    }

    public int getLimits() {
        return this.m_limits;
    }

    public void setLimits(int limits) {
        this.m_limits = limits;
    }

    public boolean getLimit(int limitToCheck) {
        return (this.m_limits & limitToCheck) != 0;
    }

    public FunctionList getValidConditionals() {
        if (this.m_dataSource != null) {
            return this.m_dataSource.getProperties().getAllFunctions().getSubsetByReturnType(32768);
        }
        return null;
    }

    public Function getConditionalByShortCut(char charToMatch) {
        FunctionList conditionalList = this.getValidConditionals();
        for (int index = 0; index < conditionalList.size(); ++index) {
            Function conditional = conditionalList.elementAt(index);
            if (!conditional.hasShortCut(charToMatch)) continue;
            return conditional;
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    @Override
    public SqlProperties getSqlProperties() {
        return this.m_dataSource.getProperties();
    }

    public FunctionList getDataSourceFunctions() {
        return this.m_dataSource.getProperties().getAllFunctions();
    }

    public Function getDataSourceFunction(int iFunctionType, String functionName, int priParmType, int functionReturnType, int nParms) {
        return this.getDataSourceFunctions().findFunction(iFunctionType, functionName, priParmType, functionReturnType, nParms);
    }

    public ExpressionList getExpressions() {
        Expression expression;
        int index;
        ExpressionList expressionList = new ExpressionList();
        for (int index2 = 0; index2 < this.m_resultItems.size(); ++index2) {
            Expression expression2 = this.m_resultItems.elementAt(index2).getExpression();
            if (expression2 == null) continue;
            expressionList.addElement(expression2);
        }
        ExpressionList newList = this.m_whereFilterTree.getExpressions();
        expressionList.add(newList);
        newList = this.m_havingFilterTree.getExpressions();
        expressionList.add(newList);
        for (index = 0; index < this.m_groupItems.size(); ++index) {
            expression = this.m_groupItems.elementAt(index).getExpression();
            if (expression == null) continue;
            expressionList.addElement(expression);
        }
        for (index = 0; index < this.m_orderItems.size(); ++index) {
            expression = this.m_orderItems.elementAt(index).getExpression();
            if (expression == null) continue;
            expressionList.addElement(expression);
        }
        return expressionList;
    }

    protected RefreshInterfaceList getRefreshableObjects() {
        RefreshInterfaceList objectList = new RefreshInterfaceList();
        TableList tableList = this.getTables();
        for (int index = 0; index < tableList.size(); ++index) {
            if (!(tableList.elementAt(index) instanceof RefreshInterface)) continue;
            objectList.addElement((RefreshInterface)((Object)tableList.elementAt(index)));
        }
        ExpressionList expressionList = this.getExpressions();
        for (int index = 0; index < expressionList.size(); ++index) {
            objectList.addElement(expressionList.elementAt(index));
        }
        return objectList;
    }

    public RefreshMapTable getDefaultRefreshMapping(DataSource newDso) {
        RefreshMapTable refreshMapTable = new RefreshMapTable();
        RefreshInterfaceList refreshList = this.getRefreshableObjects();
        for (int index = 0; index < refreshList.size(); ++index) {
            RefreshInterface oldObject = refreshList.elementAt(index);
            oldObject.getDefaultRefreshMapping(newDso, refreshMapTable);
        }
        return refreshMapTable;
    }

    public void setDataSource(DataSource newDso) {
        this.setDataSource(newDso, null);
        if (this.failureHasOccurred()) {
            return;
        }
        this.clear();
        this.setDataSource(newDso, null);
        if (this.failureHasOccurred()) {
            this.addError(bundle.getString("Message.Query.badDataSource.txt"));
            return;
        }
    }

    public void setDataSource(DataSource newDso, RefreshMapTable mapTable) {
        DataSource oldDso = this.m_dataSource;
        this.m_dataSource = newDso;
        if (mapTable == null) {
            mapTable = this.getDefaultRefreshMapping(newDso);
        }
        Enumeration keys = mapTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object newDsoMapping = mapTable.get(key);
            if (newDsoMapping != null) continue;
            this.addError(bundle.getString("Message.Query.noDataSourceSwitch.txt"));
            return;
        }
        RefreshInterfaceList refreshList = this.getRefreshableObjects();
        for (int index = 0; index < refreshList.size(); ++index) {
            refreshList.elementAt(index).refresh(newDso, mapTable);
        }
        this.queueDataChange(1024, DataSourcePropertyChange, oldDso);
    }

    public void setShowLabels(boolean doShow) {
        this.m_showLabels = doShow;
    }

    public boolean isShowLabels() {
        return this.m_showLabels;
    }

    public PropertyChangeHandler getPropertyChangeHandler() {
        return this.getMessageHandler();
    }

    public MessageHandler getMessageHandler() {
        if (this.m_messageHandler == null) {
            this.m_messageHandler = new MessageHandler();
        }
        return this.m_messageHandler;
    }

    public void openQueryFromView(String viewName, String password) {
        this.openQueryFromView(null, false, viewName, password);
    }

    public void openQueryFromView(String viewName) {
        this.openQueryFromView(null, false, viewName);
    }

    public void openQueryFromView(Frame parentFrame, boolean promptForPasswords, String viewName) {
        this.openQueryFromView(parentFrame, promptForPasswords, viewName, null);
    }

    public void openQueryFromView(Frame parentFrame, boolean promptForPasswords, String viewName, String password) {
        try {
            String viewSql = this.getDataSource().getViewSql(parentFrame, promptForPasswords, viewName, this, password);
            if (!this.failureHasOccurred()) {
                this.setSQL(viewSql);
            }
        }
        catch (Exception exception) {
            this.getMessageHandler().addInternalError(exception);
        }
    }

    public void saveQueryToView(String viewName, String passwordForViewDefinition) {
        String strQuery = this.getSql();
        DataSource dso = this.getDataSource();
        dso.createView(strQuery, viewName, passwordForViewDefinition);
        this.queueStructureChange(1024, 1, viewName);
    }

    public void saveQueryToTable(String tableName) {
        String strQuery = this.getSql();
        this.getDataSource().createTable(strQuery, tableName);
        this.queueStructureChange(1024, 1, tableName);
    }

    public void openQueryFromFile(String path) {
        try {
            FileReader input = new FileReader(path);
            StringBuffer strSql = new StringBuffer();
            int cChars = 0;
            char[] cbuf = new char[512];
            while ((cChars = input.read(cbuf)) != -1) {
                strSql.append(cbuf, 0, cChars);
                if (cChars == cbuf.length) continue;
            }
            input.close();
            String trimmedSql = strSql.toString().trim();
            if (trimmedSql.startsWith("<?xml")) {
                XmlUtil.readXml(path, this, this.getMessageHandler());
            } else {
                this.clear();
                this.setSQL(strSql.toString().trim());
            }
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
    }

    public void saveQueryToFile(String path) {
        String selectString = this.getSql();
        try {
            FileWriter output = new FileWriter(path);
            output.write(QueryUtils.formatSql(selectString, this.m_dataSource));
            output.close();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
    }

    protected OrderItem _orderItemResyncAdded(ResultItem resultItem) {
        for (int index = 0; index < this.m_orderItems.size(); ++index) {
            OrderItem orderItem = this.m_orderItems.elementAt(index);
            if (orderItem.getResultItem() != resultItem) continue;
            return orderItem;
        }
        Expression resultExp = resultItem.getExpression();
        for (int index = 0; index < this.m_orderItems.size(); ++index) {
            OrderItem orderItem = this.m_orderItems.elementAt(index);
            if (orderItem.getResultItem() != null || !resultExp.equivalentTo(this, orderItem.getExpression())) continue;
            orderItem.setResultItem(resultItem);
            return orderItem;
        }
        return null;
    }

    protected GroupItem _groupItemResyncAdded(ResultItem resultItem) {
        for (int index = 0; index < this.m_groupItems.size(); ++index) {
            GroupItem groupItem = this.m_groupItems.elementAt(index);
            if (groupItem.getResultItem() != resultItem) continue;
            return groupItem;
        }
        Expression resultExp = resultItem.getExpression();
        for (int index = 0; index < this.m_groupItems.size(); ++index) {
            GroupItem groupItem = this.m_groupItems.elementAt(index);
            if (groupItem.getResultItem() != null || !resultExp.equivalentTo(this, groupItem.getExpression())) continue;
            groupItem.setResultItem(resultItem);
            return groupItem;
        }
        return null;
    }

    protected void _orderItemResyncDeleted(ResultItem resultItem) {
        for (int index = 0; index < this.m_orderItems.size(); ++index) {
            OrderItem orderItem = this.m_orderItems.elementAt(index);
            if (orderItem.getResultItem() != resultItem) continue;
            try {
                orderItem.setExpression((Expression)resultItem.getExpression().clone());
            }
            catch (CloneNotSupportedException e) {
                this.m_messageHandler.addInternalError(bundle, "Message.Query.cantCopyExpression.txt");
            }
            break;
        }
    }

    protected void _groupItemResyncDeleted(ResultItem resultItem) {
        for (int index = 0; index < this.m_groupItems.size(); ++index) {
            GroupItem groupItem = this.m_groupItems.elementAt(index);
            if (groupItem.getResultItem() != resultItem) continue;
            try {
                groupItem.setExpression((Expression)resultItem.getExpression().clone());
            }
            catch (CloneNotSupportedException e) {
                this.m_messageHandler.addInternalError(bundle, "Message.Query.cantCopyExpression.txt");
            }
            break;
        }
    }

    public Expression shareExpressionWithResultItem(Expression expression, ModelChangeListener listener) {
        Expression returnExpression = expression;
        ResultItemList resultList = this.getResultItems();
        String expressionString = expression.generateSQL(this.getSqlLogic(), 2);
        for (int index = 0; index < resultList.size(); ++index) {
            ResultItem resultItem = resultList.elementAt(index);
            if (!resultItem.getExpression().equivalentTo(this, expression) && !resultItem.getAliasString().equals(expressionString)) continue;
            returnExpression = resultItem.getExpression();
            if (listener == null) break;
            resultItem.addPropertyListener(listener, 4);
            break;
        }
        if (expression instanceof CompoundExpression) {
            CompoundExpression compound = (CompoundExpression)expression;
            ExpressionList parmList = compound.getParameters();
            for (int index = 0; index < parmList.size(); ++index) {
                Expression newParmExpression;
                Expression oldParmExpression = parmList.elementAt(index);
                if (oldParmExpression == null || oldParmExpression == (newParmExpression = this.shareExpressionWithResultItem(oldParmExpression, listener))) continue;
                parmList.setElementAt(newParmExpression, index);
            }
        }
        return returnExpression;
    }

    protected void _shareWithResultItem(OrderItem item) {
        ResultItemList resultList = this.getResultItems();
        OrderItemList orderList = this.getOrderItems();
        for (int index = 0; index < resultList.size(); ++index) {
            ResultItem resultItem = resultList.elementAt(index);
            if (!resultItem.getExpression().equivalentTo(this, item.getExpression()) || !resultItem.getAliasString().equals(item.getResultItem().getAliasString())) continue;
            boolean bUsed = false;
            for (int orderIndex = 0; orderIndex < orderList.size(); ++orderIndex) {
                OrderItem orderItem = orderList.elementAt(orderIndex);
                if (orderItem.getResultItem() != resultItem) continue;
                bUsed = true;
            }
            if (bUsed) continue;
            item.setResultItem(resultItem);
            return;
        }
    }

    protected void _shareWithResultItem(GroupItem item) {
        ResultItemList resultList = this.getResultItems();
        GroupItemList groupList = this.getGroupItems();
        for (int index = 0; index < resultList.size(); ++index) {
            ResultItem resultItem = resultList.elementAt(index);
            if (!resultItem.getExpression().equivalentTo(this, item.getExpression()) || !resultItem.getAliasString().equals(item.getResultItem().getAliasString())) continue;
            boolean bUsed = false;
            for (int groupIndex = 0; groupIndex < groupList.size(); ++groupIndex) {
                GroupItem groupItem = groupList.elementAt(groupIndex);
                if (groupItem.getResultItem() != resultItem) continue;
                bUsed = true;
            }
            if (bUsed) continue;
            item.setResultItem(resultItem);
            return;
        }
    }
}

