/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.query.QueryConfiguration;
import com.sas.query.QueryString;
import com.sas.query.app.AppSupport;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import com.sas.query.visuals.WindowUtil;
import com.sas.rmi.Connection;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JQueryFrame
extends JFrame {
    private transient QueryString m_queryString;
    private transient JPanel m_menuPanel;
    private transient QueryTabView m_viewer;
    private transient boolean m_showLabels;
    private transient boolean m_showMenu = true;
    private transient boolean m_showToolbar = true;
    private transient boolean m_allowAdvancedJoins = true;
    private transient boolean m_allowResultWindow = true;
    private transient boolean m_allowFileRead;
    private transient boolean m_allowFileSave;
    private transient boolean m_allowViewRead;
    private transient boolean m_allowViewSave;
    private transient boolean m_allowTableSave;
    private transient Hashtable m_menuItems;
    protected transient JMenuBar m_menubar;
    protected transient JToolBar m_toolbar;
    private transient AppSupport m_appSupport;
    static QueryConfiguration queryConfig = new QueryConfiguration();
    static QueryResource bundle = new QueryResource(JQueryFrame.class);
    private static String AdvancedJoinsAllowed = "AdvancedJoinsAllowed.notrans";
    private static String FileReadAllowed = "Visual.FileReadAllowed.notrans";
    private static String FileSaveAllowed = "Visual.FileSaveAllowed.notrans";
    private static String MenuVisible = "Visual.MenuVisible.notrans";
    private static String TableSaveAllowed = "Visual.TableSaveAllowed.notrans";
    private static String ToolbarVisible = "Visual.ToolbarVisible.notrans";
    private static String ViewReadAllowed = "Visual.ViewReadAllowed.notrans";
    private static String ViewSaveAllowed = "Visual.ViewSaveAllowed.notrans";
    private static String ShowLabels = "Visual.ShowLabels.notrans";

    public JQueryFrame() {
        this.dosetLookAndFeel();
    }

    public JQueryFrame(Connection conn, String title) {
        super(title);
        this.dosetLookAndFeel();
        this.setConnection(conn);
        this.setTitle(title);
        this._createWidgets();
        this._layoutWidgets();
        this._setState();
    }

    public JQueryFrame(QueryString qString, String title) {
        super(title);
        this.dosetLookAndFeel();
        this.setQueryString(qString);
        this.setTitle(title);
        this._createWidgets();
        this._layoutWidgets();
        this._setState();
    }

    private void dosetLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void _createWidgets() {
        if (this.m_viewer == null) {
            this.m_viewer = new QueryTabView(this.m_queryString.getQuery());
        } else {
            this.m_viewer.setQuery(this.m_queryString.getQuery());
        }
        this.m_appSupport = new AppSupport(this.m_queryString.getQuery(), this);
        this.m_appSupport.setExitOnClose(false);
        this.m_appSupport.setTabbedView(this.m_viewer);
        this._setDefaultOptions();
        this.m_menuPanel = this.m_appSupport.getMenuPanel(bundle.getString("webAFMenubarKeyString.notrans"), bundle.getString("webAFToolbarKeyString.notrans"));
    }

    private void _setDefaultOptions() {
        if (this.m_appSupport != null) {
            this.setFileReadAllowed(QueryConfiguration.getConfigurationBoolean(FileReadAllowed, true));
            this.setFileSaveAllowed(QueryConfiguration.getConfigurationBoolean(FileSaveAllowed, true));
            this.setViewReadAllowed(QueryConfiguration.getConfigurationBoolean(ViewReadAllowed, true));
            this.setViewSaveAllowed(QueryConfiguration.getConfigurationBoolean(ViewSaveAllowed, true));
            this.setTableSaveAllowed(QueryConfiguration.getConfigurationBoolean(TableSaveAllowed, true));
            this.setAdvancedJoinsAllowed(QueryConfiguration.getConfigurationBoolean(AdvancedJoinsAllowed, true));
            this.setShowLabels(QueryConfiguration.getConfigurationBoolean(ShowLabels, true));
        }
    }

    private void _layoutWidgets() {
        if (this.isMenuVisible()) {
            this.getContentPane().add("North", this.m_menuPanel);
        }
        this.m_viewer.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.getContentPane().add(this.m_viewer);
        this.setSize(WindowUtil.getBestWindowSize(new Dimension(868, 540)));
    }

    private void _setState() {
        this.m_viewer.setState();
    }

    public void setQueryString(QueryString queryString) {
        this.m_queryString = queryString;
        if (this.m_viewer != null) {
            this.m_viewer.setQuery(this.m_queryString.getQuery());
        }
    }

    public void setConnection(Connection conn) {
        QueryString queryString = new QueryString(conn, "");
        this.setQueryString(queryString);
    }

    public QueryString getQueryString() {
        return this.m_queryString;
    }

    public boolean isQueryTabVisible() {
        return this.m_viewer.isQueryTabVisible();
    }

    public boolean isDataFiltersTabVisible() {
        return this.m_viewer.isDataFiltersTabVisible();
    }

    public boolean isGroupFiltersTabVisible() {
        return this.m_viewer.isGroupFiltersTabVisible();
    }

    public boolean isResultsTabVisible() {
        return this.m_viewer.isResultsTabVisible();
    }

    public boolean isSQLTabVisible() {
        return this.m_viewer.isSQLTabVisible();
    }

    public boolean isAdvancedJoinsAllowed() {
        return this.m_allowAdvancedJoins;
    }

    public boolean isFileReadAllowed() {
        return this.m_allowFileRead;
    }

    public boolean isFileSaveAllowed() {
        return this.m_allowFileSave;
    }

    public boolean isViewReadAllowed() {
        return this.m_allowViewRead;
    }

    public boolean isViewSaveAllowed() {
        return this.m_allowViewSave;
    }

    public boolean isTableSaveAllowed() {
        return this.m_allowTableSave;
    }

    public boolean areColumnLabelsUsed() {
        return this.m_showLabels;
    }

    public boolean isToolbarVisible() {
        return this.m_showToolbar;
    }

    public boolean isMenuVisible() {
        return this.m_showMenu;
    }

    public boolean isExitOnClose() {
        return this.m_appSupport.isExitOnClose();
    }

    public QueryTabView getQueryTabView() {
        return this.m_viewer;
    }

    public AppSupport getAppSupport() {
        return this.m_appSupport;
    }

    public JPanel setMenuPanel(JPanel menuPanel) {
        JPanel oldMenuPanel = this.m_menuPanel;
        if (this.isMenuVisible()) {
            this.getContentPane().remove(this.m_menuPanel);
            this.m_menuPanel = menuPanel;
            this.getContentPane().add("North", this.m_menuPanel);
        }
        return oldMenuPanel;
    }

    private void setConfigOption(String option, boolean value) {
    }

    public void setAdvancedJoinsAllowed(boolean allow) {
        this.m_allowAdvancedJoins = allow;
        this.m_appSupport.setAdvancedJoinsAllowed(allow);
    }

    public void setFileReadAllowed(boolean allow) {
        this.m_allowFileRead = allow;
        this.m_appSupport.setFileReadAllowed(allow);
    }

    public void setFileSaveAllowed(boolean allow) {
        this.m_allowFileSave = allow;
        this.m_appSupport.setFileSaveAllowed(allow);
    }

    public void setViewReadAllowed(boolean allow) {
        this.m_allowViewRead = allow;
        this.m_appSupport.setViewReadAllowed(allow);
    }

    public void setViewSaveAllowed(boolean allow) {
        this.m_allowViewSave = allow;
        this.m_appSupport.setViewSaveAllowed(allow);
    }

    public void setTableSaveAllowed(boolean allow) {
        this.m_allowTableSave = allow;
        this.m_appSupport.setTableSaveAllowed(allow);
    }

    public void setShowLabels(boolean doShow) {
        this.m_showLabels = doShow;
        this.m_appSupport.setShowLabels(doShow);
    }

    public void setShowToolbar(boolean doShow) {
        this.m_showToolbar = doShow;
        if (this.m_menuPanel != null) {
            Component[] x = this.m_menuPanel.getComponents();
            x[1].setVisible(doShow);
        }
    }

    public void setShowMenu(boolean doShow) {
        this.m_showMenu = doShow;
        if (this.m_menuPanel != null) {
            Component[] x = this.m_menuPanel.getComponents();
            x[0].setVisible(doShow);
        }
    }

    public void setQueryTabVisible(boolean doShow) {
        this.m_viewer.setQueryTabVisible(doShow);
    }

    public void setDataFiltersTabVisible(boolean doShow) {
        this.m_viewer.setDataFiltersTabVisible(doShow);
    }

    public void setGroupFiltersTabVisible(boolean doShow) {
        this.m_viewer.setGroupFiltersTabVisible(doShow);
    }

    public void setResultsTabVisible(boolean doShow) {
        this.m_viewer.setResultsTabVisible(doShow);
    }

    public void setSQLTabVisible(boolean doShow) {
        this.m_viewer.setSQLTabVisible(doShow);
    }

    public void setExitOnClose(boolean flag) {
        this.m_appSupport.setExitOnClose(flag);
    }
}

