/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.cluster.client.SessionUtilityServiceInterface;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpService;
import com.sas.svcs.cluster.httpinvoker.stateful.SessionRouteHolder;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.SessionUtils;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SessionUtilityService
implements SessionUtilityServiceInterface,
DisposableBean {
    public static final Logger LOGGER = LogManager.getLogger(SessionUtilityService.class);
    private HttpInvokerRequestExecutor executor;
    private ConfigurationServiceInterface configService;
    private StickyRandomPolicy policy;
    private boolean useLocalSessionHolder;
    private boolean useClientSession = true;

    public void setExecutor(HttpInvokerRequestExecutor executor) {
        this.executor = executor;
    }

    public void setConfigurationService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    public void setStickyRandomPolicy(StickyRandomPolicy policy) {
        this.policy = policy;
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        if (this.policy == null) {
            this.policy = new StickyRandomPolicy();
            this.policy.setServiceURLDAO(serviceURLDAO);
        }
    }

    public void setUseLocalSessionHolder(boolean useLocalSesisonHolder) {
        this.useLocalSessionHolder = useLocalSesisonHolder;
    }

    public void setUseClientSession(boolean useClientSession) {
        this.useClientSession = useClientSession;
    }

    protected int discoverSessionTargets(MultiValueMap<URI, UUID> sessionTargets, boolean allowKeepAlives) {
        HttpSession session;
        int remainingTime = 0;
        if (this.useClientSession && (session = SessionUtils.getSession((boolean)false)) != null) {
            remainingTime = session.getMaxInactiveInterval();
            if (allowKeepAlives) {
                Enumeration attNames = session.getAttributeNames();
                while (attNames.hasMoreElements()) {
                    Object obj;
                    String attName = (String)attNames.nextElement();
                    UUID uuid = null;
                    try {
                        uuid = UUID.fromString(attName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == uuid || !((obj = session.getAttribute(attName)) instanceof String)) continue;
                    try {
                        URI selectionTarget = new URI((String)obj);
                        sessionTargets.add((Object)selectionTarget, (Object)uuid);
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
        }
        return remainingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performSessionCheck(Set<URI> localTargets, MultiValueMap<URI, UUID> sessionTargets, int remainingTime) {
        HashSet<URI> allTargets = new HashSet<URI>(localTargets.size() + sessionTargets.size());
        allTargets.addAll(localTargets);
        allTargets.addAll(sessionTargets.keySet());
        if (!allTargets.isEmpty()) {
            AutoDiscoveredHttpService serviceFactory = new AutoDiscoveredHttpService(this.policy, SessionUtilityServiceInterface.class.getName());
            serviceFactory.setMaximumFailuresPerUrl(1);
            serviceFactory.setMaximumTries(1);
            serviceFactory.setHttpInvokerRequestExecutor(this.executor);
            serviceFactory.afterPropertiesSet();
            SessionUtilityServiceInterface sessionUtilityService = (SessionUtilityServiceInterface)serviceFactory.getObject();
            for (URI target : localTargets) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Attempting to set selection target and invoke SessionUtilityService for " + target);
                    }
                    StickyRandomPolicy.setSelectionTarget(target);
                    int timeout = sessionUtilityService.sessionCheck();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Max inactive session interval from '%s' is %d seconds", target, timeout));
                    }
                    if (timeout < 0 || remainingTime < 0) {
                        remainingTime = Math.max(remainingTime, timeout);
                        continue;
                    }
                    remainingTime = Math.min(remainingTime, timeout);
                }
                catch (Throwable t) {
                    LOGGER.warn("Exception encountered while pinging " + target, t);
                    List uuids = (List)sessionTargets.get((Object)target);
                    if (null != uuids && !uuids.isEmpty()) {
                        HttpSession session;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Attempting to remove target " + target + " from local session attributes");
                        }
                        if (null != (session = SessionUtils.getSession((boolean)false))) {
                            for (UUID uuid : uuids) {
                                session.removeAttribute(uuid.toString());
                            }
                        }
                    }
                    if (!localTargets.contains(target)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Attempting to remove target " + target + " from SessionRouteHolder");
                    }
                    SessionRouteHolder.removeUriIfPresent(target);
                }
                finally {
                    StickyRandomPolicy.clearSelectionTarget();
                }
            }
        }
        return remainingTime;
    }

    public int sessionCheck() {
        Properties props = this.configService != null ? this.configService.getSettings("SAS Application Infrastructure") : null;
        String allowKeepAlivesSetting = props != null ? props.getProperty("Policy.AllowServiceKeepAlives") : null;
        boolean allowKeepAlives = Boolean.parseBoolean(allowKeepAlivesSetting);
        HashSet<URI> localTargets = new HashSet<URI>();
        LinkedMultiValueMap sessionTargets = new LinkedMultiValueMap();
        int remainingTime = this.discoverSessionTargets((MultiValueMap<URI, UUID>)sessionTargets, allowKeepAlives);
        if (allowKeepAlives && this.useLocalSessionHolder) {
            localTargets.addAll(SessionRouteHolder.getRoutes());
        }
        remainingTime = this.performSessionCheck(localTargets, (MultiValueMap<URI, UUID>)sessionTargets, remainingTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Max inactive session interval is %d seconds", remainingTime));
        }
        return remainingTime;
    }

    public void destroy() throws Exception {
        if (null != this.policy) {
            this.policy.destroy();
        }
    }
}

