/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.svcs.cluster.httpinvoker.stateful.DropBox;
import com.sas.svcs.cluster.httpinvoker.stateful.StatefulServiceLifecycleEvent;
import com.sas.svcs.cluster.httpinvoker.stateful.StatefulServiceLifecycleEventListenerInterface;

public abstract class DropBoxItem<T> {
    private static final RemovalNotification CALLBACK = new RemovalNotification();
    private T _item;
    private StatefulServiceLifecycleEventListenerInterface _listener;

    public DropBoxItem(T item) {
        this(item, null);
    }

    public DropBoxItem(T item, StatefulServiceLifecycleEventListenerInterface listener) {
        if (item == null) {
            throw new NullPointerException();
        }
        this._item = item;
        this._listener = listener;
    }

    public synchronized T getItem() {
        return this._item;
    }

    public synchronized StatefulServiceLifecycleEventListenerInterface getListener() {
        return this._listener;
    }

    public String storeIn(DropBox dropBox) {
        return this.storeIn(dropBox, 0L);
    }

    public synchronized String storeIn(DropBox dropBox, long timeoutMillis) {
        this.checkState();
        String dropBoxKey = dropBox.store(this, CALLBACK, timeoutMillis);
        if (this._listener != null) {
            StatefulServiceLifecycleEvent event = new StatefulServiceLifecycleEvent();
            event.setType(0);
            event.setService(this._item);
            this._listener.handleEvent(event);
        }
        return dropBoxKey;
    }

    public synchronized void destroy() {
        if (this._item == null) {
            return;
        }
        T item = this._item;
        this.doDestroy(item);
        this._item = null;
        if (this._listener != null) {
            StatefulServiceLifecycleEvent event = new StatefulServiceLifecycleEvent();
            event.setType(1);
            event.setService(item);
            this._listener.handleEvent(event);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().equals(that.getClass())) {
            return false;
        }
        DropBoxItem thatDropBoxItem = (DropBoxItem)that;
        T thatItem = thatDropBoxItem.getItem();
        if (!this._item.equals(thatItem)) {
            return false;
        }
        StatefulServiceLifecycleEventListenerInterface thatListener = thatDropBoxItem.getListener();
        return !(this._listener != null ? !this._listener.equals(thatListener) : thatListener != null);
    }

    public int hashCode() {
        int hc = this.getClass().hashCode();
        hc ^= this._item.hashCode();
        if (this._listener != null) {
            hc ^= this._listener.hashCode();
        }
        return hc;
    }

    protected abstract void doDestroy(T var1);

    private void checkState() {
        if (this._item == null) {
            throw new IllegalStateException("The item has been destroyed.");
        }
    }

    private static final class RemovalNotification
    implements DropBox.RemovalNotificationInterface {
        private RemovalNotification() {
        }

        @Override
        public void handleRemoval(DropBox.RemovalEvent event) {
            if (event.getType() == 1) {
                DropBoxItem dropBoxItem = (DropBoxItem)event.getItem();
                dropBoxItem.destroy();
            }
        }
    }
}

