/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.framework.annotation.services.DeletesStateful;
import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpService;
import com.sas.svcs.cluster.httpinvoker.stateful.DropBox;
import com.sas.svcs.cluster.httpinvoker.stateful.SessionRouteHolder;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.ProxyFactory;

public class AutoDiscoveredCreatesStatefulHttpService
extends AutoDiscoveredHttpService {
    private static final Logger LOG = LogManager.getLogger(AutoDiscoveredCreatesStatefulHttpService.class);
    private Map<String, Object> returnsStatefulMethodsMap = new HashMap<String, Object>(1);
    private Set<String> deletesStatefulMethods = new HashSet<String>();

    public AutoDiscoveredCreatesStatefulHttpService() {
    }

    public AutoDiscoveredCreatesStatefulHttpService(LoadBalancePolicyInterface p, String serviceInterface) {
        super(p, serviceInterface);
    }

    public void setReturnsStatefulMethodsMap(Map<String, Object> returnsStatefulMethodsMap) {
        this.returnsStatefulMethodsMap = returnsStatefulMethodsMap;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AutoDiscovered Service returns stateful services");
        }
    }

    public void setDeletesStatefulMethods(Set<String> methods) {
        this.deletesStatefulMethods = methods;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.deletesStatefulMethods.isEmpty()) {
            Class serviceInterface = this.getServiceInterface();
            for (Method method : serviceInterface.getMethods()) {
                if (!method.isAnnotationPresent(DeletesStateful.class)) continue;
                this.deletesStatefulMethods.add(method.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        URI dropBoxStatefulURI = null;
        if (this.returnsStatefulMethodsMap.containsKey(mi.getMethod().getName()) && StickyRandomPolicy.getSelectionTarget() == null) {
            Object[] argv;
            boolean debugLogging = LOG.isDebugEnabled();
            if (debugLogging) {
                LOG.debug("No selection target set for stateful return method, checking for dropbox keys for method invocation " + mi.getClass() + "." + mi.getMethod().getName());
            }
            for (Object arg : argv = mi.getArguments()) {
                if (!(arg instanceof String) || !DropBox.isKey((String)arg)) continue;
                if (debugLogging) {
                    LOG.debug("Found dropbox key '" + (String)arg + "' for method invocation " + mi.getClass() + "." + mi.getMethod().getName());
                }
                if ((dropBoxStatefulURI = DropBox.getStatefulServiceURI((String)arg)) == null) continue;
                if (debugLogging) {
                    LOG.debug("Found dropbox URI " + dropBoxStatefulURI + " for method invocation " + mi.getClass() + "." + mi.getMethod().getName());
                }
                StickyRandomPolicy.setSelectionTarget(dropBoxStatefulURI);
                break;
            }
        }
        Object result = null;
        try {
            result = super.invoke(mi);
        }
        finally {
            if (dropBoxStatefulURI != null) {
                StickyRandomPolicy.clearSelectionTarget();
            }
        }
        if (this.deletesStatefulMethods.contains(mi.getMethod().getName())) {
            SessionRouteHolder.removeRouteIfPresent(StatefulServiceIdHolder.getId());
        }
        if (this.returnsStatefulMethodsMap.containsKey(mi.getMethod().getName())) {
            Object statefulObj = this.returnsStatefulMethodsMap.get(mi.getMethod().getName());
            if (statefulObj.equals("")) {
                statefulObj = this.getObject();
            }
            Class<?> statefulClass = mi.getMethod().getReturnType();
            String statefulId = StatefulServiceResultIdHolder.getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got ID: " + statefulId);
            }
            URI statefulURI = StickyRandomPolicy.getRandomChoice();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got URI: " + statefulURI);
            }
            ProxyFactory factory = new ProxyFactory(statefulObj);
            factory.addInterface(statefulClass);
            StatefulInvocationInterceptor interceptor = new StatefulInvocationInterceptor(statefulId, statefulURI);
            factory.addAdvice((Advice)interceptor);
            SessionRouteHolder.putRoute(statefulId, statefulURI);
            return factory.getProxy();
        }
        return result;
    }

    private class StatefulInvocationInterceptor
    implements MethodInterceptor {
        private final String id;
        private final URI uri;

        public StatefulInvocationInterceptor(String id, URI uri) {
            this.id = id;
            this.uri = uri;
        }

        public Object invoke(MethodInvocation mi) throws Throwable {
            try {
                StatefulServiceIdHolder.setId((String)this.id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set ID: " + this.id);
                }
                StickyRandomPolicy.setSelectionTarget(this.uri);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set URI: " + this.uri);
                }
                Object object = mi.proceed();
                return object;
            }
            finally {
                StatefulServiceIdHolder.clear();
                StickyRandomPolicy.clearSelectionTarget();
            }
        }
    }
}

