/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.content;

import com.sas.framework.annotation.services.Content;
import com.sas.framework.services.config.dao.ServiceAlias;
import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpService;
import com.sas.svcs.cluster.httpinvoker.content.AutoDiscoveredContentService;
import com.sas.svcs.cluster.httpinvoker.content.DiscoveredServicesInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class DiscoveredServices<T>
implements DiscoveredServicesInterface<T>,
BeanPostProcessor {
    private static final String SAS_AUTO_CONTENT_SERVICES = "/sas/auto/content/services/";
    private static final String SAS_AUTO_CONTENT_ALIASES = "/sas/auto/content/aliases/";
    private static final Logger LOGGER = LogManager.getLogger(AutoDiscoveredHttpService.class);
    private HttpInvokerRequestExecutor executor;
    private LoadBalancePolicyInterface loadBalancePolicy;
    private final Class<T> serviceInterface;
    private Map<String, T> serviceMap;
    private final Map<String, T> localServiceMap = new HashMap<String, T>();
    private ServiceURLDAO serviceURLDAO;

    public DiscoveredServices(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
    }

    public void setExecutor(HttpInvokerRequestExecutor executor) {
        this.executor = executor;
    }

    public void setLoadBalancePolicy(LoadBalancePolicyInterface loadBalancePolicy) {
        this.loadBalancePolicy = loadBalancePolicy;
    }

    @Override
    public T getService(String objectType) {
        HashSet<String> objectTypes = new HashSet<String>(5);
        return this.getServiceForObjectType(objectTypes, objectType);
    }

    private T getServiceForObjectType(Set<String> objectTypes, String objectType) {
        objectTypes.add(objectType);
        T service = this.getAliasedService(objectTypes, objectType);
        if (null != service) {
            return service;
        }
        service = this.localServiceMap.get(objectType);
        if (null != service) {
            return service;
        }
        service = this.getServiceMap(objectType).get(objectType);
        if (null != service) {
            return service;
        }
        this.updateMap(objectType);
        service = this.getServiceMap(objectType).get(objectType);
        return service;
    }

    private T getAliasedService(Set<String> objectTypes, String objectType) {
        T service = null;
        String aliasType = null;
        if (null != this.serviceURLDAO) {
            ServiceAlias serviceAliasRequest = this.newServiceAlias(objectType);
            ServiceAlias serviceAlias = this.serviceURLDAO.getAlias(serviceAliasRequest);
            if (null != serviceAlias) {
                aliasType = serviceAlias.getAliasType();
                if (!objectTypes.contains(aliasType)) {
                    objectTypes.add(objectType);
                    service = this.getServiceForObjectType(objectTypes, aliasType);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("A service alias was not found for: " + serviceAliasRequest.toString());
            }
        }
        return service;
    }

    private synchronized void updateMap(String objectType) {
        List<ServiceURL> serviceURLs = this.getServiceURLsForContextServiceObjectType(objectType);
        if (LOGGER.isDebugEnabled()) {
            this.logServiceURLs(objectType, serviceURLs);
        }
        if (!serviceURLs.isEmpty() && null == this.serviceMap.get(objectType)) {
            AutoDiscoveredContentService service = this.newAutoDiscoveredContentService(objectType);
            this.serviceMap.put(objectType, service.getObject());
        }
    }

    private synchronized Map<String, T> getServiceMap(String objectType) {
        if (null == this.serviceMap) {
            this.serviceMap = new HashMap<String, T>(1);
            if (null != this.serviceURLDAO) {
                List serviceURLs = this.serviceURLDAO.getServiceURLsForContextServiceObjectType(this.newServiceURL(objectType));
                if (LOGGER.isDebugEnabled()) {
                    this.logServiceURLs(objectType, serviceURLs);
                }
                if (!serviceURLs.isEmpty()) {
                    AutoDiscoveredContentService service = this.newAutoDiscoveredContentService(objectType);
                    this.serviceMap.put(objectType, service.getObject());
                }
            }
        }
        return this.serviceMap;
    }

    private void logServiceURLs(String objectType, List<ServiceURL> urls) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder(256).append("Context: ").append(SAS_AUTO_CONTENT_SERVICES).append(lineSeparator).append("Interface: ").append(this.serviceInterface).append(lineSeparator).append("Object Type: ").append(objectType).append(lineSeparator).append("URLs: ").append(lineSeparator);
        for (ServiceURL url : urls) {
            sb.append(url.getURL());
            sb.append(lineSeparator);
        }
        LOGGER.debug(sb.toString());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Content content;
        if (this.serviceInterface.isInstance(bean) && (content = DiscoveredServices.getContentAnnotation(bean)) != null) {
            String[] objectTypes = content.objectTypes();
            if (objectTypes == null || objectTypes.length == 0) {
                throw new IllegalStateException("Services annotated with 'Content' must include an objectType.");
            }
            for (String objectType : objectTypes) {
                this.localServiceMap.put(objectType, bean);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private ServiceAlias newServiceAlias(String objectType) {
        ServiceAlias serviceAlias = new ServiceAlias();
        serviceAlias.setObjectType(objectType);
        serviceAlias.setContext(SAS_AUTO_CONTENT_ALIASES);
        serviceAlias.setServiceInterface(this.serviceInterface.getName());
        return serviceAlias;
    }

    private ServiceURL newServiceURL(String objectType) {
        ServiceURL request = new ServiceURL();
        request.setContext(SAS_AUTO_CONTENT_SERVICES);
        request.setService(this.serviceInterface.getName());
        request.setObjectType(objectType);
        return request;
    }

    private List<ServiceURL> getServiceURLsForContextServiceObjectType(String objectType) {
        ArrayList serviceURLs = null;
        if (null != this.serviceURLDAO) {
            serviceURLs = this.serviceURLDAO.getServiceURLsForContextServiceObjectType(this.newServiceURL(objectType));
        }
        if (null == serviceURLs) {
            serviceURLs = new ArrayList(0);
        }
        return serviceURLs;
    }

    private AutoDiscoveredContentService newAutoDiscoveredContentService(String objectType) {
        AutoDiscoveredContentService service = new AutoDiscoveredContentService();
        service.setServiceInterface(this.serviceInterface);
        service.setContentObjectType(objectType);
        service.setLoadBalancePolicy(this.loadBalancePolicy);
        service.setHttpInvokerRequestExecutor(this.executor);
        service.afterPropertiesSet();
        return service;
    }

    private static Content getContentAnnotation(Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        return (Content)AnnotationUtils.findAnnotation((Class)clazz, Content.class);
    }
}

