/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.content;

import com.sas.framework.services.config.dao.ServiceAlias;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.httpinvoker.content.ContentAliasExporter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.util.ClassUtils;

public class ContentAliasPublisher
implements DestructionAwareBeanPostProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ContentAliasPublisher.class);
    public static final String SAS_AUTO_CONTENT_ALIASES = "/sas/auto/content/aliases/";
    private ServiceURLDAO serviceURLDAO;

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
    }

    private boolean isAliased(Object bean) {
        return ClassUtils.isAssignable(ContentAliasExporter.class, bean.getClass());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isAliased(bean)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Publishing alias from bean: " + beanName);
            }
            ContentAliasExporter exporter = (ContentAliasExporter)bean;
            if (null != this.serviceURLDAO) {
                ServiceAlias serviceAlias1 = this.getServiceAlias(exporter);
                ServiceAlias serviceAlias2 = this.serviceURLDAO.getAlias(serviceAlias1);
                if (null == serviceAlias2) {
                    boolean wasAdded = this.serviceURLDAO.addAlias(serviceAlias1);
                    if (wasAdded && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Aliased service added: " + serviceAlias1.getAliasType());
                    }
                } else if (!serviceAlias2.isEquivalent(serviceAlias1)) {
                    serviceAlias2.setAliasType(serviceAlias1.getAliasType());
                    serviceAlias2.setContext(serviceAlias1.getContext());
                    serviceAlias2.setObjectType(serviceAlias1.getObjectType());
                    serviceAlias2.setServiceInterface(serviceAlias1.getServiceInterface());
                    boolean wasUpdated = this.serviceURLDAO.updateAlias(serviceAlias2);
                    if (wasUpdated && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Aliased service updated: " + serviceAlias2.getAliasType());
                    }
                }
            }
        }
        return bean;
    }

    static String getContextInterfaceObjectType(String serviceInterface, String objectType) {
        return SAS_AUTO_CONTENT_ALIASES + serviceInterface + '/' + objectType;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
    }

    private ServiceAlias getServiceAlias(ContentAliasExporter exporter) {
        ServiceAlias serviceAlias = new ServiceAlias();
        serviceAlias.setAliasType(exporter.getAliasType());
        serviceAlias.setContext(SAS_AUTO_CONTENT_ALIASES);
        serviceAlias.setObjectType(exporter.getObjectType());
        serviceAlias.setServiceInterface(exporter.getServiceInterface());
        return serviceAlias;
    }
}

