/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.StatefulObjectFactory;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpServiceExporter;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishAnnotationProcessor;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceMetadata;
import com.sas.svcs.cluster.httpinvoker.annotation.StatefulMetadata;
import com.sas.svcs.remoting.RemoteInvocationProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultIdProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.ServerRemoteInvocationStatefulServiceResultProxyProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceDeletionProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceProxyInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;

public class StatefulAnnotationProcessor
implements PublishAnnotationProcessor {
    private static final Logger LOGGER = LogManager.getLogger(StatefulAnnotationProcessor.class);
    private final List<RemoteInvocationProcessor> statefulServiceIdPreProcessorList = new ArrayList<RemoteInvocationProcessor>(1);

    public StatefulAnnotationProcessor() {
        this.statefulServiceIdPreProcessorList.add((RemoteInvocationProcessor)new ServerRemoteInvocationStatefulServiceIdProcessor());
    }

    @Override
    public boolean requiresProcessing(PublishableServiceMetadata metadata, Class<?> iface) {
        return metadata.hasAnnotation(StatefulObjectFactory.class);
    }

    private void getStatefulMetadata(Class<?> type, Map<Class<?>, StatefulMetadata> map, List<Class<?>> list) {
        StatefulMetadata metadata = map.get(type);
        if (metadata == null) {
            metadata = new StatefulMetadata(type);
            map.put(type, metadata);
            list.add(0, type);
            for (Map.Entry<String, Class<?>> entry : metadata.returnMethods.entrySet()) {
                Class<?> nextClass = entry.getValue();
                if (map.get(nextClass) != null) continue;
                this.getStatefulMetadata(nextClass, map, list);
            }
        }
    }

    @Override
    public void process(PublishableServiceMetadata metadata, BeanDefinitionBuilder builder, BeanDefinitionRegistry registry, Class<?> iface, String data) {
        boolean debug = LOGGER.isDebugEnabled();
        this.registerStatefulProxyInterceptorIfNecessary(registry);
        HashMap statefulObjects = new HashMap();
        ArrayList statefulObjectsList = new ArrayList();
        this.getStatefulMetadata(metadata.beanType, statefulObjects, statefulObjectsList);
        for (Class clazz : statefulObjectsList) {
            StatefulMetadata statefulMetadata = (StatefulMetadata)statefulObjects.get(clazz);
            if (debug) {
                LOGGER.debug("Processing: " + clazz.getName() + " with " + statefulMetadata);
            }
            ManagedList postProcessors = new ManagedList();
            BeanDefinitionBuilder currentBuilder = builder;
            if (statefulMetadata.isStatefulObject) {
                if (debug) {
                    LOGGER.debug("Creating additional AutoDiscoveredHttpServiceExporter...");
                }
                currentBuilder = BeanDefinitionBuilder.rootBeanDefinition(AutoDiscoveredHttpServiceExporter.class);
                currentBuilder.addPropertyValue("serviceInterface", (Object)clazz);
                currentBuilder.addPropertyReference("service", clazz.getName());
                currentBuilder.addPropertyReference("remoteInvocationExecutor", "com.sas.svcs.remote.executor");
                currentBuilder.addPropertyValue("preProcessors", this.statefulServiceIdPreProcessorList);
                if (statefulMetadata.deleteMethods.size() > 0) {
                    if (debug) {
                        LOGGER.debug("Handling deletion methods...");
                    }
                    StatefulServiceDeletionProcessor deletionProcessor = new StatefulServiceDeletionProcessor();
                    deletionProcessor.setDeleteStatefulMethodNames(statefulMetadata.deleteMethods);
                    postProcessors.add((Object)deletionProcessor);
                }
                if (debug) {
                    LOGGER.debug("Building proxy for stateful instance access...");
                }
                BeanDefinitionBuilder proxyBuilder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
                proxyBuilder.addPropertyValue("targetName", (Object)"sas.svcs.statefulServiceHolder");
                ArrayList proxyInterfaces = new ArrayList(2);
                proxyInterfaces.add(StatefulServiceHolderInterface.class);
                proxyInterfaces.add(clazz);
                proxyBuilder.addPropertyValue("proxyInterfaces", (Object)proxyInterfaces);
                ArrayList<String> interceptorNames = new ArrayList<String>(1);
                interceptorNames.add("sas.svcs.statefulServiceProxyInterceptor");
                proxyBuilder.addPropertyValue("interceptorNames", interceptorNames);
                registry.registerBeanDefinition(clazz.getName(), (BeanDefinition)proxyBuilder.getBeanDefinition());
            }
            if (statefulMetadata.returnMethods.size() > 0) {
                if (debug) {
                    LOGGER.debug("Handling return methods...");
                }
                ManagedMap statefulMethodsMap = new ManagedMap();
                for (Map.Entry<String, Class<?>> methodEntry : statefulMetadata.returnMethods.entrySet()) {
                    statefulMethodsMap.put((Object)methodEntry.getKey(), (Object)new RuntimeBeanReference(methodEntry.getValue().getName()));
                }
                BeanDefinitionBuilder resultProxyBuilder = BeanDefinitionBuilder.rootBeanDefinition(ServerRemoteInvocationStatefulServiceResultProxyProcessor.class);
                resultProxyBuilder.addPropertyValue("returnsStatefulMethodsMap", (Object)statefulMethodsMap);
                if (statefulMetadata.isStatefulObject) {
                    resultProxyBuilder.addPropertyReference("serviceHolder", clazz.getName());
                }
                AbstractBeanDefinition resultProxyDef = resultProxyBuilder.getBeanDefinition();
                String resultProxyGeneratedId = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)resultProxyDef, (BeanDefinitionRegistry)registry);
                registry.registerBeanDefinition(resultProxyGeneratedId, (BeanDefinition)resultProxyDef);
                postProcessors.add((Object)new RuntimeBeanReference(resultProxyGeneratedId));
                ServerRemoteInvocationStatefulServiceResultIdProcessor resultIdProcessor = new ServerRemoteInvocationStatefulServiceResultIdProcessor();
                resultIdProcessor.setReturnsStatefulMethodNames(statefulMetadata.returnMethods.keySet());
                postProcessors.add((Object)resultIdProcessor);
            }
            currentBuilder.addPropertyValue("postProcessors", (Object)postProcessors);
            if (!statefulMetadata.isStatefulObject) continue;
            if (debug) {
                LOGGER.debug("Adding stateful definition to registry...");
            }
            registry.registerBeanDefinition("/" + statefulMetadata.type.getName(), (BeanDefinition)currentBuilder.getBeanDefinition());
        }
    }

    private void registerStatefulProxyInterceptorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("sas.svcs.statefulServiceProxyInterceptor")) {
            BeanDefinitionBuilder interceptorDef = BeanDefinitionBuilder.rootBeanDefinition(StatefulServiceProxyInterceptor.class);
            registry.registerBeanDefinition("sas.svcs.statefulServiceProxyInterceptor", (BeanDefinition)interceptorDef.getBeanDefinition());
        }
    }
}

