/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.Publishable;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceMetadata;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceScanner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultPublishableServiceScanner
implements PublishableServiceScanner {
    private static final Logger LOGGER = LogManager.getLogger(DefaultPublishableServiceScanner.class);
    private String basePackage;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    private boolean matchesPackage(Class<?> clazz) {
        if (null == this.basePackage) {
            return true;
        }
        return clazz.getName().startsWith(this.basePackage);
    }

    @Override
    public Set<PublishableServiceMetadata> findAutoPublishedServices(ConfigurableListableBeanFactory beanFactory) {
        HashSet<PublishableServiceMetadata> autoPublishedServices = new HashSet<PublishableServiceMetadata>();
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.addAll(Arrays.asList(beanFactory.getBeanDefinitionNames()));
        if (beanFactory.getParentBeanFactory() instanceof ListableBeanFactory) {
            beanNames.addAll(Arrays.asList(((ListableBeanFactory)beanFactory.getParentBeanFactory()).getBeanDefinitionNames()));
        }
        for (String beanName : beanNames) {
            Class beanClass;
            AbstractBeanDefinition abd;
            Class handlerType = beanFactory.getType(beanName);
            Publishable aps = null;
            if (handlerType != null && this.matchesPackage(handlerType)) {
                aps = (Publishable)AnnotationUtils.findAnnotation((Class)handlerType, Publishable.class);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not get type of bean '" + beanName + "' from bean factory.");
            }
            if (aps != null) {
                autoPublishedServices.add(new PublishableServiceMetadata(beanName, handlerType));
                continue;
            }
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (!(bd instanceof AbstractBeanDefinition) || !(abd = (AbstractBeanDefinition)bd).hasBeanClass() || (aps = (Publishable)AnnotationUtils.findAnnotation((Class)(beanClass = abd.getBeanClass()), Publishable.class)) == null || !this.matchesPackage(beanClass)) continue;
            autoPublishedServices.add(new PublishableServiceMetadata(beanName, beanClass));
        }
        return autoPublishedServices;
    }
}

