/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker;

import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.balance.ZeroResultsException;
import com.sas.svcs.cluster.httpinvoker.RetryableException;
import com.sas.svcs.cluster.httpinvoker.ServiceCallback;
import com.sas.svcs.cluster.httpinvoker.UnavailableServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceExecutor {
    private static final Logger LOGGER = LogManager.getLogger(ServiceExecutor.class);
    private static final int DEFAULT_MAX_TRIES = 100;
    private static final int DEFAULT_MAX_FAILURES = 25;
    private static int warningPeriod = Integer.getInteger("sas.auto.initial.warning.period", 3600) * 1000;
    private static int failurePeriod;
    private int failureSleepPeriod = Integer.getInteger("sas.auto.discovered.failure.sleep.period", 5000);
    private int zeroResultsSleepPeriod = Integer.getInteger("sas.auto.discovered.zero.results.sleep.period", 15000);
    private int maxTries = Integer.getInteger("sas.auto.discovered.max.tries", 100);
    private int maxFailuresPerUrl = Integer.getInteger("sas.auto.discovered.max.failures", 25);
    private LoadBalancePolicyInterface lbPolicy;
    private long firstAttemptTime = -1L;
    private boolean remoteCallCompleted = false;
    private boolean haveIssuedError = false;
    private Map<String, Integer> failureMap = new ConcurrentHashMap<String, Integer>();

    public void setMaximumTries(int t) {
        this.maxTries = t;
    }

    public void setLoadBalancePolicy(LoadBalancePolicyInterface p) {
        this.lbPolicy = p;
    }

    public void setMaximumFailuresPerUrl(int m) {
        this.maxFailuresPerUrl = m;
    }

    public void executeService(String key, String serviceInterface, ServiceCallback serviceCallback) throws Throwable {
        for (int i = 0; i < this.maxTries; ++i) {
            this.handleTimePeriods(serviceInterface);
            String url = null;
            int zeroResultsCounter = 0;
            try {
                url = (String)this.lbPolicy.choose(key);
                serviceCallback.callService(url);
                this.remoteCallCompleted(key, url);
                return;
            }
            catch (RetryableException e) {
                this.handleFailure(key, url, e);
                continue;
            }
            catch (ZeroResultsException e) {
                if (this.remoteCallCompleted) break;
                if (++zeroResultsCounter % 20 == 0) {
                    this.warnAboutTries(zeroResultsCounter, serviceInterface, e);
                }
                Thread.sleep(this.zeroResultsSleepPeriod);
                continue;
            }
            catch (SocketTimeoutException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (ConnectTimeoutException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (HttpRetryException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (IOException e) {
                this.handleFailure(key, url, e);
                continue;
            }
            catch (Throwable t) {
                this.remoteCallCompleted(key, url);
                throw t;
            }
            finally {
                if (!this.remoteCallCompleted) {
                    --i;
                }
            }
        }
        throw new IllegalStateException("No services are available for: " + serviceInterface + ". Is a required process not started?");
    }

    private void remoteCallCompleted(String key, String url) {
        this.updateFailures(key, url);
        this.remoteCallCompleted = true;
    }

    private void updateFailures(String key, String url) {
        this.failureMap.remove(url);
        this.lbPolicy.affirm(key, url);
    }

    private void handleFailure(String key, String url, Throwable problem) throws InterruptedException {
        int times = 0;
        Integer timesInteger = this.failureMap.get(url);
        if (null != timesInteger) {
            times = timesInteger;
        }
        if (times >= this.maxFailuresPerUrl && this.remoteCallCompleted) {
            LOGGER.warn("Received error when accessing: " + url + ". Removing from service.", problem);
            this.lbPolicy.remove(key, url);
        } else {
            int newTimes = times + 1;
            this.failureMap.put(url, newTimes);
            if (!this.remoteCallCompleted) {
                if (newTimes % 60 == 0) {
                    this.warnAboutTries(newTimes, url, problem);
                }
                Thread.sleep(this.failureSleepPeriod);
            }
        }
    }

    private void handleTimePeriods(String serviceInterface) {
        if (this.firstAttemptTime < 0L) {
            this.firstAttemptTime = System.currentTimeMillis();
        }
        if (!this.remoteCallCompleted && System.currentTimeMillis() - this.firstAttemptTime > (long)failurePeriod) {
            throw new UnavailableServiceException("The system attempted to find and access a service for interface '" + serviceInterface + "' for " + failurePeriod / 1000 / 60 / 60 + " hours and was unsuccessful.");
        }
        if (!this.remoteCallCompleted && !this.haveIssuedError && System.currentTimeMillis() - this.firstAttemptTime > (long)warningPeriod) {
            LOGGER.error("#############################################################################################\n### Attempting to access service for interface '" + serviceInterface + "' for " + warningPeriod / 1000 / 60 / 60 + " hours. #####\n### Please ensure that the process providing the service is starting. #######################\n### After " + failurePeriod / 1000 / 60 / 60 + " hours, the service will be considered unavailable. ##############################\n#############################################################################################");
            this.haveIssuedError = true;
        }
    }

    private void warnAboutTries(int num, String requestFor, Throwable problem) {
        LOGGER.warn("Have received " + num + " failures while trying to access an auto-discoverable service to satisfy request for '" + requestFor + "'. Please ensure that the application and/or process surfacing this interface is still in the process of starting.", problem);
    }

    static {
        warningPeriod = warningPeriod > 1200000 ? warningPeriod : 1200000;
        failurePeriod = 2 * warningPeriod;
    }
}

