/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker;

import com.sas.svcs.cluster.PublisherHelper;
import com.sas.svcs.cluster.httpinvoker.AvailabilityInterface;
import jakarta.servlet.ServletContext;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.util.UriComponentsBuilder;

public class AvailabilityChecker
implements InitializingBean,
DisposableBean,
ServletContextAware,
Runnable {
    private static final Logger LOGGER = LogManager.getLogger(AvailabilityChecker.class);
    private final List<Runnable> checksToRun;
    private ServletContext servletContext;
    private Thread t;

    public AvailabilityChecker(List<Runnable> checksToRun) {
        this.checksToRun = checksToRun;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    @Override
    public void run() {
        try {
            HttpInvokerProxyFactoryBean proxy = new HttpInvokerProxyFactoryBean();
            proxy.setServiceInterface(AvailabilityInterface.class);
            proxy.setServiceUrl(this.getServletContext() + "/availabilityCheck");
            proxy.afterPropertiesSet();
            AvailabilityInterface availability = (AvailabilityInterface)proxy.getObject();
            boolean available = false;
            while (!available) {
                if (this.t.isInterrupted()) {
                    return;
                }
                try {
                    available = availability.check();
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                }
            }
            for (Runnable r : this.checksToRun) {
                r.run();
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unable to resolve host. Availability check will not run.", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        if (null != this.t) {
            this.t.interrupt();
        }
    }

    private String getServletContext() throws UnknownHostException {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance();
        builder.scheme(PublisherHelper.getProtocol());
        builder.host(PublisherHelper.getHost());
        builder.port(Integer.parseInt(PublisherHelper.getPort()));
        builder.path(this.servletContext.getContextPath());
        return builder.build().toUriString();
    }
}

