/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.balance;

import com.sas.svcs.cluster.balance.RandomPolicy;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StickyRandomPolicy
extends RandomPolicy {
    public static final String STATEFUL_SERVICE_URI_NAME = "sasStatefulServiceURI";
    public static final String DROP_BOX_KEY_ID = "dropboxid";
    public static final String DROP_BOX_KEY_STATEFUL_SERVICE_URI = "statefulserviceuri";
    public static final String DROP_BOX_KEY_ENCODED_PARAMETERS = "parameters";
    private static ThreadLocal<URI> _selectionTarget = new InheritableThreadLocal<URI>();
    private static ThreadLocal<URI> _randomChoice = new InheritableThreadLocal<URI>();
    private static ThreadLocal<URI> _selectedURI = new InheritableThreadLocal<URI>();
    private static final String _pathDelimPattern = "/";
    private static final int _pathDelimPatternL = "/".length();
    private static final Pattern _pathDelim = Pattern.compile("/");
    private static final String _utf8 = "UTF8";
    private static final String _tag = "{sas-svcsDropBoxKey}";
    private static final String _amp = "&";
    private static final String _eql = "=";
    private static final Pattern _ampPattern = Pattern.compile("&");
    private static final Pattern _eqlPattern = Pattern.compile("=");
    private static final int _tagL = "{sas-svcsDropBoxKey}".length();
    private static final Logger LOG = LogManager.getLogger(StickyRandomPolicy.class);

    public static void setSelectionTarget(URI selectionTarget) {
        _selectionTarget.set(selectionTarget);
    }

    public static URI getSelectionTarget() {
        return _selectionTarget.get();
    }

    public static void clearSelectionTarget() {
        _selectionTarget.remove();
    }

    public static void setRandomChoice(URI randomChoice) {
        _randomChoice.set(randomChoice);
    }

    public static URI getRandomChoice() {
        return _randomChoice.get();
    }

    public static void clearRandomChoice() {
        _randomChoice.remove();
    }

    public static void setSelectedURI(URI selectedURI) {
        _selectedURI.set(selectedURI);
    }

    public static URI getSelectedURI() {
        return _selectedURI.get();
    }

    public static void clearSelectedURI() {
        _selectedURI.remove();
    }

    @Override
    public Object choose(Object info) {
        if (LOG.isDebugEnabled() && info instanceof String) {
            LOG.debug("Choosing for '" + info.toString() + "'");
        }
        URI stickyURI = StickyRandomPolicy.getSelectionTarget();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSelectionTarget returned '" + (null == stickyURI ? "null" : stickyURI.toString()) + "'");
        }
        if (stickyURI == null) {
            URI randomURI;
            String choice = (String)super.choose(info);
            if (LOG.isDebugEnabled()) {
                LOG.debug("super.choose chose '" + choice + "'");
            }
            if ((randomURI = URI.create(choice)).getScheme() == null || randomURI.getHost() == null || randomURI.getPort() == -1 || randomURI.getPath() == null) {
                throw new IllegalStateException("Randomly chosen service URI is invalid for stateful services.");
            }
            return choice;
        }
        List choiceLst = this.getList(info);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got " + choiceLst.size() + " items in list");
        }
        for (String item : choiceLst) {
            URI uri;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating '" + item + "' for a match");
            }
            if (!StickyRandomPolicy.match(stickyURI, uri = URI.create(item))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matched '" + stickyURI + "' with '" + uri.toString() + "'");
            }
            return item;
        }
        throw new IllegalStateException("No service URI in cache matches selection target " + stickyURI);
    }

    @Override
    public void affirm(Object info, Object instance) {
        URI stickyURI = StickyRandomPolicy.getSelectionTarget();
        StickyRandomPolicy.clearSelectionTarget();
        String id = StatefulServiceResultIdHolder.getId();
        if (id != null) {
            if (stickyURI == null) {
                stickyURI = URI.create((String)instance);
            }
            StickyRandomPolicy.setRandomChoice(stickyURI);
        }
    }

    public static boolean isDropBoxKey(String str) {
        try {
            StickyRandomPolicy.parseDropBoxKey(str);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static URI getStatefulServiceURI(String dropBoxKey) {
        Properties p = StickyRandomPolicy.parseDropBoxKey(dropBoxKey);
        String value = p.getProperty(DROP_BOX_KEY_STATEFUL_SERVICE_URI);
        URI statefulServiceURI = value != null ? URI.create(value) : null;
        return statefulServiceURI;
    }

    public static String createDropBoxKey(String dropBoxID, URI statefulServiceURI) {
        StringBuilder keyBuf = new StringBuilder(_tag);
        keyBuf.append(DROP_BOX_KEY_ID).append(_eql).append(StickyRandomPolicy.encode(dropBoxID));
        if (statefulServiceURI != null) {
            String value = statefulServiceURI.toString();
            String encodedValue = StickyRandomPolicy.encode(value);
            int paramBufL = DROP_BOX_KEY_STATEFUL_SERVICE_URI.length() + _eql.length() + encodedValue.length();
            StringBuilder paramBuf = new StringBuilder(paramBufL);
            paramBuf.append(DROP_BOX_KEY_STATEFUL_SERVICE_URI).append(_eql).append(encodedValue);
            String param = paramBuf.toString();
            String ep = StickyRandomPolicy.paramEncode(param);
            keyBuf.append(_amp).append(DROP_BOX_KEY_ENCODED_PARAMETERS);
            keyBuf.append(_eql).append(StickyRandomPolicy.encode(ep));
        }
        String key = keyBuf.toString();
        return key;
    }

    public static Properties parseDropBoxKey(String dropBoxKey) {
        if (!dropBoxKey.startsWith(_tag)) {
            throw new IllegalArgumentException();
        }
        Properties properties = new Properties();
        String pairs = dropBoxKey.substring(_tagL);
        StickyRandomPolicy.parsePairs(pairs, properties);
        if (!properties.containsKey(DROP_BOX_KEY_ID)) {
            throw new IllegalArgumentException();
        }
        Object epObj = properties.remove(DROP_BOX_KEY_ENCODED_PARAMETERS);
        if (epObj != null) {
            String ep = epObj.toString();
            String param = StickyRandomPolicy.paramDecode(ep);
            StickyRandomPolicy.parsePairs(param, properties);
        }
        return properties;
    }

    private static void parsePairs(String pairs, Properties properties) {
        String[] pairArr;
        for (String pair : pairArr = _ampPattern.split(pairs)) {
            String[] nv = _eqlPattern.split(pair);
            if (nv == null || nv.length == 0) continue;
            String name = StickyRandomPolicy.decode(nv[0]).toLowerCase(Locale.US);
            String value = nv.length > 1 ? StickyRandomPolicy.decode(nv[1]) : "";
            properties.put(name, value);
        }
    }

    private static String encode(String raw) {
        try {
            String enc = URLEncoder.encode(raw, _utf8);
            return enc;
        }
        catch (UnsupportedEncodingException uee) {
            UnsupportedCharsetException uce = new UnsupportedCharsetException(_utf8);
            uce.initCause(uee);
            throw uce;
        }
    }

    private static String decode(String enc) {
        try {
            String raw = URLDecoder.decode(enc, _utf8);
            return raw;
        }
        catch (UnsupportedEncodingException uee) {
            UnsupportedCharsetException uce = new UnsupportedCharsetException(_utf8);
            uce.initCause(uee);
            throw uce;
        }
    }

    private static String paramEncode(String raw) {
        try {
            String enc = SasPasswordString.encode((String)"sas002", (String)raw);
            return enc;
        }
        catch (SasPasswordEncodingException spee) {
            throw new IllegalStateException(spee);
        }
    }

    private static String paramDecode(String enc) {
        try {
            String raw = SasPasswordString.decode((String)enc);
            return raw;
        }
        catch (SasPasswordEncodingException spee) {
            throw new IllegalStateException(spee);
        }
    }

    private static boolean match(URI targetURI, URI uri) {
        String path;
        int port;
        String host;
        String scheme;
        if (targetURI.equals(uri)) {
            return true;
        }
        String targetScheme = targetURI.getScheme();
        if (!targetScheme.equalsIgnoreCase(scheme = uri.getScheme())) {
            return false;
        }
        String targetHost = targetURI.getHost();
        if (!StickyRandomPolicy.matchHost(targetHost, host = uri.getHost())) {
            return false;
        }
        int targetPort = targetURI.getPort();
        if (targetPort != (port = uri.getPort())) {
            return false;
        }
        String targetPath = targetURI.getPath();
        return StickyRandomPolicy.matchPath(targetPath, path = uri.getPath());
    }

    private static boolean matchHost(String targetHost, String host) {
        if (targetHost.equalsIgnoreCase(host)) {
            return true;
        }
        try {
            InetAddress targetAddr = InetAddress.getByName(targetHost);
            InetAddress addr = InetAddress.getByName(host);
            boolean result = targetAddr.equals(addr);
            return result;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    private static boolean matchPath(String targetPath, String path) {
        while (targetPath.startsWith(_pathDelimPattern) && path.startsWith(_pathDelimPattern)) {
            targetPath = targetPath.substring(_pathDelimPatternL);
            path = path.substring(_pathDelimPatternL);
        }
        String[] targetPathElementArr = _pathDelim.split(targetPath);
        String[] pathElementArr = _pathDelim.split(path);
        int pathElements = Math.min(targetPathElementArr.length, pathElementArr.length);
        for (int i = 0; i < pathElements && i < 2; ++i) {
            String targetPathElement = targetPathElementArr[i];
            String pathElement = pathElementArr[i];
            if (targetPathElement.equals(pathElement)) continue;
            return false;
        }
        return true;
    }
}

