/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.balance;

import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.cluster.balance.ZeroResultsException;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class EnvironmentLoadBalancePolicy
implements LoadBalancePolicyInterface {
    private final ConcurrentMap<String, List<String>> cachedRoutes = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> wildcardRoutes = new HashMap<String, List<String>>();
    private final Random random = new Random();
    private final List<String> globalRoutes = new ArrayList<String>();

    public EnvironmentLoadBalancePolicy() {
        String routesProperty = System.getProperty("sas.auto.routes");
        if (StringUtils.hasText((String)routesProperty)) {
            String[] mappings;
            for (String mapping : mappings = routesProperty.split("\\|")) {
                int splitLoc = mapping.indexOf(62);
                if (splitLoc > 0) {
                    ArrayList<String> urls = new ArrayList<String>(Arrays.asList(mapping.substring(splitLoc + 1).split("\\^")));
                    this.wildcardRoutes.put(mapping.substring(0, splitLoc), urls);
                    continue;
                }
                this.globalRoutes.addAll(Arrays.asList(mapping.split("\\^")));
            }
        }
    }

    @Override
    public Object choose(Object info) {
        if (this.cachedRoutes.containsKey(info)) {
            return this.chooseOne((String)info);
        }
        if (info instanceof String) {
            String key = (String)info;
            if (key.startsWith("/sas/auto/services/")) {
                key = key.substring("/sas/auto/services/".length());
            }
            String routesStr = System.getProperty(key);
            List<Object> routes = null;
            if (!StringUtils.hasText((String)routesStr)) {
                for (Map.Entry<String, List<String>> wildcardRoute : this.wildcardRoutes.entrySet()) {
                    if (!key.startsWith(wildcardRoute.getKey())) continue;
                    routes = new ArrayList(wildcardRoute.getValue().size());
                    for (String route : wildcardRoute.getValue()) {
                        routes.add(this.processChoice(key, route));
                    }
                }
                if (null == routes && !this.globalRoutes.isEmpty()) {
                    routes = new ArrayList(this.globalRoutes.size());
                    for (String route : this.globalRoutes) {
                        routes.add(this.processChoice(key, route));
                    }
                }
                if (null == routes) {
                    routes = Collections.emptyList();
                }
            } else {
                String[] routesArr = routesStr.split(",");
                routes = new ArrayList(routesArr.length);
                for (String route : routesArr) {
                    routes.add(this.processChoice(key, route));
                }
            }
            this.cachedRoutes.putIfAbsent((String)info, routes);
            return this.chooseOne((String)info);
        }
        throw new ZeroResultsException("Info object, '" + info + "', provided no results to choose from. Is a required process available?");
    }

    protected String chooseOne(String info) {
        List choices = (List)this.cachedRoutes.get(info);
        if (0 == choices.size()) {
            throw new ZeroResultsException("Info object, '" + info + "', provided no results to choose from. Is a required process available?");
        }
        if (choices.size() == 1) {
            return (String)choices.get(0);
        }
        return (String)choices.get(this.random.nextInt(choices.size()));
    }

    protected UriComponentsBuilder findHostAndPort() {
        String host = System.getProperty("sas.auto.publish.host", System.getProperty("server.host", "localhost"));
        String port = System.getProperty("sas.auto.publish.port", System.getProperty("server.port", "8080"));
        String protocol = System.getProperty("sas.auto.publish.protocol", System.getProperty("server.protocol", "http"));
        return UriComponentsBuilder.newInstance().scheme(protocol).host(host).port(Integer.valueOf(port).intValue());
    }

    protected String processChoice(String info, String choice) {
        UriComponentsBuilder builder = null;
        if (!choice.startsWith("http://") && !choice.startsWith("https://")) {
            builder = this.findHostAndPort();
            builder.path(choice);
        } else {
            builder = UriComponentsBuilder.fromHttpUrl((String)choice);
        }
        if (builder.build().getPath().endsWith("/")) {
            builder.path("remote/" + info);
        }
        return builder.build().toUriString();
    }

    @Override
    public void affirm(Object info, Object instance) {
        URI stickyURI = StickyRandomPolicy.getSelectionTarget();
        StickyRandomPolicy.clearSelectionTarget();
        String id = StatefulServiceResultIdHolder.getId();
        if (id != null) {
            if (stickyURI == null) {
                stickyURI = URI.create((String)instance);
            }
            StickyRandomPolicy.setRandomChoice(stickyURI);
        }
    }

    @Override
    public void remove(Object info, Object instance) {
        if (this.cachedRoutes.containsKey(info)) {
            ((List)this.cachedRoutes.get(info)).remove(instance);
        }
    }
}

