/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.balance;

import com.sas.collection.Pair;
import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.balance.ZeroResultsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public abstract class CacheBasedPolicy
implements DestructionAwareBeanPostProcessor,
LoadBalancePolicyInterface,
Observer,
DisposableBean {
    private static final Logger LOG = LogManager.getLogger(CacheBasedPolicy.class);
    private static final AtomicInteger TIMER_COUNTER = new AtomicInteger();
    private final Map<String, List<String>> _items = Collections.synchronizedMap(new HashMap(512));
    private ServiceURLDAO _serviceURLDAO;
    private boolean _isTimerEnabled = true;
    private Timer _timer;
    private long _timerPeriodMsec = 120000L;

    @Override
    public void affirm(Object info, Object instance) {
    }

    @Override
    public void remove(Object info, Object instance) {
        ServiceURL request;
        ServiceURL serviceURL;
        String url = (String)instance;
        String key = (String)info;
        List<String> list = this._items.get(key);
        if (null != list) {
            list.remove(url);
            if (list.isEmpty()) {
                this._items.remove(key);
            }
        }
        if (null != this._serviceURLDAO && null != (serviceURL = this._serviceURLDAO.getServiceURL(request = this.newServiceURLFromURL(url, key)))) {
            this._serviceURLDAO.delete(serviceURL);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Pair) {
            Pair p = (Pair)arg;
            this._items.put((String)p.getFirst(), (List)p.getSecond());
        }
    }

    protected List getList(Object info) {
        String key = (String)info;
        List<String> c = this._items.get(key);
        if (null == c || c.isEmpty()) {
            this.updateServiceURLMap();
            c = this._items.get(key);
            if (null == c || c.isEmpty()) {
                throw new ZeroResultsException("Info object, '" + info + "', provided no results to choose from. Is a required process available?");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using key " + key + ", got " + c.size() + " items from cache: " + c.toString());
        }
        return c;
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this._serviceURLDAO = serviceURLDAO;
        if (null == this._serviceURLDAO) {
            this.cancelTimer();
        } else {
            this.updateServiceURLMap();
            this.scheduleTimer();
        }
    }

    public void enableTimer(boolean isTimerEnabled) {
        this._isTimerEnabled = isTimerEnabled;
        if (!this._isTimerEnabled) {
            this.cancelTimer();
        }
    }

    public long getTimerPeriod() {
        return this._timerPeriodMsec;
    }

    public void setTimerPeriod(long timerPeriodMsec) {
        this._timerPeriodMsec = timerPeriodMsec;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) {
    }

    public void destroy() {
        this.cancelTimer();
    }

    public ServiceURLDAO getServiceURLDAO() {
        return this._serviceURLDAO;
    }

    private void cancelTimer() {
        if (null != this._timer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timer canceled.");
            }
            this._timer.cancel();
            this._timer = null;
        }
    }

    private void scheduleTimer() {
        this.cancelTimer();
        if (this._isTimerEnabled) {
            this._timer = new Timer(this.getClass().getName() + " Timer " + TIMER_COUNTER.getAndIncrement(), true);
            this._timer.schedule((TimerTask)new ServiceURLQueryTimerTask(), 0L, this._timerPeriodMsec);
        }
    }

    private ServiceURL newServiceURLFromURL(String url, String key) {
        int indexServlet = url.lastIndexOf(47);
        String servletContext = url.substring(0, indexServlet);
        String servlet = url.substring(indexServlet);
        String service = servlet.substring(1);
        int indexObjectType = servlet.lastIndexOf(45);
        String objectType = 0 < indexObjectType ? servlet.substring(indexObjectType + 1) : null;
        ServiceURL serviceURL = new ServiceURL();
        serviceURL.setServletContext(servletContext);
        serviceURL.setServlet(servlet);
        serviceURL.setService(service);
        serviceURL.setObjectType(objectType);
        int indexContext = key.lastIndexOf(47);
        String context = key.substring(0, indexContext + 1);
        serviceURL.setContext(context);
        return serviceURL;
    }

    private void updateServiceURLMap() {
        boolean debug = LOG.isDebugEnabled();
        boolean trace = LOG.isTraceEnabled();
        if (debug) {
            LOG.debug("Updating service url map");
        }
        if (null != this._serviceURLDAO) {
            HashSet<String> keys = new HashSet<String>(this._items.keySet());
            if (debug) {
                LOG.debug("Got " + keys.size() + " existing items in cache before update");
                if (trace) {
                    LOG.trace("Cache items before update: " + ((Object)keys).toString());
                }
            }
            Map<String, List<String>> map = this.getServiceURLMap();
            if (debug) {
                LOG.debug("Found " + map.size() + " services to put into cache after updating from service url dao");
            }
            if (0 < map.size()) {
                for (Map.Entry entry : map.entrySet()) {
                    this._items.put((String)entry.getKey(), (List)entry.getValue());
                    if (!trace) continue;
                    LOG.trace("Putting entry in cache: " + entry.toString());
                }
            }
            for (String string : keys) {
                if (map.containsKey(string)) continue;
                this._items.remove(string);
                if (!trace) continue;
                LOG.trace("Removing item from cache :" + string);
            }
        }
    }

    private Map<String, List<String>> getServiceURLMap() {
        Map<String, List<String>> map = null;
        if (null != this._serviceURLDAO) {
            List serviceURLs = this._serviceURLDAO.getAllServiceURLs();
            map = new HashMap<String, List<String>>(serviceURLs.size());
            for (ServiceURL serviceURL : serviceURLs) {
                String key = serviceURL.getContextServiceObjectType();
                String url = serviceURL.getURL();
                if (null == key || null == url) continue;
                List<String> urls = map.get(key);
                if (null == urls) {
                    urls = new ArrayList<String>(5);
                    map.put(key, urls);
                }
                if (urls.contains(url)) continue;
                urls.add(url);
            }
        }
        if (null == map) {
            map = Collections.emptyMap();
        }
        return map;
    }

    private class ServiceURLQueryTimerTask
    extends TimerTask {
        private ServiceURLQueryTimerTask() {
        }

        @Override
        public void run() {
            CacheBasedPolicy.this.updateServiceURLMap();
        }
    }
}

