/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster;

import com.sas.svcs.cluster.MulticastPropertiesInterface;
import org.w3c.dom.Element;

@Deprecated
public class UDPMulticastProperties
implements MulticastPropertiesInterface {
    private String multicastAddress;
    private int multicastPort;
    private int pingTimeout = 3000;
    private int pingInitialMembers = 2;
    private String fdsockBindAddr;
    private int fdTimeout = 2500;
    private int fdMaxTries = 4;
    private int verifySuspectTimeout = 2000;
    private String nakackRetransmitTimeout = "600,1200,2400,4800";
    private String unicastTimeout = "800,1600,3200,6400";
    private int pbcastGMSJoinTimeout = 5000;
    private int pbcastGMSJoinRetryTimeout = 2000;
    private int pbcastGMSLeaveTimeout = 5000;
    private int pbcastGMSDigestTimeout = 5000;
    private int pbcastGMSMergeTimeout = 10000;
    private static final String PING_TIMEOUT_PROPERTY = "multicast_ping_timeout";
    private static final String PING_INITIAL_MEMBERS_PROPERTY = "multicast_ping_num_initial_members";
    private static final String FD_SOCK_BIND_ADDR_PROPERTY = "multicast_fd_sock_bind_addr";
    private static final String FD_TIMEOUT_PROPERTY = "multicast_fd_timeout";
    private static final String FD_MAX_TRIES_PROPERTY = "multicast_fd_max_tries";
    private static final String VERIFY_SUSPECT_TIMEOUT_PROPERTY = "multicast_verify_suspect_timeout";
    private static final String PBCAST_NAKACK_RETRANSMIT_TIMEOUT_PROPERTY = "multicast_pbcast_nakack_retransmit_timeout";
    private static final String UNICAST_TIMEOUT = "multicast_unicast_timeout";
    private static final String PBCAST_GMS_JOIN_TIMEOUT_PROPERTY = "multicast_pbcast_gms_join_timeout";
    private static final String PBCAST_GMS_JOIN_RETRY_TIMEOUT_PROPERTY = "multicast_pbcast_gms_join_retry_timeout";
    private static final String PBCAST_GMS_LEAVE_TIMEOUT_PROPERTY = "multicast_pbcast_gms_leave_timeout";
    private static final String PBCAST_GMS_DIGEST_TIMEOUT_PROPERTY = "multicast_pbcast_gms_digest_timeout";
    private static final String PBCAST_GMS_MERGE_TIMEOUT_PROPERTY = "multicast_pbcast_gms_merge_timeout";

    public UDPMulticastProperties(String address, int port) {
        this.multicastAddress = address;
        this.multicastPort = port;
        this.initializeValues();
    }

    @Override
    public void setAddress(String multicastAddress) {
        this.multicastAddress = multicastAddress;
    }

    @Override
    public void setPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    @Override
    public void setAuthenticationToken(String token) {
        throw new UnsupportedOperationException("UDPMulticastProperties does not support direct setting of the token. Authentication is only supported in DefaultMulticastProperties.");
    }

    @Override
    public void setPrintLocalAddress(boolean printLocalAddress) {
        throw new UnsupportedOperationException("UDPMulticastProperties does not support direct setting of the local address option. It is only supported in DefaultMulticastProperties.");
    }

    @Override
    public Element getPropertiesElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProperties() {
        String udp = "UDP(mcast_addr=" + this.multicastAddress + ";mcast_port=" + this.multicastPort + "):";
        String ping = "PING(timeout=" + this.pingTimeout + ";num_initial_members=" + this.pingInitialMembers + "):";
        String merge2 = "MERGE2(min_interval=5000;max_interval=20000):";
        String fdSock = "FD_SOCK:";
        String fd = "FD(timeout=" + this.fdTimeout + ";max_tries=" + this.fdMaxTries + "):";
        String verifySuspect = "VERIFY_SUSPECT(timeout=" + this.verifySuspectTimeout + "):";
        String pbcastNakack = "pbcast.NAKACK(retransmit_timeout=" + this.nakackRetransmitTimeout + "):";
        String unicast = "UNICAST(timeout=" + this.unicastTimeout + "):";
        String pbcastStable = "pbcast.STABLE:";
        String pbcastGMS = "pbcast.GMS(join_timeout=" + this.pbcastGMSJoinTimeout + ";join_retry_timeout=" + this.pbcastGMSJoinRetryTimeout + ";leave_timeout=" + this.pbcastGMSLeaveTimeout + ";digest_timeout=" + this.pbcastGMSDigestTimeout + ";merge_timeout=" + this.pbcastGMSLeaveTimeout + "):";
        String pbcastStateTransfer = "pbcast.STATE_TRANSFER:";
        StringBuilder b = new StringBuilder(500);
        b.append(udp).append(ping).append(merge2).append(fdSock).append(fd).append(verifySuspect);
        b.append(pbcastNakack).append(unicast).append(pbcastStable).append(pbcastGMS).append(pbcastStateTransfer);
        return b.toString();
    }

    private void initializeValues() {
        this.pingTimeout = this.getInt(PING_TIMEOUT_PROPERTY, this.pingTimeout);
        this.pingInitialMembers = this.getInt(PING_INITIAL_MEMBERS_PROPERTY, this.pingInitialMembers);
        this.fdsockBindAddr = this.getString(FD_SOCK_BIND_ADDR_PROPERTY, this.fdsockBindAddr);
        this.fdTimeout = this.getInt(FD_TIMEOUT_PROPERTY, this.fdTimeout);
        this.fdMaxTries = this.getInt(FD_MAX_TRIES_PROPERTY, this.fdMaxTries);
        this.verifySuspectTimeout = this.getInt(VERIFY_SUSPECT_TIMEOUT_PROPERTY, this.verifySuspectTimeout);
        this.nakackRetransmitTimeout = this.getString(PBCAST_NAKACK_RETRANSMIT_TIMEOUT_PROPERTY, this.nakackRetransmitTimeout);
        this.unicastTimeout = this.getString(UNICAST_TIMEOUT, this.unicastTimeout);
        this.pbcastGMSJoinTimeout = this.getInt(PBCAST_GMS_JOIN_TIMEOUT_PROPERTY, this.pbcastGMSJoinTimeout);
        this.pbcastGMSJoinRetryTimeout = this.getInt(PBCAST_GMS_JOIN_RETRY_TIMEOUT_PROPERTY, this.pbcastGMSJoinRetryTimeout);
        this.pbcastGMSLeaveTimeout = this.getInt(PBCAST_GMS_LEAVE_TIMEOUT_PROPERTY, this.pbcastGMSLeaveTimeout);
        this.pbcastGMSDigestTimeout = this.getInt(PBCAST_GMS_DIGEST_TIMEOUT_PROPERTY, this.pbcastGMSDigestTimeout);
        this.pbcastGMSMergeTimeout = this.getInt(PBCAST_GMS_MERGE_TIMEOUT_PROPERTY, this.pbcastGMSMergeTimeout);
    }

    private int getInt(String key, int defaultValue) {
        return System.getProperty(key) == null ? defaultValue : Integer.parseInt(System.getProperty(key));
    }

    private String getString(String key, String defaultValue) {
        return System.getProperty(key) == null ? defaultValue : System.getProperty(key);
    }
}

