/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class PublisherHelper {
    private static final Logger LOGGER = LogManager.getLogger(PublisherHelper.class);

    public static String getHost() throws UnknownHostException {
        InetAddress address;
        String host = System.getProperty("sas.auto.publish.host");
        if (!StringUtils.hasText((String)host)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Host value was not found. Using the local IP address. If you want a specific value, set the localIpAddress property or use the sas.auto.publish.host system property");
            }
            host = InetAddress.getLocalHost().getHostAddress();
        }
        if ((address = InetAddress.getByName(host)) instanceof Inet6Address && host.indexOf(58) >= 0) {
            int percentIndex = host.indexOf(37);
            if (percentIndex > 0) {
                host = host.substring(0, percentIndex);
            }
            if (!host.startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }

    public static String getPort() {
        String port = System.getProperty("sas.auto.publish.port");
        if (!StringUtils.hasText((String)port)) {
            throw new IllegalStateException("No port available. Please explicitly set the port property or use the sas.auto.publish.port system property setting.");
        }
        return port;
    }

    public static String getProtocol() {
        String protocol = System.getProperty("sas.auto.publish.protocol");
        if (!StringUtils.hasText((String)protocol)) {
            LOGGER.debug("Protocol value was not found; using 'http' default. If you want a specific value, set the localProtocol property or use the sas.auto.publish.protocol system property.");
            protocol = "http";
        }
        return protocol;
    }
}

