/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster;

import com.sas.svcs.cluster.MulticastPropertiesInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.SimpleTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class DefaultMulticastProperties
implements MulticastPropertiesInterface {
    private static final Logger LOGGER = LogManager.getLogger(DefaultMulticastProperties.class);
    private static final String BASIC_CONFIG = "/com/sas/svcs/cluster/config/default-config.xml";
    private static final String ENCRYPT_CONFIG = "/com/sas/svcs/cluster/config/encrypt-config.xml";
    private static final String ENCRYPT_AUTH_CONFIG = "/com/sas/svcs/cluster/config/encrypt-auth-config.xml";
    private static final String DEFAULT_CONFIG = "/com/sas/svcs/cluster/config/encrypt-auth-config.xml";
    private String multicastAddress;
    private int multicastPort;
    private int ttl = -1;
    private int udpIPTTL = 64;
    private int pingTimeout = 3000;
    private int pingInitialMembers = 2;
    private String fdsockBindAddr;
    private int fdTimeout = 10000;
    private int fdMaxTries = 5;
    private int verifySuspectTimeout = 2000;
    private String nakackRetransmitTimeout = "600,1200,2400,4800";
    private String unicastTimeout = "800,1600,3200,6400";
    private int pbcastGMSJoinTimeout = 5000;
    private int pbcastGMSJoinRetryTimeout = 2000;
    private int pbcastGMSLeaveTimeout = 5000;
    private int pbcastGMSDigestTimeout = 5000;
    private int pbcastGMSMergeTimeout = 10000;
    private boolean pbcastGMSPrintLocalAddress = true;
    private int encryptSymInit = 128;
    private String encryptSymAlgorithm = "AES/ECB/PKCS5Padding";
    private int encryptAsymInit = 512;
    private String encryptAsymAlgorithm = "RSA";
    private String authAuthClass = "org.jgroups.auth.SimpleToken";
    private String authAuthProperties = "auth_value=\"SASpw1\"";
    private int frag2FragSize = 8192;
    private static final String UDP_IP_TTL = "multicast_udp_ip_ttl";
    private static final String PING_TIMEOUT_PROPERTY = "multicast_ping_timeout";
    private static final String PING_INITIAL_MEMBERS_PROPERTY = "multicast_ping_num_initial_members";
    private static final String FD_SOCK_BIND_ADDR_PROPERTY = "multicast_fd_sock_bind_addr";
    private static final String FD_TIMEOUT_PROPERTY = "multicast_fd_timeout";
    private static final String FD_MAX_TRIES_PROPERTY = "multicast_fd_max_tries";
    private static final String VERIFY_SUSPECT_TIMEOUT_PROPERTY = "multicast_verify_suspect_timeout";
    private static final String PBCAST_NAKACK_RETRANSMIT_TIMEOUT_PROPERTY = "multicast_pbcast_nakack_retransmit_timeout";
    private static final String UNICAST_TIMEOUT = "multicast_unicast_timeout";
    private static final String PBCAST_GMS_JOIN_TIMEOUT_PROPERTY = "multicast_pbcast_gms_join_timeout";
    private static final String PBCAST_GMS_JOIN_RETRY_TIMEOUT_PROPERTY = "multicast_pbcast_gms_join_retry_timeout";
    private static final String PBCAST_GMS_LEAVE_TIMEOUT_PROPERTY = "multicast_pbcast_gms_leave_timeout";
    private static final String PBCAST_GMS_DIGEST_TIMEOUT_PROPERTY = "multicast_pbcast_gms_digest_timeout";
    private static final String PBCAST_GMS_MERGE_TIMEOUT_PROPERTY = "multicast_pbcast_gms_merge_timeout";
    private static final String PBCAST_GMS_PRINT_LOCAL_ADDRESS_PROPERTY = "multicast_pbcast_gms_print_local_addr";
    private static final String ENCRYPT_SYM_INIT_PROPERTY = "multicast_encrypt_sym_init";
    private static final String ENCRYPT_SYM_ALGORITHM_PROPERTY = "multicast_encrypt_sym_algorithm";
    private static final String ENCRYPT_ASYM_INIT_PROPERTY = "multicast_encrypt_asym_init";
    private static final String ENCRYPT_ASYM_ALGORITHM_PROPERTY = "multicast_encrypt_asym_algorithm";
    private static final String AUTH_AUTH_CLASS = "multicast_auth_auth_class";
    private static final String AUTH_AUTH_PROPERTIES = "multicast_auth_auth_properties";
    private static final String FRAG2_FRAG_SIZE = "multicast_frag2_frag_size";

    @Override
    public void setAddress(String address) {
        if (address.indexOf(58) > 0 && address.indexOf("\\:") < 0) {
            address = address.replace(":", "\\:");
        }
        this.multicastAddress = address;
    }

    @Override
    public void setPort(int port) {
        this.multicastPort = port;
    }

    public void setTtl(int ttl) {
        if (ttl > 255 || ttl < 0) {
            throw new IllegalArgumentException("ttl must be between 0 and 255");
        }
        this.ttl = ttl;
    }

    @Override
    public void setAuthenticationToken(String token) {
        if (null != token && token.trim().length() > 0) {
            try {
                token = SasPasswordString.decode((String)token);
            }
            catch (SasPasswordEncodingException e) {
                LOGGER.error("Unable to decode authentication token...", (Throwable)e);
            }
            this.authAuthProperties = "auth_value=\"" + token.trim() + "\"";
        }
    }

    @Override
    public void setPrintLocalAddress(boolean printLocalAddress) {
        this.pbcastGMSPrintLocalAddress = printLocalAddress;
    }

    @Override
    public Element getPropertiesElement() {
        try {
            this.initializeValues();
            String configPattern = this.getConfigPattern();
            Map<String, Object> dictionary = this.getDictionary();
            SimpleTemplate template = new SimpleTemplate(configPattern, dictionary);
            String configuration = template.format();
            if (LOGGER.isInfoEnabled()) {
                String logConfiguration = configuration;
                String security = System.getProperty("multicast.security");
                if (!"show".equals(security)) {
                    Pattern p = Pattern.compile("<AUTH .+>", 8);
                    Matcher m = p.matcher(logConfiguration);
                    logConfiguration = m.replaceFirst("<AUTH ****** />");
                }
                LOGGER.info("Using JGroups configuration: " + logConfiguration);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            StringReader reader = new StringReader(configuration);
            InputSource source = new InputSource(reader);
            Document document = builder.parse(source);
            return document.getDocumentElement();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse JGroups configuration", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to parse JGroups configuration", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Unable to parse JGroups configuration", e);
        }
    }

    private Map<String, Object> getDictionary() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("multicast_udp_mcast_address", this.multicastAddress);
        results.put("multicast_udp_mcast_port", this.multicastPort);
        results.put(UDP_IP_TTL, this.udpIPTTL);
        results.put(PING_TIMEOUT_PROPERTY, this.pingTimeout);
        results.put(PING_INITIAL_MEMBERS_PROPERTY, this.pingInitialMembers);
        results.put(FD_SOCK_BIND_ADDR_PROPERTY, this.fdsockBindAddr);
        results.put(FD_TIMEOUT_PROPERTY, this.fdTimeout);
        results.put(FD_MAX_TRIES_PROPERTY, this.fdMaxTries);
        results.put(VERIFY_SUSPECT_TIMEOUT_PROPERTY, this.verifySuspectTimeout);
        results.put(PBCAST_NAKACK_RETRANSMIT_TIMEOUT_PROPERTY, this.nakackRetransmitTimeout);
        results.put(UNICAST_TIMEOUT, this.unicastTimeout);
        results.put(PBCAST_GMS_JOIN_TIMEOUT_PROPERTY, this.pbcastGMSJoinTimeout);
        results.put(PBCAST_GMS_JOIN_RETRY_TIMEOUT_PROPERTY, this.pbcastGMSJoinRetryTimeout);
        results.put(PBCAST_GMS_LEAVE_TIMEOUT_PROPERTY, this.pbcastGMSLeaveTimeout);
        results.put(PBCAST_GMS_DIGEST_TIMEOUT_PROPERTY, this.pbcastGMSDigestTimeout);
        results.put(PBCAST_GMS_MERGE_TIMEOUT_PROPERTY, this.pbcastGMSMergeTimeout);
        results.put(PBCAST_GMS_PRINT_LOCAL_ADDRESS_PROPERTY, this.pbcastGMSPrintLocalAddress);
        results.put(ENCRYPT_SYM_INIT_PROPERTY, this.encryptSymInit);
        results.put(ENCRYPT_SYM_ALGORITHM_PROPERTY, this.encryptSymAlgorithm);
        results.put(ENCRYPT_ASYM_INIT_PROPERTY, this.encryptAsymInit);
        results.put(ENCRYPT_ASYM_ALGORITHM_PROPERTY, this.encryptAsymAlgorithm);
        results.put(AUTH_AUTH_CLASS, this.authAuthClass);
        results.put(AUTH_AUTH_PROPERTIES, this.authAuthProperties);
        results.put(FRAG2_FRAG_SIZE, this.frag2FragSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using dictionary: " + results + ", to perform string substitution.");
        }
        return results;
    }

    private String getConfigPattern() throws IOException {
        String configPattern = null;
        String configUrl = System.getProperty("multicast.config.file");
        if (null == configUrl || configUrl.trim().length() == 0) {
            String configFileName = "/com/sas/svcs/cluster/config/encrypt-auth-config.xml";
            String security = System.getProperty("multicast.security");
            if ("none".equals(security)) {
                configFileName = BASIC_CONFIG;
            } else if ("encrypt".equals(security)) {
                configFileName = ENCRYPT_CONFIG;
            }
            InputStream is = DefaultMulticastProperties.class.getResourceAsStream(configFileName);
            configPattern = IOUtils.toString((InputStream)is);
        } else {
            URL url = new URL(configUrl.trim());
            InputStream is = url.openStream();
            configPattern = IOUtils.toString((InputStream)is);
        }
        return configPattern;
    }

    @Override
    public String getProperties() {
        throw new UnsupportedOperationException("Only getPropertiesElement is supported by DefaultMulticastProperties...");
    }

    private void initializeValues() {
        this.udpIPTTL = this.ttl >= 0 ? this.ttl : this.getInt(UDP_IP_TTL, this.udpIPTTL);
        this.pingTimeout = this.getInt(PING_TIMEOUT_PROPERTY, this.pingTimeout);
        this.pingInitialMembers = this.getInt(PING_INITIAL_MEMBERS_PROPERTY, this.pingInitialMembers);
        this.fdsockBindAddr = this.getString(FD_SOCK_BIND_ADDR_PROPERTY, this.fdsockBindAddr);
        this.fdTimeout = this.getInt(FD_TIMEOUT_PROPERTY, this.fdTimeout);
        this.fdMaxTries = this.getInt(FD_MAX_TRIES_PROPERTY, this.fdMaxTries);
        this.verifySuspectTimeout = this.getInt(VERIFY_SUSPECT_TIMEOUT_PROPERTY, this.verifySuspectTimeout);
        this.nakackRetransmitTimeout = this.getString(PBCAST_NAKACK_RETRANSMIT_TIMEOUT_PROPERTY, this.nakackRetransmitTimeout);
        this.unicastTimeout = this.getString(UNICAST_TIMEOUT, this.unicastTimeout);
        this.pbcastGMSJoinTimeout = this.getInt(PBCAST_GMS_JOIN_TIMEOUT_PROPERTY, this.pbcastGMSJoinTimeout);
        this.pbcastGMSJoinRetryTimeout = this.getInt(PBCAST_GMS_JOIN_RETRY_TIMEOUT_PROPERTY, this.pbcastGMSJoinRetryTimeout);
        this.pbcastGMSLeaveTimeout = this.getInt(PBCAST_GMS_LEAVE_TIMEOUT_PROPERTY, this.pbcastGMSLeaveTimeout);
        this.pbcastGMSDigestTimeout = this.getInt(PBCAST_GMS_DIGEST_TIMEOUT_PROPERTY, this.pbcastGMSDigestTimeout);
        this.pbcastGMSMergeTimeout = this.getInt(PBCAST_GMS_MERGE_TIMEOUT_PROPERTY, this.pbcastGMSMergeTimeout);
        this.pbcastGMSPrintLocalAddress = this.getBoolean(PBCAST_GMS_PRINT_LOCAL_ADDRESS_PROPERTY, this.pbcastGMSPrintLocalAddress);
        this.encryptSymInit = this.getInt(ENCRYPT_SYM_INIT_PROPERTY, this.encryptSymInit);
        this.encryptSymAlgorithm = this.getString(ENCRYPT_SYM_ALGORITHM_PROPERTY, this.encryptSymAlgorithm);
        this.encryptAsymInit = this.getInt(ENCRYPT_ASYM_INIT_PROPERTY, this.encryptAsymInit);
        this.encryptAsymAlgorithm = this.getString(ENCRYPT_ASYM_ALGORITHM_PROPERTY, this.encryptAsymAlgorithm);
        this.authAuthClass = this.getString(AUTH_AUTH_CLASS, this.authAuthClass);
        this.authAuthProperties = this.getString(AUTH_AUTH_PROPERTIES, this.authAuthProperties);
        this.frag2FragSize = this.getInt(FRAG2_FRAG_SIZE, this.frag2FragSize);
    }

    private int getInt(String key, int defaultValue) {
        return System.getProperty(key) == null ? defaultValue : Integer.parseInt(System.getProperty(key));
    }

    private String getString(String key, String defaultValue) {
        return System.getProperty(key) == null ? defaultValue : System.getProperty(key);
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        return System.getProperty(key) == null ? defaultValue : Boolean.getBoolean(key);
    }
}

