/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Util {
    public static Map tokenize(String[] argsArray) {
        Properties properties = new Properties();
        String strKey = "";
        String strValue = "";
        for (int argIndex = 0; argIndex < argsArray.length; ++argIndex) {
            String strArg = argsArray[argIndex];
            if (strArg.startsWith("-")) {
                strArg = strArg.substring(1);
                if (strKey.length() > 0) {
                    properties.put(strKey, "");
                    strKey = "";
                }
                strKey = strArg;
                continue;
            }
            if (strArg.startsWith("\"") && strArg.endsWith("\"") || strArg.startsWith("'") && strArg.endsWith("'")) {
                strArg = strArg.substring(1, strArg.length() - 1);
            }
            strValue = strArg;
            if (strKey.length() <= 0 || strValue.length() <= 0) continue;
            properties.put(strKey, strValue);
            strKey = "";
            strValue = "";
        }
        if (strKey.length() > 0) {
            properties.put(strKey, "");
            strKey = "";
        }
        return properties;
    }

    public static Map tokenize(String strKey, Properties properties) throws IOException {
        char[] wordCharArray = new char[]{'=', '\\', '/', '{', '}', '<', '>', ':', ';', '-', '@', '_', '!', '#', '$', '(', ')', '*', '~', '%', '^', '&', '+', '?', '[', ']', '.'};
        return Util.tokenize(strKey, properties, wordCharArray);
    }

    public static Map tokenize(String strKey, Properties properties, char[] wordCharArray) throws IOException {
        Properties propertiesMap = new Properties();
        String strMapKey = "";
        String strMapValue = "";
        String strArgs = (String)properties.get(strKey);
        if (strArgs == null) {
            return propertiesMap;
        }
        StringReader reader = new StringReader(strArgs);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.quoteChar(39);
        for (int charIndex = 0; charIndex < wordCharArray.length; ++charIndex) {
            char wordChar = wordCharArray[charIndex];
            if (wordChar == '\'') continue;
            tokenizer.wordChars(wordChar, wordChar);
        }
        while (tokenizer.nextToken() != -1) {
            String strToken = tokenizer.sval;
            StringTokenizer subTokenizer = null;
            subTokenizer = strMapKey.length() > 0 ? new StringTokenizer(strToken, "") : new StringTokenizer(strToken, "=");
            while (subTokenizer.hasMoreTokens()) {
                String strSubToken = subTokenizer.nextToken();
                if (strMapKey.length() > 0) {
                    if (strSubToken.startsWith("'") && strSubToken.endsWith("'")) {
                        strSubToken = strSubToken.substring(1, strSubToken.length() - 1);
                    }
                    strMapValue = strSubToken;
                } else {
                    strMapKey = strSubToken;
                }
                if (strMapKey.length() <= 0 || strMapValue.length() <= 0) continue;
                propertiesMap.put(strMapKey, strMapValue);
                strMapKey = "";
                strMapValue = "";
            }
        }
        return propertiesMap;
    }
}

