/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.util;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.util.Encryption;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.mgmt.RepositoryUtil;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class MetaServerConnection {
    private String m_host;
    private String m_port;
    private String m_user;
    private PasswordAuthentication m_pwAuth = null;
    private IOMI m_connection;
    private MdOMRConnection m_metaWorkspace;
    private static MdFactory m_MdFactory = null;
    private String m_reposId;
    private String m_reposName;
    public static final String DEFAULT_METAPORT = "8561";
    public static final String DEFAULT_METAHOST = "localhost";

    public MetaServerConnection(String host, String port, String user, String password, String reposName) {
        this(Workspace.getMdFactory(), host, port, user, password, reposName);
    }

    public MetaServerConnection(String host, String port, String user, String password) {
        this(Workspace.getMdFactory(), host, port, user, password, null);
    }

    public MetaServerConnection(MdFactory m_Factory, String host, String port, String user, String password, String reposName) {
        m_MdFactory = m_Factory;
        this.m_host = host;
        this.m_port = port;
        this.m_user = user;
        this.m_reposName = reposName;
        this.m_pwAuth = new PasswordAuthentication(user, this.getEncodedPassword(password).toCharArray());
        this.populateMissingParms();
    }

    public MetaServerConnection(WorkspaceFile wsFile) {
        this(Workspace.getMdFactory(), wsFile);
    }

    public MetaServerConnection(MdFactory m_Factory, WorkspaceFile wsFile) {
        m_MdFactory = m_Factory;
        if (wsFile != null) {
            this.m_host = wsFile.getPropertyString("host", DEFAULT_METAHOST);
            this.m_port = wsFile.getPropertyString("port", DEFAULT_METAPORT);
            this.m_user = wsFile.getPropertyString("userid");
            PasswordAuthentication decryptedPwAuth = null;
            try {
                decryptedPwAuth = new PasswordAuthentication(this.m_user, m_MdFactory.getUtil().decrypt(wsFile.getPropertyString("password")).toCharArray());
            }
            catch (RemoteException e) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\nCould not decrypt password in workspace file to use.");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            this.m_pwAuth = new PasswordAuthentication(this.m_user, this.getEncodedPassword(String.valueOf(decryptedPwAuth.getPassword())).toCharArray());
            if (String.valueOf(this.m_pwAuth.getPassword()) == null) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\nCould not encrypt password from workspace file.");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            this.m_reposId = wsFile.getPropertyString("SelectedReps");
            this.populateMissingParms();
            java.lang.Object var3_3 = null;
        }
    }

    public MetaServerConnection(IOMI metaConnection) {
        this(Workspace.getMdFactory(), metaConnection);
    }

    public MetaServerConnection(MdFactory factory, IOMI metaConnection) {
        this.m_connection = metaConnection;
        m_MdFactory = factory;
        BrgOrb orb = (BrgOrb)((ObjectImpl)metaConnection)._orb();
        Properties connectionProperties = orb.objectToProperties((Object)metaConnection);
        this.setHost(connectionProperties.getProperty("host"));
        this.setPort(connectionProperties.getProperty("port"));
        this.setUser(connectionProperties.getProperty("userName"));
        this.setPassword(connectionProperties.getProperty("password"));
        this.populateMissingParms();
    }

    public void connect() throws Exception {
        this.connect(this.m_host, this.m_port, this.m_user, String.valueOf(this.m_pwAuth.getPassword()), this.m_reposName, false);
    }

    public void connect(String host, String port, String user, String password, String reposName, boolean save) throws Exception {
        if (m_MdFactory == null) {
            return;
        }
        this.m_metaWorkspace = m_MdFactory.getConnection();
        try {
            this.m_connection = this.m_metaWorkspace.makeOMRConnection(host, port, user, password);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        if (save) {
            this.m_host = host;
            this.m_port = port;
            this.m_user = user;
            this.m_pwAuth = new PasswordAuthentication(user, password.toCharArray());
            this.m_reposName = reposName;
            this.m_reposId = RepositoryUtil.getReposIdForName((MdFactory)m_MdFactory, (String)this.m_reposName);
        }
    }

    public boolean isConnected() {
        return this.m_connection != null;
    }

    public IOMI getConnection() {
        return this.m_connection;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public String getPort() {
        return this.m_port;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.m_pwAuth = new PasswordAuthentication(this.m_user, this.getEncodedPassword(password).toCharArray());
        }
    }

    public String getReposId() {
        return this.m_reposId;
    }

    public void setReposId(String reposID) {
        if (!reposID.equalsIgnoreCase(this.m_reposId)) {
            this.m_reposId = reposID;
            this.m_reposName = null;
            this.populateMissingParms();
        }
    }

    public String getReposName() {
        return this.m_reposName;
    }

    public void setReposName(String reposName) {
        if (!reposName.equalsIgnoreCase(this.m_reposName)) {
            this.m_reposName = reposName;
            this.m_reposId = null;
            this.populateMissingParms();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                if (this.m_metaWorkspace != null) {
                    this.m_metaWorkspace.closeOMRConnection();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.m_connection = null;
        }
    }

    public void dispose() {
        this.m_pwAuth = null;
        try {
            this.m_metaWorkspace.dispose();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getEncodedPassword(String password) {
        if (password == null) {
            return null;
        }
        PasswordAuthentication encodedPwAuth = null;
        if (password != null) {
            encodedPwAuth = new PasswordAuthentication(this.m_user, Encryption.encrypt((String)password).toCharArray());
        }
        if (encodedPwAuth != null && String.valueOf(encodedPwAuth.getPassword()) == null) {
            encodedPwAuth = new PasswordAuthentication(this.m_user, password.toCharArray());
            try {
                m_MdFactory.setDebug(true);
                m_MdFactory.getUtil().printOutputln("\nCould not encrypt password.");
                m_MdFactory.setDebug(false);
            }
            catch (RemoteException re) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printStackTrace((Throwable)re);
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return encodedPwAuth == null ? null : String.valueOf(encodedPwAuth.getPassword());
    }

    private void populateMissingParms() {
        boolean isAlreadyConnected = this.isConnected();
        if (!isAlreadyConnected) {
            if (this.m_host == null) {
                this.m_host = DEFAULT_METAHOST;
            }
            if (this.m_port == null) {
                this.m_port = DEFAULT_METAPORT;
            }
            try {
                this.connect();
            }
            catch (RemoteException e) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\n Could not connect to server to retrieve repository attributes.\n");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            catch (Exception e) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\n Could not connect to server to retrieve repository attributes.\n");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.m_reposId == null && this.m_reposName != null) {
            try {
                this.m_reposId = RepositoryUtil.getReposIdForName((MdFactory)m_MdFactory, (String)this.m_reposName);
            }
            catch (Exception e) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\n Could not retrived repository Id.\n");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
        } else if (this.m_reposName == null && this.m_reposId != null) {
            try {
                this.m_reposName = RepositoryUtil.getNameForReposId((MdFactory)m_MdFactory, (String)this.m_reposId);
            }
            catch (Exception e) {
                try {
                    m_MdFactory.setDebug(true);
                    m_MdFactory.getUtil().printOutputln("\n Could not retrieve repository attributes.\n");
                    m_MdFactory.setDebug(false);
                }
                catch (RemoteException re) {
                    try {
                        m_MdFactory.setDebug(true);
                        m_MdFactory.getUtil().printStackTrace((Throwable)re);
                        m_MdFactory.setDebug(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
        if (!isAlreadyConnected) {
            this.disconnect();
        }
    }
}

