/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.rsa;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.rsa.RsaCrypto;
import com.sas.net.crypto.rsa.RsaLocalizedError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class RsaCipher
implements CipherInterface {
    private static final byte[] GHTQ = new byte[]{82, 83, 65, 49};
    private static final byte[] append = new byte[]{83, 73, 90};
    private static final byte[] clearSensitiveData = new byte[]{80, 85, 66};
    private static final byte[] decryptFinal = new byte[]{83, 69, 67};
    private RsaCrypto decryptInit;
    private String decryptReInit;
    private int decryptUpdate;
    private int digestFinal;
    private int digestInit;
    private int digestUpdate;
    private int encryptFinal;
    private JSAFE_MessageDigest encryptInit;
    private JSAFE_SymmetricCipher encryptReInit;
    private JSAFE_SymmetricCipher encryptUpdate;
    private JSAFE_SymmetricCipher equals;
    private JSAFE_SymmetricCipher flush;
    private JSAFE_SecretKey generate;
    private JSAFE_SecretKey generateInit;
    private JSAFE_SecretKey getDigestSize;
    private JSAFE_SecretKey getFIPS140Context;
    private byte[] getInstance;
    private byte[] getKeyData;
    private byte[] getOutputBufferSize;
    private byte[] getPrivateKey;
    private byte[] getPublicKey;
    private byte[] getSecretKeyData;
    private byte[] max;
    private byte[] read;
    private byte[] readFully;
    private int readInt;
    private int reset;
    private int setIV;
    private int setKeyData;
    private int setMode;
    private boolean setSecretKeyData;
    private String skipBytes;
    private String toString;
    private String write;

    protected RsaCipher(RsaCrypto rsaCrypto) {
        this.decryptInit = rsaCrypto;
        this.decryptReInit = rsaCrypto.getName();
        this.skipBytes = "Unknown";
        this.toString = "Unknown";
        this.write = "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void keyExchange(InputStream inputStream, OutputStream outputStream) {
        Error error;
        RuntimeException runtimeException;
        IOException iOException;
        CryptoException cryptoException;
        block213: {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            byte[] byArray6;
            Object object;
            byte[][] byArray7;
            JSAFE_PublicKey jSAFE_PublicKey;
            JSAFE_PublicKey jSAFE_PublicKey2;
            JSAFE_PrivateKey jSAFE_PrivateKey;
            block214: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(320);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                byte[] byArray8 = new byte[384];
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                ByteArrayInputStream byteArrayInputStream = null;
                DataInputStream dataInputStream2 = null;
                JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = null;
                JSAFE_KeyPair jSAFE_KeyPair = null;
                jSAFE_PrivateKey = null;
                jSAFE_PublicKey2 = null;
                jSAFE_PublicKey = null;
                byArray7 = null;
                object = null;
                byArray6 = null;
                byArray5 = null;
                byArray4 = null;
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                cryptoException = null;
                iOException = null;
                runtimeException = null;
                error = null;
                FIPS140Context fIPS140Context = null;
                try {
                    fIPS140Context = CryptoJ.getFIPS140Context();
                }
                catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                int n3 = fIPS140Context == null ? 0 : 904;
                int n4 = this.decryptReInit.equals("AES") ? 256 : this.decryptInit.S;
                dataOutputStream.write(append);
                dataOutputStream.write(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(this.decryptInit.J);
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeInt(this.digestInit);
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeInt(this.encryptFinal);
                byteArrayOutputStream.writeTo(outputStream);
                outputStream.flush();
                dataInputStream.readFully(byArray8, 0, 28);
                byteArrayInputStream = new ByteArrayInputStream(byArray8);
                dataInputStream2 = new DataInputStream(byteArrayInputStream);
                int n5 = dataInputStream2.readInt();
                if ((n5 & 0xFF) != 0) {
                    String string = "crypto.rsa.R00.ex.fmt";
                    Object[] objectArray = new Object[]{string};
                    String string2 = RsaLocalizedError.I("{0}: Bad key size record version.", objectArray);
                    throw new CryptoException(string2);
                }
                n5 = dataInputStream2.readInt();
                if (n5 != 0) {
                    String string = "crypto.rsa.R01.ex.fmt";
                    Object[] objectArray = new Object[]{string};
                    String string3 = RsaLocalizedError.I("{0}: Bad key size exchange status.", objectArray);
                    throw new CryptoException(string3);
                }
                this.decryptUpdate = dataInputStream2.readInt();
                this.digestFinal = dataInputStream2.readInt();
                this.digestInit = dataInputStream2.readInt();
                this.digestUpdate = dataInputStream2.readInt();
                this.encryptFinal = dataInputStream2.readInt();
                String string = null;
                int[] nArray = null;
                int n6 = 0;
                int n7 = 0;
                String string4 = null;
                String string5 = "/";
                if (this.decryptReInit.equals("DES")) {
                    string = "DES";
                    this.setMode = n6 = 8;
                    n7 = 26113;
                    string4 = string + string5 + this.decryptInit.D + string5 + this.decryptInit.F;
                    this.readInt = 8;
                } else if (this.decryptReInit.equals("TRIPLEDES")) {
                    string = "3DES_EDE";
                    this.setMode = n6 = 24;
                    n7 = 26115;
                    string4 = string + string5 + this.decryptInit.D + string5 + this.decryptInit.F;
                    this.readInt = 8;
                } else if (this.decryptReInit.equals("RC2")) {
                    string = "RC2";
                    n6 = this.decryptInit.A / 8;
                    this.setMode = this.digestFinal / 8;
                    n7 = 26114;
                    nArray = new int[]{this.decryptInit.A};
                    string4 = string + '-' + this.digestFinal + string5 + this.decryptInit.D + string5 + this.decryptInit.F;
                    this.readInt = 8;
                } else if (this.decryptReInit.equals("RC4")) {
                    string = "RC4";
                    n6 = this.decryptInit.A / 8;
                    this.setMode = this.digestFinal / 8;
                    n7 = 26625;
                    nArray = new int[]{this.decryptInit.A};
                    string4 = string;
                } else {
                    string = "AES";
                    this.setMode = n6 = 32;
                    n7 = 26128;
                    nArray = new int[]{256};
                    string4 = string + "256" + string5 + this.decryptInit.D + string5 + this.decryptInit.F;
                    this.readInt = 16;
                }
                this.toString = string4;
                try {
                    block212: {
                        try {
                            boolean bl = false;
                            if ((n3 & 0x200) != 0 && (this.digestUpdate & 0x1000) != 0) {
                                this.write = "SHA512";
                            } else if ((n3 & 0x100) != 0 && (this.digestUpdate & 0x800) != 0) {
                                this.write = "SHA256";
                            } else if ((n3 & 0x80) != 0 && (this.digestUpdate & 0x400) != 0) {
                                this.write = "SHA1";
                            } else {
                                this.write = this.decryptInit.B;
                                bl = true;
                            }
                            if (fIPS140Context != null) {
                                fIPS140Context = (this.digestUpdate & 0x40) != 0 || (this.digestUpdate & 0x20) != 0 && this.decryptReInit.equals("AES") && !bl ? fIPS140Context.setMode(0) : fIPS140Context.setMode(1);
                            }
                            this.encryptInit = RsaCipher.decryptFinal(this.write, this.decryptInit.I, fIPS140Context);
                            this.reset = this.encryptInit.getDigestSize();
                            this.max = new byte[this.reset];
                            this.encryptReInit = RsaCipher.decryptInit(string4, this.decryptInit.I, fIPS140Context);
                            this.encryptUpdate = RsaCipher.decryptInit(string4, this.decryptInit.I, fIPS140Context);
                            if ((this.digestUpdate & 1) != 0) {
                                this.setSecretKeyData = true;
                                this.equals = RsaCipher.decryptInit(string4, this.decryptInit.I, fIPS140Context);
                                this.flush = RsaCipher.decryptInit(string4, this.decryptInit.I, fIPS140Context);
                            }
                            jSAFE_KeyPair = this.decryptInit.I(this.decryptUpdate, fIPS140Context);
                            jSAFE_PublicKey2 = jSAFE_KeyPair.getPublicKey();
                            jSAFE_PrivateKey = jSAFE_KeyPair.getPrivateKey();
                            byArray7 = jSAFE_PublicKey2.getKeyData();
                            byteArrayOutputStream.reset();
                            dataOutputStream.write(clearSensitiveData);
                            dataOutputStream.write(1);
                            dataOutputStream.writeInt(0);
                            dataOutputStream.write(6);
                            dataOutputStream.write(2);
                            dataOutputStream.writeShort(0);
                            dataOutputStream.writeInt(41984);
                            dataOutputStream.write(GHTQ);
                            dataOutputStream.writeInt(this.decryptUpdate);
                            dataOutputStream.writeInt(this.decryptInit.Z);
                            dataOutputStream.write(byArray7[0]);
                            byteArrayOutputStream.writeTo(outputStream);
                            outputStream.flush();
                            n5 = this.decryptUpdate / 8 + 28;
                            if (n5 > byArray8.length) {
                                byArray8 = new byte[n5];
                            }
                            dataInputStream.readFully(byArray8, 0, n5);
                            byteArrayInputStream = new ByteArrayInputStream(byArray8);
                            dataInputStream2 = new DataInputStream(byteArrayInputStream);
                            n5 = dataInputStream2.readInt();
                            if ((n5 & 0xFF) != 1) {
                                String string6 = "crypto.rsa.R02.ex.fmt";
                                Object[] objectArray = new Object[]{string6};
                                String string7 = RsaLocalizedError.I("{0}: Bad public key record version.", objectArray);
                                throw new CryptoException(string7);
                            }
                            n5 = dataInputStream2.readInt();
                            if (n5 != 0) {
                                String string8 = "crypto.rsa.R03.ex.fmt";
                                Object[] objectArray = new Object[]{string8};
                                String string9 = RsaLocalizedError.I("{0}: Bad public key exchange status.", objectArray);
                                throw new CryptoException(string9);
                            }
                            dataInputStream2.skipBytes(20);
                            object = new byte[2][];
                            object[0] = new byte[this.decryptUpdate / 8];
                            dataInputStream2.readFully(object[0]);
                            object[1] = byArray7[1];
                            jSAFE_PublicKey = RsaCipher.decryptReInit("RSA", this.decryptInit.I, fIPS140Context);
                            jSAFE_PublicKey.setKeyData(object);
                            this.skipBytes = "RSA/" + this.decryptInit.C;
                            jSAFE_AsymmetricCipher = RsaCipher.decryptUpdate(this.skipBytes, this.decryptInit.I, fIPS140Context);
                            if (!this.decryptReInit.equals("RC4")) {
                                byArray6 = new byte[this.readInt];
                                this.decryptInit.I(byArray6, 0, this.readInt);
                                byArray4 = new byte[this.readInt];
                                if (this.setSecretKeyData) {
                                    byArray5 = new byte[this.readInt];
                                    this.decryptInit.I(byArray5, 0, this.readInt);
                                    byArray3 = new byte[this.readInt];
                                }
                            }
                            this.generate = RsaCipher.digestFinal(string, this.decryptInit.I, fIPS140Context);
                            this.generate.generateInit(nArray, this.decryptInit.I());
                            this.generate.generate();
                            this.getInstance = this.generate.getSecretKeyData();
                            this.getPublicKey = RsaCipher.GHTQ(this.getInstance, 0, this.setMode);
                            this.getOutputBufferSize = new byte[n6];
                            if (this.setSecretKeyData) {
                                this.generateInit = RsaCipher.digestFinal(string, this.decryptInit.I, fIPS140Context);
                                this.generateInit.generateInit(nArray, this.decryptInit.I());
                                this.generateInit.generate();
                                this.getKeyData = this.generateInit.getSecretKeyData();
                                byArray2 = RsaCipher.GHTQ(this.getKeyData, 0, this.setMode);
                                this.getPrivateKey = new byte[n6];
                            }
                            byteArrayOutputStream.reset();
                            dataOutputStream.write(decryptFinal);
                            dataOutputStream.write(1);
                            dataOutputStream.writeInt(0);
                            if (!this.decryptReInit.equals("RC4")) {
                                dataOutputStream.write(byArray6);
                                if (this.setSecretKeyData) {
                                    dataOutputStream.write(byArray5);
                                } else {
                                    RsaCipher.clearSensitiveData(dataOutputStream, this.readInt);
                                }
                            } else {
                                RsaCipher.clearSensitiveData(dataOutputStream, 16);
                            }
                            dataOutputStream.write(1);
                            dataOutputStream.write(2);
                            dataOutputStream.writeShort(0);
                            dataOutputStream.writeInt(n7);
                            dataOutputStream.writeInt(41984);
                            jSAFE_AsymmetricCipher.encryptInit(jSAFE_PublicKey, this.decryptInit.I());
                            dataOutputStream.write(jSAFE_AsymmetricCipher.encryptUpdate(this.getInstance, 0, this.setMode));
                            dataOutputStream.write(jSAFE_AsymmetricCipher.encryptFinal());
                            if (this.setSecretKeyData) {
                                dataOutputStream.write(1);
                                dataOutputStream.write(2);
                                dataOutputStream.writeShort(0);
                                dataOutputStream.writeInt(n7);
                                dataOutputStream.writeInt(41984);
                                jSAFE_AsymmetricCipher.encryptReInit();
                                dataOutputStream.write(jSAFE_AsymmetricCipher.encryptUpdate(this.getKeyData, 0, this.setMode));
                                dataOutputStream.write(jSAFE_AsymmetricCipher.encryptFinal());
                            }
                            byteArrayOutputStream.writeTo(outputStream);
                            outputStream.flush();
                            n5 = 8 + this.readInt * 2 + 12 + this.reset + this.decryptUpdate / 8;
                            if (this.decryptReInit.equals("RC4")) {
                                n5 += 16;
                            }
                            if (this.setSecretKeyData) {
                                n5 += 12 + this.decryptUpdate / 8;
                            }
                            if (n5 > byArray8.length) {
                                byArray8 = new byte[n5];
                            }
                            dataInputStream.readFully(byArray8, 0, n5);
                            byteArrayInputStream = new ByteArrayInputStream(byArray8);
                            dataInputStream2 = new DataInputStream(byteArrayInputStream);
                            n5 = dataInputStream2.readInt();
                            if ((n5 & 0xFF) != 1) {
                                String string10 = "crypto.rsa.R04.ex.fmt";
                                Object[] objectArray = new Object[]{string10};
                                String string11 = RsaLocalizedError.I("{0}: Bad session key record version.", objectArray);
                                throw new CryptoException(string11);
                            }
                            n5 = dataInputStream2.readInt();
                            if (n5 != 0) {
                                String string12 = "crypto.rsa.R05.ex.fmt";
                                Object[] objectArray = new Object[]{string12};
                                String string13 = RsaLocalizedError.I("{0}: Bad session key exchange status.", objectArray);
                                throw new CryptoException(string13);
                            }
                            if (!this.decryptReInit.equals("RC4")) {
                                dataInputStream2.readFully(byArray4);
                                if (this.setSecretKeyData) {
                                    dataInputStream2.readFully(byArray3);
                                } else {
                                    dataInputStream2.skipBytes(this.readInt);
                                }
                            } else {
                                dataInputStream2.skipBytes(16);
                            }
                            dataInputStream2.skipBytes(12);
                            byte[] byArray9 = new byte[this.decryptUpdate / 8];
                            dataInputStream2.readFully(byArray9);
                            jSAFE_AsymmetricCipher.decryptInit(jSAFE_PrivateKey);
                            int n8 = jSAFE_AsymmetricCipher.decryptUpdate(byArray9, 0, byArray9.length, this.getOutputBufferSize, 0);
                            jSAFE_AsymmetricCipher.decryptFinal(this.getOutputBufferSize, n8);
                            this.getSecretKeyData = RsaCipher.GHTQ(this.getOutputBufferSize, 0, this.setMode);
                            if (this.setSecretKeyData) {
                                dataInputStream2.skipBytes(12);
                                dataInputStream2.readFully(byArray9);
                                jSAFE_AsymmetricCipher.decryptReInit();
                                n8 = jSAFE_AsymmetricCipher.decryptUpdate(byArray9, 0, byArray9.length, this.getPrivateKey, 0);
                                jSAFE_AsymmetricCipher.decryptFinal(this.getPrivateKey, n8);
                                byArray = RsaCipher.GHTQ(this.getPrivateKey, 0, this.setMode);
                            }
                            byte[] byArray10 = new byte[this.reset];
                            dataInputStream2.readFully(byArray10);
                            this.encryptInit.digestInit();
                            this.encryptInit.digestUpdate(this.getPublicKey, 0, this.getPublicKey.length);
                            if (this.setSecretKeyData) {
                                this.encryptInit.digestUpdate(byArray2, 0, byArray2.length);
                            }
                            this.encryptInit.digestUpdate(byArray7[0], 0, byArray7[0].length);
                            this.encryptInit.digestUpdate(this.getSecretKeyData, 0, this.getSecretKeyData.length);
                            if (this.setSecretKeyData) {
                                this.encryptInit.digestUpdate(byArray, 0, byArray.length);
                            }
                            this.encryptInit.digestUpdate(object[0], 0, object[0].length);
                            byte[] byArray11 = new byte[]{112, 104, 97, 115, 101, 32, 50};
                            this.encryptInit.digestUpdate(byArray11, 0, byArray11.length);
                            this.encryptInit.digestFinal(this.max, 0);
                            if (!RsaCipher.append(this.max, byArray10)) {
                                String string14 = "crypto.rsa.R06.ex.fmt";
                                Object[] objectArray = new Object[]{string14};
                                String string15 = RsaLocalizedError.I("{0}: The session key message was altered in transit.", objectArray);
                                throw new CryptoException(string15);
                            }
                            this.encryptInit.digestInit();
                            this.encryptInit.digestUpdate(this.getSecretKeyData, 0, this.getSecretKeyData.length);
                            if (this.setSecretKeyData) {
                                this.encryptInit.digestUpdate(byArray, 0, byArray.length);
                            }
                            this.encryptInit.digestUpdate(byArray7[0], 0, byArray7[0].length);
                            this.encryptInit.digestUpdate(object[0], 0, object[0].length);
                            byte[] byArray12 = new byte[]{112, 104, 97, 115, 101, 32, 51};
                            this.encryptInit.digestUpdate(byArray12, 0, byArray12.length);
                            this.encryptInit.digestFinal(this.max, 0);
                            outputStream.write(this.max);
                            outputStream.flush();
                            this.getDigestSize = RsaCipher.digestFinal(string, this.decryptInit.I, fIPS140Context);
                            if (this.setSecretKeyData) {
                                this.getFIPS140Context = RsaCipher.digestFinal(string, this.decryptInit.I, fIPS140Context);
                            }
                            if (!this.decryptReInit.equals("RC4")) {
                                this.encryptReInit.setIV(byArray6, 0, byArray6.length);
                                this.encryptUpdate.setIV(byArray4, 0, byArray4.length);
                                if (this.setSecretKeyData) {
                                    this.equals.setIV(byArray5, 0, byArray5.length);
                                    this.flush.setIV(byArray3, 0, byArray3.length);
                                }
                            }
                            if (this.setSecretKeyData) {
                                this.setIV = this.encryptReInit.getOutputBufferSize(this.reset);
                            }
                            int n9 = Math.max(this.setIV, 256);
                            this.readFully = new byte[n9];
                            this.read = new byte[n9];
                            this.setKeyData = (n4 - this.digestFinal) / 8;
                            if (!this.decryptReInit.equals("DES") && !this.decryptReInit.equals("TRIPLEDES") && this.setKeyData != 0) break block212;
                            this.encryptReInit.encryptInit(this.generate);
                            this.getDigestSize.setSecretKeyData(this.getOutputBufferSize, 0, this.getOutputBufferSize.length);
                            this.encryptUpdate.decryptInit(this.getDigestSize);
                            if (!this.setSecretKeyData) break block212;
                            this.equals.encryptInit(this.generateInit);
                            this.getFIPS140Context.setSecretKeyData(this.getPrivateKey, 0, this.getPrivateKey.length);
                            this.flush.decryptInit(this.getFIPS140Context);
                        }
                        catch (JSAFE_Exception jSAFE_Exception) {
                            int n12;
                            int n13;
                            cryptoException = new CryptoException((Throwable)jSAFE_Exception);
                            Object var45_73 = null;
                            if (jSAFE_AsymmetricCipher != null) {
                                jSAFE_AsymmetricCipher.clearSensitiveData();
                            }
                            if (jSAFE_PrivateKey != null) {
                                jSAFE_PrivateKey.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey2 != null) {
                                jSAFE_PublicKey2.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey != null) {
                                jSAFE_PublicKey.clearSensitiveData();
                            }
                            if (byArray7 != null) {
                                for (n13 = 0; n13 < byArray7.length; ++n13) {
                                    if (byArray7[n13] == null) continue;
                                    for (n12 = 0; n12 < byArray7[n13].length; ++n12) {
                                        byArray7[n13][n12] = 0;
                                    }
                                }
                            }
                            if (object != null) {
                                for (n13 = 0; n13 < ((byte[][])object).length; ++n13) {
                                    if (object[n13] == null) continue;
                                    for (n12 = 0; n12 < object[n13].length; ++n12) {
                                        object[n13][n12] = 0;
                                    }
                                }
                            }
                            if (byArray6 != null) {
                                for (n13 = 0; n13 < byArray6.length; ++n13) {
                                    byArray6[n13] = false;
                                }
                            }
                            if (byArray5 != null) {
                                for (n13 = 0; n13 < byArray5.length; ++n13) {
                                    byArray5[n13] = false;
                                }
                            }
                            if (byArray4 != null) {
                                for (n13 = 0; n13 < byArray4.length; ++n13) {
                                    byArray4[n13] = false;
                                }
                            }
                            if (byArray3 != null) {
                                for (n13 = 0; n13 < byArray3.length; ++n13) {
                                    byArray3[n13] = false;
                                }
                            }
                            if (byArray2 != null) {
                                for (n13 = 0; n13 < byArray2.length; ++n13) {
                                    byArray2[n13] = false;
                                }
                            }
                            if (byArray == null) break block213;
                            for (n13 = 0; n13 < byArray.length; ++n13) {
                                byArray[n13] = false;
                            }
                            break block213;
                        }
                        catch (IOException iOException2) {
                            int n14;
                            int n15;
                            iOException = iOException2;
                            Object var45_74 = null;
                            if (jSAFE_AsymmetricCipher != null) {
                                jSAFE_AsymmetricCipher.clearSensitiveData();
                            }
                            if (jSAFE_PrivateKey != null) {
                                jSAFE_PrivateKey.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey2 != null) {
                                jSAFE_PublicKey2.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey != null) {
                                jSAFE_PublicKey.clearSensitiveData();
                            }
                            if (byArray7 != null) {
                                for (n15 = 0; n15 < byArray7.length; ++n15) {
                                    if (byArray7[n15] == null) continue;
                                    for (n14 = 0; n14 < byArray7[n15].length; ++n14) {
                                        byArray7[n15][n14] = 0;
                                    }
                                }
                            }
                            if (object != null) {
                                for (n15 = 0; n15 < ((byte[][])object).length; ++n15) {
                                    if (object[n15] == null) continue;
                                    for (n14 = 0; n14 < object[n15].length; ++n14) {
                                        object[n15][n14] = 0;
                                    }
                                }
                            }
                            if (byArray6 != null) {
                                for (n15 = 0; n15 < byArray6.length; ++n15) {
                                    byArray6[n15] = false;
                                }
                            }
                            if (byArray5 != null) {
                                for (n15 = 0; n15 < byArray5.length; ++n15) {
                                    byArray5[n15] = false;
                                }
                            }
                            if (byArray4 != null) {
                                for (n15 = 0; n15 < byArray4.length; ++n15) {
                                    byArray4[n15] = false;
                                }
                            }
                            if (byArray3 != null) {
                                for (n15 = 0; n15 < byArray3.length; ++n15) {
                                    byArray3[n15] = false;
                                }
                            }
                            if (byArray2 != null) {
                                for (n15 = 0; n15 < byArray2.length; ++n15) {
                                    byArray2[n15] = false;
                                }
                            }
                            if (byArray == null) break block213;
                            for (n15 = 0; n15 < byArray.length; ++n15) {
                                byArray[n15] = false;
                            }
                            break block213;
                        }
                        catch (CryptoException cryptoException2) {
                            int n16;
                            int n17;
                            cryptoException = cryptoException2;
                            Object var45_75 = null;
                            if (jSAFE_AsymmetricCipher != null) {
                                jSAFE_AsymmetricCipher.clearSensitiveData();
                            }
                            if (jSAFE_PrivateKey != null) {
                                jSAFE_PrivateKey.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey2 != null) {
                                jSAFE_PublicKey2.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey != null) {
                                jSAFE_PublicKey.clearSensitiveData();
                            }
                            if (byArray7 != null) {
                                for (n17 = 0; n17 < byArray7.length; ++n17) {
                                    if (byArray7[n17] == null) continue;
                                    for (n16 = 0; n16 < byArray7[n17].length; ++n16) {
                                        byArray7[n17][n16] = 0;
                                    }
                                }
                            }
                            if (object != null) {
                                for (n17 = 0; n17 < ((byte[][])object).length; ++n17) {
                                    if (object[n17] == null) continue;
                                    for (n16 = 0; n16 < object[n17].length; ++n16) {
                                        object[n17][n16] = 0;
                                    }
                                }
                            }
                            if (byArray6 != null) {
                                for (n17 = 0; n17 < byArray6.length; ++n17) {
                                    byArray6[n17] = false;
                                }
                            }
                            if (byArray5 != null) {
                                for (n17 = 0; n17 < byArray5.length; ++n17) {
                                    byArray5[n17] = false;
                                }
                            }
                            if (byArray4 != null) {
                                for (n17 = 0; n17 < byArray4.length; ++n17) {
                                    byArray4[n17] = false;
                                }
                            }
                            if (byArray3 != null) {
                                for (n17 = 0; n17 < byArray3.length; ++n17) {
                                    byArray3[n17] = false;
                                }
                            }
                            if (byArray2 != null) {
                                for (n17 = 0; n17 < byArray2.length; ++n17) {
                                    byArray2[n17] = false;
                                }
                            }
                            if (byArray == null) break block213;
                            for (n17 = 0; n17 < byArray.length; ++n17) {
                                byArray[n17] = false;
                            }
                            break block213;
                        }
                        catch (RuntimeException runtimeException2) {
                            int n18;
                            int n19;
                            runtimeException = runtimeException2;
                            Object var45_76 = null;
                            if (jSAFE_AsymmetricCipher != null) {
                                jSAFE_AsymmetricCipher.clearSensitiveData();
                            }
                            if (jSAFE_PrivateKey != null) {
                                jSAFE_PrivateKey.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey2 != null) {
                                jSAFE_PublicKey2.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey != null) {
                                jSAFE_PublicKey.clearSensitiveData();
                            }
                            if (byArray7 != null) {
                                for (n19 = 0; n19 < byArray7.length; ++n19) {
                                    if (byArray7[n19] == null) continue;
                                    for (n18 = 0; n18 < byArray7[n19].length; ++n18) {
                                        byArray7[n19][n18] = 0;
                                    }
                                }
                            }
                            if (object != null) {
                                for (n19 = 0; n19 < ((byte[][])object).length; ++n19) {
                                    if (object[n19] == null) continue;
                                    for (n18 = 0; n18 < object[n19].length; ++n18) {
                                        object[n19][n18] = 0;
                                    }
                                }
                            }
                            if (byArray6 != null) {
                                for (n19 = 0; n19 < byArray6.length; ++n19) {
                                    byArray6[n19] = false;
                                }
                            }
                            if (byArray5 != null) {
                                for (n19 = 0; n19 < byArray5.length; ++n19) {
                                    byArray5[n19] = false;
                                }
                            }
                            if (byArray4 != null) {
                                for (n19 = 0; n19 < byArray4.length; ++n19) {
                                    byArray4[n19] = false;
                                }
                            }
                            if (byArray3 != null) {
                                for (n19 = 0; n19 < byArray3.length; ++n19) {
                                    byArray3[n19] = false;
                                }
                            }
                            if (byArray2 != null) {
                                for (n19 = 0; n19 < byArray2.length; ++n19) {
                                    byArray2[n19] = false;
                                }
                            }
                            if (byArray == null) break block213;
                            for (n19 = 0; n19 < byArray.length; ++n19) {
                                byArray[n19] = false;
                            }
                            break block213;
                        }
                        catch (Error error2) {
                            int n20;
                            int n21;
                            error = error2;
                            Object var45_77 = null;
                            if (jSAFE_AsymmetricCipher != null) {
                                jSAFE_AsymmetricCipher.clearSensitiveData();
                            }
                            if (jSAFE_PrivateKey != null) {
                                jSAFE_PrivateKey.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey2 != null) {
                                jSAFE_PublicKey2.clearSensitiveData();
                            }
                            if (jSAFE_PublicKey != null) {
                                jSAFE_PublicKey.clearSensitiveData();
                            }
                            if (byArray7 != null) {
                                for (n21 = 0; n21 < byArray7.length; ++n21) {
                                    if (byArray7[n21] == null) continue;
                                    for (n20 = 0; n20 < byArray7[n21].length; ++n20) {
                                        byArray7[n21][n20] = 0;
                                    }
                                }
                            }
                            if (object != null) {
                                for (n21 = 0; n21 < ((byte[][])object).length; ++n21) {
                                    if (object[n21] == null) continue;
                                    for (n20 = 0; n20 < object[n21].length; ++n20) {
                                        object[n21][n20] = 0;
                                    }
                                }
                            }
                            if (byArray6 != null) {
                                for (n21 = 0; n21 < byArray6.length; ++n21) {
                                    byArray6[n21] = false;
                                }
                            }
                            if (byArray5 != null) {
                                for (n21 = 0; n21 < byArray5.length; ++n21) {
                                    byArray5[n21] = false;
                                }
                            }
                            if (byArray4 != null) {
                                for (n21 = 0; n21 < byArray4.length; ++n21) {
                                    byArray4[n21] = false;
                                }
                            }
                            if (byArray3 != null) {
                                for (n21 = 0; n21 < byArray3.length; ++n21) {
                                    byArray3[n21] = false;
                                }
                            }
                            if (byArray2 != null) {
                                for (n21 = 0; n21 < byArray2.length; ++n21) {
                                    byArray2[n21] = false;
                                }
                            }
                            if (byArray == null) break block213;
                            for (n21 = 0; n21 < byArray.length; ++n21) {
                                byArray[n21] = false;
                            }
                            break block213;
                        }
                    }
                    Object var45_72 = null;
                    if (jSAFE_AsymmetricCipher == null) break block214;
                }
                catch (Throwable throwable) {
                    int n10;
                    int n11;
                    Object var45_78 = null;
                    if (jSAFE_AsymmetricCipher != null) {
                        jSAFE_AsymmetricCipher.clearSensitiveData();
                    }
                    if (jSAFE_PrivateKey != null) {
                        jSAFE_PrivateKey.clearSensitiveData();
                    }
                    if (jSAFE_PublicKey2 != null) {
                        jSAFE_PublicKey2.clearSensitiveData();
                    }
                    if (jSAFE_PublicKey != null) {
                        jSAFE_PublicKey.clearSensitiveData();
                    }
                    if (byArray7 != null) {
                        for (n11 = 0; n11 < byArray7.length; ++n11) {
                            if (byArray7[n11] == null) continue;
                            for (n10 = 0; n10 < byArray7[n11].length; ++n10) {
                                byArray7[n11][n10] = 0;
                            }
                        }
                    }
                    if (object != null) {
                        for (n11 = 0; n11 < ((byte[][])object).length; ++n11) {
                            if (object[n11] == null) continue;
                            for (n10 = 0; n10 < object[n11].length; ++n10) {
                                object[n11][n10] = 0;
                            }
                        }
                    }
                    if (byArray6 != null) {
                        for (n11 = 0; n11 < byArray6.length; ++n11) {
                            byArray6[n11] = false;
                        }
                    }
                    if (byArray5 != null) {
                        for (n11 = 0; n11 < byArray5.length; ++n11) {
                            byArray5[n11] = false;
                        }
                    }
                    if (byArray4 != null) {
                        for (n11 = 0; n11 < byArray4.length; ++n11) {
                            byArray4[n11] = false;
                        }
                    }
                    if (byArray3 != null) {
                        for (n11 = 0; n11 < byArray3.length; ++n11) {
                            byArray3[n11] = false;
                        }
                    }
                    if (byArray2 != null) {
                        for (n11 = 0; n11 < byArray2.length; ++n11) {
                            byArray2[n11] = false;
                        }
                    }
                    if (byArray != null) {
                        for (n11 = 0; n11 < byArray.length; ++n11) {
                            byArray[n11] = false;
                        }
                    }
                    throw throwable;
                }
                jSAFE_AsymmetricCipher.clearSensitiveData();
            }
            if (jSAFE_PrivateKey != null) {
                jSAFE_PrivateKey.clearSensitiveData();
            }
            if (jSAFE_PublicKey2 != null) {
                jSAFE_PublicKey2.clearSensitiveData();
            }
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
            if (byArray7 != null) {
                for (n2 = 0; n2 < byArray7.length; ++n2) {
                    if (byArray7[n2] == null) continue;
                    for (n = 0; n < byArray7[n2].length; ++n) {
                        byArray7[n2][n] = 0;
                    }
                }
            }
            if (object != null) {
                for (n2 = 0; n2 < ((byte[][])object).length; ++n2) {
                    if (object[n2] == null) continue;
                    for (n = 0; n < object[n2].length; ++n) {
                        object[n2][n] = 0;
                    }
                }
            }
            if (byArray6 != null) {
                for (n2 = 0; n2 < byArray6.length; ++n2) {
                    byArray6[n2] = 0;
                }
            }
            if (byArray5 != null) {
                for (n2 = 0; n2 < byArray5.length; ++n2) {
                    byArray5[n2] = 0;
                }
            }
            if (byArray4 != null) {
                for (n2 = 0; n2 < byArray4.length; ++n2) {
                    byArray4[n2] = 0;
                }
            }
            if (byArray3 != null) {
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    byArray3[n2] = 0;
                }
            }
            if (byArray2 != null) {
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    byArray2[n2] = 0;
                }
            }
            if (byArray != null) {
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    byArray[n2] = 0;
                }
            }
        }
        if (cryptoException != null) {
            throw cryptoException;
        }
        if (iOException != null) {
            throw iOException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (error != null) {
            throw error;
        }
    }

    public final int getCipherTextLength(int n) {
        int n2 = this.setKeyData;
        n2 = !this.decryptReInit.equals("RC4") ? (n2 += n + this.readInt & ~(this.readInt - 1)) : (n2 += n);
        if (this.setSecretKeyData) {
            n2 += this.setIV + this.setKeyData;
        }
        return n2;
    }

    public final int getMaxPlainTextLength(int n) {
        int n2 = n - this.setKeyData;
        if (this.setSecretKeyData) {
            n2 -= this.setIV + this.setKeyData;
        }
        return Math.max(n2, 0);
    }

    public final synchronized int encrypt(byte[] byArray, int n, int n2, OutputStream outputStream) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            if (this.setKeyData > 0) {
                this.decryptInit.I(this.getInstance, this.setMode, this.setKeyData);
                outputStream.write(this.getInstance, this.setMode, this.setKeyData);
                n6 += this.setKeyData;
                if (this.setSecretKeyData) {
                    this.decryptInit.I(this.getKeyData, this.setMode, this.setKeyData);
                    outputStream.write(this.getKeyData, this.setMode, this.setKeyData);
                    n6 += this.setKeyData;
                }
            }
            if (this.setSecretKeyData) {
                this.encryptInit.digestInit();
                this.encryptInit.digestUpdate(this.getPublicKey, 0, this.getPublicKey.length);
                this.encryptInit.digestUpdate(byArray, n, n2);
                this.encryptInit.digestFinal(this.max, 0);
                if (this.decryptReInit.equals("RC2") && this.setKeyData > 0 || this.decryptReInit.equals("RC4")) {
                    this.generateInit.setSecretKeyData(this.getKeyData, 0, this.getKeyData.length);
                    this.equals.encryptInit(this.generateInit);
                } else {
                    this.equals.encryptReInit();
                }
                n5 = this.equals.encryptUpdate(this.max, 0, this.max.length, this.readFully, 0);
                n5 += this.equals.encryptFinal(this.readFully, n5);
                outputStream.write(this.readFully, 0, n5);
            }
            if (this.decryptReInit.equals("RC2") && this.setKeyData > 0 || this.decryptReInit.equals("RC4")) {
                this.generate.setSecretKeyData(this.getInstance, 0, this.getInstance.length);
                this.encryptReInit.encryptInit(this.generate);
            } else {
                this.encryptReInit.encryptReInit();
            }
            n3 = this.encryptReInit.getOutputBufferSize(n2);
            if (this.readFully.length < n3) {
                this.readFully = new byte[n3];
            }
            n4 = this.encryptReInit.encryptUpdate(byArray, n, n2, this.readFully, 0);
            n4 += this.encryptReInit.encryptFinal(this.readFully, n4);
            outputStream.write(this.readFully, 0, n4);
            outputStream.flush();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CryptoException((Throwable)jSAFE_Exception);
        }
        return n4 + n5 + n6;
    }

    public final synchronized int decrypt(InputStream inputStream, int n, byte[] byArray, int n2) {
        int n3;
        if (this.read.length < n) {
            this.read = new byte[n];
        }
        int n4 = 0;
        do {
            if ((n3 = inputStream.read(this.read, n4, n - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n);
        n3 = 0;
        int n5 = 0;
        try {
            int n6;
            if (this.setKeyData > 0) {
                for (n6 = 0; n6 < this.setKeyData; ++n6) {
                    this.getOutputBufferSize[this.setMode + n6] = this.read[n5 + n6];
                }
                n5 += this.setKeyData;
                if (this.setSecretKeyData) {
                    for (n6 = 0; n6 < this.setKeyData; ++n6) {
                        this.getPrivateKey[this.setMode + n6] = this.read[n5 + n6];
                    }
                    n5 += this.setKeyData;
                }
            }
            if (this.setSecretKeyData) {
                if (this.decryptReInit.equals("RC2") && this.setKeyData > 0 || this.decryptReInit.equals("RC4")) {
                    this.getFIPS140Context.setSecretKeyData(this.getPrivateKey, 0, this.getPrivateKey.length);
                    this.flush.decryptInit(this.getFIPS140Context);
                } else {
                    this.flush.decryptReInit();
                }
                n6 = this.flush.decryptUpdate(this.read, n5, this.setIV, this.max, 0);
                this.flush.decryptFinal(this.max, n6);
                n5 += this.setIV;
            }
            if (this.decryptReInit.equals("RC2") && this.setKeyData > 0 || this.decryptReInit.equals("RC4")) {
                this.getDigestSize.setSecretKeyData(this.getOutputBufferSize, 0, this.getOutputBufferSize.length);
                this.encryptUpdate.decryptInit(this.getDigestSize);
            } else {
                this.encryptUpdate.decryptReInit();
            }
            n3 = this.encryptUpdate.decryptUpdate(this.read, n5, n - n5, byArray, 0);
            n3 += this.encryptUpdate.decryptFinal(byArray, n3);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CryptoException((Throwable)jSAFE_Exception);
        }
        return n3;
    }

    public final void close() {
        int n;
        if (this.encryptReInit != null) {
            this.encryptReInit.clearSensitiveData();
            this.encryptReInit = null;
        }
        if (this.equals != null) {
            this.equals.clearSensitiveData();
            this.equals = null;
        }
        if (this.encryptUpdate != null) {
            this.encryptUpdate.clearSensitiveData();
            this.encryptUpdate = null;
        }
        if (this.flush != null) {
            this.flush.clearSensitiveData();
            this.flush = null;
        }
        if (this.generate != null) {
            this.generate.clearSensitiveData();
        }
        if (this.generateInit != null) {
            this.generateInit.clearSensitiveData();
        }
        if (this.getDigestSize != null) {
            this.getDigestSize.clearSensitiveData();
        }
        if (this.getFIPS140Context != null) {
            this.getFIPS140Context.clearSensitiveData();
        }
        if (this.getInstance != null) {
            for (n = 0; n < this.getInstance.length; ++n) {
                this.getInstance[n] = 0;
            }
        }
        if (this.getKeyData != null) {
            for (n = 0; n < this.getKeyData.length; ++n) {
                this.getKeyData[n] = 0;
            }
        }
        if (this.getOutputBufferSize != null) {
            for (n = 0; n < this.getOutputBufferSize.length; ++n) {
                this.getOutputBufferSize[n] = 0;
            }
        }
        if (this.getPrivateKey != null) {
            for (n = 0; n < this.getPrivateKey.length; ++n) {
                this.getPrivateKey[n] = 0;
            }
        }
        if (this.getPublicKey != null) {
            for (n = 0; n < this.getPublicKey.length; ++n) {
                this.getPublicKey[n] = 0;
            }
        }
        if (this.getSecretKeyData != null) {
            for (n = 0; n < this.getSecretKeyData.length; ++n) {
                this.getSecretKeyData[n] = 0;
            }
        }
        if (this.encryptInit != null) {
            this.encryptInit.clearSensitiveData();
            this.encryptInit = null;
        }
        this.decryptInit.I(this);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Asymmetric=").append(this.skipBytes);
        stringBuffer.append("/").append(this.decryptUpdate).append("|");
        stringBuffer.append("Symmetric=").append(this.toString).append("|");
        stringBuffer.append("Digester=").append(this.write);
        String string = stringBuffer.toString();
        return string;
    }

    private static byte[] GHTQ(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = n2 - 1;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            byArray2[n3] = byArray[n5];
            ++n5;
            --n3;
        }
        return byArray2;
    }

    private static boolean append(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static void clearSensitiveData(DataOutputStream dataOutputStream, int n) {
        while (n >= 4) {
            dataOutputStream.writeInt(0);
            n -= 4;
        }
        while (n >= 1) {
            dataOutputStream.write(0);
            --n;
        }
    }

    private static JSAFE_MessageDigest decryptFinal(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_MessageDigest jSAFE_MessageDigest = fIPS140Context != null ? JSAFE_MessageDigest.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_MessageDigest.getInstance((String)string, (String)string2);
        return jSAFE_MessageDigest;
    }

    private static JSAFE_SymmetricCipher decryptInit(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = fIPS140Context != null ? JSAFE_SymmetricCipher.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_SymmetricCipher.getInstance((String)string, (String)string2);
        return jSAFE_SymmetricCipher;
    }

    private static JSAFE_PublicKey decryptReInit(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_PublicKey jSAFE_PublicKey = fIPS140Context != null ? JSAFE_PublicKey.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_PublicKey.getInstance((String)string, (String)string2);
        return jSAFE_PublicKey;
    }

    private static JSAFE_AsymmetricCipher decryptUpdate(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = fIPS140Context != null ? JSAFE_AsymmetricCipher.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_AsymmetricCipher.getInstance((String)string, (String)string2);
        return jSAFE_AsymmetricCipher;
    }

    private static JSAFE_SecretKey digestFinal(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_SecretKey jSAFE_SecretKey = fIPS140Context != null ? JSAFE_SecretKey.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_SecretKey.getInstance((String)string, (String)string2);
        return jSAFE_SecretKey;
    }
}

