/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.sas.entities.GUID;
import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.build.ImportFlowFromCSV;
import com.sas.scheduler.api.build.ImportFlowFromSAS;
import com.sas.scheduler.api.build.ImportFlowFromXML;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.BatchJob;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.MetaUtilitiesContext;
import com.sas.scheduler.api.oma.MetaUtilitiesContextHolder;
import com.sas.scheduler.api.oma.SubmitFlow;
import com.sas.scheduler.api.report.ReportFlowToCSV;
import com.sas.scheduler.api.report.ReportFlowToSAS;
import com.sas.scheduler.api.report.ReportFlowToXML;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.sasjfs.SASJFSServiceProxy;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilInterface;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.server.ServerUtilitiesListener;
import com.sas.scheduler.visuals.swing.DeployJobPanel;
import com.sas.services.ServiceException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class ServerUtilOMA
implements ServerUtilInterface,
MdFactoryListener {
    private static ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ServerUtilOMA.class);
    private static final Logger LOGGER = LogManager.getLogger(ServerUtilOMA.class);
    private PromptCallbackInterface m_prompt;
    public static final String MYFOLDER_NAME = "My Folder";
    private SessionContextInterface m_defaultSessionContext;
    private UserContextInterface m_defaultUserContext;
    private MdFactory m_defaultMdFactory;
    private MdObjectStore m_defaultMdStore;
    private String m_defaultMdRepository;
    private String m_defaultMdRepositoryId;
    private boolean m_bListeningToFactory = false;
    private ServerUtilitiesListener m_listener = null;
    public static final String OMR_FOLDER_DEFAULT = "/Shared Data";
    public static final String INVALIDFILENAMECHARACTERS = MetaUtilities.INVALIDFILENAMECHARACTERS;

    public ServerUtilOMA(PromptCallbackInterface prompt) {
        this.m_prompt = prompt;
    }

    public ServerUtilOMA(SessionContextInterface session, UserContextInterface user) throws SchedulerException {
        try {
            MdFactory factory;
            OMIServer server;
            this.m_defaultSessionContext = session;
            this.m_defaultUserContext = user;
            OMIServer oMIServer = server = user != null ? (OMIServer)user.getAuthServer() : null;
            if (server != null && (factory = server.getMdFactory()) != null) {
                this.setDefaultMdFactory(factory);
                this.setDefaultMdStore(factory.createObjectStore(null, "ServerUtilities_" + user.getName()));
                OMIServerRepository osr = (OMIServerRepository)server.getFoundationRepository();
                if (osr != null) {
                    this.setDefaultMdRepository(osr.getDefaultRepositoryId());
                }
                MetaUtilitiesContext context = new MetaUtilitiesContext(this.getDefaultMdFactory(), this.getDefaultMdStore(), this.getDefaultMdRepository(), session);
                MetaUtilitiesContextHolder.setMetaUtilitiesContext((MetaUtilitiesContext)context);
            }
        }
        catch (RemoteException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ServiceException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    @Override
    public void setPrompt(PromptCallbackInterface prompt) {
        this.m_prompt = prompt;
    }

    @Override
    public void secondaryInitialization(boolean reset, boolean debug, String name, String repos) {
        block5: {
            if (reset || this.getDefaultMdFactory() == null) {
                this.setDefaultMdFactory(debug);
            }
            if (this.getDefaultMdFactory() != null) {
                try {
                    this.setDefaultMdStore(this.getDefaultMdFactory().createObjectStore(null, name));
                    this.setDefaultMdRepository(repos);
                }
                catch (RemoteException remoteException) {
                }
                catch (Exception ex) {
                    if (!debug) break block5;
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void clearServerCaches() {
        MetaUtilities.clearCaches();
    }

    @Override
    public boolean isAllowPasswordCache() {
        return MetaUtilities.isAllowPasswordCache();
    }

    @Override
    public void dispose() {
        block3: {
            if (this.getDefaultMdStore() != null) {
                try {
                    this.getDefaultMdStore().dispose();
                    this.setDefaultMdStore(null);
                }
                catch (RemoteException e) {
                    if (!MetaUtilities.isDebug()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<SchedulerServerInfo> getSchedulingServers(int type) {
        boolean setAppServer = MetaUtilities.isAppServerResource((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        ArrayList<SchedulerServerInfo> list = new ArrayList<SchedulerServerInfo>();
        try {
            List temp = MetaUtilities.getSchedulerServers((int)type, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            for (ServerComponent sc : temp) {
                Scheduler s = MetaUtilities.getSchedulingServer((ServerComponent)sc, (boolean)setAppServer);
                SchedulerServerInfo sinfo = s.getServerComponent();
                list.add(sinfo);
            }
        }
        catch (RemoteException ex) {
            list = null;
        }
        catch (MdException ex) {
            list = null;
        }
        return list;
    }

    @Override
    public Scheduler getSchedulingServer(SchedulerServerInfo ssi) throws SchedulerException {
        Scheduler scheduler = ServerUtilities.getSchedulingServerFromCache(ssi);
        if (scheduler != null) {
            SchedulerServerInfo ssi2 = scheduler.getServerComponent();
            if (ssi != ssi2) {
                ssi.setUsername(ssi2.getUsername());
                ssi.setPassword(ssi2.getPassword());
            }
        } else {
            scheduler = MetaUtilities.getSchedulingServer((SchedulerServerInfo)ssi, (MdObjectStore)this.m_defaultMdStore);
        }
        return scheduler;
    }

    @Override
    public Scheduler getSchedulingServer(String id) throws SchedulerException {
        try {
            SchedulerServerInfo ssi2;
            boolean setAppServer = MetaUtilities.isAppServerResource((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            ServerComponent sc = MetaUtilities.getSchedulerServer((String)id, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            Scheduler scheduler = MetaUtilities.getSchedulingServer((ServerComponent)sc, (boolean)setAppServer);
            SchedulerServerInfo ssi = scheduler.getServerComponent();
            if (ServerUtilities.getSchedulingServerFromCache(ssi) != null && ssi != (ssi2 = (scheduler = ServerUtilities.getSchedulingServerFromCache(ssi)).getServerComponent())) {
                ssi.setUsername(ssi2.getUsername());
                ssi.setPassword(ssi2.getPassword());
            }
            return scheduler;
        }
        catch (RemoteException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (MdException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    @Override
    public PasswordAuthentication getSchedulerLoginIdentity(SchedulerServerInfo server) throws SchedulerException {
        String user = null;
        SealedString pass = null;
        PasswordAuthentication l = MetaUtilities.getLoginIdentity((SchedulerServerInfo)server);
        if (l != null) {
            user = l.getUserName();
            SealedString sealedString = pass = l.getPassword() != null ? new SealedString(l.getPassword()) : null;
        }
        if (user == null) {
            try {
                ServerComponent sc = MetaUtilities.getSchedulerServer((SchedulerServerInfo)server, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                Map map = sc.getObjectStore().getFactory().getConnection().getCredentialMap();
                if (map != null) {
                    user = (String)map.get("Username");
                    if (map.get("Password") != null) {
                        pass = new SealedString((String)map.get("Password"));
                        l = new PasswordAuthentication(user, pass.getCharacters());
                    } else {
                        l = null;
                    }
                }
            }
            catch (RemoteException e) {
                SchedulerException se = new SchedulerException(e.toString());
                se.initCause((Throwable)e);
                throw se;
            }
            catch (MdException e) {
                SchedulerException se = new SchedulerException(e.toString());
                se.initCause((Throwable)e);
                throw se;
            }
        }
        return l;
    }

    @Override
    public List<SASAppServer> getAppServersWithDeployedDirectories() {
        try {
            return MetaUtilities.getSASAppServers((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public IWorkspace getWorkspaceServer(BatchServerInfo bsi, UserContextInterface user, ServerComponent sc) throws SchedulerException, RemoteException, MdException, InvalidParameterException, CallbackCancelledException {
        IWorkspace iworkspace = ServerUtilities.getWorkspaceServerFromCache(bsi);
        if (iworkspace == null) {
            ServerContext context = IWorkspaceServer.getServerContext((ServerComponent)sc);
            SASAppServer appserver = new SASAppServer(context.getName(), context.getId(), null);
            iworkspace = ServerUtilOMA.getIWorkspace(user, this, appserver);
            if (bsi.getConnectionId() == null) {
                String connectionId = GUID.newGUID();
                bsi.setConnectionId(connectionId);
                ServerUtilities.putWorkspaceServerInCache(connectionId, iworkspace);
            }
        }
        return iworkspace;
    }

    @Override
    public IWorkspace getIWorkspace(UserContextInterface user, SASAppServer appserver) throws SchedulerException, InvalidParameterException, CallbackCancelledException {
        try {
            ServerContext sc = this.getSASAppServer(appserver);
            TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection((ServerComponent)sc, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
            if (tcpip == null) {
                throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.ErrorMsg.NoWorkspaceServer.fmt"), (Object)sc.getName()));
            }
            return IWorkspaceServer.checkConnectionToServer((UserContextInterface)user, (ServerComponent)sc, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public List<BatchServerInfo> getBatchServers(int type, int subtype) {
        try {
            ArrayList<BatchServerInfo> list = new ArrayList<BatchServerInfo>();
            for (ServerComponent sc : MetaUtilities.getBatchServers((int)type, (int)subtype, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId)) {
                BatchServerInfo batchserver = new BatchServerInfo(sc.getName(), sc.getClassIdentifier(), CommandUtilities.getTargetOSForBatchServer((ServerComponent)sc));
                MetaUtilities.setBatchServerProperties((BatchServerInfo)batchserver, (ServerComponent)sc);
                list.add(batchserver);
            }
            return list;
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    @Override
    public SASAppServer getSASAppServerFromBatchServer(BatchServerInfo bsinfo) {
        try {
            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)bsinfo, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            ServerContext appserver = IWorkspaceServer.getServerContext((ServerComponent)sc);
            return new SASAppServer(appserver.getName(), appserver.getId(), null);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (MdException ex) {
            return null;
        }
    }

    @Override
    public boolean isValidBatchServer(BatchServerInfo batchserver) {
        try {
            return MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId) != null;
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    @Override
    public String getJCLDir(BatchServerInfo info) {
        try {
            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)info, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepository);
            return MetaUtilities.getProperty((Root)sc, (String)"JCLDir");
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    @Override
    public String getJCLTemplate(BatchServerInfo batchserver, UserContextInterface user) {
        block16: {
            try {
                ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                IWorkspace iworkspace = null;
                if (iworkspace == null) {
                    try {
                        iworkspace = this.getWorkspaceServer(batchserver, user, sc);
                    }
                    catch (SchedulerException se) {
                        iworkspace = this.checkConnectionToWorkspaceServer(batchserver, this.m_prompt);
                    }
                }
                if (iworkspace == null) {
                    return null;
                }
                IFileService rio = iworkspace.FileService();
                String template = CommandUtilities.getCommandLineFromBatchServer((ServerComponent)sc);
                StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)template, (String)"", (String)"open_ed-1047", (int)2);
                return contents.toString();
            }
            catch (RemoteException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (GenericError ge) {
                if (MetaUtilities.isDebug()) {
                    ge.printStackTrace();
                }
            }
            catch (InvalidParameterException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (CallbackCancelledException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (!MetaUtilities.isDebug()) break block16;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IWorkspace getWorkspaceServer(BatchServerInfo batchserver, UserContextInterface user) throws SchedulerException, InvalidParameterException, CallbackCancelledException {
        try {
            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            ServerContext context = IWorkspaceServer.getServerContext((ServerComponent)sc);
            SASAppServer appserver = new SASAppServer(context.getName(), context.getId(), null);
            IWorkspace iworkspace = ServerUtilOMA.getIWorkspace(user, this, appserver);
            if (batchserver.getConnectionId() == null) {
                String connectionId = GUID.newGUID();
                batchserver.setConnectionId(connectionId);
                ServerUtilities.putWorkspaceServerInCache(connectionId, iworkspace);
            }
            return iworkspace;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public IWorkspace checkConnectionToWorkspaceServer(BatchServerInfo batchserver, PromptCallbackInterface prompt) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        IWorkspace iworkspace = null;
        try {
            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            iworkspace = this.getWorkspaceServer(batchserver, this.m_defaultUserContext, sc);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (SchedulerException e) {
            if (prompt != null) {
                String title = MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.Login.WorkspaceServer.Title.fmt"), (Object)batchserver.getName());
                while (iworkspace == null) {
                    String[] rc = prompt.promptLogin(title, null, null);
                    if (Integer.valueOf(rc[0]) == 1) {
                        SchedulerException se;
                        try {
                            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
                            iworkspace = this.makeConnectionToWorkspaceServer(sc, rc[1], rc[2]);
                            if (iworkspace == null || batchserver.getConnectionId() != null) continue;
                            String connectionId = GUID.newGUID();
                            batchserver.setConnectionId(connectionId);
                            ServerUtilities.putWorkspaceServerInCache(connectionId, iworkspace);
                            continue;
                        }
                        catch (MdException mde) {
                            se = new SchedulerException(mde.getLocalizedMessage());
                            se.initCause((Throwable)mde);
                            throw se;
                        }
                        catch (RemoteException ex) {
                            se = new SchedulerException(ex.getLocalizedMessage());
                            se.initCause((Throwable)ex);
                            throw se;
                        }
                    }
                    return null;
                }
            }
            throw e;
        }
        return iworkspace;
    }

    @Override
    public boolean isFileSystemAccessible(SchedulerServerInfo sinfo) {
        try {
            ServerComponent sched = MetaUtilities.getSchedulerServer((SchedulerServerInfo)sinfo, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            Machine machine = sched.getAssociatedMachine();
            if (machine != null) {
                for (Object obj : machine.getDeployedComponents()) {
                    ServerComponent temp;
                    if (!(obj instanceof ServerComponent) || (temp = (ServerComponent)obj).getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    return true;
                }
            }
            return false;
        }
        catch (MdException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
        catch (RemoteException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public IWorkspace checkConnectionToWorkspaceServer(SchedulerServerInfo schedserver, PromptCallbackInterface prompt) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        IWorkspace iworkspace = null;
        ServerComponent sc = null;
        try {
            ServerComponent sched = MetaUtilities.getSchedulerServer((SchedulerServerInfo)schedserver, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            Machine machine = sched.getAssociatedMachine();
            if (machine != null) {
                for (Object obj : machine.getDeployedComponents()) {
                    ServerComponent temp;
                    if (!(obj instanceof ServerComponent) || (temp = (ServerComponent)obj).getClassIdentifier().compareTo("440196D4-90F0-11D0-9F41-00A024BB830C") != 0) continue;
                    sc = temp;
                    break;
                }
            }
            if (sc != null) {
                ServerContext context = IWorkspaceServer.getServerContext(sc);
                SASAppServer appserver = new SASAppServer(context.getName(), context.getId(), null);
                iworkspace = ServerUtilOMA.getIWorkspace(this.m_defaultUserContext, this, appserver);
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (SchedulerException se) {
            if (prompt != null) {
                String title = MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.Login.WorkspaceServer.Title.fmt"), (Object)schedserver.getName());
                while (iworkspace == null) {
                    String[] rc = prompt.promptLogin(title, null, null);
                    if (Integer.valueOf(rc[0]) == 1) {
                        try {
                            iworkspace = this.makeConnectionToWorkspaceServer(sc, rc[1], rc[2]);
                            if (iworkspace == null || schedserver.getConnectionId() != null) continue;
                            String connectionId = GUID.newGUID();
                            schedserver.setConnectionId(connectionId);
                            ServerUtilities.putWorkspaceServerInCache(connectionId, iworkspace);
                            continue;
                        }
                        catch (RemoteException ex) {
                            SchedulerException e = new SchedulerException(ex.getLocalizedMessage());
                            e.initCause((Throwable)ex);
                            throw e;
                        }
                    }
                    return null;
                }
            }
            throw se;
        }
        return iworkspace;
    }

    @Override
    public IWorkspace checkConnectionToWorkspaceServer(UserContextInterface user, SASAppServer appserver) throws InvalidParameterException, SchedulerException, CallbackCancelledException {
        try {
            return ServerUtilOMA.getIWorkspace(user, this, appserver);
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public boolean updateSASAppServerDirectories(SASAppServer server) throws SchedulerException {
        try {
            return MetaUtilities.updateSASAppServerDirectories((SASAppServer)server, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public boolean setDefaultSessionContext(SessionContextInterface session) {
        MetaUtilities.setSessionContext((SessionContextInterface)session);
        return true;
    }

    @Override
    public String getUserID(UserContextInterface uc) throws SchedulerException {
        String userID = "unknown";
        try {
            IdentityInterface identity = uc.getPerson();
            if (identity != null) {
                userID = identity.getName();
                Person person = (Person)identity.getRepositoryEntity();
                if (person != null) {
                    userID = person.getName();
                    AssociationList l = person.getLogins();
                    if (l.size() > 0) {
                        Login login = (Login)l.get(0);
                        userID = login.getUserID();
                    }
                }
            }
        }
        catch (MdException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (RemoteException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        return userID;
    }

    @Override
    public String getFolderLocation(SASFolder folder) {
        try {
            return MetaUtilities.getFolderLocation((SASFolder)folder, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (MdException ex) {
            return "";
        }
        catch (RemoteException ex) {
            return "";
        }
    }

    @Override
    public SASFolder getFolder(String name) {
        try {
            String folder = name;
            String path = "/";
            int lastslash = name.lastIndexOf("/");
            if (lastslash > -1) {
                folder = name.substring(lastslash + 1);
                path = name.substring(0, lastslash);
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
            }
            SASFolder sasfolder = new SASFolder(folder, path);
            Tree tree = MetaUtilities.getFolder((SASFolder)sasfolder, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            sasfolder.setId(tree.getId());
            return sasfolder;
        }
        catch (RemoteException e1) {
            return null;
        }
        catch (NotFound e1) {
            return null;
        }
        catch (NoContext e1) {
            return null;
        }
        catch (MdException e1) {
            return null;
        }
    }

    @Override
    public void setDefaultFolder(String defaultDefaultFolder) {
        boolean createFolder = false;
        try {
            MetaUtilities.getDefaultFolder((MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (NotFound nf) {
            createFolder = true;
        }
        catch (NoContext nc) {
            if (nc.getCause() instanceof NotFound) {
                createFolder = true;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (createFolder) {
            try {
                MetaUtilities.createDefaultFolder();
            }
            catch (MdException mdException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public SASFolder getMyFolder(UserContextInterface user) {
        block7: {
            try {
                MdOMIUtil util = this.getDefaultMdFactory().getOMIUtil();
                String domain = user.getAuthServer().getDomain();
                UserIdentityInterface ident = user.getIdentityByDomain(domain);
                String userName = ident == null ? user.getResolvedUserId() : (String)ident.getCredential();
                Tree tree = util.getUserHomeFolder(this.getDefaultMdStore(), userName, MYFOLDER_NAME, "", 8584);
                String path = MetaUtilities.getFolderLocation((Tree)tree);
                int i = path.lastIndexOf(MYFOLDER_NAME);
                if (i > 0) {
                    path = path.substring(0, i - 1);
                }
                return new SASFolder(MYFOLDER_NAME, path);
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (ServiceException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block7;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<DirectoryInfo> getExistingDeploymentDirectories(BatchServerInfo batchserver) {
        try {
            ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)batchserver, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            return MetaUtilities.getDirectoryPaths((ServerComponent)sc);
        }
        catch (Exception ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public FileInfo getSourceCodes(DisplayInfo job) {
        return DeployedJob.getSourceCodes((DisplayInfo)job, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
    }

    @Override
    public String createFullPath(FileInfo file, BatchServerInfo binfo) {
        try {
            ServerComponent batchserver = MetaUtilities.getBatchServerComponent((BatchServerInfo)binfo, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            return CommandUtilities.createFullPath((String)file.getPath(), (String)file.getName(), (int)CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver));
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uniqueName(String name, String[] excludelist) {
        int MAXAUTONUMBER = 1000;
        int MAXDIGITS = 3;
        String unique = name;
        int count = 0;
        MdObjectStore tempStore = null;
        try {
            MdFactory factory = this.getDefaultMdStore().getFactory();
            tempStore = factory.createObjectStore();
            String repos = this.getDefaultMdRepository();
            boolean jobexists = MetaUtilities.doesJobExist((String)unique, (MdStore)tempStore, (String)repos);
            block15: while (jobexists && count < 1000) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumIntegerDigits(3);
                nf.setMinimumIntegerDigits(3);
                unique = name + nf.format(count++);
                jobexists = MetaUtilities.doesJobExist((String)unique, (MdStore)tempStore, (String)repos);
                if (jobexists || excludelist == null) continue;
                for (int x = 0; x < excludelist.length; ++x) {
                    if (excludelist[x].compareTo(unique) != 0) continue;
                    jobexists = true;
                    continue block15;
                }
            }
        }
        catch (MdException ex) {
            String string = null;
            return string;
        }
        catch (RemoteException ex) {
            String string = null;
            return string;
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RemoteException remoteException) {}
                tempStore = null;
            }
        }
        if (count < 1000) {
            return unique;
        }
        return null;
    }

    @Override
    public List<JobInfo> getAllJobsAndFlows(boolean readFromServer) {
        try {
            if (this.m_defaultMdStore != null) {
                return MetaUtilities.getJFJobList((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<JobInfo> getAllJobsAndFlowsByRoles(String role, boolean readFromServer) {
        try {
            if (this.m_defaultMdFactory != null) {
                return MetaUtilities.getJFJobList((String)role, (MdFactory)this.m_defaultMdFactory, (String)this.m_defaultMdRepositoryId);
            }
            if (this.m_defaultMdStore != null) {
                MdFactory factory = this.m_defaultMdStore.getFactory();
                if (factory != null) {
                    return MetaUtilities.getJFJobList((String)role, (MdFactory)factory, (String)this.m_defaultMdRepositoryId);
                }
                return null;
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<ServerFlowInfo> getListOfFlows(ServerInfoInterface info, ServerUtilities serverUtil) throws SchedulerException {
        if (info instanceof ServerFlowInfo) {
            DeployedFlow dflow;
            ArrayList<ServerFlowInfo> flows = new ArrayList<ServerFlowInfo>();
            ServerFlowInfo flow = (ServerFlowInfo)info;
            if (flow.m_object == null) {
                this.generateAllInformation(info);
            }
            if ((dflow = (DeployedFlow)flow.m_object) != null) {
                try {
                    for (JFJob jfjob : dflow.getListofFlows()) {
                        try {
                            FlowInfo finfo = new DeployedFlow(jfjob, (MdObjectStore)jfjob.getObjectStore()).getInfo();
                            ServerFlowInfo f = new ServerFlowInfo(finfo, serverUtil, null);
                            flows.add(f);
                        }
                        catch (SchedulerException finfo) {}
                    }
                    return flows;
                }
                catch (MdException ex) {
                    return null;
                }
                catch (RemoteException e) {
                    return null;
                }
            }
            return null;
        }
        if (info instanceof ServerJobInfo) {
            DeployedJob djob;
            ArrayList<ServerFlowInfo> flows = new ArrayList<ServerFlowInfo>();
            ServerJobInfo job = (ServerJobInfo)info;
            if (job.m_object == null) {
                this.generateAllInformation(info);
            }
            if ((djob = (DeployedJob)job.m_object) != null) {
                try {
                    for (JFJob jfjob : djob.getListofFlows()) {
                        FlowInfo finfo = new FlowInfo(jfjob.getName(), null, null);
                        finfo.setFlowSubmitted(DeployedFlow.isFlowSubmitted((JFJob)jfjob), DeployedFlow.getScheduledUser((JFJob)jfjob));
                        finfo.setSchedulerQueue(DeployedFlow.getQueue((JFJob)jfjob));
                        ServerFlowInfo flow = new ServerFlowInfo(finfo, serverUtil, null);
                        flows.add(flow);
                    }
                    return flows;
                }
                catch (MdException ex) {
                    return null;
                }
                catch (RemoteException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public DisplayInfo refresh(ServerInfoInterface serverinfo) throws SchedulerException {
        if (serverinfo instanceof ServerFlowInfo) {
            ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                DeployedFlow dflow = (DeployedFlow)o;
                try {
                    dflow.refresh();
                    return dflow.getInfo();
                }
                catch (MdException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
                catch (RemoteException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            ServerJobInfo job = (ServerJobInfo)serverinfo;
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                DeployedJob djob = (DeployedJob)o;
                try {
                    djob.refresh();
                    ServerFlowInfo flow = job.m_flow;
                    return djob.getInfo(flow.getName());
                }
                catch (MdException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
                catch (RemoteException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
            }
        }
        return null;
    }

    @Override
    public boolean resetFromInfo(ServerFlowInfo flow) throws SchedulerException {
        if (flow.isDirty()) {
            try {
                Object o = flow.m_object;
                if (o instanceof DeployedFlow) {
                    DeployedFlow dflow = (DeployedFlow)o;
                    FlowInfo info = flow.getInfo();
                    Scheduler sch = dflow.getSchedulingServer();
                    if (sch == null) {
                        sch = this.getSchedulingServer(info.getScheduler());
                    }
                    return dflow.resetFromInfo(info, this.m_prompt, sch);
                }
                Object obj = this.generateAllInformation(flow);
                return obj != null;
            }
            catch (MdException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (RemoteException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
        }
        return false;
    }

    @Override
    public Object generateAllInformation(ServerInfoInterface serverinfo) throws SchedulerException {
        DeployedJob rc = null;
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow = null;
            try {
                ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
                Object o = flow.m_object;
                if (o instanceof DeployedFlow) {
                    dflow = (DeployedFlow)o;
                }
                FlowInfo info = flow.getInfo();
                if (flow.isDirty()) {
                    String repos = this.getDefaultMdRepository();
                    if (repos.length() > 8) {
                        repos = repos.substring(9);
                    }
                    if (dflow != null) {
                        String newId;
                        Scheduler sch = dflow.getSchedulingServer();
                        String oldId = sch.getServerComponent() != null ? sch.getServerComponent().getId() : null;
                        String string = newId = info.getScheduler() != null ? info.getScheduler().getId() : null;
                        if (newId != null && oldId != null && newId.compareTo(oldId) == 0) {
                            dflow.resetFromInfo(info, this.m_prompt, sch);
                        } else {
                            dflow = new DeployedFlow(info, this.getDefaultMdStore(), repos);
                            flow.m_object = dflow;
                        }
                    } else {
                        Scheduler scheduler = null;
                        if (info != null && info.getScheduler() != null) {
                            scheduler = this.getSchedulingServer(info.getScheduler());
                        }
                        dflow = new DeployedFlow(info, null, scheduler, this.getDefaultMdStore(), repos);
                        flow.m_object = dflow;
                    }
                } else {
                    Scheduler scheduler = null;
                    if (info != null && info.getScheduler() != null) {
                        scheduler = this.getSchedulingServer(info.getScheduler());
                    }
                    JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    dflow = new DeployedFlow(jfjob, (MdObjectStore)jfjob.getObjectStore(), scheduler);
                    flow.m_object = dflow;
                    info = dflow.getInfo();
                }
                if (info != null) {
                    info.resetDirty(info.getId());
                }
                flow.m_info = info;
                List jobs = dflow.getJobs();
                if (jobs != null) {
                    for (Object obj : jobs) {
                        DeployedFlow tflow;
                        if (obj instanceof DeployedJob) {
                            DeployedJob job = (DeployedJob)obj;
                            if (!job.hasErrors()) continue;
                            dflow.checkAssociatedJobForErrors(job);
                            continue;
                        }
                        if (!(obj instanceof DeployedFlow) || !(tflow = (DeployedFlow)obj).hasErrors()) continue;
                        dflow.checkAssociatedSubflowForErrors(tflow);
                    }
                }
            }
            catch (MdException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (RemoteException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            rc = dflow;
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob = null;
            try {
                ServerFlowInfo flow;
                String flowname;
                ServerJobInfo job = (ServerJobInfo)serverinfo;
                DisplayInfo info = job.getJobInfo();
                Object o = job.m_object;
                String repos = this.getDefaultMdRepository();
                if (repos.length() > 8) {
                    repos = repos.substring(9);
                }
                String string = flowname = (flow = job.m_flow) != null ? flow.getName() : null;
                if (o instanceof DeployedJob) {
                    djob = (DeployedJob)o;
                } else if (info instanceof JobInfo) {
                    if (info.isDisplayOnly()) {
                        JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)this.getDefaultMdStore(), (String)("A0000001." + repos));
                        djob = new DeployedJob(jfjob);
                    } else {
                        djob = new DeployedJob((JobInfo)job.getJobInfo(), flowname, this.getDefaultMdStore(), repos);
                    }
                    job.m_object = djob;
                } else {
                    JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)this.getDefaultMdStore(), (String)("A0000001." + repos));
                    djob = new DeployedJob(jfjob);
                    job.m_object = djob;
                }
                job.m_info = djob.getInfo(flowname);
                if (djob.hasErrors()) {
                    djob.reevaluateErrors();
                }
            }
            catch (MdException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                djob = null;
            }
            catch (RemoteException ex) {
                djob = null;
            }
            catch (RuntimeException ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                djob = null;
            }
            rc = djob;
        }
        return rc;
    }

    @Override
    public Date getDateCreated(ServerInfoInterface serverinfo) {
        Date rc = null;
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
            }
            if (dflow != null) {
                rc = dflow.getDateCreated();
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedFlow.getDateCreated((JFJob)jfjob);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob = null;
            ServerJobInfo job = (ServerJobInfo)serverinfo;
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                djob = (DeployedJob)o;
            }
            if (djob != null) {
                rc = djob.getDateCreated();
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedJob.getDateCreated((JFJob)jfjob);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        }
        return rc;
    }

    @Override
    public String getDateCreatedStr(ServerInfoInterface serverinfo, boolean localformat) {
        String rc = null;
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
            }
            if (dflow != null) {
                rc = dflow.getDateCreated(localformat);
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedFlow.getDateCreated((JFJob)jfjob, (boolean)localformat);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob = null;
            ServerJobInfo job = (ServerJobInfo)serverinfo;
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                djob = (DeployedJob)o;
            }
            if (djob != null) {
                rc = djob.getDateCreated(localformat);
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedJob.getDateCreated((JFJob)jfjob, (boolean)localformat);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        }
        return rc;
    }

    @Override
    public Date getDateModified(ServerInfoInterface serverinfo) {
        Date rc = null;
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
            }
            if (dflow != null) {
                rc = dflow.getDateModified();
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedFlow.getDateModified((JFJob)jfjob, null);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob = null;
            ServerJobInfo job = (ServerJobInfo)serverinfo;
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                djob = (DeployedJob)o;
            }
            if (djob != null) {
                rc = djob.getDateModified();
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedJob.getDateModified((JFJob)jfjob);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        }
        return rc;
    }

    @Override
    public String getDateModifiedStr(ServerInfoInterface serverinfo, boolean localformat) {
        String rc = null;
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = (ServerFlowInfo)serverinfo;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
            }
            if (dflow != null) {
                rc = dflow.getDateModified(localformat);
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedFlow.getDateModified((JFJob)jfjob, null, (boolean)localformat);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob = null;
            ServerJobInfo job = (ServerJobInfo)serverinfo;
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                djob = (DeployedJob)o;
            }
            if (djob != null) {
                rc = djob.getDateModified(localformat);
            } else {
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)job.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    rc = DeployedJob.getDateModified((JFJob)jfjob, (boolean)localformat);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
            }
        }
        return rc;
    }

    @Override
    public String errorConditions(ServerInfoInterface serverinfo) throws SchedulerException {
        if (serverinfo instanceof ServerFlowInfo) {
            DeployedFlow dflow;
            ServerFlowInfo info = (ServerFlowInfo)serverinfo;
            if (info.m_object == null) {
                this.generateAllInformation(info);
            }
            if ((dflow = (DeployedFlow)info.m_object) != null) {
                try {
                    return dflow.errorConditions();
                }
                catch (RemoteException e) {
                    SchedulerException se = new SchedulerException(e.toString());
                    se.initCause((Throwable)e);
                    throw se;
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            DeployedJob djob;
            ServerJobInfo info = (ServerJobInfo)serverinfo;
            if (info.m_object == null) {
                this.generateAllInformation(info);
            }
            if ((djob = (DeployedJob)info.m_object) != null) {
                try {
                    djob.checkErrors();
                    return djob.errorConditions();
                }
                catch (RemoteException e) {
                    SchedulerException se = new SchedulerException(e.toString());
                    se.initCause((Throwable)e);
                    throw se;
                }
            }
        }
        return "";
    }

    @Override
    public void reevaluateErrors(ServerInfoInterface serverinfo) throws SchedulerException {
        if (serverinfo instanceof ServerFlowInfo) {
            ServerFlowInfo info = (ServerFlowInfo)serverinfo;
            DeployedFlow dflow = (DeployedFlow)info.m_object;
            if (dflow != null) {
                dflow.reevaluateErrors();
                if (!dflow.hasErrors()) {
                    FlowInfo finfo = info.getInfo();
                    finfo.clearErrors();
                }
            }
        } else if (serverinfo instanceof ServerJobInfo) {
            ServerJobInfo info = (ServerJobInfo)serverinfo;
            DeployedJob djob = (DeployedJob)info.m_object;
            if (djob != null) {
                djob.reevaluateErrors();
                if (!djob.hasErrors()) {
                    JobInfo jinfo = (JobInfo)info.getJobInfo();
                    jinfo.clearError();
                }
            }
        }
    }

    @Override
    public void checkAssociatedInfoForErrors(ServerFlowInfo sflow, ServerInfoInterface info) throws SchedulerException {
        DeployedFlow main = null;
        if (sflow.m_object instanceof DeployedFlow) {
            main = (DeployedFlow)sflow.m_object;
        }
        if (main != null) {
            if (info instanceof ServerFlowInfo) {
                DeployedFlow dflow;
                ServerFlowInfo flow = (ServerFlowInfo)info;
                if (flow.m_object == null) {
                    this.generateAllInformation(info);
                }
                if ((dflow = (DeployedFlow)flow.m_object) != null) {
                    main.checkAssociatedSubflowForErrors(dflow);
                }
            } else if (info instanceof ServerJobInfo) {
                DeployedJob djob;
                ServerJobInfo job = (ServerJobInfo)info;
                if (job.m_object == null) {
                    this.generateAllInformation(info);
                }
                if ((djob = (DeployedJob)job.m_object) != null) {
                    main.checkAssociatedJobForErrors(djob);
                }
            }
        }
    }

    @Override
    public boolean hasCriticalErrors(ServerFlowInfo flow) throws SchedulerException {
        DeployedFlow dflow;
        if (flow.m_object == null) {
            this.generateAllInformation(flow);
        }
        if ((dflow = (DeployedFlow)flow.m_object) != null) {
            return dflow.hasCriticalErrors();
        }
        return false;
    }

    @Override
    public boolean isJobAssociatedError(ServerJobInfo job) throws SchedulerException {
        DeployedJob djob;
        if (job.m_object == null) {
            this.generateAllInformation(job);
        }
        if ((djob = (DeployedJob)job.m_object) != null) {
            return (djob.getErrorFlag() & 1) != 0;
        }
        return false;
    }

    @Override
    public List<ServerFlowInfo> getFlows(FilterSelector filter, List<?> itemsList) {
        ArrayList<ServerFlowInfo> returnList = new ArrayList<ServerFlowInfo>();
        try {
            SortedSet<FlowInfo> jfjoblist = ServerUtilOMA.getFlowsFromRepository(filter, this.m_defaultMdStore, this.m_defaultMdRepositoryId, true);
            block3: for (FlowInfo flow : jfjoblist) {
                int numItems = itemsList.size();
                for (int x = 0; x < numItems; ++x) {
                    ServerFlowInfo info = (ServerFlowInfo)itemsList.get(x);
                    if (flow.getId().compareTo(info.getId()) != 0) continue;
                    returnList.add(info);
                    continue block3;
                }
            }
            return returnList;
        }
        catch (RemoteException e) {
            return returnList;
        }
        catch (MdException e) {
            return returnList;
        }
    }

    @Override
    public SortedSet<?> getFlowsFromRepository(int select, boolean displayOnly) {
        try {
            return MetaUtilities.getFlowsFromRepository((int)select, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId, (boolean)displayOnly);
        }
        catch (MdException e) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public SortedSet<FlowInfo> getFlowsFromRepository(FilterSelector filter, boolean displayOnly) throws SchedulerException {
        try {
            return ServerUtilOMA.getFlowsFromRepository(filter, this.m_defaultMdStore, this.m_defaultMdRepositoryId, displayOnly);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public List<FlowInfo> getSubmittedFlows(String message, String title, List<FlowInfo> notscheduled) throws SchedulerException {
        try {
            if (notscheduled != null) {
                return SubmitFlow.getSubmittedFlowInfos(notscheduled, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            }
            return SubmitFlow.getSubmittedFlowInfos((MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public List<FlowInfo> getFlowsByParty(String party) throws SchedulerException {
        ArrayList<FlowInfo> flows = new ArrayList<FlowInfo>();
        try {
            List dflows = MetaUtilities.getFlowsInRepository((MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            int num = dflows.size();
            for (int x = 0; x < num; ++x) {
                DeployedFlow dflow = (DeployedFlow)dflows.get(x);
                AssociationList parties = dflow.getMetadataObject().getResponsibleParties(true);
                int n = parties.size();
                for (int z = 0; z < n; ++z) {
                    ResponsibleParty p;
                    Object o = parties.get(z);
                    if (!(o instanceof ResponsibleParty) || !(p = (ResponsibleParty)o).getRole().equals("Reporting_Scheduler_Job_Owner")) continue;
                    AssociationList persons = p.getPersons();
                    int a = persons.size();
                    for (int b = 0; b < a; ++b) {
                        Person s;
                        Object c = persons.get(b);
                        if (!(c instanceof Person) || (s = (Person)c).getName().compareToIgnoreCase(party) != 0) continue;
                        flows.add(dflow.getInfo());
                    }
                }
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        return flows;
    }

    @Override
    public ServerFlowInfo getFlow(String id, ServerUtilities utilities) {
        ServerFlowInfo flow = null;
        try {
            FlowInfo info = MetaUtilities.getFlowFromRepository((String)id, (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId, (boolean)false);
            if (info != null) {
                flow = new ServerFlowInfo(info, utilities, null);
            } else if (MetaUtilities.isDebug()) {
                System.err.println("Null FLOWINFO returned from SAS Metadata.");
            }
            return flow;
        }
        catch (RemoteException e) {
            return flow;
        }
        catch (MdException e) {
            return flow;
        }
    }

    @Override
    public FlowInfo createFlow(FlowInfo info) throws SchedulerException {
        MdObjectStore store = null;
        try {
            String repos;
            block17: {
                store = this.m_defaultMdFactory.createObjectStore(null, "createFlow");
                repos = this.m_defaultMdRepository;
                try {
                    Tree folder = MetaUtilities.getFolder((String)info.getLocation(), (MdObjectStore)store, (String)this.m_defaultMdRepository);
                    if (folder != null) {
                        repos = folder.getId().substring(0, 8);
                    }
                }
                catch (NotFound nf) {
                    if (MetaUtilities.isDebug()) {
                        nf.printStackTrace();
                    }
                }
                catch (NoContext nc) {
                    if (!MetaUtilities.isDebug()) break block17;
                    nc.printStackTrace();
                }
            }
            DeployedFlow flow = new DeployedFlow(info, store, repos);
            if (!flow.commitChanges()) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
            }
            FlowInfo flowInfo = flow.getInfo();
            return flowInfo;
        }
        catch (RemoteException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (MdException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        finally {
            block18: {
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (Exception e) {
                        if (!MetaUtilities.isDebug()) break block18;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean updateScheduler(SchedulerServerInfo ssi) throws SchedulerException {
        try {
            TCPIPConnection connection;
            boolean update = false;
            ServerComponent server = MetaUtilities.getSchedulerServer((String)ssi.getId(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            if (server == null) {
                throw new RuntimeException("MetaUtilities.updateSASJFScheduler()");
            }
            String name = ssi.getName();
            if (name != null && name.trim().length() > 0) {
                server.setName(name);
                update = true;
            }
            String host = ssi.getHost();
            AssociationList connections = server.getSourceConnections();
            if (connections != null && connections.size() > 0 && (connection = (TCPIPConnection)connections.get(0)) != null) {
                int neoport;
                String old_host = connection.getHostName();
                if (old_host.compareTo(host) != 0) {
                    System.out.println("Info: fixing the host for TCPIP connection");
                    connection.setHostName(host);
                    update = true;
                    String cname = connection.getName();
                    if (cname.contains(old_host)) {
                        System.out.println("Info: fixing the name for TCPIP connection");
                        String newName = MetaUtilities.replaceString((String)cname, (String)old_host, (String)host);
                        connection.setName(newName);
                    }
                    name = server.getName();
                    String short_old_host = old_host;
                    if (old_host.indexOf(46) > 0) {
                        short_old_host = old_host.substring(0, old_host.indexOf(46));
                    }
                    String short_host = host;
                    if (host.indexOf(46) > 0) {
                        short_host = host.substring(0, host.indexOf(46));
                    }
                    if (name.contains(old_host)) {
                        System.out.println("Info: fixing the name for ServerComponent");
                        String newName = MetaUtilities.replaceString((String)name, (String)old_host, (String)short_host);
                        server.setName(newName);
                    } else if (name.contains(short_old_host)) {
                        System.out.println("Info: fixing the name for ServerComponent");
                        String newName = MetaUtilities.replaceString((String)name, (String)short_old_host, (String)short_host);
                        server.setName(newName);
                    }
                }
                String port = ssi.getPort();
                int old_port = connection.getPort();
                if (old_port != (neoport = Integer.valueOf(port).intValue())) {
                    System.out.println("Info: fixing the port for TCPIP connection");
                    connection.setPort(neoport);
                    update = true;
                }
            }
            if (update) {
                server.updateMetadataAll();
            }
            return update;
        }
        catch (MdException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
    }

    @Override
    public boolean updateDeployedFlow(ServerFlowInfo finfo) throws SchedulerException {
        try {
            String oldname;
            FlowInfo info = finfo.getInfo();
            DeployedFlow flow = null;
            JFJob jfjob = MetaUtilities.getJFJob((String)finfo.getId(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            String string = oldname = jfjob != null ? jfjob.getName() : "";
            if (oldname.compareTo(finfo.getName()) != 0) {
                if (!this.isUniqueFlow(finfo.getName(), finfo.getId())) {
                    String message = m_bundle.getString("ServerUtilities.ErrorMsg.FlowAlreadyExists.txt");
                    IllegalArgumentException e = new IllegalArgumentException(message);
                    SchedulerException ex = new SchedulerException(message);
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                if (finfo.isFlowSubmitted()) {
                    flow = finfo.getDeployedFlow();
                    Scheduler scheduler = flow.getSchedulingServer();
                    try {
                        String runnowname;
                        boolean notRemoved = true;
                        FlowInfo temp = new FlowInfo(oldname, info.getTriggerEvent(), info.getScheduler());
                        String flowname = scheduler.genFlowName(temp);
                        if (scheduler.isConnected()) {
                            try {
                                if (scheduler.removeFlow(flowname)) {
                                    notRemoved = false;
                                }
                            }
                            catch (UnsupportedOperationException ex) {
                                ex.printStackTrace();
                                notRemoved = false;
                            }
                            catch (SchedulerException se) {
                                se.printStackTrace();
                            }
                        }
                        if (flowname.compareTo(runnowname = scheduler.runNowName(flowname)) != 0) {
                            try {
                                scheduler.removeFlow(runnowname);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                            }
                            catch (SchedulerException se) {
                                se.printStackTrace();
                            }
                        }
                        info.setFlowSubmitted(false);
                        flow.setFlowSubmitted(false);
                        jfjob.setName(info.getName());
                        finfo.setName(info.getName());
                        if (notRemoved) {
                            flow.commitChanges();
                            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToRemoveFromScheduler.txt"));
                        }
                    }
                    catch (UnsupportedOperationException ex) {
                        throw new SchedulerException(ex.getMessage());
                    }
                    flow.resetFromInfo(info, null, scheduler);
                } else {
                    flow = new DeployedFlow(info, this.m_defaultMdStore, this.m_defaultMdRepository);
                    flow.getMetadataObject().setName(info.getName());
                    finfo.setName(info.getName());
                }
            } else {
                flow = new DeployedFlow(info, this.m_defaultMdStore, this.m_defaultMdRepository);
            }
            return flow.commitChanges();
        }
        catch (MdException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
    }

    @Override
    public boolean setSchedulerAfterConnection(ServerFlowInfo info, Scheduler scheduler) {
        block5: {
            DeployedFlow dflow = info.getDeployedFlow();
            if (dflow != null) {
                try {
                    return dflow.setScheduleServer(scheduler);
                }
                catch (MdException ex) {
                    if (MetaUtilities.isDebug()) {
                        ex.printStackTrace();
                    }
                }
                catch (RemoteException ex) {
                    if (!MetaUtilities.isDebug()) break block5;
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public boolean commitFlowToStore(FlowInfo info) throws SchedulerException {
        try {
            String repos;
            block10: {
                repos = this.m_defaultMdRepository;
                try {
                    Tree folder = MetaUtilities.getFolder((String)info.getLocation(), (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepository);
                    if (folder != null) {
                        repos = folder.getId().substring(0, 8);
                    }
                }
                catch (NotFound nf) {
                    if (MetaUtilities.isDebug()) {
                        nf.printStackTrace();
                    }
                }
                catch (NoContext nc) {
                    if (!MetaUtilities.isDebug()) break block10;
                    nc.printStackTrace();
                }
            }
            if (MetaUtilities.isDebug()) {
                System.out.println("Saving flow to repository: " + repos);
            }
            MdObjectStore temp_store = this.m_defaultMdFactory.createObjectStore(null, "ResetFromInfo");
            DeployedFlow flow = new DeployedFlow(info, temp_store, repos);
            boolean rc = flow.commitChanges();
            if (temp_store != null) {
                temp_store.dispose();
            }
            return rc;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public SchedulerResultSet submitFlow(ServerFlowInfo flow, boolean modified, boolean errorOnDelete) throws SchedulerException {
        SchedulerResultSet rc;
        block5: {
            DeployedFlow dflow;
            FlowInfo info = flow.getInfo();
            Scheduler scheduler = this.getSchedulingServer(info.getScheduler());
            rc = SubmitFlow.ScheduleFlow((FlowInfo)info, (Scheduler)scheduler, (boolean)modified, (boolean)errorOnDelete);
            DeployedFlow deployedFlow = dflow = flow.isDataGathered() ? flow.getDeployedFlow() : null;
            if (dflow != null) {
                dflow.updateInfoAfterScheduled(info);
            } else {
                flow.commitChangesToOMR();
            }
            try {
                if (scheduler instanceof DIPServiceProxy || scheduler instanceof SASJFSServiceProxy) {
                    flow.refresh();
                }
            }
            catch (RemoteException e) {
                if (!MetaUtilities.isDebug()) break block5;
                e.printStackTrace();
            }
        }
        return rc;
    }

    @Override
    public boolean deleteFlowFromMetadata(ServerFlowInfo flow) {
        DeployedFlow dflow = flow.getDeployedFlow();
        try {
            return dflow.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean fixUnableToDelete(ServerFlowInfo flow) {
        Root obj = flow.getMetadataObject(null);
        if (obj instanceof JFJob) {
            JFJob jfjob = (JFJob)obj;
            try {
                if (jfjob.getTransformRole().equals("SCHEDULER_FLOW_DELETE")) {
                    jfjob.setTransformRole("SCHEDULER_FLOW");
                    jfjob.updateMetadataAll();
                }
            }
            catch (RemoteException e) {
                return false;
            }
            catch (MdException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUniqueFlow(String name, String id) {
        List list = null;
        MdObjectStore tempStore = null;
        try {
            tempStore = this.m_defaultMdFactory.createObjectStore();
            list = MetaUtilities.getJFJobList((String)name, (boolean)true, (MdStore)tempStore, (String)this.m_defaultMdRepositoryId);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((JFJob)list.get(i)).getFQID().compareToIgnoreCase(id) == 0) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (RemoteException ex) {
            boolean bl = true;
            return bl;
        }
        catch (MdException ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RemoteException remoteException) {}
                tempStore = null;
            }
            if (list != null) {
                list.clear();
                list = null;
            }
        }
        return true;
    }

    @Override
    public boolean checkWritePermission(SASFolder sasfolder) {
        try {
            Tree folder = MetaUtilities.getFolder((SASFolder)sasfolder, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            MdFactory factory = folder.getObjectStore().getFactory();
            MdSecurityUtil security = factory.getSecurityUtil();
            return security.isFolderWriteAuthorized(folder.getId());
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (NotFound e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (NoContext e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean checkWritePermission(Directory dir) {
        try {
            MdFactory factory = dir.getObjectStore().getFactory();
            MdSecurityUtil security = factory.getSecurityUtil();
            return security.isWriteAuthorized("Directory", dir.getId());
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean checkWritePermission(ServerContext appServer) {
        try {
            MdFactory factory = appServer.getObjectStore().getFactory();
            MdSecurityUtil security = factory.getSecurityUtil();
            return security.isWriteAuthorized("ServerContext", appServer.getId());
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean removeFromFlow(ServerInfoInterface info, ServerFlowInfo flow) {
        DeployedFlow main = null;
        if (flow.m_object instanceof DeployedFlow) {
            main = (DeployedFlow)flow.m_object;
        }
        if (main != null) {
            DeployedFlow dflow;
            if (info instanceof ServerJobInfo) {
                DeployedJob djob = (DeployedJob)((ServerJobInfo)info).m_object;
                if (djob != null) {
                    return main.removeJob(djob);
                }
            } else if (info instanceof ServerFlowInfo && (dflow = (DeployedFlow)((ServerFlowInfo)info).m_object) != null) {
                return main.removeJob(dflow);
            }
        } else {
            FlowInfo finfo = flow.getInfo();
            if (info instanceof ServerJobInfo) {
                finfo.removeJob(((ServerJobInfo)info).getJobInfo());
            } else if (info instanceof ServerFlowInfo) {
                finfo.removeJob((DisplayInfo)((ServerFlowInfo)info).getInfo());
            }
            try {
                return this.commitFlowToStore(finfo);
            }
            catch (SchedulerException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean removeFromAllFlows(ServerInfoInterface info) throws SchedulerException {
        DeployedFlow dflow;
        if (info instanceof ServerJobInfo) {
            DeployedJob djob = (DeployedJob)((ServerJobInfo)info).m_object;
            if (djob != null) {
                try {
                    djob.removeAll();
                }
                catch (RemoteException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
                catch (MdException ex) {
                    SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                    se.initCause((Throwable)ex);
                    throw se;
                }
            }
        } else if (info instanceof ServerFlowInfo && (dflow = (DeployedFlow)((ServerFlowInfo)info).m_object) != null) {
            try {
                dflow.removeThisSubFlowFromAllFlows();
            }
            catch (RemoteException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (MdException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
        }
        return false;
    }

    @Override
    public boolean updateTriggers(ServerFlowInfo flow) throws SchedulerException {
        if (flow.m_object instanceof DeployedFlow) {
            return ((DeployedFlow)flow.m_object).checkInfoAfterSelectingTriggers(flow.m_info);
        }
        return false;
    }

    @Override
    public void checkCircularDependencies(FlowInfo flow, String id) throws SchedulerException {
        try {
            MdObjectStore tempstore = this.m_defaultMdFactory.createObjectStore(null, "checkCircularLogic");
            String path = DeployedFlow.hasCircularLogic((String)flow.getId(), (String)id, (MdObjectStore)tempstore, (String)this.m_defaultMdRepositoryId);
            tempstore.dispose();
            if (path != null) {
                throw new InvalidParameterException(path);
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public List<JobInfo> getDeployedJobs(List<?> filter) throws SchedulerException {
        return this.getDeployedJobs(filter, false);
    }

    @Override
    public List<JobInfo> getDeployedJobs(List<?> filter, boolean displayOnly) throws SchedulerException {
        ArrayList<JobInfo> joblist = new ArrayList<JobInfo>();
        try {
            List list = MetaUtilities.getDeployedJobs((MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId, (boolean)displayOnly);
            int listsize = list.size();
            for (int i = 0; i < listsize; ++i) {
                JobInfo job = (JobInfo)list.get(i);
                if (filter != null) {
                    if (filter.contains(job.getName())) continue;
                    joblist.add(job);
                    continue;
                }
                joblist.add(job);
            }
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
        catch (MdException e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
        return joblist;
    }

    @Override
    public List<DisplayInfo> getJobsForFlow(FilterSelector filter, ServerFlowInfo flow, ServerUtilities utilities) {
        String flowid = flow.getId();
        ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>();
        try {
            SortedSet<DisplayInfo> jfjoblist = ServerUtilOMA.getJobsFromRepository(filter, flowid, (MdStore)this.m_defaultMdStore, this.m_defaultMdRepositoryId, true);
            for (Object e : jfjoblist) {
                if (e instanceof JobInfo) {
                    JobInfo job = (JobInfo)e;
                    list.add(new ServerJobInfo((DisplayInfo)job, flow, utilities));
                    continue;
                }
                if (!(e instanceof FlowInfo)) continue;
                FlowInfo subflow = (FlowInfo)e;
                list.add(new ServerFlowInfo(subflow, utilities, this.m_prompt));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<JobInfo> getAvailableJobsSubflowsByLocation(String folder, List<DisplayInfo> inFlow) {
        ArrayList<String> exclude = new ArrayList<String>();
        for (int x = 0; x < inFlow.size(); ++x) {
            exclude.add(inFlow.get(x).getName());
        }
        List avail = null;
        try {
            avail = MetaUtilities.getAvailJobListByFolder((String)folder, exclude, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return avail;
    }

    @Override
    public void setJobListInFlow(FlowInfo info) {
        block6: {
            try {
                DeployedFlow.setJobsInInfo((FlowInfo)info, (MdObjectStore)this.m_defaultMdStore);
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (!MetaUtilities.isDebug()) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    public ServerJobInfo getJob(String id, ServerUtilities utilities) {
        ServerJobInfo job = null;
        try {
            JobInfo info = MetaUtilities.getJobInfo((String)id, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            job = new ServerJobInfo((DisplayInfo)info, null, utilities);
            return job;
        }
        catch (RemoteException e) {
            return job;
        }
        catch (MdException e) {
            return job;
        }
        catch (SchedulerException e) {
            return job;
        }
    }

    @Override
    public boolean doesJobExist(String name, SASFolder sasfolder) throws SchedulerException {
        try {
            Tree folder = MetaUtilities.getFolder((SASFolder)sasfolder, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            return MetaUtilities.doesJobExist((String)name, (Tree)folder, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
        catch (MdException e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
        catch (NotFound e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
        catch (NoContext e) {
            throw new SchedulerException(e.getLocalizedMessage());
        }
    }

    @Override
    public SchedulerResultSet deployBatchJobs(DeployedJobInterface data, ServerUtilities serverUtil, UserContextInterface user, DeployedJobCodeGenerationInterface codegen) {
        int total;
        DirectoryInfo dirInfo;
        List jobs;
        DisplayInfo job;
        int failed;
        int success;
        StringBuffer failedMessage;
        StringBuffer okMessage;
        block109: {
            boolean overwriteall = false;
            boolean skipall = false;
            DeployedJob djob = null;
            okMessage = new StringBuffer();
            failedMessage = new StringBuffer();
            success = 0;
            failed = 0;
            String file = null;
            String[] files = data.getSourceFileNames();
            String name = null;
            String[] names = data.getDeployedJobNames();
            job = null;
            jobs = data.getAssociatedJobs();
            String jcl = data.getJCL();
            String jclExt = null;
            dirInfo = data.getSelectedDirectory();
            Directory dir = null;
            String fileContent = data.getFileContent();
            String spacer = "   ";
            total = names.length;
            if (total == 1) {
                spacer = "";
            }
            Map<String, BatchServerInfo> _workspaceCache = Collections.synchronizedMap(new HashMap());
            BatchServerInfo bsinfo = data.getBatchServer();
            if (BatchServerInfo.requiresSourceFile((BatchServerInfo)bsinfo) && files.length != 0 && files.length != total) {
                return new SchedulerResultSet(0, MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnmatchedFilesToJobs.fmt"), (Object)String.valueOf(total)));
            }
            block47: for (int z = 0; z < total; ++z) {
                try {
                    String message;
                    String repos;
                    SASFolder folder;
                    block104: {
                        name = names[z];
                        if (!DeployedJob.isValidName((String)name)) {
                            int response;
                            String newname = MetaUtilities.makeValidJobName((String)name);
                            int n = response = this.m_prompt == null ? -1 : this.m_prompt.warningMessageOKCancel(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Warning.InvalidJobName.fmt"), (Object)name, (Object)newname), data.getTitle());
                            if (response == 2) {
                                name = newname;
                            } else if (codegen == null) {
                                String message2 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.InvalidJobName.txt");
                                ++failed;
                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message2));
                                failedMessage.append("\n");
                                continue;
                            }
                        }
                        if (!this.checkWritePermission(folder = data.getSASFolder())) {
                            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToFolder.txt"));
                        }
                        if (this.doesJobExist(name, folder)) {
                            String message3 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.DeployedJobExists.fmt"), (Object)name, (Object)folder.getName());
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message3));
                            failedMessage.append("\n");
                            continue;
                        }
                        repos = this.getDefaultMdRepository();
                        try {
                            Tree tree = MetaUtilities.getFolder((SASFolder)folder, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                            if (tree != null) {
                                repos = tree.getId().substring(0, 8);
                            }
                        }
                        catch (NotFound nf) {
                            if (MetaUtilities.isDebug()) {
                                nf.printStackTrace();
                            }
                        }
                        catch (NoContext nc) {
                            if (!MetaUtilities.isDebug()) break block104;
                            nc.printStackTrace();
                        }
                    }
                    int numofjobs = jobs.size();
                    job = numofjobs - 1 < z ? null : (DisplayInfo)jobs.get(z);
                    file = files == null || files.length == 0 || files.length - 1 < z ? null : files[z];
                    if (file != null) {
                        ServerComponent sc;
                        IWorkspace iworkspace;
                        String fullname;
                        String srcpath;
                        String srcname;
                        String targetname;
                        String basename;
                        block106: {
                            String message4;
                            IFileService rio;
                            block105: {
                                basename = null;
                                targetname = null;
                                srcname = null;
                                srcpath = null;
                                fullname = null;
                                iworkspace = null;
                                rio = null;
                                try {
                                    iworkspace = ServerUtilities.getWorkspaceServerFromCache(bsinfo);
                                    if (iworkspace == null && (iworkspace = this.checkConnectionToWorkspaceServer(bsinfo, this.m_prompt)) != null) {
                                        _workspaceCache.put(iworkspace.UniqueIdentifier(), bsinfo);
                                    }
                                    if (iworkspace == null) {
                                        List<String> values = this.setFilePaths(name, file, bsinfo, dirInfo);
                                        dir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (DirectoryInfo)dirInfo, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                        boolean x = Boolean.parseBoolean(values.get(0));
                                        String path = values.get(4);
                                        if (x || path == null || dir == null || path.compareTo(CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)bsinfo.getOperatingSystem())) != 0) {
                                            String message5 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.txt");
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message5));
                                            failedMessage.append("\n");
                                            continue;
                                        }
                                    } else {
                                        rio = iworkspace.FileService();
                                    }
                                }
                                catch (CallbackCancelledException e) {
                                    String message6 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.UserAbort.txt");
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message6));
                                    failedMessage.append("\n");
                                    continue;
                                }
                                catch (Exception ex) {
                                    String message7 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.txt");
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message7));
                                    failedMessage.append("\n");
                                    continue;
                                }
                                sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)bsinfo, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                dir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (DirectoryInfo)dirInfo, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                if (dir == null) {
                                    String message8 = null;
                                    message8 = data.getNumberOfDirectories() == 0 ? m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.NoDeploymentDirs.txt") : m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.MissingDeploymentDir.txt");
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message8));
                                    failedMessage.append("\n");
                                    continue;
                                }
                                if (!this.checkWritePermission(dir)) {
                                    String message9 = null;
                                    try {
                                        ServerContext appServer = (ServerContext)dir.getDeployedComponents().get(0);
                                        message9 = !this.checkWritePermission(appServer) ? m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToAppServer.txt") : m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToDir.txt");
                                    }
                                    catch (Exception e) {
                                        message9 = m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToDir.txt");
                                    }
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message9));
                                    failedMessage.append("\n");
                                    continue;
                                }
                                boolean copyfile = false;
                                try {
                                    List<String> values = this.setFilePaths(name, file, bsinfo, dirInfo);
                                    boolean x = Boolean.parseBoolean(values.get(0));
                                    basename = values.get(1);
                                    targetname = values.get(2);
                                    srcname = values.get(3);
                                    srcpath = values.get(4);
                                    fullname = values.get(5);
                                    if (codegen == null) {
                                        if (x) {
                                            copyfile = true;
                                        } else if (srcpath == null || srcpath.compareTo(CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)bsinfo.getOperatingSystem())) != 0) {
                                            copyfile = true;
                                        }
                                    }
                                    if (fileContent != null) {
                                        CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)file, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)fileContent);
                                    }
                                    if (!copyfile && codegen == null || overwriteall) break block105;
                                    try {
                                        int response1;
                                        Object[] options;
                                        String prompt;
                                        CommandUtilities.readFromRemoteFile((IFileService)rio, (String)fullname, (int)bsinfo.getOperatingSystem());
                                        String skipmessage = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UserAbortDeployedJobExists.fmt"), (Object)fullname));
                                        if (skipall) {
                                            ++failed;
                                            failedMessage.append(skipmessage);
                                            failedMessage.append("\n");
                                            continue;
                                        }
                                        if (total - z < 2) {
                                            prompt = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Single.Message.fmt"), (Object)fullname);
                                            options = new Object[]{m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.Overwrite.txt"), m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.Skip.txt")};
                                            response1 = this.m_prompt == null ? 1 : this.m_prompt.promptMessage(prompt, m_bundle.getString("ServerDeployedJobUtilities.FileExists.Title.txt"), options);
                                            switch (response1) {
                                                case 0: {
                                                    break;
                                                }
                                                case 1: {
                                                    ++failed;
                                                    failedMessage.append(skipmessage);
                                                    failedMessage.append("\n");
                                                    continue block47;
                                                }
                                            }
                                        } else {
                                            prompt = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Message.fmt"), (Object)fullname);
                                            options = new Object[]{m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.Overwrite.txt"), m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.OverwriteAll.txt"), m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.Skip.txt"), m_bundle.getString("ServerDeployedJobUtilities.TargetFileExists.Option.SkipAll.txt")};
                                            response1 = this.m_prompt == null ? 3 : this.m_prompt.promptMessage(prompt, m_bundle.getString("ServerDeployedJobUtilities.FileExists.Title.txt"), options);
                                            switch (response1) {
                                                case 1: {
                                                    overwriteall = true;
                                                }
                                                case 0: {
                                                    break;
                                                }
                                                case 3: {
                                                    skipall = true;
                                                }
                                                case 2: {
                                                    ++failed;
                                                    failedMessage.append(skipmessage);
                                                    failedMessage.append("\n");
                                                    continue block47;
                                                }
                                            }
                                        }
                                    }
                                    catch (GenericError skipmessage) {
                                        // empty catch block
                                    }
                                    String filename = srcname;
                                    if (srcpath != null) {
                                        filename = CommandUtilities.createFullPath((String)srcpath, (String)srcname, (int)bsinfo.getOperatingSystem());
                                    }
                                    StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)filename, (int)bsinfo.getOperatingSystem());
                                    try {
                                        if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)fullname, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)contents.toString())) {
                                            message4 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)fullname);
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message4));
                                            failedMessage.append("\n");
                                            continue;
                                        }
                                        break block105;
                                    }
                                    catch (SchedulerException se) {
                                        String message10 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)se.getLocalizedMessage());
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message10));
                                        failedMessage.append("\n");
                                    }
                                    catch (GenericError ge) {
                                        String message11 = null;
                                        message11 = bsinfo.getOperatingSystem() == 2 && fullname.indexOf("/") < 0 ? MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingJCLFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)ge.getLocalizedMessage()) : MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)ge.getLocalizedMessage());
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message11));
                                        failedMessage.append("\n");
                                    }
                                }
                                catch (GenericError ex) {
                                    String message12 = ex.getLocalizedMessage();
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message12));
                                    failedMessage.append("\n");
                                }
                                catch (RuntimeException ex) {
                                    String message13;
                                    if (MetaUtilities.isDebug()) {
                                        ex.printStackTrace();
                                    }
                                    if ((message13 = ex.getLocalizedMessage()) == null || message13.length() == 0) {
                                        message13 = ex.toString();
                                    }
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message13));
                                    failedMessage.append("\n");
                                }
                                continue;
                            }
                            if (jcl != null) {
                                jclExt = "jcl";
                                try {
                                    String jclName = basename + "." + jclExt;
                                    String strFullName = null;
                                    try {
                                        String dirString = "./";
                                        if (dir != null) {
                                            dirString = dir.getDirectoryName();
                                        }
                                        strFullName = CommandUtilities.createFullPath((String)dirString, (String)jclName, (int)bsinfo.getOperatingSystem());
                                        String runas = djob != null ? djob.getRunAs() : null;
                                        jcl = DataStepProgramDeployer.GenerateJCLFromTemplate((String)fullname, (String)runas, (String)jcl);
                                        if (!CommandUtilities.saveToRemoteFile((IFileService)rio, (String)strFullName, (int)bsinfo.getOperatingSystem(), (String)jcl)) {
                                            message4 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)strFullName);
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message4));
                                            failedMessage.append("\n");
                                            continue;
                                        }
                                        break block106;
                                    }
                                    catch (GenericError ge) {
                                        String message14 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), strFullName, (Object)ge.getLocalizedMessage());
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message14));
                                        failedMessage.append("\n");
                                    }
                                }
                                catch (MdException e) {
                                    String message15 = e.getLocalizedMessage();
                                    if (message15 == null) {
                                        message15 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                                    }
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message15));
                                    failedMessage.append("\n");
                                }
                                catch (RemoteException e) {
                                    String message16 = e.getLocalizedMessage();
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message16));
                                    failedMessage.append("\n");
                                }
                                catch (RuntimeException e) {
                                    String message17;
                                    if (MetaUtilities.isDebug()) {
                                        e.printStackTrace();
                                    }
                                    if ((message17 = e.getLocalizedMessage()) == null || message17.length() == 0) {
                                        message17 = e.toString();
                                    }
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message17));
                                    failedMessage.append("\n");
                                }
                                continue;
                            }
                        }
                        if (codegen != null) {
                            block108: {
                                block107: {
                                    try {
                                        if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)fullname, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)"VERIFYING WRITE TO FILE")) {
                                            String message18 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)fullname);
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message18));
                                            failedMessage.append("\n");
                                        }
                                        break block107;
                                    }
                                    catch (GenericError ge) {
                                        String message19 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)ge.getLocalizedMessage());
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message19));
                                        failedMessage.append("\n");
                                    }
                                    continue;
                                }
                                try {
                                    DeployedJob.deletePhysicalFile((IWorkspace)iworkspace, (String)fullname);
                                }
                                catch (SchedulerException ex) {
                                    ex.printStackTrace();
                                }
                                codegen.setAppServer(this.getSASAppServerFromBatchServer(bsinfo));
                                codegen.setJob(job);
                                String codegenResults = codegen.generateSource();
                                try {
                                    if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)fullname, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)codegenResults)) {
                                        String message20 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)fullname);
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message20));
                                        failedMessage.append("\n");
                                    }
                                    break block108;
                                }
                                catch (GenericError ge) {
                                    String message21 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.Codegen.fmt"), (Object)fullname, (Object)ge.getLocalizedMessage());
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message21));
                                    failedMessage.append("\n");
                                }
                                continue;
                            }
                            File fileObj = MetaUtilities.createSourceCodeObject((String)basename, (Directory)dir, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                            fileObj.setFileName(targetname);
                            Job jobObject = MetaUtilities.getAssociatedJob((String)job.getId(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                            djob = DataStepProgramDeployer.BuildMetaObjects((Job)jobObject, (File)fileObj, (String)basename, (String)jclExt, (Directory)dir, (ServerComponent)sc, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)this.getDefaultMdStore(), (String)repos);
                            djob.getDeployedJobObject().setName(name);
                        } else {
                            djob = DataStepProgramDeployer.BuildMetaObjects((String)name, (String)targetname, (String)basename, (String)jclExt, (Directory)dir, (ServerComponent)sc, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)this.getDefaultMdStore(), (String)repos);
                            Job jobObject = djob.getJobObject();
                            if (jobObject != null && srcname != null) {
                                Directory srcdir = null;
                                if (srcpath != null && (srcdir = MetaUtilities.getDirectoryFromPath((String)srcpath, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository())) == null) {
                                    String dirname = srcpath.substring(srcpath.lastIndexOf("/") + 1);
                                    srcdir = MetaUtilities.createDirectoryObject((String)dirname, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                    srcdir.setDirectoryName(srcpath);
                                }
                                File fileObj = MetaUtilities.createSourceCodeObject((String)srcname, (Directory)srcdir, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                if (srcname.indexOf(".") >= 0) {
                                    fileObj.setFileName(srcname.substring(0, srcname.lastIndexOf(46)));
                                    fileObj.setFileExtension(srcname.substring(srcname.lastIndexOf(46) + 1));
                                } else {
                                    fileObj.setFileName(srcname);
                                }
                                fileObj.getDirectories().add((Object)srcdir);
                                MetaUtilities.setSourceForUserWrittenJob((Job)jobObject, (File)fileObj, (ServerComponent)CommandUtilities.getWorkspaceServerComponentFromBatchServer((ServerComponent)sc), (String)"SCHEDULER_JOB", (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                            }
                        }
                    } else {
                        Job jobObject = MetaUtilities.getAssociatedJob((String)job.getId(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                        ServerComponent sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)data.getBatchServer(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                        djob = DataStepProgramDeployer.BuildMetaObjects((String)name, (Job)jobObject, (ServerComponent)sc, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)this.getDefaultMdStore(), (String)repos);
                    }
                    if (djob == null) {
                        String message22 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message22));
                        failedMessage.append("\n");
                        continue;
                    }
                    Tree tree = MetaUtilities.getFolder((SASFolder)folder, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    if (folder != null) {
                        if (djob != null) {
                            Job temp;
                            djob.setFolder(tree);
                            if (job == null && (temp = djob.getJobObject()) != null) {
                                AssociationList trees = temp.getTrees();
                                trees.clear();
                                trees.add(tree);
                            }
                            if (!djob.commitChangesWithNoValidation()) {
                                message = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                                ++failed;
                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message));
                                failedMessage.append("\n");
                                continue;
                            }
                        }
                    } else {
                        message = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)message));
                        failedMessage.append("\n");
                        continue;
                    }
                    message = null;
                    String jobName = "";
                    String djobName = "";
                    String location = "";
                    if (djob != null) {
                        djobName = djob.getName();
                        Job temp = djob.getJobObject();
                        if (temp != null) {
                            jobName = temp.getName();
                        }
                    }
                    location = dir != null ? dir.getDirectoryName() : folder.toString();
                    message = total == 1 ? MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Single.DeploySucc.fmt"), (Object)jobName, (Object)djobName, (Object)location) : MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Multiple.DeploySucc.fmt"), (Object)spacer, (Object)jobName, (Object)djobName);
                    ++success;
                    okMessage.append(message);
                    okMessage.append("\n");
                    serverUtil.addToListForAllJobsAndFlows(djob.getInfo());
                    continue;
                }
                catch (MdException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (RemoteException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (SchedulerException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (NotFound e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (NoContext e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (RuntimeException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.DeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.toString()));
                    failedMessage.append("\n");
                }
            }
            try {
                Set keys = _workspaceCache.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    BatchServerInfo binfo = (BatchServerInfo)_workspaceCache.get(i.next());
                    ServerUtilities.disconnectFromWorkspaceServer(binfo);
                }
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block109;
                e.printStackTrace();
            }
        }
        StringBuffer summary = new StringBuffer();
        if (failed > 0) {
            summary.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Deployed.Failed.Header.fmt"), (Object)String.valueOf(failed), (Object)String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        if (success > 0) {
            summary.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Deployed.Success.Header.fmt"), (Object)String.valueOf(success), (Object)String.valueOf(total), (Object)(dirInfo != null ? dirInfo.getPath() : "")));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        SchedulerResultSet resultset = null;
        resultset = total == 1 ? (success == 1 ? new SchedulerResultSet(1, okMessage.toString(), job) : (failed == 1 ? new SchedulerResultSet(0, failedMessage.toString(), job) : new SchedulerResultSet(1, summary.toString(), job))) : (failed > 0 ? new SchedulerResultSet(0, summary.toString(), total, jobs) : new SchedulerResultSet(1, summary.toString(), total, jobs));
        return resultset;
    }

    @Override
    public SchedulerResultSet redeployBatchJobs(DeployedJobInterface data, UserContextInterface user, DeployedJobCodeGenerationInterface codegen) {
        int total;
        List jobs;
        JobInfo job;
        int failed;
        int success;
        StringBuffer failedMessage;
        StringBuffer okMessage;
        Directory dir;
        block116: {
            dir = null;
            okMessage = new StringBuffer();
            failedMessage = new StringBuffer();
            success = 0;
            failed = 0;
            String file = null;
            String[] files = data.getSourceFileNames();
            String name = null;
            String[] names = data.getDeployedJobNames();
            job = null;
            jobs = data.getDeployedJobs();
            String jcl = data.getJCL();
            String fileContent = data.getFileContent();
            String spacer = "   ";
            total = names.length;
            if (total == 1) {
                spacer = "";
            }
            Map<String, BatchServerInfo> _workspaceCache = Collections.synchronizedMap(new HashMap());
            BatchServerInfo bsinfo = data.getBatchServer();
            if (BatchServerInfo.requiresSourceFile((BatchServerInfo)bsinfo) && files != null && files.length != 0 && files.length != total) {
                return new SchedulerResultSet(0, MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnmatchedFilesToJobs.fmt"), (Object)String.valueOf(total), (Object)String.valueOf(names.length)));
            }
            boolean preserveServer = bsinfo.getName().compareTo(DeployJobPanel.BATCHSERVER_PRESERVE_PREVIOUS_VALUE) == 0;
            for (int z = 0; z < total; ++z) {
                boolean thisOkay = false;
                try {
                    String message;
                    String resource;
                    String message2;
                    name = names[z];
                    if (!DeployedJob.isValidName((String)name)) {
                        int response;
                        String newname = MetaUtilities.makeValidJobName((String)name);
                        int n = response = this.m_prompt == null ? -1 : this.m_prompt.warningMessageOKCancel(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Warning.InvalidJobName.fmt"), (Object)name, (Object)newname), data.getTitle());
                        if (response == 2) {
                            name = newname;
                        }
                    }
                    if (jobs.size() - 1 < z) {
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, null));
                        failedMessage.append("\n");
                        continue;
                    }
                    job = (JobInfo)jobs.get(z);
                    DeployedJob djob = new DeployedJob(job, this.getDefaultMdStore(), this.getDefaultMdRepository());
                    Job jobObject = djob.getJobObject();
                    ServerComponent sc = djob.getBatchServer();
                    if (preserveServer) {
                        String id;
                        String string = id = bsinfo.getId() != null ? bsinfo.getId() : "";
                        if (sc.getId().compareTo(id) != 0) {
                            bsinfo = MetaUtilities.getBatchServer((ServerComponent)sc);
                        }
                    } else {
                        sc = MetaUtilities.getBatchServerComponent((BatchServerInfo)bsinfo, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                    }
                    file = files == null || files.length == 0 || files.length - 1 < z ? null : files[z];
                    if (file != null) {
                        File destfile;
                        File jclFile;
                        JFJob jfjob;
                        String message3;
                        block114: {
                            IWorkspace iworkspace;
                            String srcpath;
                            String srcname;
                            String targetname;
                            String basename;
                            block113: {
                                String message4;
                                String message5;
                                String jclDirPath;
                                IFileService rio;
                                String fullname;
                                block112: {
                                    boolean copyfile;
                                    block111: {
                                        block110: {
                                            String message6;
                                            basename = null;
                                            targetname = null;
                                            srcname = null;
                                            srcpath = null;
                                            fullname = null;
                                            iworkspace = null;
                                            try {
                                                iworkspace = ServerUtilities.getWorkspaceServerFromCache(bsinfo);
                                                if (iworkspace == null && (iworkspace = this.checkConnectionToWorkspaceServer(bsinfo, this.m_prompt)) != null) {
                                                    _workspaceCache.put(iworkspace.UniqueIdentifier(), bsinfo);
                                                }
                                                if (iworkspace == null) {
                                                    String message7 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.txt");
                                                    ++failed;
                                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message7));
                                                    failedMessage.append("\n");
                                                }
                                                break block110;
                                            }
                                            catch (CallbackCancelledException e) {
                                                message6 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.UserAbort.txt");
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message6));
                                                failedMessage.append("\n");
                                            }
                                            catch (Exception ex) {
                                                message6 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToConnectToAppServer.txt");
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message6));
                                                failedMessage.append("\n");
                                            }
                                            continue;
                                        }
                                        rio = iworkspace.FileService();
                                        if (codegen != null) {
                                            codegen.setAppServer(this.getSASAppServerFromBatchServer(bsinfo));
                                        }
                                        jclDirPath = null;
                                        if (preserveServer) {
                                            AssociationList directories;
                                            File jclsource;
                                            File source = djob.getSourceCode();
                                            if (source != null) {
                                                AssociationList directories2 = source.getDirectories();
                                                if (directories2 != null && !directories2.isEmpty()) {
                                                    dir = (Directory)directories2.get(0);
                                                }
                                            } else if (BatchServerInfo.requiresSourceFile((BatchServerInfo)bsinfo)) {
                                                String message8 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.MissingRequiredSource.txt");
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message8));
                                                failedMessage.append("\n");
                                                continue;
                                            }
                                            if (BatchServerInfo.requiresJCLFile((BatchServerInfo)bsinfo) && (jclsource = djob.getJCL()) != null && (directories = jclsource.getDirectories()) != null && !directories.isEmpty()) {
                                                jclDirPath = ((Directory)directories.get(0)).getDirectoryName();
                                            }
                                        } else {
                                            dir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (DirectoryInfo)data.getSelectedDirectory(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                            if (dir == null) {
                                                String message9 = null;
                                                message9 = data.getNumberOfDirectories() == 0 ? m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.NoDeploymentDirs.txt") : m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.MissingDeploymentDir.txt");
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message9));
                                                failedMessage.append("\n");
                                                continue;
                                            }
                                            if (BatchServerInfo.requiresJCLFile((BatchServerInfo)bsinfo)) {
                                                jclDirPath = data.getJCLPath();
                                            }
                                        }
                                        copyfile = false;
                                        try {
                                            DirectoryInfo dinfo = new DirectoryInfo(dir.getName(), dir.getDirectoryName());
                                            dinfo.setId(dir.getId());
                                            List<String> values = this.setFilePaths(name, file, bsinfo, dinfo);
                                            boolean x = values.get(0).equals("true");
                                            basename = values.get(1);
                                            targetname = values.get(2);
                                            srcname = values.get(3);
                                            srcpath = values.get(4);
                                            fullname = values.get(5);
                                            if (codegen == null) {
                                                if (x) {
                                                    copyfile = true;
                                                } else if (srcpath == null || srcpath.compareTo(CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)bsinfo.getOperatingSystem())) != 0) {
                                                    copyfile = true;
                                                }
                                            }
                                            if (fileContent == null) break block111;
                                            try {
                                                if (file != null && file.length() > 0) {
                                                    CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)file, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)fileContent);
                                                } else {
                                                    CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)fullname, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)fileContent);
                                                    copyfile = false;
                                                }
                                                break block111;
                                            }
                                            catch (GenericError ex) {
                                                message3 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWriteContent.fmt"), (Object)(file != null && file.length() > 0 ? file : fullname));
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message3));
                                                failedMessage.append("\n");
                                            }
                                        }
                                        catch (RuntimeException ex) {
                                            if (MetaUtilities.isDebug()) {
                                                ex.printStackTrace();
                                            }
                                            if ((message5 = ex.getLocalizedMessage()) == null || message5.length() == 0) {
                                                message5 = ex.toString();
                                            }
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message5));
                                            failedMessage.append("\n");
                                        }
                                        continue;
                                    }
                                    if (copyfile) {
                                        try {
                                            String filename = srcname;
                                            if (srcpath != null) {
                                                filename = CommandUtilities.createFullPath((String)srcpath, (String)srcname, (int)bsinfo.getOperatingSystem());
                                            }
                                            StringBuffer contents = null;
                                            try {
                                                contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)filename, (int)bsinfo.getOperatingSystem());
                                            }
                                            catch (GenericError ge) {
                                                if (MetaUtilities.isDebug()) {
                                                    ge.printStackTrace();
                                                }
                                                message4 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)(filename != null && filename.length() > 0 ? filename : "UNKNOWN_ORIGINAL_SOURCE_FILE"));
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message4));
                                                failedMessage.append("\n");
                                                continue;
                                            }
                                            if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)fullname, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)contents.toString())) {
                                                String message10 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)fullname);
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message10));
                                                failedMessage.append("\n");
                                            }
                                            break block112;
                                        }
                                        catch (GenericError ge) {
                                            message5 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(fullname != null ? fullname : srcname), (Object)ge.getLocalizedMessage());
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message5));
                                            failedMessage.append("\n");
                                        }
                                        continue;
                                    }
                                }
                                if (jcl != null) {
                                    try {
                                        String jclName = basename + ".jcl";
                                        String strFullName = null;
                                        try {
                                            String dirString = "./";
                                            Directory jcldir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (String)jclDirPath, (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                            if (jcldir != null) {
                                                dirString = jcldir.getDirectoryName();
                                            }
                                            strFullName = CommandUtilities.createFullPath((String)dirString, (String)jclName, (int)bsinfo.getOperatingSystem());
                                            String runas = djob.getRunAs();
                                            jcl = DataStepProgramDeployer.GenerateJCLFromTemplate((String)fullname, (String)runas, (String)jcl);
                                            if (!CommandUtilities.saveToRemoteFile((IFileService)rio, (String)strFullName, (int)bsinfo.getOperatingSystem(), (String)jcl)) {
                                                String message11 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)strFullName);
                                                ++failed;
                                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message11));
                                                failedMessage.append("\n");
                                                continue;
                                            }
                                            break block113;
                                        }
                                        catch (GenericError ge) {
                                            message4 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), strFullName, (Object)ge.getLocalizedMessage());
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message4));
                                            failedMessage.append("\n");
                                        }
                                    }
                                    catch (MdException e) {
                                        message5 = e.getLocalizedMessage();
                                        if (message5 == null) {
                                            message5 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                                        }
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message5));
                                        failedMessage.append("\n");
                                    }
                                    catch (RemoteException e) {
                                        message5 = e.getLocalizedMessage();
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message5));
                                        failedMessage.append("\n");
                                    }
                                    catch (RuntimeException e) {
                                        if (MetaUtilities.isDebug()) {
                                            e.printStackTrace();
                                        }
                                        if ((message5 = e.getLocalizedMessage()) == null || message5.length() == 0) {
                                            message5 = e.toString();
                                        }
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message5));
                                        failedMessage.append("\n");
                                    }
                                    continue;
                                }
                            }
                            jfjob = djob.getDeployedJobObject();
                            jclFile = null;
                            destfile = null;
                            for (Object obj : jfjob.getSourceCodes()) {
                                if (!(obj instanceof File)) continue;
                                destfile = (File)obj;
                                destfile.setName(basename);
                                destfile.setFileName(targetname);
                                destfile.getDirectories().clear();
                                destfile.getDirectories().add((Object)dir);
                                break;
                            }
                            if (codegen == null) {
                                File srcfile = null;
                                for (Object obj : jobObject.getSourceCodes()) {
                                    if (!(obj instanceof File)) continue;
                                    srcfile = (File)obj;
                                    MetaUtilities.setFileSource((File)srcfile, (String)srcname, (String)srcpath, (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                    break;
                                }
                                for (Object obj : jobObject.getSourceSpecifications()) {
                                    if (!(obj instanceof File)) continue;
                                    jclFile = (File)obj;
                                    jclFile.setName(basename);
                                    jclFile.setFileName(basename + ".jcl");
                                    jclFile.getDirectories().clear();
                                    Directory jcldir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (String)data.getJCLPath(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                                    jclFile.getDirectories().add((Object)jcldir);
                                    break;
                                }
                            } else {
                                String message12;
                                String codegen_filename;
                                block115: {
                                    String ext;
                                    codegen_filename = null;
                                    String nameStr = destfile != null ? destfile.getFileName() : null;
                                    String string = ext = destfile != null ? destfile.getFileExtension() : null;
                                    if (ext != null && ext.length() > 0) {
                                        nameStr = ext.startsWith(".") ? nameStr + ext.substring(1) : nameStr + "." + ext;
                                    }
                                    String path = dir != null ? dir.getDirectoryName() : null;
                                    codegen_filename = path != null ? CommandUtilities.createFullPath((String)path, (String)nameStr, (int)bsinfo.getOperatingSystem()) : nameStr;
                                    try {
                                        if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)codegen_filename, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)"VERIFYING WRITE TO FILE")) {
                                            String message13 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)codegen_filename);
                                            ++failed;
                                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message13));
                                            failedMessage.append("\n");
                                        }
                                        break block115;
                                    }
                                    catch (GenericError ge) {
                                        message12 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile2.fmt"), (Object)(codegen_filename != null ? codegen_filename : srcname), (Object)ge.getLocalizedMessage());
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message12));
                                        failedMessage.append("\n");
                                    }
                                    continue;
                                }
                                codegen.setJob(job.getJob());
                                String codegenResults = codegen.generateSource();
                                try {
                                    if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)codegen_filename, (Machine)sc.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)codegenResults)) {
                                        message12 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.fmt"), (Object)codegen_filename);
                                        ++failed;
                                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message12));
                                        failedMessage.append("\n");
                                    }
                                    break block114;
                                }
                                catch (GenericError ge) {
                                    String message14 = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.SavingFile.Codegen.fmt"), (Object)codegen_filename, (Object)ge.getLocalizedMessage());
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message14));
                                    failedMessage.append("\n");
                                }
                                continue;
                            }
                        }
                        djob = DataStepProgramDeployer.UpdateMetaObjects((Job)jobObject, (JFJob)jfjob, (File)destfile, (File)jclFile, (Directory)dir, (ServerComponent)sc, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                        djob.getDeployedJobObject().setName(name);
                        if (!djob.commitChangesWithNoValidation()) {
                            message3 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message3));
                            failedMessage.append("\n");
                            continue;
                        }
                        thisOkay = true;
                    } else {
                        try {
                            JFJob jfjob = djob.getDeployedJobObject();
                            djob = DataStepProgramDeployer.UpdateMetaObjects((Job)jobObject, (JFJob)jfjob, (ServerComponent)sc, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                            djob.getDeployedJobObject().setName(name);
                            if (!djob.commitChangesWithNoValidation()) {
                                message2 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                                ++failed;
                                failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message2));
                                failedMessage.append("\n");
                                continue;
                            }
                            thisOkay = true;
                        }
                        catch (SchedulerException ex) {
                            message2 = ex.getLocalizedMessage();
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message2));
                            failedMessage.append("\n");
                            continue;
                        }
                    }
                    if (data.getSASFolder().getName().compareTo(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE) != 0) {
                        Tree folder = MetaUtilities.getFolder((SASFolder)data.getSASFolder(), (MdObjectStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                        if (folder != null) {
                            if (djob != null) {
                                djob.setFolder(folder);
                                if (!djob.commitChangesWithNoValidation()) {
                                    message2 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                                    ++failed;
                                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message2));
                                    failedMessage.append("\n");
                                    continue;
                                }
                            }
                        } else {
                            message2 = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)message2));
                            failedMessage.append("\n");
                            continue;
                        }
                    }
                    djob.setDescription(job.getDescription());
                    djob.setJobArgs(job.getJobArgs());
                    djob.setEncodedJobArgsProperty(job.getEncodedArgs());
                    String runas = job.getUserId();
                    if (runas != null) {
                        djob.setRunAs(runas);
                    }
                    if ((resource = job.getSchedulerResources()) != null) {
                        djob.setResources(resource);
                    }
                    String jobcmd = job.getCommandLine();
                    if (job.isCommandLineDerived()) {
                        if (djob.getCmdLineProperty() != null) {
                            djob.removeCmdLineProperty();
                        }
                    } else {
                        String cmdline2 = CommandUtilities.getCommandLine((JFJob)djob.getDeployedJobObject(), null);
                        if (jobcmd != null && jobcmd.compareTo(cmdline2) != 0) {
                            if (djob.getCmdLineProperty() != null) {
                                djob.setCmdLineProperty(jobcmd);
                            } else {
                                if (MetaUtilities.isDebug()) {
                                    System.err.println("No flow context, command-line does not match derived command-line, and job was not deployed with a property.");
                                    System.err.println("Redeploy will be necessary to change the command-line in the future.");
                                }
                                djob.setCmdLineProperty(jobcmd);
                            }
                        }
                    }
                    if (!djob.commitChangesWithNoValidation()) {
                        message = m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.UnableToWrite.txt");
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)djob.getName(), (Object)message));
                        failedMessage.append("\n");
                        continue;
                    }
                    if (!thisOkay) continue;
                    message = null;
                    String jobName = "";
                    String djobName = "";
                    String dirName = "";
                    if (djob != null) {
                        djobName = djob.getName();
                        if (jobObject != null) {
                            jobName = jobObject.getName();
                        }
                    }
                    if (dir != null) {
                        dirName = dir.getDirectoryName();
                    }
                    message = MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeploySucc.fmt"), (Object)spacer, (Object)jobName, (Object)djobName, (Object)dirName);
                    ++success;
                    okMessage.append(message);
                    okMessage.append("\n");
                    continue;
                }
                catch (SchedulerException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (MdException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (RemoteException e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (NotFound e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (NoContext e) {
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e.getLocalizedMessage()));
                    failedMessage.append("\n");
                    continue;
                }
                catch (RuntimeException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.RedeployFail.fmt"), (Object)spacer, (Object)name, (Object)e));
                    failedMessage.append("\n");
                }
            }
            try {
                Set keys = _workspaceCache.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    BatchServerInfo binfo = (BatchServerInfo)_workspaceCache.get(i.next());
                    ServerUtilities.disconnectFromWorkspaceServer(binfo);
                }
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block116;
                e.printStackTrace();
            }
        }
        StringBuffer summary = new StringBuffer();
        if (success > 0) {
            String dirstring = "";
            try {
                if (dir != null) {
                    dirstring = dir.getDirectoryName();
                }
            }
            catch (RemoteException ex) {
                dirstring = "";
            }
            summary.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Redeployed.Success.Header.fmt"), (Object)String.valueOf(success), (Object)String.valueOf(total), (Object)dirstring));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        if (failed > 0) {
            summary.append(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.Redeployed.Failed.Header.fmt"), (Object)String.valueOf(failed), (Object)String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        SchedulerResultSet resultset = null;
        if (total == 1) {
            resultset = success == 1 ? new SchedulerResultSet(1, okMessage.toString(), (DisplayInfo)job) : (failed == 1 ? new SchedulerResultSet(0, failedMessage.toString(), (DisplayInfo)job) : new SchedulerResultSet(1, summary.toString(), (DisplayInfo)job));
        } else {
            ArrayList infos = new ArrayList();
            infos.addAll(jobs);
            resultset = new SchedulerResultSet(1, summary.toString(), total, infos);
        }
        return resultset;
    }

    protected List<String> setFilePaths(String name, String infile, BatchServerInfo bsinfo, DirectoryInfo dir) {
        ArrayList<String> returnValues = new ArrayList<String>();
        String file = CommandUtilities.normalizeFullPath((String)infile, (int)bsinfo.getOperatingSystem());
        if (file.startsWith("\"") || file.startsWith("'")) {
            file = file.substring(1, file.length() - 1);
        }
        String basename = MetaUtilities.replaceInvalidCharactersInFileName((String)name);
        String targetname = "";
        if (basename != null && basename.length() > 0) {
            targetname = bsinfo.getType() == 1 ? basename + ".sas" : basename;
        }
        char pathseparator = CommandUtilities.getPathSeparator((int)bsinfo.getOperatingSystem());
        String srcname = file.substring(file.lastIndexOf(pathseparator) + 1);
        String srcpath = null;
        int lastindex = file.lastIndexOf(pathseparator);
        if (lastindex > 0) {
            int firstindex = file.indexOf(pathseparator);
            srcpath = firstindex == lastindex ? file.substring(0, lastindex + 1) : file.substring(0, lastindex);
        }
        boolean rc = false;
        String fullname = CommandUtilities.createFullPath((String)dir.getPath(), (String)targetname, (int)bsinfo.getOperatingSystem());
        if (targetname.compareTo(srcname) != 0) {
            rc = true;
        }
        returnValues.add(String.valueOf(rc));
        returnValues.add(basename);
        returnValues.add(targetname);
        returnValues.add(srcname);
        returnValues.add(srcpath);
        returnValues.add(fullname);
        return returnValues;
    }

    @Override
    public JobInfo createDeployedJob(JobInfo job, UserContextInterface user) throws SchedulerException {
        JobInfo info = null;
        SASFolder sasFolder = new SASFolder(job.getLocation());
        BatchServerInfo bsinfo = job.getBatchServer();
        info = bsinfo.getType() == 1 ? this.createDataStepDeployedJob(job.getName(), bsinfo, sasFolder, job.getSourceFile(), job.getSourceDir(), user) : this.createDeployedJob(job.getName(), bsinfo, sasFolder, job.getJob(), job.getJobArgs(), user);
        boolean update = false;
        if (job.getDescription() != null) {
            info.setDescription(job.getDescription());
            update = true;
        }
        if (job.getEncodedArgs() != null) {
            info.setEncodedArgs(job.getEncodedArgs());
            update = true;
        }
        if (job.getJobPriority() != -1) {
            info.setJobPriority(job.getJobPriority());
        }
        if (job.getResponsiblePartyDataBinding() != null && job.getResponsiblePartyDataBinding().length() > 0) {
            info.setResponsiblePartyDataBinding(job.getResponsiblePartyDataBinding());
            update = true;
        }
        if (job.getRunAsDataBinding() != null) {
            info.setRunAsDataBinding(job.getRunAsDataBinding());
            update = true;
        }
        if (job.getSchedulerProperties() != null) {
            info.setSchedulerResources(job.getSchedulerProperties());
            update = true;
        }
        if (job.getSchedulerResources() != null) {
            info.setSchedulerResources(job.getSchedulerResources());
            update = true;
        }
        try {
            if (update) {
                this.updateDeployedJob(info, null);
                JFJob jfjob = MetaUtilities.getJFJob((String)info.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
                DeployedJob djob = new DeployedJob(jfjob);
                info = djob.getInfo();
            }
            return info;
        }
        catch (RemoteException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (MdException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    @Override
    public JobInfo createDeployedJob(String jobName, BatchServerInfo bsinfo, SASFolder sasFolder, DisplayInfo associatedJob, String jobArgs, UserContextInterface user) throws SchedulerException {
        MdObjectStore store = null;
        try {
            store = this.m_defaultMdFactory.createObjectStore(null, "createDeployedJob");
            ServerComponent bsComponent = MetaUtilities.getBatchServerComponent((BatchServerInfo)bsinfo, (MdStore)store, (String)this.getDefaultMdRepository());
            if (bsComponent == null) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingBatchServer.txt"));
            }
            Tree folder = MetaUtilities.getFolder((SASFolder)sasFolder, (MdObjectStore)store, (String)this.getDefaultMdRepository());
            if (MetaUtilities.doesJobExist((String)jobName, (Tree)folder, (MdStore)store, (String)this.getDefaultMdRepository())) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.JobAlreadyExists.txt"));
            }
            if (associatedJob == null) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingAssociatedJob.txt"));
            }
            Job job = null;
            if (associatedJob.getId() == null || associatedJob.getId().equals("")) {
                job = MetaUtilities.createJobObject((String)jobName, (MdObjectStore)store, (String)this.getDefaultMdRepository());
                if (job == null) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingAssociatedJob2.txt"));
                }
                job.getTrees().clear();
                job.getTrees().add((Object)folder);
            } else if (associatedJob.getId().equals("SCHEDULER_TERMINAL_JOB")) {
                String reposId = "A0000001." + folder.getId().substring(0, 8);
                job = MetaUtilities.createTerminalJobObject((String)jobName, (MdObjectStore)store, (String)reposId);
                if (job == null) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingAssociatedJob2.txt"));
                }
            } else {
                job = MetaUtilities.getAssociatedJob((String)associatedJob.getId(), (MdStore)store, (String)this.getDefaultMdRepository());
                if (job == null) {
                    Transformation t = MetaUtilities.getTransformation((String)associatedJob.getId(), (MdStore)store, (String)this.getDefaultMdRepository());
                    if (t != null) {
                        job = BatchJob.makeJobFromTransformation((Transformation)t, (boolean)true);
                    } else {
                        throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingAssociatedJob.txt"));
                    }
                }
            }
            if (!ServerUtilOMA.checkWritePermission(folder)) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToFolder.txt"));
            }
            DeployedJob deployedJob = null;
            deployedJob = jobArgs == null || jobArgs.length() == 0 ? new DeployedJob(job, bsComponent, user) : new DeployedJob(job, bsComponent, user, jobArgs);
            deployedJob.getDeployedJobObject().setName(jobName);
            deployedJob.setFolder(folder);
            if (!deployedJob.commitChangesWithNoValidation()) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
            }
            String newJobArgs = deployedJob.replaceCommandLineArgs(jobArgs);
            if (newJobArgs != null && !newJobArgs.equals(jobArgs)) {
                deployedJob.setJobArgs(newJobArgs);
                if (!deployedJob.commitChangesWithNoValidation()) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
                }
            }
            if (bsinfo.getOperatingSystem() == 2) {
                if (deployedJob.getDeploymentDirectory() == null) {
                    deployedJob.setDeploymentDirectory(MetaUtilities.getProperty((Root)bsComponent, (String)"JCLDir"));
                }
                deployedJob.checkJCLGeneration();
                if (!deployedJob.commitChangesWithNoValidation()) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
                }
            }
            JobInfo jobInfo = deployedJob.getInfo();
            return jobInfo;
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (MdException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (SchedulerException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (NotFound e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (NoContext e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (InvalidParameterException e) {
            throw new SchedulerException(e.getMessage());
        }
        finally {
            block34: {
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        if (!MetaUtilities.isDebug()) break block34;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public JobInfo createDataStepDeployedJob(String jobName, BatchServerInfo bsinfo, SASFolder sasFolder, String sourceFileName, DirectoryInfo deploymentDir, UserContextInterface user) throws SchedulerException {
        IWorkspace iworkspace = null;
        MdObjectStore store = null;
        try {
            store = this.m_defaultMdFactory.createObjectStore(null, "createDataStepDeployedJob");
            ServerComponent bsComponent = MetaUtilities.getBatchServerComponent((BatchServerInfo)bsinfo, (MdStore)store, (String)this.getDefaultMdRepository());
            if (bsComponent == null) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.MissingBatchServer.txt"));
            }
            Tree folder = MetaUtilities.getFolder((SASFolder)sasFolder, (MdObjectStore)store, (String)this.getDefaultMdRepository());
            if (MetaUtilities.doesJobExist((String)jobName, (Tree)folder, (MdStore)store, (String)this.getDefaultMdRepository())) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.JobAlreadyExists.txt"));
            }
            Directory targetDir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (DirectoryInfo)deploymentDir, (MdStore)store, (String)this.getDefaultMdRepository());
            if (targetDir == null) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.DirectoryDoesNotExist.txt"));
            }
            String targetBaseName = MetaUtilities.replaceInvalidCharactersInFileName((String)jobName);
            String targetName = targetBaseName + ".sas";
            String targetPath = deploymentDir.getPath();
            String targetFullPath = CommandUtilities.createFullPath((String)targetPath, (String)targetName, (int)bsinfo.getOperatingSystem());
            String srcNormalizedPath = CommandUtilities.normalizeFullPath((String)sourceFileName, (int)bsinfo.getOperatingSystem());
            char pathseparator = CommandUtilities.getPathSeparator((int)bsinfo.getOperatingSystem());
            String srcName = srcNormalizedPath.substring(srcNormalizedPath.lastIndexOf(pathseparator) + 1);
            String srcPath = null;
            int lastindex = srcNormalizedPath.lastIndexOf(pathseparator);
            if (lastindex > 0) {
                int firstindex = srcNormalizedPath.indexOf(pathseparator);
                srcPath = firstindex == lastindex ? srcNormalizedPath.substring(0, lastindex + 1) : srcNormalizedPath.substring(0, lastindex);
            }
            String srcFullPath = srcName;
            if (srcPath != null) {
                srcFullPath = CommandUtilities.createFullPath(srcPath, (String)srcName, (int)bsinfo.getOperatingSystem());
            }
            iworkspace = this.checkConnectionToWorkspaceServer(bsinfo, this.m_prompt);
            IFileService rio = iworkspace.FileService();
            StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)srcFullPath, (int)bsinfo.getOperatingSystem());
            if (!CommandUtilities.saveToRemoteFile((IWorkspace)iworkspace, (String)targetFullPath, (Machine)bsComponent.getAssociatedMachine(), (int)bsinfo.getOperatingSystem(), (String)contents.toString())) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
            }
            String jclExt = null;
            if (bsinfo.getOperatingSystem() == 2) {
                jclExt = "jcl";
                try {
                    String runas = null;
                    String template = CommandUtilities.getCommandLineFromBatchServer((ServerComponent)bsComponent);
                    String jcl = DataStepProgramDeployer.GenerateJCLFromBatchServer((String)targetFullPath, runas, (String)template, (IWorkspace)iworkspace);
                    String jclName = targetBaseName + "." + jclExt;
                    try {
                        String strFullJCLName = CommandUtilities.createFullPath((String)targetPath, (String)jclName, (int)bsinfo.getOperatingSystem());
                        if (!CommandUtilities.saveToRemoteFile((IFileService)rio, (String)strFullJCLName, (int)bsinfo.getOperatingSystem(), (String)jcl)) {
                            throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
                        }
                    }
                    catch (GenericError ge) {
                        throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
                    }
                }
                catch (MdException e) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
                }
                catch (RemoteException e) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
                }
                catch (RuntimeException e) {
                    throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.SavingFile.txt"));
                }
            }
            if (!ServerUtilOMA.checkWritePermission(folder)) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWriteToFolder.txt"));
            }
            String reposId = "A0000001." + folder.getId().substring(0, 8);
            DeployedJob deployedJob = DataStepProgramDeployer.BuildMetaObjects((String)jobName, (String)targetName, (String)targetBaseName, (String)jclExt, (Directory)targetDir, (ServerComponent)bsComponent, (UserContextInterface)user, (MdFactory)this.getDefaultMdFactory(), (MdObjectStore)store, (String)reposId);
            Job job = deployedJob.getJobObject();
            if (job != null && srcName != null) {
                Directory srcDir = null;
                if (srcPath != null && (srcDir = MetaUtilities.getDirectoryFromPath((String)srcPath, (MdStore)store, (String)this.getDefaultMdRepository())) == null) {
                    srcNormalizedPath = CommandUtilities.normalizePath((String)srcPath, (int)bsinfo.getOperatingSystem());
                    lastindex = srcNormalizedPath.lastIndexOf(pathseparator);
                    String dirName = srcNormalizedPath.substring(lastindex + 1);
                    srcDir = MetaUtilities.createDirectoryObject((String)dirName, (MdObjectStore)store, (String)this.getDefaultMdRepository());
                    srcDir.setDirectoryName(srcPath);
                }
                File srcCode = MetaUtilities.createSourceCodeObject((String)srcName, srcDir, (MdObjectStore)store, (String)reposId);
                if (srcName.indexOf(".") >= 0) {
                    srcCode.setFileName(srcName.substring(0, srcName.lastIndexOf(46)));
                    srcCode.setFileExtension(srcName.substring(srcName.lastIndexOf(46) + 1));
                } else {
                    srcCode.setFileName(srcName);
                }
                srcCode.getDirectories().add((Object)srcDir);
                MetaUtilities.setSourceForUserWrittenJob((Job)job, (File)srcCode, (ServerComponent)CommandUtilities.getWorkspaceServerComponentFromBatchServer((ServerComponent)bsComponent), (String)"SCHEDULER_JOB");
            }
            if (job != null) {
                job.getTrees().clear();
                job.getTrees().add((Object)folder);
            }
            deployedJob.setFolder(folder);
            if (!deployedJob.commitChangesWithNoValidation()) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
            }
            JobInfo jobInfo = deployedJob.getInfo();
            return jobInfo;
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (MdException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (SchedulerException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (NotFound e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (NoContext e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (GenericError e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (InvalidParameterException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (CallbackCancelledException e) {
            throw new SchedulerException(e.getMessage());
        }
        finally {
            block44: {
                if (iworkspace != null) {
                    try {
                        ServerUtilities.disconnectFromWorkspaceServer(bsinfo);
                        iworkspace.Close();
                    }
                    catch (Exception exception) {}
                }
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        if (!MetaUtilities.isDebug()) break block44;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public String getJobCommandline(JobInfo info) {
        String cmd = null;
        try {
            cmd = CommandUtilities.getCommandLine((JFJob)MetaUtilities.getJFJob((String)info.getId(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId));
        }
        catch (SchedulerException schedulerException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return cmd;
    }

    @Override
    public String resetCommandLine(ServerJobInfo job, ServerFlowInfo flow) throws InvalidParameterException {
        TransformationActivity ta = null;
        String flowname = null;
        if (flow != null) {
            ta = flow.getDeployedFlow().getTA();
            flowname = flow.getName();
        }
        try {
            JFJob jfjob;
            DeployedJob djob;
            TransformationStep step;
            String sascommand = null;
            if (job.m_object == null) {
                this.generateAllInformation(job);
            }
            if ((step = (djob = (DeployedJob)job.m_object).getLogicalJob(ta)) != null && DeployedJob.getCmdLineProperty((Root)step) != null) {
                DeployedJob.removeCmdLineProperty((Root)step);
            }
            if ((jfjob = djob.getDeployedJobObject()) != null && DeployedJob.getCmdLineProperty((Root)jfjob) != null) {
                sascommand = DeployedJob.getCmdLineProperty((Root)jfjob);
                InvalidParameterException ex = new InvalidParameterException(sascommand);
                throw ex;
            }
            sascommand = CommandUtilities.getCommandLine((JFJob)jfjob, (String)flowname, (String)" ");
            return sascommand;
        }
        catch (SchedulerException ex) {
            return "";
        }
        catch (MdException ex) {
            return "";
        }
        catch (RemoteException ex) {
            return "";
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (RuntimeException ex) {
            return "";
        }
    }

    @Override
    public void updateJobCommandline(JobInfo job, String flowname) {
        block6: {
            try {
                JobInfo temp = DeployedJob.getInfo((JFJob)MetaUtilities.getJFJob((String)job.getId(), (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository()), null, (String)flowname, null, null, null);
                String cmdline = temp.getCommandLine();
                job.setCommandLine(cmdline, true);
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getSourceFile(JobInfo jinfo) {
        try {
            String filename;
            DeployedJob job = new DeployedJob(jinfo, this.m_defaultMdStore, this.m_defaultMdRepository);
            File srcfile = job.getSourceCode();
            if (srcfile != null && (filename = job.getSourceCode().getFileName()) != null && filename.trim().length() > 0) {
                return filename;
            }
            return null;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (MdException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLogfile(ServerJobInfo job, ServerFlowInfo flow, IWorkspace workspace) throws SchedulerException {
        try {
            Object o = job.m_object;
            if (o instanceof DeployedJob) {
                DeployedJob djob = (DeployedJob)o;
                JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
                TransformationStep step = djob.getLogicalJob(DeployedFlow.getTA((JFJob)jfjob));
                return djob.getLogFile(step, workspace);
            }
            if (job.getJobInfo() instanceof JobInfo) {
                DeployedJob djob = new DeployedJob((JobInfo)job.getJobInfo(), this.m_defaultMdStore, this.m_defaultMdRepository);
                JFJob jfjob = MetaUtilities.getJFJob((String)flow.getId(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
                TransformationStep step = djob.getLogicalJob(DeployedFlow.getTA((JFJob)jfjob));
                return djob.getLogFile(step, workspace);
            }
            return null;
        }
        catch (MdException e) {
            e.printStackTrace();
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    @Override
    public String getJCLFile(ServerJobInfo job) {
        try {
            DeployedJob djob = null;
            if (job.m_object instanceof DeployedJob) {
                djob = (DeployedJob)job.m_object;
            } else if (job.getJobInfo() instanceof JobInfo) {
                this.generateAllInformation(job);
                djob = (DeployedJob)job.m_object;
            } else {
                return null;
            }
            File jclFile = djob.getJCL();
            if (jclFile != null) {
                String jclName = jclFile.getFileName();
                String jclExt = jclFile.getFileExtension();
                if (jclExt != null && jclExt.length() > 0) {
                    jclName = jclExt.startsWith(".") ? jclName + jclExt : jclName + "." + jclExt;
                }
                String directory = null;
                if (jclFile.getDirectories().size() != 0) {
                    directory = ((Directory)jclFile.getDirectories().get(0)).getDirectoryName();
                }
                return CommandUtilities.createFullPath(directory, (String)jclName, (int)2);
            }
            return null;
        }
        catch (MdException mde) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (SchedulerException e) {
            return null;
        }
    }

    @Override
    public boolean isRedeployable(JobInfo jinfo, boolean schmgr) {
        try {
            JFJob jfjob = MetaUtilities.getJFJob((String)jinfo.getId(), (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            Job job = jfjob.getAssociatedJob();
            if (job == null) {
                return false;
            }
            if (schmgr) {
                String role = job.getTransformRole();
                if (role.compareTo("SCHEDULER_JOB") == 0 && job.getIsUserDefined() != 0 && job.getSourceCodes().size() > 0) {
                    return true;
                }
                return role.compareTo("SCHEDULER_TERMINAL_JOB") == 0;
            }
            return MetaUtilities.isRedeployable((Job)job, (boolean)false);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (MdException ex) {
            return false;
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    @Override
    public boolean commitJobToStore(JobInfo jinfo, String flowname) throws SchedulerException {
        try {
            String repos;
            block8: {
                repos = this.m_defaultMdRepository;
                try {
                    Tree folder = MetaUtilities.getFolder((String)jinfo.getLocation(), (MdObjectStore)this.m_defaultMdStore, (String)this.m_defaultMdRepository);
                    if (folder != null) {
                        repos = folder.getId().substring(0, 8);
                    }
                }
                catch (NotFound nf) {
                    if (MetaUtilities.isDebug()) {
                        nf.printStackTrace();
                    }
                }
                catch (NoContext nc) {
                    if (!MetaUtilities.isDebug()) break block8;
                    nc.printStackTrace();
                }
            }
            DeployedJob djob = new DeployedJob(jinfo, flowname, this.getDefaultMdStore(), repos);
            return djob.commitChangesWithNoValidation();
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public void updateDeployedJob(JobInfo jinfo, String flowname) throws SchedulerException {
        try {
            DeployedJob djob = new DeployedJob(jinfo, flowname, this.getDefaultMdStore(), this.getDefaultMdRepository());
            if (!djob.commitChangesWithNoValidation()) {
                throw new SchedulerException(m_bundle.getString("ServerUtilities.ErrorMsg.UnableToWrite.txt"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateCmdlineForDeployedJobs() {
        boolean flag = CommandUtilities.m_allowFlowPrefix;
        CommandUtilities.setAllowFlowPrefixForLogfile((boolean)true);
        try {
            String selectXML = "<XMLSELECT search=\"*[JobActivities/*TransformationActivity]\"/><Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>";
            int flags = 532876;
            MdFactory factory = this.getDefaultMdStore().getFactory();
            List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.getDefaultMdStore(), this.getDefaultMdRepository(), "JFJob", flags, selectXML);
            int listsize = jfjobList.size();
            for (int x = 0; x < listsize; ++x) {
                JFJob flow = (JFJob)jfjobList.get(x);
                String flowname = flow.getName();
                TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
                for (TransformationStep step : activity.getSteps()) {
                    if (step instanceof SyncStep) continue;
                    JFJob jfjob = null;
                    try {
                        String cmdline;
                        jfjob = (JFJob)step.getTransformations().get(0);
                        step.setName(JobEvent.getName((JFJob)jfjob));
                        if (step.getTransformRole().equalsIgnoreCase("FLOW") || (cmdline = DeployedJob.getCmdLineProperty((Root)step)) == null) continue;
                        String derived1 = CommandUtilities.getCommandLine((JFJob)jfjob, (String)flowname);
                        String derived2 = CommandUtilities.getCommandLine((JFJob)jfjob, null);
                        if (derived1.compareTo(cmdline) == 0) {
                            if (MetaUtilities.isDebug()) {
                                System.out.println("Removing job cmdline property for: " + jfjob.getName() + " in flow: " + flowname);
                                System.out.println("The generated command line matches the property using flow prefix.");
                            }
                            DeployedJob.removeCmdLineProperty((Root)step);
                            continue;
                        }
                        if (derived2.compareTo(cmdline) == 0) {
                            if (MetaUtilities.isDebug()) {
                                System.out.println("Removing job cmdline property for: " + jfjob.getName() + " in flow: " + flowname);
                                System.out.println("The generated command line matches the property if the flow prefix to log file name is removed.");
                            }
                            DeployedJob.removeCmdLineProperty((Root)step);
                            continue;
                        }
                        if (!MetaUtilities.isDebug()) continue;
                        System.out.println("job cmdline property for: " + jfjob.getName() + " in flow: " + flowname);
                        System.out.println("The generated command line does not matches the property.");
                        System.out.println("<" + derived1 + "> != <" + cmdline + ">");
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {}
                }
            }
            this.getDefaultMdStore().updatedMetadataAll();
        }
        catch (MdException mde) {
            if (MetaUtilities.isDebug()) {
                System.out.println("Ingoring the MdException:" + mde.getMessage());
            }
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                System.out.println("Ingoring the RemoteException:" + e.toString());
            }
        }
        finally {
            CommandUtilities.setAllowFlowPrefixForLogfile((boolean)flag);
        }
    }

    @Override
    public boolean deleteDeployedJobFromMetadata(String id) throws SchedulerException {
        boolean result = false;
        try {
            JFJob jfJob = MetaUtilities.getJFJob((String)id, (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)this.getDefaultMdStore(), (String)this.getDefaultMdRepository());
            DeployedJob djob = new DeployedJob(jfJob);
            result = djob.delete();
        }
        catch (RemoteException e) {
            throw new SchedulerException(e.getMessage());
        }
        catch (MdException e) {
            throw new SchedulerException(e.getMessage());
        }
        return result;
    }

    @Override
    public List<DirectoryInfo> getDirectoriesFromServer(SASAppServer appserver) {
        ArrayList<DirectoryInfo> list = new ArrayList<DirectoryInfo>();
        try {
            ServerContext sc = this.getSASAppServer(appserver);
            AssociationList temp = sc.getDataPackages(true);
            int listsize = temp.size();
            for (int i = 0; i < listsize; ++i) {
                if (!(temp.get(i) instanceof Directory)) continue;
                Directory dir = (Directory)temp.get(i);
                list.add(new DirectoryInfo(dir.getName(), dir.getDirectoryName()));
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUniqueDirectory(String name) {
        boolean rc = true;
        MdObjectStore tempStore = null;
        List list = null;
        try {
            tempStore = this.m_defaultMdFactory.createObjectStore();
            list = MetaUtilities.getDirectoryList((String)name, (MdStore)tempStore, (String)this.m_defaultMdRepositoryId);
            if (list.size() > 0) {
                rc = false;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RemoteException remoteException) {}
                tempStore = null;
            }
            if (list != null) {
                list.clear();
                list = null;
            }
        }
        return rc;
    }

    @Override
    public boolean okayToDeleteDirectory(DirectoryInfo info) {
        try {
            Directory directory = MetaUtilities.getDirectoryFromName((String)info.getName(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            if (!MetaUtilities.okayToDelete((Directory)directory)) {
                List list = MetaUtilities.getAssociatedObjects((Directory)directory);
                for (CMetadata obj : list) {
                    if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) continue;
                    String s = MetaUtilities.messageString((String)"The object \"{0}\" of type \"{1}\" is associated to directory \"{2}\".", (Object)obj.getName(), (Object)obj.getCMetadataType(), (Object)directory.getName());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(s);
                        continue;
                    }
                    System.out.println(s);
                }
                return false;
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteDirectory(DirectoryInfo info) {
        try {
            Directory directory = MetaUtilities.getDirectoryFromName((String)info.getName(), (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
            if (MetaUtilities.okayToDelete((Directory)directory)) {
                return directory.delete();
            }
        }
        catch (MdException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public SortedSet<DisplayInfo> getNonAssociatedJobsFromRepository() throws SchedulerException {
        try {
            return MetaUtilities.getNonAssociatedJobsFromRepository((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public SortedSet<DisplayInfo> getJobObjectsFromRepository() throws SchedulerException {
        try {
            return MetaUtilities.getJobObjectsFromRepository((MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    private static boolean matchJobCountCriteria(JFJob flow, FilterRule rule) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
        if (activity == null) {
            return false;
        }
        Iterator i = activity.getSteps().iterator();
        int count = 0;
        while (i.hasNext()) {
            block17: {
                TransformationStep step = (TransformationStep)i.next();
                if (step instanceof SyncStep) continue;
                JFJob jfjob = null;
                try {
                    String role;
                    jfjob = (JFJob)step.getTransformations().get(0);
                    if (jfjob == null || (role = jfjob.getTransformRole()).compareTo("SCHEDULER_FLOW_DELETE") == 0) continue;
                    if (role.compareTo("SCHEDULER_JOB_DELETE") == 0) {
                    }
                    break block17;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    MdFactory factory = step.getObjectStore().getFactory();
                    int c = factory.getSecurityUtil().getAssociationCountForObject((CMetadata)jfjob, "AssociatedJob");
                    if (c != 0) break block17;
                }
                continue;
            }
            ++count;
        }
        try {
            int value = Integer.parseInt(rule.getValue());
            switch (rule.getCondition()) {
                case 4: {
                    if (count <= value) {
                        return false;
                    }
                    break;
                }
                case 5: {
                    if (count >= value) {
                        return false;
                    }
                    break;
                }
                case 6: {
                    if (count != value) {
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (count == value) {
                        return false;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @Override
    public IWorkspace makeConnectionToWorkspaceServer(SASAppServer appserver, String user, String pass) throws SchedulerException {
        try {
            ServerContext appsrv = this.getSASAppServer(appserver);
            TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection((ServerComponent)appsrv, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
            if (tcpip == null) {
                throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.ErrorMsg.NoWorkspaceServer.fmt"), (Object)appserver.getName()));
            }
            String host = tcpip.getHostName();
            int port = tcpip.getPort();
            return IWorkspaceServer.makeConnection((String)user, (String)pass, (String)"440196D4-90F0-11D0-9F41-00A024BB830C", (String)host, (int)port);
        }
        catch (Exception ex) {
            SchedulerException e = new SchedulerException(ex.getLocalizedMessage());
            e.initCause((Throwable)ex);
            throw e;
        }
    }

    private IWorkspace makeConnectionToWorkspaceServer(ServerComponent sc, String user, String pass) throws RemoteException, InvalidParameterException, SchedulerException, CallbackCancelledException {
        IWorkspace iworkspace = null;
        try {
            ServerContext context = IWorkspaceServer.getServerContext((ServerComponent)sc);
            try {
                ServerComponent workspace = IWorkspaceServer.getWorkspace((ServerContext)context, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
                if (workspace == null) {
                    throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.ErrorMsg.NoWorkspaceServer.fmt"), (Object)sc.getName()));
                }
                TCPIPConnection tcpip = (TCPIPConnection)workspace.getSourceConnections().get(0);
                if (tcpip == null) {
                    throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.ErrorMsg.NoWorkspaceServer.fmt"), (Object)sc.getName()));
                }
                String host = tcpip.getHostName();
                int port = tcpip.getPort();
                String name = workspace.getName();
                iworkspace = IWorkspaceServer.makeConnection((String)user, (String)pass, (String)"440196D4-90F0-11D0-9F41-00A024BB830C", (String)name, (String)host, (int)port);
            }
            catch (MdException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (InvalidCredentialsException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
            catch (FatalConnectionFactoryException ex) {
                SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
                se.initCause((Throwable)ex);
                throw se;
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        return iworkspace;
    }

    public void mdInitialization(boolean reset, boolean debug, String name, String repos) {
        block5: {
            if (reset || this.getDefaultMdFactory() == null) {
                this.setDefaultMdFactory(debug);
            }
            if (this.getDefaultMdFactory() != null) {
                try {
                    this.setDefaultMdStore(this.getDefaultMdFactory().createObjectStore(null, name));
                    this.setDefaultMdRepository(repos);
                }
                catch (RemoteException remoteException) {
                }
                catch (Exception ex) {
                    if (!debug) break block5;
                    ex.printStackTrace();
                }
            }
        }
    }

    protected boolean setDefaultMdFactory(boolean debug) {
        try {
            this.m_defaultMdFactory = MetaUtilities.getMdFactory((SessionContextInterface)this.m_defaultSessionContext);
            return true;
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean setDefaultMdFactory(MdFactory factory) {
        this.m_defaultMdFactory = factory;
        return true;
    }

    public MdFactory getDefaultMdFactory() {
        return this.m_defaultMdFactory;
    }

    public boolean setDefaultMdStore(MdObjectStore store) {
        this.m_defaultMdStore = store;
        return true;
    }

    public MdObjectStore getDefaultMdStore() {
        if (this.m_defaultMdStore == null && this.m_defaultMdFactory != null) {
            try {
                this.m_defaultMdStore = this.m_defaultMdFactory.createObjectStore(null, "ServerUtilities");
            }
            catch (RemoteException e) {
                this.m_defaultMdStore = null;
            }
        }
        return this.m_defaultMdStore;
    }

    public void disposeStore() throws RemoteException {
        if (this.getDefaultMdStore() != null) {
            this.getDefaultMdStore().dispose();
            this.setDefaultMdStore(null);
        }
    }

    public boolean setDefaultMdRepository(String repos) {
        if (repos.length() > 8) {
            this.m_defaultMdRepository = repos.substring(9);
            this.m_defaultMdRepositoryId = repos;
        } else {
            this.m_defaultMdRepository = repos;
            this.m_defaultMdRepositoryId = "A0000001." + repos;
        }
        return true;
    }

    public String getDefaultMdRepository() {
        return this.m_defaultMdRepositoryId;
    }

    public static boolean checkWritePermission(Tree folder) {
        try {
            MdFactory factory = folder.getObjectStore().getFactory();
            MdSecurityUtil security = factory.getSecurityUtil();
            return security.isFolderWriteAuthorized(folder.getId());
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public String XMLExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        try {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = info;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
                ReportFlowToXML reporter = new ReportFlowToXML(dflow, name, dir != null ? dir.getPath() : "", workspace);
                if (reporter.writeFlow()) {
                    return null;
                }
                return reporter.getData();
            }
            return null;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public FlowInfo XMLImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        String user = null;
        SealedString password = null;
        try {
            UserIdentityInterface uI = this.m_defaultUserContext.getIdentityByDomain("");
            if (uI != null) {
                user = uI.getPrincipal().toString();
                password = uI.getCredential().toString() != null ? new SealedString(uI.getCredential().toString()) : null;
            }
        }
        catch (Exception ex) {
            user = null;
            password = null;
        }
        ImportFlowFromXML importer = new ImportFlowFromXML(file, workspace, this.m_defaultMdStore, this.m_defaultMdRepositoryId, user, password);
        if (importer.parse(maxPredsPerJob)) {
            return importer.getFlowInfo();
        }
        return null;
    }

    @Override
    public String SASExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        try {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = info;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
                ReportFlowToSAS reporter = new ReportFlowToSAS(dflow, name, dir != null ? dir.getPath() : "", workspace);
                if (reporter.writeFlow()) {
                    return null;
                }
                return reporter.getData();
            }
            return null;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public FlowInfo SASImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        ImportFlowFromSAS importer = new ImportFlowFromSAS(file, workspace, this.m_defaultMdStore, this.m_defaultMdRepositoryId);
        if (importer.parse(maxPredsPerJob)) {
            return importer.getFlowInfo();
        }
        return null;
    }

    @Override
    public String CSVExport(IWorkspace workspace, ServerFlowInfo info, String name, SASAppServer appServer, DirectoryInfo dir) throws InvalidParameterException, SchedulerException, IOException {
        try {
            DeployedFlow dflow = null;
            ServerFlowInfo flow = info;
            Object o = flow.m_object;
            if (o instanceof DeployedFlow) {
                dflow = (DeployedFlow)o;
                ReportFlowToCSV reporter = new ReportFlowToCSV(dflow, name, dir != null ? dir.getPath() : "", workspace);
                if (reporter.writeFlow()) {
                    return null;
                }
                return reporter.getData();
            }
            return null;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    @Override
    public FlowInfo CSVImport(IWorkspace workspace, String file, int maxPredsPerJob) throws IOException, SchedulerException {
        ImportFlowFromCSV importer = new ImportFlowFromCSV(file, workspace, this.m_defaultMdStore, this.m_defaultMdRepositoryId);
        if (importer.parse(maxPredsPerJob)) {
            return importer.getFlowInfo();
        }
        return null;
    }

    private ServerContext getSASAppServer(SASAppServer appserver) throws RemoteException {
        try {
            String strSelect = "<XMLSELECT search=\"*[@Id='" + appserver.getId() + "']\" />";
            List list = this.m_defaultMdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_defaultMdStore, this.m_defaultMdRepositoryId, "ServerContext", 8584, strSelect);
            if (list.size() == 1) {
                return (ServerContext)list.get(0);
            }
            return null;
        }
        catch (MdException ex) {
            return null;
        }
    }

    protected static SortedSet<FlowInfo> getFlowsFromRepository(FilterSelector filter, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        int x;
        TreeSet<FlowInfo> flowlist = new TreeSet<FlowInfo>((Comparator<FlowInfo>)new CompareDisplayInfoObjects());
        MdFactory factory = store.getFactory();
        int flags = 532876;
        String selectXML = null;
        List flows = null;
        FilterRule rule = filter.getRule(0);
        String column = rule.getColumnName();
        int columnID = FlowColumnSelectorModel.getColumnKeyFromName((String)column);
        switch (columnID) {
            case 0: {
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW' and " + ServerUtilities.getSelectXMLSub("@Name", rule.getCondition(), rule.getValue()) + "]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                break;
            }
            case 1: {
                JFJob flow;
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW']\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    flow = (JFJob)flows.get(x);
                    if (ServerUtilOMA.matchJobCountCriteria(flow, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 2: {
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW' and " + ServerUtilities.getSelectXMLSub("@MetadataCreated", rule.getCondition(), rule.getValue()) + "]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                break;
            }
            case 3: {
                JFJob flow;
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW']\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    TransformationActivity activity;
                    flow = (JFJob)flows.get(x);
                    Date server = DeployedFlow.getDateModified((JFJob)flow, (TransformationActivity)(activity = (TransformationActivity)flow.getJobActivities().get(0)));
                    if (ServerUtilities.matchTimeCriteria(server, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 4: {
                JFJob flow;
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW']\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    flow = (JFJob)flows.get(x);
                    if (ServerUtilOMA.matchLastExecutionCriteria(flow, store, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 5: {
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW'][" + ServerUtilities.getSelectXMLSub("@Id", rule.getCondition(), rule.getValue()) + "]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                break;
            }
            case 6: {
                selectXML = "<XMLSELECT search=\"JFJob[ComputeLocations/ServerComponent[" + ServerUtilities.getSelectXMLSub("@Name", rule.getCondition(), rule.getValue()) + "]]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW'][Properties/Property[@PropertyName='SUBMITTED' and " + ServerUtilities.getSelectXMLSub("@DefaultValue", rule.getCondition(), rule.getValue()) + "]]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                break;
            }
            case 9: {
                selectXML = "<XMLSELECT search=\"JFJob[@TransformRole='SCHEDULER_FLOW'][Trees/Tree[" + ServerUtilities.getSelectXMLSub("@Name", rule.getCondition(), rule.getValue()) + "]]\" />" + "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
            }
        }
        if (flows != null) {
            int numRules = filter.getRuleCount();
            block54: for (int i = 1; i < numRules; ++i) {
                rule = filter.getRule(i);
                column = rule.getColumnName();
                columnID = FlowColumnSelectorModel.getColumnKeyFromName((String)column);
                switch (columnID) {
                    case 0: {
                        JFJob obj;
                        int x2;
                        block55: for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            switch (rule.getCondition()) {
                                case 0: {
                                    if (obj.getName().compareTo(rule.getValue()) == 0) continue block55;
                                    flows.remove(x2);
                                    continue block55;
                                }
                                case 3: {
                                    if (obj.getName().indexOf(rule.getValue()) >= 0) continue block55;
                                    flows.remove(x2);
                                    continue block55;
                                }
                                case 1: {
                                    if (obj.getName().startsWith(rule.getValue())) continue block55;
                                    flows.remove(x2);
                                    continue block55;
                                }
                                case 2: {
                                    if (obj.getName().endsWith(rule.getValue())) continue block55;
                                    flows.remove(x2);
                                }
                            }
                        }
                        continue block54;
                    }
                    case 1: {
                        JFJob flow;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            if (ServerUtilOMA.matchJobCountCriteria(flow, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block54;
                    }
                    case 2: {
                        JFJob flow;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            Date server = DeployedFlow.getDateCreated((JFJob)flow);
                            if (ServerUtilities.matchTimeCriteria(server, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block54;
                    }
                    case 3: {
                        JFJob flow;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            TransformationActivity activity;
                            flow = (JFJob)flows.get(x2);
                            Date server = DeployedFlow.getDateModified((JFJob)flow, (TransformationActivity)(activity = (TransformationActivity)flow.getJobActivities().get(0)));
                            if (ServerUtilities.matchTimeCriteria(server, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block54;
                    }
                    case 4: {
                        JFJob flow;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            if (ServerUtilOMA.matchLastExecutionCriteria(flow, store, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block54;
                    }
                    case 5: {
                        JFJob obj;
                        int x2;
                        block60: for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            switch (rule.getCondition()) {
                                case 0: {
                                    if (obj.getId().compareTo(rule.getValue()) == 0) continue block60;
                                    flows.remove(x2);
                                    continue block60;
                                }
                                case 3: {
                                    if (obj.getId().indexOf(rule.getValue()) >= 0) continue block60;
                                    flows.remove(x2);
                                    continue block60;
                                }
                                case 1: {
                                    if (obj.getId().startsWith(rule.getValue())) continue block60;
                                    flows.remove(x2);
                                    continue block60;
                                }
                                case 2: {
                                    if (obj.getId().endsWith(rule.getValue())) continue block60;
                                    flows.remove(x2);
                                }
                            }
                        }
                        continue block54;
                    }
                    case 6: {
                        JFJob obj;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            try {
                                String schName = DeployedFlow.getSchedulerComponent((JFJob)obj).getName();
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (schName.compareTo(rule.getValue()) == 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 3: {
                                        if (schName.indexOf(rule.getValue()) >= 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 1: {
                                        if (schName.startsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 2: {
                                        if (schName.endsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                    }
                                }
                                continue;
                            }
                            catch (RuntimeException ex) {
                                flows.remove(x2);
                            }
                        }
                        continue block54;
                    }
                    case 7: {
                        continue block54;
                    }
                    case 8: {
                        JFJob obj;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            try {
                                String username = DeployedFlow.getScheduledUser((JFJob)obj);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (username.compareTo(rule.getValue()) == 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 3: {
                                        if (username.indexOf(rule.getValue()) >= 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 1: {
                                        if (username.startsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 2: {
                                        if (username.endsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                    }
                                }
                                continue;
                            }
                            catch (RuntimeException ex) {
                                flows.remove(x2);
                            }
                        }
                        continue block54;
                    }
                }
            }
        }
        if (flows != null) {
            for (x = 0; x < flows.size(); ++x) {
                JFJob flow = (JFJob)flows.get(x);
                FlowInfo info = DeployedFlow.getInfo((JFJob)flow, (MdObjectStore)store, (boolean)displayOnly);
                flowlist.add(info);
            }
        }
        return flowlist;
    }

    protected static SortedSet<DisplayInfo> getJobsFromRepository(FilterSelector filter, String flowId, MdStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        TreeSet<DisplayInfo> joblist = new TreeSet<DisplayInfo>((Comparator<DisplayInfo>)new CompareDisplayInfoObjects());
        ArrayList<JFJob> jobs = new ArrayList<JFJob>();
        try {
            JFJob flow = null;
            String strSelect = "<XMLSELECT search=\"*[@Id='" + flowId + "']\" />" + "<Templates><JFJob><TargetSpecifications/><Properties/><Trees/></JFJob></Templates>";
            MdFactory factory = store.getFactory();
            List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8588, strSelect);
            if (list.size() > 0) {
                flow = (JFJob)list.get(0);
                TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
                for (TransformationStep step : activity.getSteps()) {
                    if (step instanceof SyncStep) continue;
                    try {
                        JFJob jfjob = (JFJob)step.getTransformations().get(0);
                        String role = jfjob.getTransformRole();
                        if (role.compareTo("SCHEDULER_FLOW_DELETE") == 0 || role.compareTo("SCHEDULER_JOB_DELETE") == 0) continue;
                        step.setName(JobEvent.getName((JFJob)jfjob));
                        jobs.add(jfjob);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {}
                }
                int numRules = filter.getRuleCount();
                block63: for (int n = 0; n < numRules; ++n) {
                    FilterRule rule = filter.getRule(n);
                    String column = rule.getColumnName();
                    int columnID = JobColumnSelectorModel.getColumnKeyFromName((String)column);
                    switch (columnID) {
                        case 0: {
                            JFJob job;
                            int x;
                            block64: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getName().compareTo(rule.getValue()) == 0) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 3: {
                                        if (job.getName().indexOf(rule.getValue()) >= 0) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 1: {
                                        if (job.getName().startsWith(rule.getValue())) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 2: {
                                        if (job.getName().endsWith(rule.getValue())) continue block64;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 2: {
                            Date server;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                server = DeployedJob.getDateCreated((JFJob)job);
                                if (ServerUtilities.matchTimeCriteria(server, rule)) continue;
                                jobs.remove(x);
                            }
                            continue block63;
                        }
                        case 3: {
                            Date server;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                server = DeployedJob.getDateModified((JFJob)job);
                                if (ServerUtilities.matchTimeCriteria(server, rule)) continue;
                                jobs.remove(x);
                            }
                            continue block63;
                        }
                        case 8: {
                            JFJob job;
                            int x;
                            block67: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getId().compareTo(rule.getValue()) == 0) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 3: {
                                        if (job.getId().indexOf(rule.getValue()) >= 0) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 1: {
                                        if (job.getId().startsWith(rule.getValue())) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 2: {
                                        if (job.getId().endsWith(rule.getValue())) continue block67;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 7: {
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                            }
                            continue block63;
                        }
                        case 1: {
                            JFJob job;
                            int x;
                            block69: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getId().compareTo(rule.getValue()) == 0) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 3: {
                                        if (job.getId().indexOf(rule.getValue()) >= 0) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 1: {
                                        if (job.getId().startsWith(rule.getValue())) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 2: {
                                        if (job.getId().endsWith(rule.getValue())) continue block69;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 4: {
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    String bserverName = DeployedJob.getBatchServer((JFJob)job).getName();
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (bserverName.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (bserverName.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (bserverName.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (bserverName.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                        case 5: {
                            continue block63;
                        }
                        case 6: {
                            String username;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    username = DeployedJob.getRunAs((Root)job);
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (username.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (username.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (username.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (username.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                        case 9: {
                            String username;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    username = DeployedJob.getResponsiblePartyForDeployment((JFJob)job);
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (username.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (username.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (username.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (username.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                    }
                }
            }
        }
        catch (MdException mde) {
            jobs = new ArrayList();
        }
        for (int x = 0; x < jobs.size(); ++x) {
            JobInfo info;
            block79: {
                JFJob job = (JFJob)jobs.get(x);
                if (job.getTransformRole().equalsIgnoreCase("SCHEDULER_FLOW")) {
                    FlowInfo info2;
                    block78: {
                        DeployedFlow sflow = new DeployedFlow(job, (MdObjectStore)store);
                        info2 = null;
                        try {
                            info2 = sflow.getInfo();
                        }
                        catch (SchedulerException ex) {
                            info2 = new FlowInfo(job.getName(), null, null);
                            info2.setDescription(job.getDesc());
                            info2.setId(job.getFQID());
                            Tree folder = DeployedJob.getFolder((JFJob)job);
                            if (folder == null) break block78;
                            info2.setLocation(MetaUtilities.getFolderLocation((Tree)folder));
                            info2.setLocationId(folder.getId());
                        }
                    }
                    joblist.add((DisplayInfo)info2);
                    continue;
                }
                if (!job.getTransformRole().equalsIgnoreCase("SCHEDULER_JOB")) continue;
                info = null;
                try {
                    DeployedJob djob = new DeployedJob(job);
                    djob.checkJCLGeneration();
                    info = djob.getInfo();
                }
                catch (Exception ex) {
                    Tree folder;
                    ServerComponent batchserver = CommandUtilities.getServerComponentForJob((JFJob)job);
                    BatchServerInfo bsinfo = MetaUtilities.getBatchServer((ServerComponent)batchserver);
                    info = new JobInfo(job.getName(), job.getId(), bsinfo);
                    info.setDisplayOnly(true);
                    info.setDescription(job.getDesc());
                    info.setId(job.getFQID());
                    Date d = DeployedJob.getDateCreated((JFJob)job);
                    if (d != null) {
                        GregorianCalendar ccal = new GregorianCalendar();
                        ccal.setTime(d);
                        info.setCreationDateDataBinding((Calendar)ccal);
                    }
                    if ((d = DeployedJob.getDateModified((JFJob)job)) != null) {
                        GregorianCalendar mcal = new GregorianCalendar();
                        mcal.setTime(d);
                        info.setModifiedDateDataBinding((Calendar)mcal);
                    }
                    if ((folder = DeployedJob.getFolder((JFJob)job)) == null) break block79;
                    info.setLocation(MetaUtilities.getFolderLocation((Tree)folder));
                    info.setLocationId(folder.getId());
                }
            }
            joblist.add((DisplayInfo)info);
        }
        return joblist;
    }

    protected static IWorkspace getIWorkspace(UserContextInterface user, ServerUtilOMA server, SASAppServer appserver) throws SchedulerException, InvalidParameterException, RemoteException, CallbackCancelledException {
        try {
            ServerContext sc = server.getSASAppServer(appserver);
            TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection((ServerComponent)sc, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
            if (tcpip == null) {
                throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerUtilities.ErrorMsg.NoWorkspaceServer.fmt"), (Object)sc.getName()));
            }
            return IWorkspaceServer.checkConnectionToServer((UserContextInterface)user, (ServerComponent)sc, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    private static boolean matchLastExecutionCriteria(JFJob flow, MdObjectStore store, FilterRule rule) throws MdException, RemoteException {
        DeployedFlow dflow = new DeployedFlow(flow, store);
        SubmitFlow submitter = new SubmitFlow(dflow);
        boolean scheduled = dflow.isFlowSubmitted();
        if (scheduled) {
            String user = null;
            SealedString pass = null;
            PasswordAuthentication l = MetaUtilities.getLoginInformation((ServerComponent)dflow.getSchedulerComponent());
            if (l == null) {
                return false;
            }
            user = l.getUserName();
            pass = l.getPassword() != null ? new SealedString(l.getPassword()) : null;
            try {
                Date timestamp = submitter.getFinishTime(user, pass);
                if (!ServerUtilities.matchTimeCriteria(timestamp, rule)) {
                    return false;
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (GeneralSecurityException ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean setFactoryListener(ServerUtilitiesListener listener) {
        if (this.m_listener != null) {
            this.removeFactoryListener(this.m_listener);
        }
        this.m_listener = listener;
        if (this.m_defaultMdFactory != null) {
            if (!this.m_bListeningToFactory) {
                try {
                    String[] aryTypes = new String[]{"JFJob"};
                    this.m_defaultMdFactory.addMdFactoryListener((MdFactoryListener)this, aryTypes);
                    this.m_bListeningToFactory = true;
                }
                catch (RemoteException e) {
                    this.m_bListeningToFactory = false;
                }
            }
            return true;
        }
        return false;
    }

    public void removeFactoryListener(ServerUtilitiesListener listener) {
        if (this.m_listener != null && this.m_listener.equals(listener) && this.m_bListeningToFactory) {
            try {
                if (this.m_defaultMdStore != null && !this.m_defaultMdStore.isDisposed() && this.m_defaultMdFactory != null) {
                    this.m_defaultMdFactory.removeMdFactoryListener((MdFactoryListener)this);
                    this.m_bListeningToFactory = false;
                }
                this.m_listener = null;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void MdObjectsCreated(MdFactoryEvent evt) throws RemoteException {
        if (this.m_defaultMdStore == null) {
            return;
        }
        Map mapObject = evt.getObjectMap();
        if (mapObject == null) {
            return;
        }
        Object[] aryID = mapObject.keySet().toArray();
        for (int index = 0; index < aryID.length; ++index) {
            JFJob jfjob;
            String role;
            Root root;
            String strID = (String)aryID[index];
            String strType = (String)mapObject.get(strID);
            if (!strType.equalsIgnoreCase("JFJob")) continue;
            if (this.m_defaultMdStore.getObject(strID) == null) {
                try {
                    MetaUtilities.getJFJob((String)strID, (MdStore)this.m_defaultMdStore, (String)this.m_defaultMdRepositoryId);
                }
                catch (SchedulerException exc) {
                    exc.printStackTrace();
                    return;
                }
                catch (MdException e) {
                    e.printStackTrace();
                    return;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (this.m_listener == null || !((root = (Root)this.m_defaultMdStore.getObject(strID)) instanceof JFJob) || (role = (jfjob = (JFJob)root).getTransformRole()).compareTo("SCHEDULER_FLOW") != 0) continue;
            try {
                FlowInfo info = DeployedFlow.getInfo((JFJob)jfjob, (MdObjectStore)this.m_defaultMdStore, (boolean)true);
                EventObject obj = new EventObject(info);
                this.m_listener.ObjectsCreated(obj);
                continue;
            }
            catch (MdException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void MdObjectsDeleted(MdFactoryEvent evt) throws RemoteException {
        if (this.m_listener != null) {
            Map mapObject = evt.getObjectMap();
            if (mapObject == null) {
                return;
            }
            Object[] aryID = mapObject.keySet().toArray();
            for (int index = 0; index < aryID.length; ++index) {
                String strID = (String)aryID[index];
                String strType = (String)mapObject.get(strID);
                if (strID.indexOf(36) != -1 || strType != null && !strType.equalsIgnoreCase("JFJob")) continue;
                EventObject obj = new EventObject(strID);
                this.m_listener.ObjectsDeleted(obj);
            }
        }
    }

    public void MdObjectsModified(MdFactoryEvent evt) throws RemoteException {
        if (this.m_listener != null) {
            Map mapObject = evt.getObjectMap();
            if (mapObject == null) {
                return;
            }
            Object[] aryID = mapObject.keySet().toArray();
            for (int index = 0; index < aryID.length; ++index) {
                String strID = (String)aryID[index];
                String strType = (String)mapObject.get(strID);
                if (strID.indexOf(36) != -1 || strType != null && !strType.equalsIgnoreCase("JFJob")) continue;
                EventObject obj = new EventObject(strID);
                this.m_listener.ObjectsModified(obj);
            }
        }
    }
}

