/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.sas.filter.model.FilterSelector;
import com.sas.iom.SAS.IWorkspace;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;

public interface ServerUtilInterface {
    public void setPrompt(PromptCallbackInterface var1);

    public void secondaryInitialization(boolean var1, boolean var2, String var3, String var4);

    public void clearServerCaches();

    public void dispose();

    public SchedulerResultSet deployBatchJobs(DeployedJobInterface var1, ServerUtilities var2, UserContextInterface var3, DeployedJobCodeGenerationInterface var4);

    public SchedulerResultSet redeployBatchJobs(DeployedJobInterface var1, UserContextInterface var2, DeployedJobCodeGenerationInterface var3);

    public List<SchedulerServerInfo> getSchedulingServers(int var1);

    public Scheduler getSchedulingServer(SchedulerServerInfo var1) throws SchedulerException;

    public Scheduler getSchedulingServer(String var1) throws SchedulerException;

    public PasswordAuthentication getSchedulerLoginIdentity(SchedulerServerInfo var1) throws SchedulerException;

    public List<SASAppServer> getAppServersWithDeployedDirectories();

    public IWorkspace getIWorkspace(UserContextInterface var1, SASAppServer var2) throws SchedulerException, InvalidParameterException, CallbackCancelledException;

    public List<BatchServerInfo> getBatchServers(int var1, int var2);

    public SASAppServer getSASAppServerFromBatchServer(BatchServerInfo var1);

    public IWorkspace getWorkspaceServer(BatchServerInfo var1, UserContextInterface var2) throws SchedulerException, InvalidParameterException, CallbackCancelledException;

    public boolean isValidBatchServer(BatchServerInfo var1);

    public String getJCLDir(BatchServerInfo var1);

    public String getJCLTemplate(BatchServerInfo var1, UserContextInterface var2);

    public boolean isAllowPasswordCache();

    public boolean isFileSystemAccessible(SchedulerServerInfo var1);

    public IWorkspace checkConnectionToWorkspaceServer(BatchServerInfo var1, PromptCallbackInterface var2) throws InvalidParameterException, SchedulerException, CallbackCancelledException;

    public IWorkspace checkConnectionToWorkspaceServer(SchedulerServerInfo var1, PromptCallbackInterface var2) throws InvalidParameterException, SchedulerException, CallbackCancelledException;

    public IWorkspace checkConnectionToWorkspaceServer(UserContextInterface var1, SASAppServer var2) throws InvalidParameterException, SchedulerException, CallbackCancelledException;

    public IWorkspace makeConnectionToWorkspaceServer(SASAppServer var1, String var2, String var3) throws SchedulerException;

    public boolean updateSASAppServerDirectories(SASAppServer var1) throws SchedulerException;

    public boolean setDefaultSessionContext(SessionContextInterface var1);

    public String getUserID(UserContextInterface var1) throws SchedulerException;

    public String getFolderLocation(SASFolder var1);

    public SASFolder getFolder(String var1);

    public void setDefaultFolder(String var1);

    public SASFolder getMyFolder(UserContextInterface var1);

    public List<DirectoryInfo> getExistingDeploymentDirectories(BatchServerInfo var1);

    public FileInfo getSourceCodes(DisplayInfo var1);

    public String createFullPath(FileInfo var1, BatchServerInfo var2);

    public String uniqueName(String var1, String[] var2);

    public List<JobInfo> getAllJobsAndFlows(boolean var1);

    public List<JobInfo> getAllJobsAndFlowsByRoles(String var1, boolean var2);

    public List<ServerFlowInfo> getListOfFlows(ServerInfoInterface var1, ServerUtilities var2) throws SchedulerException;

    public DisplayInfo refresh(ServerInfoInterface var1) throws SchedulerException;

    public boolean resetFromInfo(ServerFlowInfo var1) throws SchedulerException;

    public Object generateAllInformation(ServerInfoInterface var1) throws SchedulerException;

    public Date getDateCreated(ServerInfoInterface var1);

    public String getDateCreatedStr(ServerInfoInterface var1, boolean var2);

    public Date getDateModified(ServerInfoInterface var1);

    public String getDateModifiedStr(ServerInfoInterface var1, boolean var2);

    public String errorConditions(ServerInfoInterface var1) throws SchedulerException;

    public void reevaluateErrors(ServerInfoInterface var1) throws SchedulerException;

    public void checkAssociatedInfoForErrors(ServerFlowInfo var1, ServerInfoInterface var2) throws SchedulerException;

    public boolean hasCriticalErrors(ServerFlowInfo var1) throws SchedulerException;

    public boolean isJobAssociatedError(ServerJobInfo var1) throws SchedulerException;

    public List<ServerFlowInfo> getFlows(FilterSelector var1, List<?> var2);

    public SortedSet<?> getFlowsFromRepository(int var1, boolean var2);

    public SortedSet<FlowInfo> getFlowsFromRepository(FilterSelector var1, boolean var2) throws SchedulerException;

    public List<FlowInfo> getFlowsByParty(String var1) throws SchedulerException;

    public List<FlowInfo> getSubmittedFlows(String var1, String var2, List<FlowInfo> var3) throws SchedulerException;

    public ServerFlowInfo getFlow(String var1, ServerUtilities var2);

    public FlowInfo createFlow(FlowInfo var1) throws SchedulerException;

    public boolean updateScheduler(SchedulerServerInfo var1) throws SchedulerException;

    public boolean updateDeployedFlow(ServerFlowInfo var1) throws SchedulerException;

    public boolean setSchedulerAfterConnection(ServerFlowInfo var1, Scheduler var2);

    public boolean removeFromFlow(ServerInfoInterface var1, ServerFlowInfo var2) throws SchedulerException;

    public boolean removeFromAllFlows(ServerInfoInterface var1) throws SchedulerException;

    public boolean updateTriggers(ServerFlowInfo var1) throws SchedulerException;

    public boolean commitFlowToStore(FlowInfo var1) throws SchedulerException;

    public SchedulerResultSet submitFlow(ServerFlowInfo var1, boolean var2, boolean var3) throws SchedulerException;

    public boolean deleteFlowFromMetadata(ServerFlowInfo var1);

    public boolean isUniqueFlow(String var1, String var2);

    public boolean fixUnableToDelete(ServerFlowInfo var1);

    public boolean checkWritePermission(SASFolder var1);

    public void checkCircularDependencies(FlowInfo var1, String var2) throws SchedulerException;

    public List<JobInfo> getDeployedJobs(List<?> var1) throws SchedulerException;

    public List<JobInfo> getDeployedJobs(List<?> var1, boolean var2) throws SchedulerException;

    public List<DisplayInfo> getJobsForFlow(FilterSelector var1, ServerFlowInfo var2, ServerUtilities var3);

    public List<JobInfo> getAvailableJobsSubflowsByLocation(String var1, List<DisplayInfo> var2);

    public void setJobListInFlow(FlowInfo var1);

    public ServerJobInfo getJob(String var1, ServerUtilities var2);

    public boolean doesJobExist(String var1, SASFolder var2) throws SchedulerException;

    public JobInfo createDeployedJob(String var1, BatchServerInfo var2, SASFolder var3, DisplayInfo var4, String var5, UserContextInterface var6) throws SchedulerException;

    public JobInfo createDataStepDeployedJob(String var1, BatchServerInfo var2, SASFolder var3, String var4, DirectoryInfo var5, UserContextInterface var6) throws SchedulerException;

    public JobInfo createDeployedJob(JobInfo var1, UserContextInterface var2) throws SchedulerException;

    public String getJobCommandline(JobInfo var1);

    public String resetCommandLine(ServerJobInfo var1, ServerFlowInfo var2);

    public void updateJobCommandline(JobInfo var1, String var2);

    public String getSourceFile(JobInfo var1);

    public String getLogfile(ServerJobInfo var1, ServerFlowInfo var2, IWorkspace var3) throws SchedulerException;

    public String getJCLFile(ServerJobInfo var1);

    public boolean isRedeployable(JobInfo var1, boolean var2);

    public boolean commitJobToStore(JobInfo var1, String var2) throws SchedulerException;

    public void updateDeployedJob(JobInfo var1, String var2) throws SchedulerException;

    public boolean deleteDeployedJobFromMetadata(String var1) throws SchedulerException;

    public void validateCmdlineForDeployedJobs();

    public List<DirectoryInfo> getDirectoriesFromServer(SASAppServer var1);

    public boolean isUniqueDirectory(String var1);

    public boolean okayToDeleteDirectory(DirectoryInfo var1);

    public boolean deleteDirectory(DirectoryInfo var1);

    public SortedSet<DisplayInfo> getNonAssociatedJobsFromRepository() throws SchedulerException;

    public SortedSet<DisplayInfo> getJobObjectsFromRepository() throws SchedulerException;

    public String XMLExport(IWorkspace var1, ServerFlowInfo var2, String var3, SASAppServer var4, DirectoryInfo var5) throws InvalidParameterException, SchedulerException, IOException;

    public FlowInfo XMLImport(IWorkspace var1, String var2, int var3) throws IOException, SchedulerException;

    public String SASExport(IWorkspace var1, ServerFlowInfo var2, String var3, SASAppServer var4, DirectoryInfo var5) throws InvalidParameterException, SchedulerException, IOException;

    public FlowInfo SASImport(IWorkspace var1, String var2, int var3) throws IOException, SchedulerException;

    public String CSVExport(IWorkspace var1, ServerFlowInfo var2, String var3, SASAppServer var4, DirectoryInfo var5) throws InvalidParameterException, SchedulerException, IOException;

    public FlowInfo CSVImport(IWorkspace var1, String var2, int var3) throws IOException, SchedulerException;
}

