/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.sas.filter.model.FilterSelector;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.lsf.JFHandler;
import com.sas.scheduler.model.lsf.JFJob;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.IconUtil;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerFlowInfo
extends DisplayInfo
implements ServerInfoInterface {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ServerFlowInfo.class);
    public FlowInfo m_info = null;
    private ServerUtilities m_serverUtil = null;
    private PromptCallbackInterface m_prompt = null;
    private boolean m_dirty = false;
    private int m_numJobs = -1;
    private Icon m_icon;
    private String m_lastExecuteStr = null;
    private Date m_lastExecuteObj = null;
    private String m_modifiedTimeStr = null;
    private Date m_modifiedTimeObj = null;
    private String m_createdTimeStr = null;
    private Date m_createdTimeObj = null;
    public transient Object m_object = null;
    public static final String NAMECHANGE_EVENT = "NAME";
    public static final String WRITE_EVENT = "WRITECHANGE";
    public static final String GATHER_FULL_METADATA = "GATHERMETADATA";
    private transient Root m_localJFJobObject;

    public ServerFlowInfo(FlowInfo info, ServerUtilities server, PromptCallbackInterface prompt) {
        super(info.getName(), info.getDescription(), info.getIconName());
        this.m_info = info;
        this.m_serverUtil = server;
        this.m_prompt = prompt;
        this.setId(info.getId());
        this.setLocation(info.getLocation());
        this.setDisplayOnly(info.isDisplayOnly());
        this.m_numJobs = info.isDisplayOnly() ? -1 : info.getJobs().size();
    }

    public ServerUtilities getServerUtil() {
        return this.m_serverUtil;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void delete() throws SchedulerException {
        this.m_serverUtil.deleteDeployedFlow(this.m_info.getId());
    }

    public void persist() throws SchedulerException {
        this.m_serverUtil.commitFlowToStore(this.m_info);
    }

    public Icon getIcon(int size) {
        return this.getIcon();
    }

    public boolean isDataGathered() {
        return this.m_object != null;
    }

    public List<FlowHistory> getHistory() throws RemoteException, SchedulerException {
        ArrayList<FlowHistory> returnList = new ArrayList<FlowHistory>();
        Scheduler scheduler = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
        List histories = scheduler.getFlowHistoryList(this.m_info);
        for (com.sas.scheduler.api.servers.FlowHistory item : histories) {
            FlowHistory record = new FlowHistory();
            record.setIdDataBinding((long)((int)item.getID()));
            Date date = item.getStartTime();
            if (date != null) {
                GregorianCalendar start = new GregorianCalendar();
                start.setTime(date);
                record.setStartTimeDataBinding((Calendar)start);
            }
            if ((date = item.getFinishTime()) != null) {
                GregorianCalendar finish = new GregorianCalendar();
                finish.setTime(date);
                record.setFinishTimeDataBinding((Calendar)finish);
            }
            record.setStateDataBinding(item.getState());
            record.setStatusDataBinding(item.getStatus());
            record.setInstanceNameDataBinding(item.getInstanceName());
            record.setFlowNameDataBinding(item.getFlowName());
            record.setSchedulerFlowNameDataBinding(item.getSchedulerFlowName());
            record.setErrorCodeDataBinding(item.getErrorCode());
            returnList.add(record);
        }
        return returnList;
    }

    public Icon getIcon() {
        this.m_icon = IconUtil.getIcon((String)FlowInfo.getIconName((boolean)this.isFlowSubmitted(), (boolean)this.hasErrors()));
        return this.m_icon;
    }

    public int getJobCount() {
        if (this.m_numJobs != -1) {
            return this.m_numJobs;
        }
        try {
            SortedSet<ServerInfoInterface> list = this.getListOfJobs(0);
            this.m_numJobs = list.size();
        }
        catch (RuntimeException rte) {
            rte.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return this.m_numJobs;
    }

    public String getLastExecutedDateTime(Locale locale) {
        return this.getLastExecutedDateTime(locale, "client", "", "", "", 9999, 25);
    }

    public String getLastExecutedDateTime(Locale locale, String timezone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) {
        if (this.m_lastExecuteStr != null) {
            return this.m_lastExecuteStr;
        }
        try {
            Date timestamp = this.getLastExecutedDateTime(timezone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow);
            if (timestamp == null) {
                this.m_lastExecuteStr = "";
            } else {
                DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, locale);
                String localetime = dateTime.format(timestamp);
                SimpleDateFormat javadate = new SimpleDateFormat();
                javadate.applyPattern("Z");
                this.m_lastExecuteStr = MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.LocalTimeFormatWithGMTOffset.fmt"), (Object)localetime, (Object)javadate.format(timestamp));
            }
        }
        catch (GeneralSecurityException ex) {
            this.m_lastExecuteStr = MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.Undetermined.fmt"), (Object)m_bundle.getString("ServerFlowInfo.UndeterminedReason.ScheduledByAnotherUser.txt"));
        }
        catch (SchedulerException ex) {
            this.m_lastExecuteStr = ex.getLocalizedMessage();
        }
        catch (InvalidParameterException ex) {
            String message = ex.getLocalizedMessage();
            this.m_lastExecuteStr = message.startsWith(m_bundle.getString("ServerFlowInfo.ERROR.PrefixTag.txt")) ? message : MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.Undetermined.fmt"), (Object)message);
        }
        catch (RuntimeException ex) {
            return "";
        }
        catch (RemoteException ex) {
            return "";
        }
        return this.m_lastExecuteStr;
    }

    public Date getLastExecutedDateTime() throws GeneralSecurityException, SchedulerException, InvalidParameterException, RemoteException {
        return this.getLastExecutedDateTime("client", "", "", "", 9999, 25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastExecutedDateTime(String timezone, String stdout, String stderr, String flowDefDir, int maxHistory, int maxHistoryPerFlow) throws GeneralSecurityException, SchedulerException, InvalidParameterException, RemoteException {
        if (this.m_lastExecuteObj != null) {
            return this.m_lastExecuteObj;
        }
        boolean scheduled = this.m_info.isFlowSubmitted();
        if (scheduled) {
            Scheduler sch = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
            if (sch == null) {
                throw new InvalidParameterException(m_bundle.getString("ServerFlowInfo.MissingSchedulerInfo.txt"));
            }
            if (!sch.isHistorySupported()) {
                throw new InvalidParameterException(m_bundle.getString("ServerFlowInfo.LastExecutedDateTime.ScheduleNotSupportHistory.txt"));
            }
            try {
                ServerFlowInfo serverFlowInfo = this;
                synchronized (serverFlowInfo) {
                    block19: {
                        if (!this.m_serverUtil.connectToSchedulingServer(this, timezone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow)) break block19;
                        long flowid = this.m_info.getScheduleID();
                        if (flowid == -2L) {
                            flowid = sch.getFlowInstance(this.m_info);
                        }
                        if (flowid == -1L) {
                            GeneralSecurityException ex = new GeneralSecurityException("Not Owner");
                            throw ex;
                        }
                        if (flowid == -2L) {
                            throw new SchedulerException(MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.Undetermined.fmt"), (Object)m_bundle.getString("ServerFlowInfo.UndeterminedReason.unknown.txt")));
                        }
                        this.m_info.setScheduleID(flowid);
                        Date date = this.m_lastExecuteObj = sch.getFinishTime(flowid);
                        return date;
                    }
                }
            }
            catch (Exception ex) {
                Logger LOGGER = LogManager.getLogger(ServerFlowInfo.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)ex.getStackTrace());
                }
            }
            finally {
                if (sch instanceof OSScheduler) {
                    sch.closeConnection();
                }
            }
        }
        return null;
    }

    public String getDateCreated(boolean localformat) {
        if (this.m_createdTimeStr == null) {
            this.m_createdTimeStr = this.m_serverUtil.getDateCreatedStr(this, localformat);
        }
        return this.m_createdTimeStr;
    }

    public Date getDateCreated() {
        if (this.m_createdTimeObj == null) {
            this.m_createdTimeObj = this.m_serverUtil.getDateCreated(this);
        }
        return this.m_createdTimeObj;
    }

    public String getDateModified(boolean localformat) {
        if (this.m_modifiedTimeStr == null) {
            this.m_modifiedTimeStr = this.m_serverUtil.getDateModifiedStr(this, localformat);
        }
        return this.m_modifiedTimeStr;
    }

    public Date getDateModified() {
        if (this.m_modifiedTimeObj == null) {
            this.m_modifiedTimeObj = this.m_serverUtil.getDateModified(this);
        }
        return this.m_modifiedTimeObj;
    }

    public boolean isHistorySupported() throws SchedulerException {
        Scheduler scheduler = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
        try {
            if (scheduler != null) {
                return scheduler.isHistorySupported();
            }
            return false;
        }
        catch (InvalidParameterException e) {
            SchedulerException se = new SchedulerException(e.toString());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public boolean isDependenciesEnabled() throws RemoteException, SchedulerException {
        Scheduler scheduler = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
        if (scheduler != null) {
            return scheduler.isDependenciesEnabled();
        }
        return false;
    }

    public boolean hasScheduler() {
        return this.m_info.getScheduler() != null;
    }

    public String getServerName() {
        block4: {
            if (this.m_info.getScheduler() != null) {
                return this.m_info.getScheduler().getName();
            }
            try {
                Scheduler scheduler = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
                if (scheduler != null) {
                    return scheduler.getName();
                }
            }
            catch (SchedulerException e) {
                if (!MetaUtilities.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return m_bundle.getString("ServerFlowInfo.SchedulerUnknown.txt");
    }

    public boolean setScheduler(SchedulerServerInfo scheduler) {
        try {
            Scheduler s = this.m_serverUtil.getSchedulingServer(scheduler);
            SchedulerServerInfo sinfo = null;
            if (s != null) {
                sinfo = s.getServerComponent();
            }
            this.m_info.setScheduler(sinfo);
            this.m_dirty = true;
            return true;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public String getApplicationName() {
        return "NOT IMPLEMENTED YET";
    }

    public String getUsername() {
        String username = null;
        if (this.isFlowSubmitted()) {
            username = this.m_info.getScheduledUser();
            if (username == null) {
                username = m_bundle.getString("ServerFlowInfo.UsernameUnknown.txt");
            }
        } else {
            username = "";
        }
        return username;
    }

    public boolean isFlowSubmitted() {
        return this.m_info.isFlowSubmitted();
    }

    public boolean verifyFlowSubmitted() throws SchedulerException {
        Scheduler sch = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
        return sch.verifyFlowScheduled(this.m_info);
    }

    public boolean removeFromScheduler() throws SchedulerException {
        int rc = this.m_serverUtil.removeScheduledFlow(this);
        return rc == 0;
    }

    public int removeFromScheduler2() throws SchedulerException {
        return this.m_serverUtil.removeScheduledFlow(this);
    }

    public boolean hasComplexDependencies(ServerJobInfo job) {
        DisplayInfo jobinfo = job.getJobInfo();
        if (jobinfo instanceof JobInfo) {
            return this.m_info.hasComplexDependencies((JobInfo)jobinfo);
        }
        return jobinfo instanceof FlowInfo;
    }

    public FlowInfo getInfo() {
        return this.m_info;
    }

    public boolean setEmailNotification(FlowInfo info) {
        if (info.emailNotificationLevel() != -1) {
            this.m_info.setEmailNotification(true, info.emailNotificationLevel(), info.emailAddress());
        } else {
            this.m_info.setEmailNotification(false, -1, null);
        }
        this.m_dirty = true;
        return true;
    }

    public boolean setCompletionLevel(FlowInfo info) {
        if (info.completionLevel() != 0) {
            this.m_info.setCompletion(true, info.completionLevel(), info.completionSelectedJobs());
        } else {
            this.m_info.setCompletion(false, 0, null);
        }
        try {
            this.m_info.setEndBehaviorDataBinding(info.getEndBehaviorDataBinding());
        }
        catch (NullPointerException npe) {
            this.m_info.setEndBehaviorDataBinding(Integer.valueOf(0));
        }
        try {
            this.m_info.setExitcodeBehaviorDataBinding(info.getExitcodeBehaviorDataBinding());
        }
        catch (NullPointerException npe) {
            this.m_info.setExitcodeBehaviorDataBinding(Integer.valueOf(0));
        }
        this.m_dirty = true;
        return true;
    }

    public boolean setExclusive(boolean value) {
        this.m_info.setExclusive(value);
        this.m_dirty = true;
        return true;
    }

    public boolean setSaveLayout(boolean value) {
        this.m_info.setSaveLayout(value);
        this.m_dirty = true;
        return true;
    }

    public boolean setJobDefaultEmailNotification(FlowInfo info) {
        if (info.jobDefaultEmailNotificationLevel() != -1) {
            this.m_info.setJobDefaultEmailNotification(true, info.jobDefaultEmailNotificationLevel(), info.jobDefaultEmailAddress());
        } else {
            this.m_info.setJobDefaultEmailNotification(false, -1, null);
        }
        this.m_dirty = true;
        return true;
    }

    public boolean setJobDefaultPriority(int priority) {
        this.m_info.setJobDefaultPriority(priority);
        this.m_dirty = true;
        return true;
    }

    public boolean setJobDefaultEnvironmentVariables(String vars) {
        this.m_info.setJobDefaultEnvironmentVariables(vars);
        this.m_dirty = true;
        return true;
    }

    public boolean setJobDefaultExceptionHandlers(String xml) {
        this.m_info.setJobDefaultExceptionHandlers(xml);
        this.m_dirty = true;
        return true;
    }

    public boolean resetPFD() {
        return this.m_info.setPFD(null);
    }

    public boolean resetJobInfo(JobInfo job) {
        for (DisplayInfo d : this.m_info.getJobs()) {
            String id;
            String jId = d.getId();
            if (jId.compareTo(id = job.getId()) != 0) continue;
            JobInfo j = (JobInfo)d;
            j.setBatchServer(job.getBatchServer());
            j.setJob(job.getJob());
            j.setOriginalSourceFileDataBinding(job.getOriginalSourceFileDataBinding());
            j.setSourceDir(job.getSourceDir());
            j.setSourceFile(job.getSourceFile());
            j.setCommandLine(job.getCommandLine(), job.getRawCommandLine(), job.isCommandLineDerived());
            j.setDescription(job.getDescription());
            j.setDisplayOnly(job.isDisplayOnly());
            j.setJobArgs(job.getJobArgs());
            j.setEncodedArgs(job.getEncodedArgs());
            j.setJCL(job.getJCL());
            j.setResponsiblePartyDataBinding(job.getResponsiblePartyDataBinding());
            j.setLocation(job.getLocation());
            j.setSchedulerProperties(job.getSchedulerProperties());
            j.setSchedulerResources(job.getSchedulerResources());
            j.setUserId(job.getUserId());
            return true;
        }
        return false;
    }

    public boolean reset(FlowInfo info) throws RemoteException {
        if (info.getId().compareToIgnoreCase(this.getId()) == 0) {
            this.setName(info.getName());
            this.setDescription(info.getDescription());
            this.m_info = info;
            this.m_numJobs = info.isDisplayOnly() ? -1 : info.getJobs().size();
            this.m_dirty = false;
            this.m_info.resetDirty(this.m_info.getId());
            return true;
        }
        return false;
    }

    public boolean resetInfo(FlowInfo info) throws SchedulerException {
        if (info.getId().compareToIgnoreCase(this.getId()) == 0) {
            this.setName(info.getName());
            this.setDescription(info.getDescription());
            this.m_info = info;
            this.m_numJobs = info.isDisplayOnly() ? -1 : info.getJobs().size();
            this.m_dirty = true;
            try {
                if (this.m_object != null) {
                    if (MetaUtilities.isDebug()) {
                        System.out.println("Resetting flow from information.");
                    }
                    return this.m_serverUtil.resetFromInfo(this);
                }
                this.generateAllInformation(true);
                return this.commitChangesToOMR();
            }
            catch (SchedulerException se) {
                this.m_object = null;
                throw se;
            }
            catch (RemoteException re) {
                this.m_object = null;
                SchedulerException se = new SchedulerException(re.getLocalizedMessage());
                se.initCause((Throwable)re);
                throw se;
            }
        }
        this.m_info.resetDirty(this.m_info.getId());
        this.m_dirty = false;
        return false;
    }

    public Boolean generateAllInformation(boolean always) throws RemoteException, SchedulerException {
        if (!this.m_dirty && !always && this.m_object != null) {
            return true;
        }
        this.m_object = this.m_serverUtil.generateAllInformation(this);
        return this.m_object != null;
    }

    public List<ServerFlowInfo> getListOfFlows() throws SchedulerException {
        return this.m_serverUtil.getListOfFlows(this);
    }

    public List<SchedulerServerInfo> getListOfSchedulers() throws RemoteException {
        ArrayList<SchedulerServerInfo> list = new ArrayList<SchedulerServerInfo>();
        for (SchedulerServerInfo sinfo : this.m_serverUtil.getSchedulingServers(100)) {
            list.add(sinfo);
        }
        return list;
    }

    public SortedSet<ServerInfoInterface> getListOfJobs(int filter) throws RemoteException, SchedulerException {
        ArrayList<DisplayInfo> returnList = new ArrayList<DisplayInfo>();
        this.generateAllInformation(false);
        Vector<DisplayInfo> infoList = new Vector<DisplayInfo>();
        List list = this.m_info.getJobs();
        for (DisplayInfo obj : list) {
            if (obj instanceof FlowInfo) {
                FlowInfo subflow = (FlowInfo)obj;
                infoList.add((DisplayInfo)subflow);
                ServerFlowInfo flow = new ServerFlowInfo(subflow, this.m_serverUtil, this.m_prompt);
                if (flow.hasErrors()) {
                    this.m_serverUtil.checkAssociatedInfoForErrors(this, flow);
                }
                returnList.add(flow);
                continue;
            }
            if (!(obj instanceof JobInfo)) continue;
            JobInfo job = (JobInfo)obj;
            if (job.isSubflow()) {
                FlowInfo subflow = new FlowInfo();
                subflow.setName(job.getName());
                subflow.setId(job.getId());
                subflow.setLocation(job.getLocation());
                infoList.add((DisplayInfo)job);
                ServerFlowInfo flow = new ServerFlowInfo(subflow, this.m_serverUtil, this.m_prompt);
                if (flow.hasErrors()) {
                    this.m_serverUtil.checkAssociatedInfoForErrors(this, flow);
                }
                returnList.add(flow);
                continue;
            }
            infoList.add(obj);
            ServerJobInfo jobinfo = new ServerJobInfo(obj, this, this.m_serverUtil);
            if (job.hasErrors()) {
                this.m_serverUtil.checkAssociatedInfoForErrors(this, jobinfo);
            }
            returnList.add(jobinfo);
        }
        this.setJobs(infoList);
        TreeSet<ServerInfoInterface> jobList = new TreeSet<ServerInfoInterface>((Comparator<ServerInfoInterface>)new CompareDisplayInfoObjects());
        jobList.addAll(returnList);
        return jobList;
    }

    public boolean removeJob(ServerJobInfo job) {
        this.m_dirty = true;
        return this.m_info.removeJob((DisplayInfo)job);
    }

    public boolean removeJob(ServerFlowInfo subflow) {
        this.m_dirty = true;
        return this.m_info.removeJob((DisplayInfo)subflow);
    }

    public boolean remove(ServerFlowInfo flow) throws SchedulerException {
        return this.m_serverUtil.removeFromFlow(this, flow);
    }

    public void removeThisSubFlowFromAllFlows() throws SchedulerException {
        this.m_serverUtil.removeFromAllFlows(this);
    }

    public List<String> getQueues(SchedulerServerInfo sinfo) throws SchedulerException {
        Scheduler scheduler = this.m_serverUtil.getSchedulingServer(sinfo);
        return scheduler.getQueues();
    }

    public String getDefaultQueue() {
        return this.m_info.getSchedulerQueue();
    }

    public boolean setDefaultQueue(String queueName) {
        this.m_dirty = true;
        return this.m_info.setSchedulerQueue(queueName);
    }

    public void checkJobname(String jobname) throws InvalidParameterException {
        Scheduler scheduler = null;
        try {
            scheduler = this.m_serverUtil.getSchedulingServer(this.m_info.getScheduler());
        }
        catch (Exception x) {
            scheduler = null;
        }
        if (scheduler != null) {
            if (!scheduler.isValidJobName(jobname)) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.JobName.InvalidChars.Message.fmt"), (Object)jobname, (Object)scheduler.getInvalidChars(false));
                throw new InvalidParameterException(errorMessage);
            }
        } else if (!DeployedJob.isValidName((String)jobname)) {
            String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("ServerFlowInfo.JobName.InvalidChars.Message.fmt"), (Object)jobname, (Object)DeployedJob.getInvalidChars());
            throw new InvalidParameterException(errorMessage);
        }
    }

    public boolean updateTriggers() throws SchedulerException {
        boolean changed;
        String triggerType;
        String string = triggerType = this.m_info != null ? this.m_info.getTriggerType() : "";
        if (triggerType.compareTo("RunNow") != 0 && (changed = this.m_serverUtil.updateTriggers(this))) {
            try {
                return this.m_serverUtil.commitFlowToStore(this.m_info);
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public boolean commitChangesToOMR() {
        try {
            if (!this.m_dirty && this.m_info.isDirty()) {
                this.m_dirty = true;
            }
            if (this.m_dirty) {
                if (MetaUtilities.isDebug()) {
                    System.out.println("Changes detected in flow, saving changes.");
                }
                return this.m_serverUtil.commitFlowToStore(this.m_info);
            }
            if (MetaUtilities.isDebug()) {
                System.out.println("No changes detected in flow.");
            }
            return false;
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public void refreshIcon() {
        this.m_icon = null;
    }

    public void refresh() throws RemoteException, SchedulerException {
        this.m_icon = null;
        this.m_lastExecuteStr = null;
        this.m_lastExecuteObj = null;
        this.m_modifiedTimeStr = null;
        this.m_modifiedTimeObj = null;
        this.m_createdTimeStr = null;
        this.m_createdTimeObj = null;
        if (this.m_object != null) {
            this.m_info = (FlowInfo)this.m_serverUtil.refresh(this);
        }
        this.setName(this.m_info.getName());
        this.setDescription(this.m_info.getDescription());
        this.m_numJobs = this.m_info.isDisplayOnly() ? -1 : this.m_info.getJobs().size();
        this.m_info.resetDirty(this.m_info.getId());
    }

    public boolean areJobs() {
        List list = this.m_info.getJobs();
        return list == null ? true : list.size() > 0;
    }

    public List<DisplayInfo> getJobs() {
        return this.m_info.getJobs();
    }

    public List<String> getJobNames() {
        ArrayList<String> flowjoblist = new ArrayList<String>();
        for (DisplayInfo obj : this.getJobs()) {
            if (!(obj instanceof DisplayInfo)) continue;
            flowjoblist.add(obj.getName());
        }
        return flowjoblist;
    }

    public boolean addJob(ServerJobInfo job) throws RemoteException {
        boolean rc = true;
        this.m_info.addJob(job.getJobInfo());
        this.m_dirty = true;
        if (this.m_numJobs != -1) {
            ++this.m_numJobs;
        }
        return rc;
    }

    public boolean setJobs(List<DisplayInfo> jobs) {
        this.m_numJobs = jobs.size();
        this.m_dirty = true;
        return this.m_info.setJobs(jobs);
    }

    public List<?> getJobsForFlow(FilterSelector filter) {
        return this.m_serverUtil.getJobsForFlow(filter, this);
    }

    public boolean hasErrors() {
        try {
            this.m_serverUtil.reevaluateErrors(this);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        List list = this.m_info.getJobs();
        if (list != null) {
            for (Object obj : this.m_info.getJobs()) {
                FlowInfo sfinfo;
                JobInfo jinfo;
                if (!(obj instanceof JobInfo ? (jinfo = (JobInfo)obj).hasErrors() : obj instanceof FlowInfo && (sfinfo = (FlowInfo)obj).hasErrors())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCriticalErrors() {
        try {
            return this.m_serverUtil.hasCriticalErrors(this);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String errorConditions() {
        try {
            return this.m_serverUtil.errorConditions(this);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void reevaluateErrors() throws SchedulerException {
        this.m_icon = null;
        this.m_serverUtil.reevaluateErrors(this);
    }

    @Override
    public List<?> getPropertyTabs() {
        return null;
    }

    public JFJob getLSFJobFromPlatformPM(JobInfo job) throws SchedulerException {
        JFJob pmJFJob = new JFJob();
        SchedulerServerInfo scheduler = this.m_info.getScheduler();
        LSFScheduler sch = (LSFScheduler)this.m_serverUtil.getSchedulingServer(scheduler);
        com.platform.LSFJobFlow.api.JFJob lsfJFJob = sch.getJFJob(job, this.m_info);
        pmJFJob.setAttributes(lsfJFJob.getAttributes().toString());
        pmJFJob.setExecutionType(lsfJFJob.getExecutionType());
        com.platform.LSFJobFlow.api.JFHandler[] handlers = lsfJFJob.getHandlers();
        int count = handlers.length;
        ArrayList<JFHandler> pmHandlers = new ArrayList<JFHandler>();
        for (int i = 0; i < count; ++i) {
            com.platform.LSFJobFlow.api.JFHandler handler = handlers[i];
            JFHandler pmJFHandler = new JFHandler();
            pmJFHandler.setAction(handler.getAction());
            pmJFHandler.setDelay(handler.getDelay());
            pmJFHandler.setNumberRerun(handler.getNumberRerun());
            JFEvent event = handler.getEvent();
            com.sas.scheduler.model.lsf.JFEvent pmevent = new com.sas.scheduler.model.lsf.JFEvent();
            pmevent.setAttributes(event.getAttributes().toString());
            pmJFHandler.setEvent(pmevent);
            com.platform.LSFJobFlow.api.JFJob alarmjob = handler.getAlarmJob();
            JFJob ajob = new JFJob();
            ajob.setExecutionType(alarmjob.getExecutionType());
            ajob.setName(alarmjob.getName());
            ajob.setUserName(alarmjob.getUserName());
            ajob.setUserPassword(alarmjob.getUserPassword());
            pmJFHandler.setAlarmJob(ajob);
            pmHandlers.add(pmJFHandler);
        }
        pmJFJob.setName(lsfJFJob.getName());
        pmJFJob.setAttributes(lsfJFJob.getAttributes().toString());
        pmJFJob.setHandlers(pmHandlers);
        pmJFJob.setUserName(lsfJFJob.getUserName());
        pmJFJob.setUserPassword(lsfJFJob.getUserPassword());
        return pmJFJob;
    }

    public JobInfo setLSFJobFromPlatformPM(JobInfo job, JFJob pmJFJob) throws SchedulerException {
        SchedulerServerInfo scheduler = this.m_info.getScheduler();
        LSFScheduler sch = (LSFScheduler)this.m_serverUtil.getSchedulingServer(scheduler);
        com.platform.LSFJobFlow.api.JFJob lsfJFJob = sch.getJFJob(job, this.m_info);
        lsfJFJob.setExecutionType(pmJFJob.getExecutionType());
        lsfJFJob.setName(pmJFJob.getName());
        for (String attr : pmJFJob.getAttributes().split(";")) {
            int pos = attr.indexOf("=");
            String name = attr.substring(0, pos);
            String value = attr.substring(pos + 1);
            lsfJFJob.setAttribute(name, value);
        }
        lsfJFJob.setUserName(pmJFJob.getUserName());
        lsfJFJob.setUserPassword(pmJFJob.getUserPassword());
        List pmHandlers = pmJFJob.getHandlers();
        int count = pmHandlers.size();
        for (int i = 0; i < count; ++i) {
            JFHandler pmJFHandler = (JFHandler)pmHandlers.get(i);
            com.platform.LSFJobFlow.api.JFHandler handler = new com.platform.LSFJobFlow.api.JFHandler();
            try {
                handler.setAction(pmJFHandler.getAction());
            }
            catch (JFException e) {
                e.printStackTrace();
            }
            handler.setDelay(pmJFHandler.getDelay());
            handler.setNumberRerun(pmJFHandler.getNumberRerun());
            com.sas.scheduler.model.lsf.JFEvent pmevent = pmJFHandler.getEvent();
            JFJobEvent event = new JFJobEvent();
            for (String attr : pmevent.getAttributes().split(";")) {
                int pos = attr.indexOf("=");
                String name = attr.substring(0, pos);
                String value = attr.substring(pos + 1);
                event.setAttribute(name, value);
            }
            handler.setEvent((JFEvent)event);
            JFJob alarmjob = pmJFHandler.getAlarmJob();
            com.platform.LSFJobFlow.api.JFJob ajob = new com.platform.LSFJobFlow.api.JFJob();
            ajob.setExecutionType(alarmjob.getExecutionType());
            ajob.setName(alarmjob.getName());
            ajob.setUserName(alarmjob.getUserName());
            ajob.setUserPassword(alarmjob.getUserPassword());
            try {
                handler.setAlarmJob(ajob);
            }
            catch (JFException e) {
                e.printStackTrace();
            }
            lsfJFJob.addHandler(handler);
        }
        JobInfo info = this.m_info.getJob(job.getId());
        info.setSchedulerProperties(lsfJFJob.generateDefinition());
        this.m_dirty = true;
        return info;
    }

    @Override
    public Root getMetadataObject(ServerUtilities serverUtil) {
        try {
            if (this.m_localJFJobObject == null || this.m_localJFJobObject.getObjectStore() == null) {
                com.sas.metadata.remote.JFJob jfjob = this.getDeployedFlow().getMetadataObject();
                this.m_localJFJobObject = MetaUtilities.createNewEditableObject((Root)jfjob, (MdObjectStore)((MdObjectStore)jfjob.getObjectStore()));
            }
        }
        catch (MdException ex) {
            this.m_localJFJobObject = null;
        }
        catch (RemoteException ex) {
            this.m_localJFJobObject = null;
        }
        catch (RuntimeException ex) {
            this.m_localJFJobObject = null;
        }
        return this.m_localJFJobObject;
    }

    public void addMetaDataListener(MdObjectListener mol) throws RemoteException {
        this.m_localJFJobObject.addMdObjectListener(mol);
    }

    public List<JFHandler> getFlowHandlersFromPlatformPM() throws SchedulerException {
        ArrayList<JFHandler> pmHandlers = new ArrayList<JFHandler>();
        try {
            com.sas.metadata.remote.JFJob jfjob = MetaUtilities.getJFJob((String)this.m_info.getId());
            String xml = DeployedFlow.getExceptionHandlers((com.sas.metadata.remote.JFJob)jfjob);
            SchedulerServerInfo scheduler = this.m_info.getScheduler();
            LSFScheduler sch = (LSFScheduler)this.m_serverUtil.getSchedulingServer(scheduler);
            com.platform.LSFJobFlow.api.JFHandler[] handlers = sch.getFlowHandlers(xml);
            int count = handlers != null ? handlers.length : 0;
            for (int i = 0; i < count; ++i) {
                com.platform.LSFJobFlow.api.JFHandler handler = handlers[i];
                JFHandler pmJFHandler = new JFHandler();
                pmJFHandler.setAction(handler.getAction());
                pmJFHandler.setDelay(handler.getDelay());
                pmJFHandler.setNumberRerun(handler.getNumberRerun());
                JFEvent event = handler.getEvent();
                com.sas.scheduler.model.lsf.JFEvent pmevent = new com.sas.scheduler.model.lsf.JFEvent();
                pmevent.setAttributes(event.getAttributes().toString());
                pmJFHandler.setEvent(pmevent);
                pmHandlers.add(pmJFHandler);
            }
        }
        catch (SchedulerException ex) {
            ex.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return pmHandlers;
    }

    public boolean setFlowHandlersFromPlatformPM(List<JFHandler> pmhandlers) throws SchedulerException {
        try {
            SchedulerServerInfo scheduler = this.m_info.getScheduler();
            LSFScheduler sch = (LSFScheduler)this.m_serverUtil.getSchedulingServer(scheduler);
            int count = pmhandlers != null ? pmhandlers.size() : 0;
            com.platform.LSFJobFlow.api.JFHandler[] handlers = new com.platform.LSFJobFlow.api.JFHandler[count];
            for (int i = 0; i < count; ++i) {
                JFHandler pmJFHandler = pmhandlers.get(i);
                com.platform.LSFJobFlow.api.JFHandler handler = new com.platform.LSFJobFlow.api.JFHandler();
                handler.setAction(pmJFHandler.getAction());
                handler.setDelay(pmJFHandler.getDelay());
                handler.setNumberRerun(pmJFHandler.getNumberRerun());
                com.sas.scheduler.model.lsf.JFEvent pmevent = pmJFHandler.getEvent();
                JFFlowEvent event = new JFFlowEvent();
                for (String attr : pmevent.getAttributes().split(";")) {
                    int pos = attr.indexOf("=");
                    String name = attr.substring(0, pos);
                    String value = attr.substring(pos + 1);
                    event.setAttribute(name, value);
                }
                handler.setEvent((JFEvent)event);
                handlers[i] = handler;
            }
            String xml = sch.genFlowHandlersXML(handlers);
            this.m_dirty = true;
            com.sas.metadata.remote.JFJob jfjob = MetaUtilities.getJFJob((String)this.m_info.getId());
            DeployedFlow.setExceptionHandlers((com.sas.metadata.remote.JFJob)jfjob, (String)xml);
            jfjob.updateMetadataAll();
            return true;
        }
        catch (SchedulerException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (JFException e) {
            e.printStackTrace();
        }
        return false;
    }

    public DeployedFlow getDeployedFlow() {
        if (this.m_object == null) {
            try {
                this.generateAllInformation(true);
                DeployedFlow dflow = (DeployedFlow)this.m_object;
                this.m_info = dflow.getInfo();
                this.m_dirty = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (DeployedFlow)this.m_object;
    }
}

