/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.server;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.model.DeployedJobInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.JobDeployerInterface;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.ResourceBundle;

public class ServerDeployedJobUtilities
implements JobDeployerInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ServerDeployedJobUtilities.class);
    private ServerUtilities m_serverUtil;
    private PromptCallbackInterface m_prompt = null;
    private UserContextInterface m_userContext;
    private DeployedJobCodeGenerationInterface m_codegen = null;

    public ServerDeployedJobUtilities(ServerUtilities serverUtil, PromptCallbackInterface prompt, DeployedJobCodeGenerationInterface codegen, UserContextInterface userContext) {
        this.m_serverUtil = serverUtil;
        this.m_prompt = prompt;
        this.m_codegen = codegen;
        this.m_userContext = userContext;
    }

    public String createFullPath(String strDirectory, String strFilename, int host) {
        return CommandUtilities.createFullPath((String)strDirectory, (String)strFilename, (int)host);
    }

    public String createFullPath(FileInfo file, BatchServerInfo binfo) {
        return this.m_serverUtil.createFullPath(file, binfo);
    }

    public char getPathSeparator(int targetOS) {
        return CommandUtilities.getPathSeparator((int)targetOS);
    }

    public String makeValidFileName(String name) {
        return MetaUtilities.replaceInvalidCharactersInFileName((String)name);
    }

    public String normalizePath(String name, int targetOS) {
        return CommandUtilities.normalizePath((String)name, (int)targetOS);
    }

    public String uniqueName(String name, String[] files) {
        return this.m_serverUtil.uniqueName(name, files);
    }

    public List<?> getExistingDeploymentDirectories(BatchServerInfo batchserver) {
        return this.m_serverUtil.getExistingDeploymentDirectories(batchserver);
    }

    public SASFolder getFolder(String folderName) {
        return this.m_serverUtil.getFolder(folderName);
    }

    public FileInfo getSourceCodes(DisplayInfo job) {
        return this.m_serverUtil.getSourceCodes(job);
    }

    public boolean checkConnectionToWorkspaceServer(BatchServerInfo batchserver) {
        block8: {
            try {
                IWorkspace iworkspace = null;
                try {
                    iworkspace = this.m_serverUtil.getWorkspaceServer(batchserver, this.m_userContext);
                }
                catch (SchedulerException e) {
                    iworkspace = this.m_serverUtil.checkConnectionToWorkspaceServer(batchserver, this.m_prompt);
                }
                return iworkspace != null && batchserver.getConnectionId() != null;
            }
            catch (InvalidParameterException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (CallbackCancelledException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (SchedulerException e) {
                if (!MetaUtilities.isDebug()) break block8;
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getWorkspaceServerFromCache(BatchServerInfo bsinfo) {
        IWorkspace workspace = ServerUtilities.getWorkspaceServerFromCache(bsinfo);
        if (workspace != null) {
            return workspace.Name();
        }
        return null;
    }

    public void disconnectFromWorkspaceServer(BatchServerInfo binfo) {
        ServerUtilities.disconnectFromWorkspaceServer(binfo);
    }

    public String getJCLTemplate(BatchServerInfo batchserver) {
        return this.m_serverUtil.getJCLTemplate(batchserver);
    }

    public boolean updateSASAppServerDirectories(BatchServerInfo bs, List<DirectoryInfo> dirs) throws SchedulerException {
        try {
            SASAppServer server = this.m_serverUtil.getSASAppServerFromBatchServer(bs);
            server.setDirectoriesDataBinding(dirs);
            return this.m_serverUtil.updateSASAppServerDirectories(server);
        }
        catch (Exception ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public SchedulerResultSet deploy(DeployedJobInterface dialog) {
        SchedulerResultSet results = null;
        BatchServerInfo bsinfo = dialog.getBatchServer();
        if (bsinfo.getType() == 1) {
            results = this.m_serverUtil.deployBatchJobs(dialog, this.m_userContext, this.m_codegen);
        } else if (bsinfo.getType() == 2) {
            results = this.m_serverUtil.deployBatchJobs(dialog, this.m_userContext, this.m_codegen);
        }
        if (results != null && this.m_prompt != null) {
            this.m_prompt.showResults(dialog.getTitle(), results);
        }
        return results;
    }

    public SchedulerResultSet redeploy(DeployedJobInterface dialog) {
        SchedulerResultSet results = null;
        BatchServerInfo bsinfo = dialog.getBatchServer();
        if (bsinfo.getType() == 1) {
            results = this.m_serverUtil.redeployBatchJobs(dialog, this.m_userContext, this.m_codegen);
        } else if (bsinfo.getType() == 2) {
            results = this.m_serverUtil.redeployBatchJobs(dialog, this.m_userContext, this.m_codegen);
        }
        if (results != null && this.m_prompt != null) {
            this.m_prompt.showResults(dialog.getTitle(), results);
        }
        return results;
    }

    public static String GenerateJCLFromBatchServer(String filepath, String template, IFileService rio) throws RemoteException, GenericError {
        try {
            StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)template, (String)"", (String)"open_ed-1047", (int)2);
            return DataStepProgramDeployer.GenerateJCLFromTemplate((String)filepath, (String)contents.toString());
        }
        catch (GenericError ge) {
            GenericError neoGe = new GenericError(MetaUtilities.messageString((String)m_bundle.getString("ServerDeployedJobUtilities.ErrorMsg.JCLTemplateException.fmt"), (Object)ge.getLocalizedMessage()));
            neoGe.initCause((Throwable)ge);
            throw neoGe;
        }
    }

    public static String GenerateJCLFromBatchServer(String filename, String runas, String template, IFileService rio) throws RemoteException, GenericError {
        StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)template, (String)"", (String)"open_ed-1047", (int)2);
        template = DataStepProgramDeployer.GenerateJCLFromTemplate((String)filename, (String)contents.toString());
        return DataStepProgramDeployer.GenerateJCLFromTemplate((String)filename, (String)runas, (String)template);
    }
}

