/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;

class OSGiTokenizer {
    protected final CharSequence m_chars;
    private int m_pos;

    OSGiTokenizer(CharSequence chars) throws IllegalArgumentException {
        if (chars == null) {
            throw Util.illegalNull("chars");
        }
        this.m_chars = chars;
    }

    int getPos() {
        return this.m_pos;
    }

    void setPos(int pos) throws IllegalArgumentException {
        if (pos < 0) {
            throw Util.illegalNegative("pos", pos);
        }
        if (pos > this.m_chars.length()) {
            throw Util.illegalArgument("pos", new Integer(pos));
        }
        this.m_pos = pos;
    }

    boolean hasMore() {
        return this.m_pos < this.m_chars.length();
    }

    boolean scanToken() {
        int start;
        char c;
        int pos;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        for (pos = start = this.m_pos; pos < limit && ((c = chars.charAt(pos)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_'); ++pos) {
        }
        this.m_pos = pos;
        return pos > start;
    }

    String token() {
        int start = this.m_pos;
        if (!this.scanToken()) {
            return null;
        }
        return this.m_chars.subSequence(start, this.m_pos).toString();
    }

    boolean scanSymbolicName() {
        if (!this.scanToken()) {
            return false;
        }
        while (this.maybe('.')) {
            if (this.scanToken()) continue;
            return false;
        }
        return true;
    }

    String symbolicName() {
        int start = this.m_pos;
        if (!this.scanSymbolicName()) {
            return null;
        }
        return this.m_chars.subSequence(start, this.m_pos).toString();
    }

    boolean scanArgument() {
        return this.maybe('\"') ? this.scanFinishQuotedString() : this.scanToken();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean scanFinishQuotedString() {
        int pos = this.m_pos;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        if (pos >= limit) {
            return false;
        }
        boolean inEscape = false;
        while (pos < limit) {
            char c = chars.charAt(pos);
            if (c == '\u0000' || c == '\r' || c == '\n') {
                this.m_pos = pos;
                return false;
            }
            if (inEscape) {
                if (c != '\\' && c != '\"') {
                    this.m_pos = pos - 1;
                    return false;
                }
                inEscape = false;
            } else {
                if (c == '\"') {
                    this.m_pos = ++pos;
                    return true;
                }
                if (c == '\\') {
                    inEscape = true;
                }
            }
            ++pos;
        }
        this.m_pos = inEscape ? pos - 1 : pos;
        return false;
    }

    String argument() {
        return this.maybe('\"') ? this.finishQuotedString() : this.token();
    }

    /*
     * Unable to fully structure code
     */
    String finishQuotedString() {
        pos = this.m_pos;
        chars = this.m_chars;
        limit = chars.length();
        if (pos >= limit) {
            return null;
        }
        start = pos;
        value = null;
        inEscape = false;
        while (pos < limit) {
            block10: {
                c = chars.charAt(pos);
                if (c == '\u0000' || c == '\r' || c == '\n') {
                    this.m_pos = pos;
                    return null;
                }
                if (!inEscape) break block10;
                if (c != '\\' && c != '\"') {
                    this.m_pos = pos - 1;
                    return null;
                }
                if (!OSGiTokenizer.$assertionsDisabled && value == null) {
                    throw new AssertionError();
                }
                inEscape = false;
                ** GOTO lbl-1000
            }
            if (c == '\"') {
                this.m_pos = pos + 1;
                return (value != null ? value : chars.subSequence(start, pos)).toString();
            }
            if (c == '\\') {
                inEscape = true;
                if (value == null) {
                    value = new StringBuffer(chars.subSequence(start, pos).toString());
                }
            } else if (value != null) {
                value.append(c);
            }
            ++pos;
        }
        this.m_pos = inEscape != false ? pos - 1 : pos;
        return null;
    }

    boolean maybe(char c) {
        CharSequence chars = this.m_chars;
        if (this.m_pos < chars.length() && this.m_chars.charAt(this.m_pos) == c) {
            ++this.m_pos;
            return true;
        }
        return false;
    }

    void skipSpaces() {
        int pos;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        for (pos = this.m_pos; pos < limit && ' ' == chars.charAt(pos); ++pos) {
        }
        this.m_pos = pos;
    }

    void skipWhitespace() {
        int pos;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        for (pos = this.m_pos; pos < limit && Character.isWhitespace(chars.charAt(pos)); ++pos) {
        }
        this.m_pos = pos;
    }

    int read() {
        CharSequence chars = this.m_chars;
        if (this.m_pos >= chars.length()) {
            return -1;
        }
        return chars.charAt(this.m_pos++);
    }

    int peek() {
        CharSequence chars = this.m_chars;
        if (this.m_pos >= chars.length()) {
            return -1;
        }
        return chars.charAt(this.m_pos);
    }

    boolean skipChar() {
        if (++this.m_pos <= this.m_chars.length()) {
            return true;
        }
        --this.m_pos;
        return false;
    }

    boolean scanPath() {
        if (!this.hasMore()) {
            return false;
        }
        boolean quoted = this.maybe('\"');
        if (!this.scanPathUnquoted(quoted)) {
            return false;
        }
        return !quoted || this.maybe('\"');
    }

    private boolean scanPathUnquoted(boolean quoted) {
        int start = this.getPos();
        boolean startSep = this.maybe('/');
        if (!this.scanPathElement(quoted)) {
            return startSep && start + 1 == this.getPos();
        }
        while (this.maybe('/')) {
            if (this.scanPathElement(quoted)) continue;
            return false;
        }
        return true;
    }

    private boolean scanPathElement(boolean quoted) {
        char c;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        int pos = this.getPos();
        if (pos >= limit) {
            return false;
        }
        int start = pos;
        while (pos < limit && (c = chars.charAt(pos)) != '/' && c != '\\' && c != '\"' && c != '\r' && c != '\n' && c != '\u0000' && (quoted || c != ';' && c != ',')) {
            ++pos;
        }
        this.m_pos = pos;
        return pos > start;
    }

    String path() {
        int start = this.getPos();
        return this.scanPath() ? this.m_chars.subSequence(start, this.getPos()).toString() : null;
    }

    boolean scanLenientArgument() {
        if (this.maybe('\"')) {
            return this.scanFinishQuotedString();
        }
        this.skipSpaces();
        return this.scanLenientArgumentUnquoted();
    }

    private boolean scanLenientArgumentUnquoted() {
        char c;
        int pos;
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        int start = pos = this.getPos();
        int lastNonSpace = start - 1;
        while (pos < limit && (c = chars.charAt(pos)) != '\"' && c != '\\' && c != ';' && c != ',' && c != '\r' && c != '\n' && c != '\u0000') {
            if (c != ' ') {
                lastNonSpace = pos;
            }
            ++pos;
        }
        if (lastNonSpace < start) {
            return false;
        }
        this.m_pos = pos = lastNonSpace + 1;
        return pos > start;
    }

    String lenientArgument() {
        if (this.maybe('\"')) {
            return this.finishQuotedString();
        }
        int start = this.getPos();
        return this.scanLenientArgument() ? this.m_chars.subSequence(start, this.getPos()).toString() : null;
    }

    boolean scanFilterAttr() {
        char c;
        int pos;
        this.skipWhitespace();
        CharSequence chars = this.m_chars;
        int limit = chars.length();
        int start = pos = this.getPos();
        int lastNonSpace = start - 1;
        while (pos < limit && (c = chars.charAt(pos)) != '=' && c != '<' && c != '>' && c != '~' && c != '(' && c != ')') {
            if (!Character.isWhitespace(c)) {
                lastNonSpace = pos;
            }
            ++pos;
        }
        if (lastNonSpace < start) {
            return false;
        }
        this.m_pos = pos = lastNonSpace + 1;
        return pos > start;
    }

    String filterAttr() {
        this.skipWhitespace();
        int start = this.getPos();
        return this.scanFilterAttr() ? this.m_chars.subSequence(start, this.getPos()).toString() : null;
    }

    /*
     * Unable to fully structure code
     */
    String filterValue() {
        pos = this.m_pos;
        chars = this.m_chars;
        limit = chars.length();
        if (pos >= limit) {
            return null;
        }
        start = pos;
        value = null;
        inEscape = false;
        while (pos < limit) {
            block10: {
                c = chars.charAt(pos);
                if (!inEscape) break block10;
                if (c != '\\' && c != '*' && c != '(' && c != ')') {
                    this.m_pos = --pos;
                    return null;
                }
                if (!OSGiTokenizer.$assertionsDisabled && value == null) {
                    throw new AssertionError();
                }
                inEscape = false;
                ** GOTO lbl-1000
            }
            if (c == '*' || c == '(' || c == ')') {
                this.m_pos = pos;
                if (pos <= start) {
                    return null;
                }
                return (value != null ? value : chars.subSequence(start, pos)).toString();
            }
            if (c == '\\') {
                inEscape = true;
                if (value == null) {
                    value = new StringBuffer(chars.subSequence(start, pos).toString());
                }
            } else if (value != null) {
                value.append(c);
            }
            ++pos;
        }
        this.m_pos = inEscape != false ? pos - 1 : pos;
        return null;
    }
}

