/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.Serializable;

class NameVersion
implements Comparable,
Serializable {
    private static final long serialVersionUID = 6351099779026919737L;
    private final String m_name;
    private final VersionSpec m_version;
    private final int m_hashCode;
    private transient String m_versionString;

    static int maxNameMatchScore() {
        return 8;
    }

    static int scoreNameMatch(String filename, String idName, String version) {
        if (filename == null) {
            assert (false);
            return 0;
        }
        int n = idName.length();
        if (filename.startsWith(idName)) {
            if (filename.endsWith(version)) {
                if (filename.length() == n + version.length() + 1) {
                    char c = filename.charAt(n);
                    if (c == '_') {
                        return 8;
                    }
                    if (c == '-') {
                        return 7;
                    }
                }
                return 5;
            }
            if (filename.length() == n) {
                return 6;
            }
            return 4;
        }
        if (filename.endsWith(version)) {
            if (filename.length() == version.length()) {
                return 3;
            }
            return 2;
        }
        if (filename.indexOf(version) >= 0) {
            return 1;
        }
        return 0;
    }

    NameVersion(String idName, VersionSpec version) {
        if (idName == null) {
            assert (false);
            throw Util.illegalNull("idName");
        }
        if (idName.length() <= 0) {
            assert (false);
            throw Util.illegalArgument("idName.length()", idName.length());
        }
        if (version == null) {
            assert (false);
            throw Util.illegalNull("version");
        }
        if (version.isRange()) {
            assert (false);
            throw Util.illegalArgument("version.isRange()", Boolean.TRUE);
        }
        this.m_name = idName;
        this.m_version = version;
        int PRIME = 31;
        this.m_hashCode = 31 * (31 + idName.hashCode()) + version.hashCode();
    }

    public String getName() {
        return this.m_name;
    }

    public VersionSpec getVersion() {
        return this.m_version;
    }

    String getVersionString() {
        String rc = this.m_versionString;
        if (rc == null) {
            this.m_versionString = rc = this.m_version.toVersionString();
        }
        return rc;
    }

    int scoreNameMatch(String filename) {
        return NameVersion.scoreNameMatch(filename, this.m_name, this.getVersionString());
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object o) {
        VersionSpec aVersion;
        String aname;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NameVersion)) {
            return false;
        }
        NameVersion a = (NameVersion)o;
        String name = this.getName();
        if (name != (aname = a.getName()) && !name.equals(aname)) {
            return false;
        }
        VersionSpec version = this.getVersion();
        return version == (aVersion = a.getVersion()) || version.equals(aVersion);
    }

    public int compareTo(Object o) throws ClassCastException {
        String aname;
        NameVersion a = (NameVersion)o;
        if (a == null) {
            return -1;
        }
        String name = this.getName();
        int rc = name.compareToIgnoreCase(aname = a.getName());
        if (rc != 0) {
            return rc;
        }
        rc = name.compareTo(aname);
        if (rc != 0) {
            return rc;
        }
        VersionSpec version = this.getVersion();
        VersionSpec aVersion = a.getVersion();
        return -version.compareTo(aVersion);
    }
}

