/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.impl.JobImpl;
import com.sas.metadata.remote.impl.JobImpl_Stub;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepository;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.jobexecution.client.SASTaskInterface;
import com.sas.svcs.jobexecution.client.StoredProcessTaskMethodsInterface;
import com.sas.svcs.jobexecution.client.TaskInterface;
import com.sas.svcs.jobexecution.client.TaskType;
import com.sas.svcs.jobexecution.client.impl.SASTask;
import com.sas.svcs.jobexecution.client.impl.StoredProcessTask;
import com.sas.svcs.jobexecution.client.impl.Task;
import com.sas.svcs.jobexecution.metadata.JobAndTaskInterface;
import com.sas.svcs.jobexecution.metadata.TaskFilter;
import com.sas.svcs.jobexecution.metadata.i18n.RB;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobAndTask
extends Metadata
implements JobAndTaskInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String PUBLIC_TYPE_JOB = "Job.ExecutionService";
    public static final String PUBLIC_TYPE_TASK = "Task.ExecutionService";
    private static final long serialVersionUID = -1L;
    private static final String SAS_TASK_TYPE_NAME = "wks";
    private static final String STORED_PROCESS_TASK_TYPE_NAME = "stp";
    private static final String TASK_TYPE_PROPERTY_NAME = "Job Execution Service Task Type";
    private static final String SOURCE_METADATA_NAME = "Job Execution Service Task Source";
    private static final String ACTIVITY_METADATA_NAME = "Job Execution Service Activity";
    private static final String STEP_METADATA_NAME = "Job Execution Service Step";
    private static final String INPUT_METADATA_NAME = "Job Execution Service Input Parameters";
    private static final String OUTPUT_METADATA_NAME = "Job Execution Service Output Parameters";
    private static final String CONTROL_METADATA_NAME = "Job Execution Service Controls";
    private static final String INPUT_METADATA_ROLE = "input";
    private static final String OUTPUT_METADATA_ROLE = "output";
    private static final String CONTROL_METADATA_ROLE = "control";
    private static final String PARM_HOLDING_PROMPTS = "_JESInternalPrompts";
    private static final int INPUT_SET_INDEX = 0;
    private static final int OUTPUT_SET_INDEX = 1;
    private static final int CONTROL_SET_INDEX = 2;
    private static final String LINE_TERMINATOR_PATTERN = "\r\n|[\r\n\u2028\u2029\u0085]";

    public JobAndTask() throws RemoteException {
    }

    public JobAndTask(Job job) throws RemoteException {
        super((Object)job);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public JobAndTask(JobImpl job) throws RemoteException {
        super((Object)job);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public JobAndTask(JobImpl_Stub job) throws RemoteException {
        super((Object)job);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public JobAndTask(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (null == repos) {
            throw new IllegalArgumentException("repos is null");
        }
        if (null == name) {
            throw new IllegalArgumentException("name is null");
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            Job jobMetadata = (Job)omirepository.createMetadata(name, "Job");
            jobMetadata.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = jobMetadata;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                try {
                    parent.addItem((MetadataInterface)this);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, "Exception adding Job or Task named: " + name, JobAndTask.class.getName(), ex);
                }
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), JobAndTask.class.getName(), ex);
        }
    }

    public String getType() throws RemoteException {
        return null == this._repositoryObject ? null : ((PrimaryType)this._repositoryObject).getPublicType();
    }

    @Override
    public void setSource(String source, boolean isCreate) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        Job jobMetadata = (Job)this._repositoryObject;
        TextStore text = null;
        if (isCreate) {
            text = (TextStore)omirepository.createMetadata(SOURCE_METADATA_NAME, "TextStore");
            jobMetadata.setSourceCode((Text)text);
        } else {
            text = (TextStore)jobMetadata.getSourceCode();
        }
        text.setStoredText(source);
    }

    @Override
    public String getSource() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Job jobMetadata = (Job)this._repositoryObject;
        return ((TextStore)jobMetadata.getSourceCode()).getStoredText();
    }

    @Override
    public void setTaskType(TaskType taskType, boolean isCreate) throws RemoteException, MdException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        String taskTypeString = null;
        if (null == taskType) {
            if (this._repositoryObject != null) {
                PrimaryType primaryType = (PrimaryType)this._repositoryObject;
                primaryType.setPublicType(PUBLIC_TYPE_JOB);
            }
            return;
        }
        if (null != this._repositoryObject) {
            PrimaryType primaryType = (PrimaryType)this._repositoryObject;
            primaryType.setPublicType(PUBLIC_TYPE_TASK);
        }
        if (TaskType.SAS_CODE.equals((Object)taskType)) {
            taskTypeString = SAS_TASK_TYPE_NAME;
        } else if (TaskType.STORED_PROCESS.equals((Object)taskType)) {
            taskTypeString = STORED_PROCESS_TASK_TYPE_NAME;
        } else {
            throw new IllegalArgumentException("Task type " + taskType.getType() + " is not supported. Supported task types are: " + TaskType.SAS_CODE.getType() + " and " + TaskType.STORED_PROCESS.getType());
        }
        Job jobMetadata = (Job)this._repositoryObject;
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        AssociationList props = jobMetadata.getProperties();
        Property property2 = null;
        if (isCreate) {
            property2 = (Property)omirepository.createMetadata(TASK_TYPE_PROPERTY_NAME, "Property");
            props.add((Object)property2);
        } else {
            boolean taskTypeFound = false;
            for (Property property2 : props) {
                String propName = property2.getName();
                if (!propName.equals(TASK_TYPE_PROPERTY_NAME)) continue;
                taskTypeFound = true;
                break;
            }
            if (!taskTypeFound) {
                property2 = (Property)omirepository.createMetadata(TASK_TYPE_PROPERTY_NAME, "Property");
                props.add((Object)property2);
            }
        }
        property2.setDefaultValue(taskTypeString);
        if (isCreate) {
            AssociationList propertySets = jobMetadata.getPropertySets();
            PropertySet propSet = (PropertySet)omirepository.createMetadata(INPUT_METADATA_NAME, "PropertySet");
            propSet.setSetRole(INPUT_METADATA_ROLE);
            propertySets.add(0, (Object)propSet);
            propSet = (PropertySet)omirepository.createMetadata(OUTPUT_METADATA_NAME, "PropertySet");
            propSet.setSetRole(OUTPUT_METADATA_ROLE);
            propertySets.add(1, (Object)propSet);
            propSet = (PropertySet)omirepository.createMetadata(CONTROL_METADATA_NAME, "PropertySet");
            propSet.setSetRole(CONTROL_METADATA_ROLE);
            propertySets.add(2, (Object)propSet);
        }
    }

    @Override
    public TaskType getTaskType() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        String taskTypeString = null;
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList props = jobMetadata.getProperties();
        Property property2 = null;
        boolean taskTypeFound = false;
        for (Property property2 : props) {
            String propName = property2.getName();
            if (!propName.equals(TASK_TYPE_PROPERTY_NAME)) continue;
            taskTypeFound = true;
            break;
        }
        if (!taskTypeFound) {
            return null;
        }
        taskTypeString = property2.getDefaultValue();
        if (taskTypeString.indexOf(SAS_TASK_TYPE_NAME) != -1) {
            return TaskType.SAS_CODE;
        }
        if (taskTypeString.indexOf(STORED_PROCESS_TASK_TYPE_NAME) != -1) {
            return TaskType.STORED_PROCESS;
        }
        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"JobAndTask.illegalTaskTypeString.ex.fmt.txt", (Object)taskTypeString));
    }

    @Override
    public List<TaskInterface> getTasks() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList jobActivities = jobMetadata.getJobActivities();
        ArrayList<TaskInterface> taskList = new ArrayList<TaskInterface>(jobActivities.size());
        RepositoryInterface repos = this._repository;
        for (TransformationActivity activity : jobActivities) {
            String source;
            TransformationStep step = (TransformationStep)activity.getSteps().get(0);
            JobAndTaskInterface taskSmartObject = (JobAndTaskInterface)repos.factoryProcess(step.getTransformations().get(0));
            TaskType taskType = taskSmartObject.getTaskType();
            StoredProcessTask task = null;
            String publicName = null;
            Map<String, String[]> inputs = null;
            Set<String> outputs = null;
            Map<String, String[]> controls = null;
            Job taskMetadata = (Job)taskSmartObject.getRepositoryEntity();
            AssociationList taskActivities = taskMetadata.getJobActivities();
            if (taskActivities.size() > 0) {
                TransformationActivity taskActivity = (TransformationActivity)taskActivities.get(0);
                TransformationStep taskStep = (TransformationStep)taskActivity.getSteps().get(0);
                JobAndTaskInterface jobAndTaskInterface = (JobAndTaskInterface)repos.factoryProcess(taskStep.getTransformations().get(0));
                source = jobAndTaskInterface.getSource();
                publicName = jobAndTaskInterface.getIdentifier();
                inputs = jobAndTaskInterface.getParameters();
                outputs = jobAndTaskInterface.getOutputParameters();
                controls = jobAndTaskInterface.getControls();
                inputs.putAll(taskSmartObject.getParameters());
                outputs.addAll(taskSmartObject.getOutputParameters());
                controls.putAll(taskSmartObject.getControls());
            } else {
                source = taskSmartObject.getSource();
                inputs = taskSmartObject.getParameters();
                outputs = taskSmartObject.getOutputParameters();
                controls = taskSmartObject.getControls();
            }
            switch (taskType) {
                case SAS_CODE: {
                    SASTask sasTask = new SASTask(taskSmartObject.getName(), taskSmartObject.getDescription());
                    sasTask.setSASCode(source, LINE_TERMINATOR_PATTERN);
                    task = sasTask;
                    break;
                }
                case STORED_PROCESS: {
                    StoredProcessTask storedProcessTask = new StoredProcessTask(taskSmartObject.getName(), taskSmartObject.getDescription());
                    storedProcessTask.setStoredProcessPath(source);
                    task = storedProcessTask;
                    break;
                }
            }
            if (null == task) continue;
            if (publicName != null) {
                task.setPublicName(publicName);
            }
            HashMap<String, List<String>> parametersMap = new HashMap<String, List<String>>();
            for (Map.Entry entry : inputs.entrySet()) {
                if (((String)entry.getKey()).equals(PARM_HOLDING_PROMPTS)) {
                    task.setPromptValues(this.getPromptValuesFromXML(((String[])entry.getValue())[0]));
                    continue;
                }
                parametersMap.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
            task.setParameters(parametersMap);
            task.setOutputParameters(outputs);
            HashMap<String, List<String>> controlsMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, String[]> entry : controls.entrySet()) {
                controlsMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
            task.setControls(controlsMap);
            taskList.add((TaskInterface)task);
        }
        return taskList;
    }

    @Override
    public void setTasks(List<TaskInterface> taskList, UserContextInterface user) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        RepositoryInterface repos = this._repository;
        InformationServiceInterface infoService = OMIRepository.getInformationService();
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList jobActivities = jobMetadata.getJobActivities();
        if (null != jobActivities && !jobActivities.isEmpty()) {
            this.deleteTasks(jobActivities);
        }
        for (Task task : taskList) {
            JobAndTaskInterface taskSmartObject = (JobAndTaskInterface)infoService.newMetadata(null, task.getName(), repos, PUBLIC_TYPE_TASK);
            taskSmartObject.setDescription(task.getDescription());
            switch (task.getType()) {
                case SAS_CODE: {
                    taskSmartObject.setTaskType(TaskType.SAS_CODE, true);
                    break;
                }
                case STORED_PROCESS: {
                    taskSmartObject.setTaskType(TaskType.STORED_PROCESS, true);
                    break;
                }
            }
            String publicName = task.getPublicName();
            if (null != publicName) {
                JobAndTaskInterface publicTaskSmartObject = this.getTaskSmartObjectForID(publicName);
                if (null == publicTaskSmartObject) {
                    throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"JobAndTask.publicTaskNotFound.ex.fmt.txt", (Object)publicName));
                }
                TransformationActivity activity = null;
                TransformationStep step = null;
                Object var14_15 = null;
                activity = (TransformationActivity)repos.newMetadata(null, ACTIVITY_METADATA_NAME, "TransformationActivity").getRepositoryEntity();
                step = (TransformationStep)repos.newMetadata(null, STEP_METADATA_NAME, "TransformationStep").getRepositoryEntity();
                activity.getSteps().add((Object)step);
                AssociationList associationList = step.getTransformations();
                associationList.add(publicTaskSmartObject.getRepositoryEntity());
                Job taskMetadata = (Job)taskSmartObject.getRepositoryEntity();
                taskMetadata.getJobActivities().add((Object)activity);
                HashMap<String, String[]> parametersMap = new HashMap<String, String[]>();
                if (null != task.getPromptValues()) {
                    parametersMap.put(PARM_HOLDING_PROMPTS, new String[]{this.getXMLFromPromptValues(task.getPromptValues())});
                }
                for (Map.Entry entry : task.getParameters().entrySet()) {
                    parametersMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                }
                taskSmartObject.setParameters(this.mapDifference(parametersMap, publicTaskSmartObject.getParameters()));
                HashMap<String, String[]> controlsMap = new HashMap<String, String[]>();
                for (Map.Entry entry3 : task.getControls().entrySet()) {
                    controlsMap.put((String)entry3.getKey(), ((List)entry3.getValue()).toArray(new String[0]));
                }
                taskSmartObject.setControls(this.mapDifference(controlsMap, publicTaskSmartObject.getControls()));
                Set set = task.getOutputParameters();
                set.removeAll(publicTaskSmartObject.getOutputParameters());
                taskSmartObject.setOutputParameters(set);
            } else {
                String source = null;
                switch (task.getType()) {
                    case SAS_CODE: {
                        source = this.linesArrayToString(((SASTaskInterface)task).getSASCode());
                        break;
                    }
                    case STORED_PROCESS: {
                        source = ((StoredProcessTaskMethodsInterface)task).getStoredProcessPath();
                        break;
                    }
                }
                taskSmartObject.setSource(source, true);
                HashMap<String, String[]> parametersMap = new HashMap<String, String[]>();
                if (null != task.getPromptValues()) {
                    parametersMap.put(PARM_HOLDING_PROMPTS, new String[]{this.getXMLFromPromptValues(task.getPromptValues())});
                }
                for (Map.Entry entry : task.getParameters().entrySet()) {
                    parametersMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                }
                taskSmartObject.setParameters(parametersMap);
                HashMap<String, String[]> controlsMap = new HashMap<String, String[]>();
                for (Map.Entry entry : task.getControls().entrySet()) {
                    controlsMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                }
                taskSmartObject.setControls(controlsMap);
                taskSmartObject.setOutputParameters(task.getOutputParameters());
            }
            TransformationActivity activity = null;
            TransformationStep step = null;
            AssociationList transformations = null;
            activity = (TransformationActivity)repos.newMetadata(null, ACTIVITY_METADATA_NAME, "TransformationActivity").getRepositoryEntity();
            step = (TransformationStep)repos.newMetadata(null, STEP_METADATA_NAME, "TransformationStep").getRepositoryEntity();
            activity.getSteps().add((Object)step);
            transformations = step.getTransformations();
            transformations.add(taskSmartObject.getRepositoryEntity());
            jobMetadata.getJobActivities().add((Object)activity);
        }
    }

    @Override
    public Map<String, String[]> getParameters() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.getPropertyValues(0);
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.setPropertyValues(parameters, 0);
    }

    @Override
    public Map<String, String[]> getControls() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.getPropertyValues(2);
    }

    @Override
    public void setControls(Map<String, String[]> controls) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.setPropertyValues(controls, 2);
    }

    @Override
    public Set<String> getOutputParameters() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList propertySets = jobMetadata.getPropertySets();
        PropertySet propSet = (PropertySet)propertySets.get(1);
        AssociationList props = propSet.getSetProperties();
        HashSet<String> set = new HashSet<String>(props.size());
        for (Property prop : props) {
            set.add(prop.getName());
        }
        return set;
    }

    @Override
    public void setOutputParameters(Set<String> parameters) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList propertySets = jobMetadata.getPropertySets();
        PropertySet propSet = (PropertySet)propertySets.get(1);
        AssociationList props = propSet.getSetProperties();
        String item2 = null;
        for (String item2 : parameters) {
            Property prop = (Property)omirepository.createMetadata(item2, "Property");
            prop.setSQLType(12);
            props.add((Object)prop);
        }
    }

    @Override
    public Set<String> getContainingJobs() throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Job jobMetadata = null;
        Job taskMetadata = null;
        TransformationStep step2 = null;
        TransformationActivity activity = null;
        HashSet<String> jobSet = new HashSet<String>();
        taskMetadata = (Job)this._repositoryObject;
        AssociationList steps = taskMetadata.getSteps();
        for (TransformationStep step2 : steps) {
            activity = (TransformationActivity)step2.getActivities().get(0);
            taskMetadata = (Job)activity.getJobs().get(0);
            step2 = (TransformationStep)taskMetadata.getSteps().get(0);
            activity = (TransformationActivity)step2.getActivities().get(0);
            jobMetadata = (Job)activity.getJobs().get(0);
            String jobName = jobMetadata.getName();
            jobSet.add(jobName);
        }
        return jobSet;
    }

    private Map<String, String[]> getPropertyValues(int setIndex) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList propertySets = jobMetadata.getPropertySets();
        PropertySet propSet = (PropertySet)propertySets.get(setIndex);
        AssociationList props = propSet.getSetProperties();
        HashMap<String, String[]> map = new HashMap<String, String[]>(props.size());
        for (Property prop : props) {
            if (0 != prop.getDefaultValueState()) {
                map.put(prop.getName(), new String[]{prop.getDefaultValue()});
                continue;
            }
            AssociationList innerPropList = prop.getProperties();
            int length = innerPropList.size();
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                Property innerProp = (Property)innerPropList.get(i);
                values[i] = innerProp.getDefaultValue();
            }
            map.put(prop.getName(), values);
        }
        return map;
    }

    private void setPropertyValues(Map<String, String[]> parameters, int setIndex) throws RemoteException, ServiceException, MdException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        Job jobMetadata = (Job)this._repositoryObject;
        AssociationList propertySets = jobMetadata.getPropertySets();
        PropertySet propSet = (PropertySet)propertySets.get(setIndex);
        AssociationList props = propSet.getSetProperties();
        Map.Entry<String, String[]> entry2 = null;
        String[] values = null;
        int length = 0;
        this.deleteProperties(props);
        for (Map.Entry<String, String[]> entry2 : parameters.entrySet()) {
            values = entry2.getValue();
            length = values.length;
            if (0 >= length) continue;
            String propName = entry2.getKey();
            Property prop = (Property)omirepository.createMetadata(propName, "Property");
            prop.setSQLType(12);
            if (1 == length) {
                prop.setDefaultValue(values[0]);
            } else {
                AssociationList innerPropList = prop.getProperties();
                for (int i = 0; i < length; ++i) {
                    Property innerProp = (Property)omirepository.createMetadata(propName, "Property");
                    innerProp.setSQLType(12);
                    innerProp.setDefaultValue(values[i]);
                    innerPropList.add((Object)innerProp);
                }
            }
            props.add((Object)prop);
        }
    }

    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        Job jobMetadata = (Job)this._repositoryObject;
        try {
            Text sourceCode;
            AssociationList jobActivities = jobMetadata.getJobActivities();
            if (null != jobActivities && !jobActivities.isEmpty()) {
                this.deleteTasks(jobActivities);
            }
            if ((sourceCode = jobMetadata.getSourceCode()) != null) {
                omirepository.deleteEntity((CMetadata)sourceCode);
            }
            AssociationList propertySets = jobMetadata.getPropertySets();
            for (PropertySet propSet : propertySets) {
                AssociationList props = propSet.getSetProperties();
                this.deleteProperties(props);
            }
            omirepository.deleteEntities((List)propertySets);
        }
        catch (MdException ex) {
            throw new ServiceException((Throwable)ex, ex.getMessage());
        }
        super.delete();
    }

    private void deleteTasks(AssociationList jobActivities) throws ServiceException, RemoteException, MdException {
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        TaskType taskType = this.getTaskType();
        for (TransformationActivity activity : new ArrayList(jobActivities)) {
            AssociationList taskList;
            TransformationStep step = (TransformationStep)activity.getSteps().get(0);
            if (null == taskType && (taskList = step.getTransformations()).size() > 0) {
                JobAndTaskInterface taskSmartObject = (JobAndTaskInterface)omirepository.factoryProcess(taskList.get(0));
                taskSmartObject.delete();
            }
            omirepository.deleteEntity((CMetadata)step);
            omirepository.deleteEntity((CMetadata)activity);
        }
    }

    private void deleteProperties(AssociationList props) throws ServiceException, RemoteException, MdException {
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
        for (Property prop : props) {
            if (0 != prop.getDefaultValueState()) continue;
            AssociationList innerPropList = prop.getProperties();
            omirepository.deleteEntities((List)innerPropList);
        }
        omirepository.deleteEntities((List)props);
    }

    private Map<String, String[]> mapDifference(Map<String, String[]> privateMap, Map<String, String[]> publicMap) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Object[] values = null;
        for (Map.Entry<String, String[]> entry : privateMap.entrySet()) {
            String key = entry.getKey();
            values = entry.getValue();
            if (publicMap.containsKey(key) && Arrays.equals(values, publicMap.get(key))) continue;
            map.put(key, (String[])values);
        }
        return map;
    }

    private String linesArrayToString(List<String> linesArray) {
        String lines = null;
        if (linesArray != null) {
            StringBuilder stringBuilder = new StringBuilder(80 * linesArray.size());
            String lineSeparator = System.getProperty("line.separator");
            for (String logLine : linesArray) {
                stringBuilder.append(logLine).append(lineSeparator);
            }
            lines = stringBuilder.toString();
        }
        return lines;
    }

    private JobAndTaskInterface getTaskSmartObjectForID(String taskID) throws RemoteException, ServiceException {
        List tasks = this._repository.search((FilterInterface)new TaskFilter(taskID));
        return 1 == tasks.size() ? (JobAndTaskInterface)tasks.get(0) : null;
    }

    private PromptValuesInterface getPromptValuesFromXML(String xml) {
        PromptValuesInterface promptValues = null;
        if (xml != null) {
            try {
                PromptsReadingContext readingContext = PersistenceFactory.newReadingContext((LoggerFactoryInterface)new Log4JFactory2());
                StringReader rdr = new StringReader(xml);
                PersistenceInterface object = PromptUtil.newObjectFromXML((Reader)rdr, null, (PromptsReadingContext)readingContext);
                if (object instanceof PromptValuesInterface) {
                    promptValues = (PromptValuesInterface)object;
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return promptValues;
    }

    private String getXMLFromPromptValues(PromptValuesInterface promptValues) {
        String xml = null;
        if (promptValues != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                Document doc = documentBuilder.newDocument();
                PromptsWritingContext writingContext = PersistenceFactory.newWritingContext((PersistenceInterface)((PromptValues)promptValues), (LoggerFactoryInterface)new Log4JFactory2());
                Element element = ((AbstractPersistence)promptValues).write((Node)doc, (IntegratedWritingContext)writingContext);
                xml = XmlUtil.documentToString((Node)element);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return xml;
    }
}

