/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest.model;

import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.HistoryJsonDecorator;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.model.EnvironmentContext;
import com.sas.svcs.batch.rest.model.FormParams;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Service {
    private String method;
    private String relURL;
    private Map<String, String> headers = new HashMap<String, String>();
    private String requestBody;
    private FormParams formParams;
    private List<String> filterNode;
    private List<String> missingArg;
    private ResponseDecorator decorator = null;

    public void setMissingUtilityArgument(String missingArg) {
        if (this.missingArg != null && this.missingArg.size() > 0) {
            this.missingArg.add(missingArg);
        } else {
            this.missingArg = new ArrayList<String>();
            this.missingArg.add(missingArg);
        }
    }

    public List<String> getMissingUtilityArgument() {
        return this.missingArg;
    }

    public void setFilterNode(List<String> skipnode) {
        this.filterNode = skipnode;
    }

    public List<String> getFilterNode() {
        return this.filterNode;
    }

    public Service(String method, String serviceEndPoint) {
        this.method = method;
        this.relURL = serviceEndPoint;
    }

    public void setRequestBody(String body) {
        this.requestBody = body;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setForm(FormParams params) {
        this.formParams = params;
    }

    public FormParams getForm() {
        return this.formParams;
    }

    public String getRelURL() {
        return this.relURL;
    }

    @Deprecated
    public void setRelURL(String url) {
        this.relURL = url;
    }

    public String getURL() throws UnsupportedEncodingException {
        EnvironmentContext context = EnvironmentContextHolder.get();
        return context.getBaseURI() + "/" + this.getRelURL();
    }

    public void clearForm() {
        this.formParams.clear();
    }

    public boolean hasHeaders() {
        return this.headers != null && this.headers.size() > 0;
    }

    public boolean hasFormData() {
        return this.formParams != null;
    }

    public ResponseDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String key) {
        if (key.equalsIgnoreCase("HistoryDecorator")) {
            this.decorator = new HistoryJsonDecorator();
        }
    }

    public Map<String, List<String>> getOutputParams() {
        return null;
    }
}

