/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class RestUtil {
    public static final String UTF8_ENCODING = "UTF-8";
    private static final Logger logger = LogManager.getLogger(RestUtil.class);

    public static File LoadDataFile(String completepath) {
        File datafile = new File(completepath);
        if (datafile.exists()) {
            return datafile;
        }
        return null;
    }

    public static String getContent(File file) throws FileNotFoundException {
        String body = "";
        Scanner sc = new Scanner(file, UTF8_ENCODING);
        while (sc.hasNextLine()) {
            String str = sc.nextLine();
            body = body + str;
        }
        return body;
    }

    public static String getString(Map<String, String> map) {
        String strComplete = "";
        if (map.size() > 1) {
            logger.info(RB.getStringResource("RestUtil.RestUtil.IncorrectBody.txt"));
        } else {
            for (String key : map.keySet()) {
                strComplete = "{ \"" + key + "\" : \"" + map.get(key) + "\" }";
            }
        }
        return strComplete;
    }

    public static void writeFile(BasicResponse responsere, String name) throws IOException {
        File file = new File(name + ".json");
        OutputStreamWriter fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8_ENCODING);
        boolean success = responsere.getStatusCode() >= 200 && responsere.getStatusCode() < 300;
        String raw = responsere.getRawResponse();
        if (success && raw != null) {
            ObjectMapper mapper = new ObjectMapper();
            Object json = mapper.readValue(raw, Object.class);
            if (json instanceof Map) {
                ((Map)json).remove("links");
            }
            String pretty = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            fstream.write(pretty);
        }
        ((Writer)fstream).close();
        System.out.println(Message.format((String)RB.getStringResource("restUtil.json.output.file.path.fmt"), (Object)file.getCanonicalPath()));
    }

    public static Object getYamlObject(String path) throws FileNotFoundException {
        Object obj = null;
        File file = RestUtil.LoadDataFile(path);
        if (file != null && file.length() > 0L) {
            FileInputStream stream = new FileInputStream(file);
            Yaml yaml = new Yaml();
            obj = yaml.load((InputStream)stream);
        }
        return obj;
    }

    public static void PrintIterativeHAshMap(Map<String, String> hmmObj) {
        if (hmmObj.size() > 0) {
            Set<String> objectKeySet = hmmObj.keySet();
            for (String key : objectKeySet) {
                System.out.println("\t" + key + ":\t" + hmmObj.get(key));
            }
        }
    }

    public static boolean presentAndAccessible(String Configfile) {
        if (Configfile == null) {
            return false;
        }
        File file = new File(Configfile);
        return file.exists() && file.canRead();
    }

    public static String getConfigFileName(boolean isConfigurationFileExist, String configfile) {
        String strFileName = null;
        if (isConfigurationFileExist && configfile.lastIndexOf(File.separator) != -1) {
            strFileName = configfile.substring(configfile.lastIndexOf(File.separator) + 1, configfile.length());
        }
        return strFileName;
    }
}

