/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.RestUtil;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.Service;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonDecorator
implements ResponseDecorator {
    private static final Logger logger = LogManager.getLogger(ResponseDecorator.class);
    Stack<String> keyStack = new Stack();
    private List<String> filterNode;
    JsonParser jp;

    @Override
    public void decorate(BasicResponse response, Service service) throws Exception {
        this.filterNode = service.getFilterNode();
        JsonFactory f = new JsonFactory();
        this.jp = f.createJsonParser(response.getRawResponse());
        boolean cnt = false;
        JsonToken startToken = this.jp.nextToken();
        if (startToken != JsonToken.START_OBJECT) {
            logger.info(RB.getStringResource("JsonDecorator.root.object.error.txt"));
            return;
        }
        String strName = EnvironmentContextHolder.get().getConfigFileName().substring(0, EnvironmentContextHolder.get().getConfigFileName().indexOf("."));
        System.out.println(strName);
        while (startToken != JsonToken.END_OBJECT && startToken != null) {
            this.PrintOutput(startToken);
            startToken = this.jp.nextToken();
        }
        this.jp.close();
        RestUtil.writeFile(response, strName);
    }

    private void PrintErrorObject(JsonToken token) throws JsonProcessingException, IOException {
        if (token == JsonToken.START_OBJECT) {
            while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                String strToken = this.jp.getCurrentName();
                this.jp.nextValue();
                String strVal = this.jp.getText();
                if (strVal.endsWith(".txt") || strVal.endsWith(".fmt")) continue;
                System.out.println(strToken + " : " + strVal.trim());
            }
        }
    }

    private void PrintOutput(JsonToken token) throws JsonParseException, IOException {
        switch (token) {
            case START_OBJECT: {
                String FieldName = this.jp.getCurrentName();
                if (FieldName != null) {
                    this.keyStack.push(FieldName);
                    System.out.println(this.getTabsString() + this.getKeyFromStack());
                }
                this.startObjMethod();
                if (FieldName == null) break;
                System.out.print("\n");
                if (this.keyStack.isEmpty()) break;
                this.keyStack.pop();
                break;
            }
            case START_ARRAY: {
                this.parseArray();
                break;
            }
            case FIELD_NAME: {
                this.printFieldValue();
                break;
            }
            case END_ARRAY: {
                if (this.keyStack.isEmpty()) break;
                this.keyStack.pop();
                if (!this.keyStack.isEmpty()) {
                    String string = this.getTabsString();
                }
                this.jp.skipChildren();
                break;
            }
        }
    }

    private void printFieldValue() throws JsonParseException, IOException {
        String FieldName = this.jp.getCurrentName();
        String strTab = this.getTabsString();
        if (FieldName != null) {
            JsonToken chkToken = this.jp.nextToken();
            if (chkToken == JsonToken.START_OBJECT) {
                if (!(FieldName == null || this.filterNode != null && this.filterNode.contains(FieldName))) {
                    this.keyStack.push(FieldName);
                    System.out.println(strTab + this.getKeyFromStack());
                }
                this.startObjMethod();
                if (FieldName != null) {
                    System.out.print("\n");
                    if (!this.keyStack.isEmpty()) {
                        this.keyStack.pop();
                    }
                }
            } else if (chkToken == JsonToken.START_ARRAY) {
                boolean chkSkipNode = false;
                if (this.filterNode == null) {
                    chkSkipNode = true;
                } else if (!this.filterNode.contains(FieldName)) {
                    chkSkipNode = true;
                }
                if (chkSkipNode) {
                    this.keyStack.push(FieldName);
                    this.parseArray();
                } else {
                    this.jp.skipChildren();
                }
            } else if (!(chkToken == JsonToken.VALUE_NULL || this.filterNode != null && this.filterNode.contains(FieldName))) {
                String strVal = this.getKeyFromStack();
                String key = strVal + "/" + FieldName;
                String tab = this.getTabsString() + "\t";
                String curName = this.jp.getCurrentName();
                String nodeText = this.jp.getText();
                if (!nodeText.endsWith(".txt") && !nodeText.endsWith(".fmt")) {
                    System.out.println(tab + this.jp.getCurrentName() + ":\t" + this.jp.getText());
                }
            }
        }
    }

    private String getKeyFromStack() {
        String key = "";
        if (!this.keyStack.isEmpty()) {
            key = (String)this.keyStack.lastElement();
            return key;
        }
        return key;
    }

    private void startObjMethod() throws JsonParseException, IOException {
        JsonToken current = this.jp.nextToken();
        String strTab = this.getTabsString();
        while (current != JsonToken.END_OBJECT) {
            this.PrintOutput(current);
            current = this.jp.nextToken();
        }
        System.out.print("\n");
    }

    private void parseArray() throws JsonParseException, IOException {
        String strTab = this.getTabsString();
        System.out.println(strTab + this.getKeyFromStack());
        JsonToken token = this.jp.nextToken();
        if (token == JsonToken.START_OBJECT) {
            String FieldName = this.jp.getCurrentName();
            if (FieldName != null) {
                this.keyStack.push(FieldName);
                System.out.println(strTab + this.getKeyFromStack());
            }
            this.startObjMethod();
            if (FieldName != null) {
                System.out.print("\n");
                if (!this.keyStack.isEmpty()) {
                    this.keyStack.pop();
                }
            }
        } else if (token == JsonToken.VALUE_STRING) {
            System.out.print(strTab + "\t" + this.jp.getText());
            while (this.jp.nextToken() != JsonToken.END_ARRAY) {
                System.out.print(", " + this.jp.getText());
            }
            System.out.print("\n");
            if (!this.keyStack.isEmpty()) {
                this.keyStack.pop();
            }
        } else if (token == JsonToken.END_ARRAY) {
            if (!this.keyStack.isEmpty()) {
                this.keyStack.pop();
            }
        } else {
            System.out.println(strTab + this.getKeyFromStack());
        }
    }

    private String getTabsString() {
        String tab = "";
        if (!this.keyStack.isEmpty()) {
            for (int i = 0; i < this.keyStack.size(); ++i) {
                String temp = "\t";
                tab = tab + temp;
            }
        }
        return tab;
    }
}

