/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.util;

import com.sas.awt.util.Util;
import com.sas.geometry.Rectangles;
import com.sas.visuals.util.SizeConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class RubberBand
implements SizeConstraints {
    private int m_minWidth = 1;
    private int m_minHeight = 1;
    private int m_maxWidth = Integer.MAX_VALUE;
    private int m_maxHeight = Integer.MAX_VALUE;
    private boolean m_heightFixed;
    private boolean m_widthFixed;
    private boolean m_invertable;
    private boolean m_tracking;
    private boolean m_maintainAspectRatio;
    private Rectangle m_bounds = new Rectangle();
    private Point m_anchor = new Point();
    private Dimension m_offset = new Dimension();
    private Dimension m_initialSize = new Dimension();
    private Component m_component;
    private Tracker m_listener = new Tracker();
    private int m_constraints = 3;

    public void start(Component component, Rectangle initialBounds, Point point) {
        if (this.m_tracking) {
            throw new RuntimeException();
        }
        this.m_component = component;
        this.m_bounds.setBounds(initialBounds);
        this.m_initialSize.width = initialBounds.width;
        this.m_initialSize.height = initialBounds.height;
        this.m_anchor.x = initialBounds.x;
        this.m_anchor.y = initialBounds.y;
        if (point != null) {
            this.m_offset.width = point.x - Rectangles.getRight((Rectangle)initialBounds);
            this.m_offset.height = point.y - Rectangles.getBottom((Rectangle)initialBounds);
        } else {
            this.m_offset.width = 0;
            this.m_offset.height = 0;
        }
        this.m_component.addMouseMotionListener(this.m_listener);
        this.m_tracking = true;
        this.adjustBounds(point.x, point.y);
        Graphics g = null;
        if (g == null && (g = this.m_component.getGraphics()) == null) {
            return;
        }
        this.paint(g, this.m_bounds);
    }

    public void stop() {
        this.m_component.removeMouseMotionListener(this.m_listener);
        Graphics g = null;
        if (g == null && (g = this.m_component.getGraphics()) == null) {
            return;
        }
        this.paint(g, this.m_bounds);
        this.m_tracking = false;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_bounds);
    }

    public int getConstraints() {
        return this.m_constraints;
    }

    public Rectangle getInitialBounds() {
        return new Rectangle(this.m_anchor.x, this.m_anchor.y, this.m_initialSize.width, this.m_initialSize.height);
    }

    public int getMaximumHeight() {
        return this.m_maxHeight;
    }

    public int getMaximumWidth() {
        return this.m_maxWidth;
    }

    public int getMinimumHeight() {
        return this.m_minHeight;
    }

    public int getMinimumWidth() {
        return this.m_minWidth;
    }

    public boolean isRunning() {
        return this.m_tracking;
    }

    public boolean isInvertable() {
        return this.m_invertable;
    }

    protected void erase(Graphics g, Rectangle rect) {
        if (g == null && (g = this.m_component.getGraphics()) == null) {
            return;
        }
        Util.drawFocusRect(g, rect.x, rect.y, rect.width, rect.height);
    }

    protected void paint(Graphics g, Rectangle rect) {
        if (g == null && (g = this.m_component.getGraphics()) == null) {
            return;
        }
        Util.drawFocusRect(g, rect.x, rect.y, rect.width, rect.height);
    }

    public void setConstraints(int constraints) {
        this.m_constraints = constraints;
        if (constraints == 2) {
            this.m_heightFixed = true;
            this.m_widthFixed = true;
            this.m_maintainAspectRatio = false;
        } else if (constraints == 1) {
            this.m_heightFixed = true;
            this.m_widthFixed = false;
            this.m_maintainAspectRatio = false;
        } else if (constraints == 0) {
            this.m_widthFixed = true;
            this.m_heightFixed = false;
        } else if (constraints == 3) {
            this.m_heightFixed = false;
            this.m_widthFixed = false;
            this.m_maintainAspectRatio = false;
        } else if (constraints == 4) {
            this.m_heightFixed = false;
            this.m_widthFixed = false;
            this.m_maintainAspectRatio = true;
        }
    }

    public void setInvertable(boolean newValue) {
        this.m_invertable = newValue;
    }

    public void setMaximumHeight(int newHeight) {
        this.m_maxHeight = newHeight;
    }

    public void setMaximumWidth(int newWidth) {
        this.m_maxWidth = newWidth;
    }

    public void setMinimumHeight(int newHeight) {
        if (newHeight < 1) {
            newHeight = 1;
        }
        this.m_minHeight = newHeight;
    }

    public void setMinimumWidth(int newWidth) {
        if (newWidth < 1) {
            newWidth = 1;
        }
        this.m_minWidth = newWidth;
    }

    public void move(int x, int y) {
        Graphics g = this.m_component.getGraphics();
        if (g == null) {
            return;
        }
        this.erase(g, this.m_bounds);
        this.adjustBounds(x, y);
        this.paint(g, this.m_bounds);
    }

    protected void adjustBounds(int x, int y) {
        x -= this.m_offset.width;
        y -= this.m_offset.height;
        if (!this.m_widthFixed) {
            int newWidth;
            if (x < this.m_anchor.x && !this.m_invertable) {
                x = this.m_anchor.x;
            }
            if ((newWidth = Math.abs(x - this.m_anchor.x) + 1) < this.m_minWidth) {
                newWidth = this.m_minWidth;
                if (x < this.m_anchor.x) {
                    x = Math.min(x, this.m_anchor.x - this.m_minWidth + 1);
                }
            }
            if (newWidth > this.m_maxWidth) {
                newWidth = this.m_maxWidth;
            }
            this.m_bounds.x = x < this.m_anchor.x ? x : this.m_anchor.x;
            this.m_bounds.width = newWidth;
        }
        if (!this.m_heightFixed) {
            int newHeight;
            if (y < this.m_anchor.y && !this.m_invertable) {
                y = this.m_anchor.y;
            }
            if ((newHeight = Math.abs(y - this.m_anchor.y) + 1) < this.m_minHeight) {
                newHeight = this.m_minHeight;
                if (y < this.m_anchor.y) {
                    y = Math.min(y, this.m_anchor.y - this.m_minHeight + 1);
                }
            }
            if (newHeight > this.m_maxHeight) {
                newHeight = this.m_maxHeight;
            }
            this.m_bounds.y = y < this.m_anchor.y ? y : this.m_anchor.y;
            this.m_bounds.height = newHeight;
        }
    }

    private class Tracker
    implements MouseMotionListener {
        private Tracker() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Point p = me.getPoint();
            RubberBand.this.move(p.x, p.y);
        }
    }
}

