/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.adapters;

import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.lang.BooleanDataInterface;
import com.sas.util.Command;
import com.sas.util.CommandDispatcher;
import com.sas.util.CommandManager;
import com.sas.util.CommandsInterface;
import com.sas.util.ContextCommandsConsumerInterface;
import com.sas.util.ContextCommandsInterface;
import com.sas.util.MenuCommand;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class PopupMenuAdapter
implements MouseListener,
SupportsErrorHandlerInterface,
ContextCommandsConsumerInterface,
ContextCommandsInterface,
Serializable {
    static final long serialVersionUID = -2043108492555610492L;
    protected Component component;
    protected Object context;
    protected boolean popupMenuEnabled;
    protected boolean separatorsAdded;
    protected ErrorHandlerInterface errHandler;
    protected PopupMenu popupMenu;
    protected OrderedCollectionInterface commandProducers;

    public PopupMenuAdapter() {
        this.setDefaultValues();
    }

    public PopupMenuAdapter(Component comp) {
        this();
        this.setComponent(comp);
    }

    public PopupMenuAdapter(Component comp, ContextCommandsInterface[] producers) {
        this();
        this.setComponent(comp);
        if (producers != null) {
            for (int i = 0; i < producers.length; ++i) {
                this.addContextCommandsProducer(producers[i]);
            }
        }
    }

    public void setDefaultValues() {
        this.separatorsAdded = true;
        this.popupMenuEnabled = true;
    }

    public Object clone() throws CloneNotSupportedException {
        PopupMenuAdapter clone = new PopupMenuAdapter(null, this.getContextCommandsProducers());
        return clone;
    }

    public ContextCommandsInterface[] getContextCommandsProducers() {
        if (this.commandProducers == null) {
            return CommandManager.getEmptyContextCommandsInterfaceArray();
        }
        int count = this.commandProducers.count();
        ContextCommandsInterface[] producerArray = new ContextCommandsInterface[count];
        Enumeration producerEnum = this.commandProducers.getItems();
        for (int i = 0; i < count && producerEnum.hasMoreElements(); ++i) {
            producerArray[i] = (ContextCommandsInterface)producerEnum.nextElement();
        }
        return producerArray;
    }

    public void addContextCommandsProducer(ContextCommandsInterface producer) {
        if (this.commandProducers == null) {
            this.commandProducers = this.newCommandProducerList();
        }
        this.commandProducers.add((Object)producer);
    }

    public void removeContextCommandsProducer(ContextCommandsInterface producer) {
        if (this.commandProducers != null) {
            this.commandProducers.remove((Object)producer);
        }
    }

    public Command[] getContextCommands(Object context, int x, int y) {
        Object[] cmds;
        ContextCommandsInterface[] ccp = this.getContextCommandsProducers();
        Vector<Object> workVector = new Vector<Object>();
        for (int i = 0; i < ccp.length; ++i) {
            cmds = ccp[i].getContextCommands(context, x, y);
            if (cmds == null || cmds.length == 0) continue;
            if (workVector.size() != 0 && this.isSeparatorsAdded()) {
                workVector.addElement(MenuSeparatorCommand.instance());
            }
            for (int j = 0; j < cmds.length; ++j) {
                workVector.addElement(cmds[j]);
            }
        }
        if (workVector.size() == 0) {
            cmds = CommandManager.getEmptyCommandArray();
        } else {
            cmds = new Command[workVector.size()];
            workVector.copyInto(cmds);
        }
        return cmds;
    }

    public boolean isSeparatorsAdded() {
        return this.separatorsAdded;
    }

    public void setSeparatorsAdded(boolean addSeparators) {
        this.separatorsAdded = addSeparators;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getX(), event.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getX(), event.getY());
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component comp) {
        if (comp != this.component) {
            this.component = comp;
            this.connectPopupToComponent();
        }
    }

    protected void connectPopupToComponent() {
        Component comp;
        if (Beans.isDesignTime()) {
            return;
        }
        PopupMenu popMenu = this.getPopupMenu();
        MenuContainer popParent = popMenu.getParent();
        if (popParent != null) {
            popParent.remove(popMenu);
            if (popParent instanceof Component) {
                ((Component)popParent).removeMouseListener(this);
            }
        }
        if ((comp = this.getComponent()) != null) {
            comp.add(this.popupMenu);
            comp.removeMouseListener(this);
            comp.addMouseListener(this);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.connectPopupToComponent();
    }

    public void showPopupMenu(int x, int y) {
        Component comp = this.getComponent();
        if (comp == null || !this.isPopupMenuEnabled()) {
            return;
        }
        PopupMenu popMenu = this.getPopupMenu();
        popMenu.removeAll();
        this.populatePopupMenu(popMenu, x, y);
        popMenu.show(comp, x, y);
    }

    public void setPopupMenuEnabled(boolean enabled) {
        this.popupMenuEnabled = enabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public Object getContext() {
        if (this.context != null) {
            return this.context;
        }
        return this.getComponent();
    }

    public void setContext(Object cntxt) {
        this.context = cntxt;
    }

    protected void populatePopupMenu(PopupMenu popupMenu, int x, int y) {
        Object context = this.getContext();
        Command[] cmds = this.getContextCommands(context, x, y);
        this.populateMenu(popupMenu, cmds);
    }

    protected void populateMenu(Menu menu, Command[] cmds) {
        for (int i = 0; i < cmds.length; ++i) {
            MenuItem menuItem = this.newPopupMenuItem(cmds[i]);
            if (menuItem instanceof Menu && cmds[i] instanceof CommandsInterface) {
                this.populateMenu((Menu)menuItem, ((CommandsInterface)cmds[i]).getCommands());
            } else if (menuItem instanceof CheckboxMenuItem) {
                ((CheckboxMenuItem)menuItem).addItemListener(this.newCommandDispatcher(cmds[i]));
            } else {
                menuItem.addActionListener(this.newCommandDispatcher(cmds[i]));
            }
            menu.add(menuItem);
        }
    }

    protected PopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.newPopupMenu();
        }
        return this.popupMenu;
    }

    protected PopupMenu newPopupMenu() {
        return new PopupMenu();
    }

    protected CommandDispatcher newCommandDispatcher(Command command) {
        CommandDispatcher cmdDispatcher = new CommandDispatcher(command, this.getContext());
        cmdDispatcher.setErrorHandler(this.getErrorHandler());
        return cmdDispatcher;
    }

    protected OrderedCollectionInterface newCommandProducerList() {
        return new OrderedCollection();
    }

    protected MenuItem newPopupMenuItem(Command command) {
        String name = command.getText();
        MenuItem menuItem = null;
        menuItem = command instanceof CommandsInterface && ((CommandsInterface)command).getCommands() != null && ((CommandsInterface)command).getCommands().length > 0 ? new Menu(name) : (command instanceof BooleanDataInterface ? new CheckboxMenuItem(name, ((BooleanDataInterface)command).getBooleanData()) : (command instanceof MenuCommand && ((MenuCommand)command).isSeparator() ? new MenuItem("-") : new MenuItem(name)));
        menuItem.setEnabled(command.isExecutable());
        return menuItem;
    }

    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        this.errHandler = errorHandler;
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errHandler;
    }
}

