/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.Border;
import com.sas.visuals.BufferedGraphics;
import com.sas.visuals.VisualAspects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class Windows95Border
extends Border
implements VisualAspects {
    static final long serialVersionUID = -137736626883851960L;
    protected Component _component;

    public Windows95Border() {
        this(-1);
    }

    public Windows95Border(int s) {
        this(null, s);
    }

    public Windows95Border(Component component) {
        this(component, -1);
    }

    public Windows95Border(Component component, int s) {
        this.setStyle(s);
        this.setComponent(component);
    }

    public Windows95Border(Windows95Border border) {
        this.setStyle(border.getStyle());
        this.setComponent(border.getComponent());
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        this._component = component;
    }

    protected Color getBackground() {
        Component c = this.getComponent();
        if (c != null) {
            return c.getBackground();
        }
        return SystemColor.control;
    }

    protected Color getForeground() {
        Component c = this.getComponent();
        if (c != null) {
            return c.getForeground();
        }
        return SystemColor.controlText;
    }

    @Override
    public Insets getInsets(Component c) {
        return new Insets(this.getTopMargin(), this.getLeftMargin(), this.getBottomMargin(), this.getRightMargin());
    }

    @Override
    public void drawInRect(Graphics graphics, int x, int y, int width, int height) {
        this.drawInRect(this.getComponent(), graphics, x, y, width, height);
    }

    @Override
    public void drawInRect(Component component, Graphics graphics, int x, int y, int width, int height) {
        Component comp = this.getComponent();
        this.setComponent(component);
        Rectangle rectangle = new Rectangle(x, y, width, height);
        BufferedGraphics g = graphics instanceof BufferedGraphics ? (BufferedGraphics)graphics : new BufferedGraphics(graphics);
        Color c = g.getColor();
        g.setColor(this.getBackground());
        switch (this.getStyle()) {
            case 0: {
                g.drawBasicBorderRect(rectangle, 0);
                break;
            }
            case 1: 
            case 13: {
                g.drawBasicBorderRect(rectangle, 1);
                break;
            }
            case 2: 
            case 14: {
                g.drawBasicBorderRect(rectangle, 2);
                break;
            }
            case 3: {
                g.drawBasicBorderRect(rectangle, 3);
                break;
            }
            case 4: {
                g.drawWindowBorderRect(rectangle);
                break;
            }
            case 5: {
                g.drawButtonBorderRect(rectangle, 0);
                break;
            }
            case 6: {
                g.drawButtonBorderRect(rectangle, 1);
                break;
            }
            case 7: {
                g.drawButtonBorderRect(rectangle, 2);
                break;
            }
            case 8: {
                g.drawFieldBorderRect(rectangle);
                break;
            }
            case 9: {
                g.drawGroupBorderRect(rectangle);
                break;
            }
            case 10: {
                g.setColor(this.getForeground());
                g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 15: {
                g.drawStatusFieldBorderRect(rectangle);
                break;
            }
            case -1: {
                break;
            }
        }
        g.setColor(c);
        this.setComponent(comp);
    }

    @Override
    public int getLeftMargin() {
        return this.getTopMargin();
    }

    @Override
    public int getBottomMargin() {
        return this.getTopMargin();
    }

    @Override
    public int getRightMargin() {
        return this.getTopMargin();
    }

    @Override
    public int getTopMargin() {
        switch (this.getStyle()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 14: 
            case 15: {
                return 1;
            }
            case 4: 
            case 8: 
            case 9: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 10: {
                return 1;
            }
            case -1: {
                return 0;
            }
        }
        return 0;
    }
}

