/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.DrawingSupport;
import com.sas.visuals.ImageDataInterface;
import com.sas.visuals.Part;
import com.sas.visuals.SerialImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;

public class Wallpaper
extends Part
implements ImageDataInterface {
    protected SerialImage _image;
    public static final int TILE = 0;
    public static final int CENTER = 1;
    public static final int STRETCH = 2;
    protected int _display = 1;
    protected transient Image _backgroundImage;

    public Wallpaper() {
    }

    public Wallpaper(int display) {
        this();
        this._display = display;
    }

    public Wallpaper(Image image, int display) {
        this(display);
        this.setImage(image);
    }

    public Wallpaper(URL url, int display) {
        this(display);
        this.setImage(url);
    }

    public Wallpaper(String filename, int display) {
        this(display);
        this.setImage(filename);
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
        super.paint(component, g, x, y, width, height);
    }

    @Override
    protected void paintView(Graphics g) {
        Image image = this.getImage();
        int display = this.getDisplay();
        Component parent = this.getParent();
        if (image != null && parent != null) {
            if (display == 1) {
                this.centerImage(g, image);
            } else {
                this._backgroundImage = this.getBackgroundImage(g);
                if (this._backgroundImage == null) {
                    this._backgroundImage = this.createBackgroundImage();
                    Graphics graphics = this._backgroundImage.getGraphics();
                    graphics.setColor(parent.getBackground());
                    DrawingSupport.fillRect(graphics, this);
                    switch (display) {
                        case 0: {
                            this.tileImage(graphics, image);
                            break;
                        }
                        case 2: {
                            this.stretchImage(graphics, image);
                            break;
                        }
                        default: {
                            this._backgroundImage = null;
                        }
                    }
                    graphics.dispose();
                }
                if (this._backgroundImage != null) {
                    g.drawImage(this._backgroundImage, 0, 0, parent);
                }
            }
        }
    }

    protected Image getBackgroundImage(Graphics g) {
        Component parent = this.getParent();
        if (this._backgroundImage != null && parent != null) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            return DrawingSupport.getImageSize(g, this._backgroundImage, parent).equals(size) ? this._backgroundImage : null;
        }
        return null;
    }

    protected Image createBackgroundImage() {
        Component parent = this.getParent();
        if (parent != null) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            Image image = parent.createImage(size.width, size.height);
            return image;
        }
        return null;
    }

    protected void tileImage(Graphics g, Image image) {
        Component parent = this.getParent();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int x = this.x + insets.left;
        int y = this.y + insets.top;
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        if (parent != null) {
            Dimension imageSize = DrawingSupport.getImageSize(g, image, parent);
            int cols = width / imageSize.width + 1;
            int rows = height / imageSize.height + 1;
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    g.drawImage(image, x, y, parent);
                    y += imageSize.height;
                }
                x += imageSize.width;
                y = insets.top;
            }
        }
    }

    protected void centerImage(Graphics g, Image image) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Component parent = this.getParent();
        if (parent != null) {
            Dimension imageSize = DrawingSupport.getImageSize(g, image, parent);
            int x = this.x + insets.left + (size.width - imageSize.width) / 2;
            int y = this.y + insets.top + (size.height - imageSize.height) / 2;
            g.drawImage(image, x, y, parent);
        }
    }

    protected void stretchImage(Graphics g, Image image) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Component parent = this.getParent();
        if (parent != null) {
            int x = this.x + insets.left;
            int y = this.y + insets.top;
            g.drawImage(image, x, y, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom), parent);
        }
    }

    public void setDisplay(int display) {
        switch (display) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                display = 1;
            }
        }
        if (this._display != display) {
            this._backgroundImage = null;
            this._display = display;
        }
    }

    public int getDisplay() {
        return this._display;
    }

    @Override
    public synchronized Image getImage() {
        return this._image == null ? null : this._image.getImage();
    }

    void setImage(Image image) {
        this.setImage(image, this.getParent());
    }

    void setImage(URL url) {
        this.setImage(url, this.getParent());
    }

    void setImage(String filename) {
        this.setImage(filename, this.getParent());
    }

    @Override
    public synchronized void setImage(Image image, Component component) {
        if (component != null) {
            MediaTracker tracker = new MediaTracker(component);
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SerialImage si = new SerialImage(image, component);
        if (this._image == null) {
            this._image = si;
            this._backgroundImage = null;
        } else if (!si.getImage().equals(this._image.getImage())) {
            this._image = si;
            this._backgroundImage = null;
        }
    }

    @Override
    public void setImage(URL url, Component component) {
        SerialImage si = new SerialImage(url, component);
        if (this._image == null) {
            this._image = si;
            this._backgroundImage = null;
        } else if (!si.getImage().equals(this._image.getImage())) {
            this._image = si;
            this._backgroundImage = null;
        }
    }

    @Override
    public void setImage(String filename, Component component) {
        SerialImage si = new SerialImage(filename, component);
        if (this._image == null) {
            this._image = si;
            this._backgroundImage = null;
        } else if (!si.getImage().equals(this._image.getImage())) {
            this._image = si;
            this._backgroundImage = null;
        }
    }

    @Override
    public void setImage(byte[] imagedata, Component component) {
        this.setImage(Toolkit.getDefaultToolkit().createImage(imagedata), component);
    }

    @Override
    public void setImage(InputStream imagedata, Component component) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(imagedata);
        try {
            int avail = bis.available();
            avail = avail == 0 ? 1 : avail;
            byte[] bytes = new byte[avail];
            while (bis.read(bytes, 0, avail) != -1) {
                baos.write(bytes, 0, avail);
                avail = bis.available();
                avail = avail == 0 ? 1 : avail;
                bytes = new byte[avail];
            }
            bis.close();
            baos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setImage(baos.toByteArray(), component);
    }

    @Override
    public Object getImageLocation() {
        try {
            return this._image.getImageLocation();
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

