/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.OrderedListCollection;
import com.sas.collection.Permuter;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.util.EventGateInterface;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.EmptyComponent;
import com.sas.visuals.Placement;
import com.sas.visuals.RB;
import com.sas.visuals.SpinButton;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class UpDownListBox
extends CompositePanel
implements ActionListener,
ItemSelectable,
ItemListener,
ContentsChangedListener,
ViewDefaultModelInterface {
    private transient boolean initialized;
    private transient Placement buttonPlacement = Placement.RIGHTSIDE_BOTTOM;
    private transient ItemListener itemListener;
    private transient StaticOrderedCollectionInterface sciModel;
    private Component buttons;
    private SpinButton spinButton;
    private Panel buttonPanel;
    private ListBox listBox;
    private Button upButton;
    private Button downButton;
    private String upButtonLabel = "Move up";
    private String downButtonLabel = "Move down";
    private boolean mutlipleMode;
    private OrderedCollectionInterface ociModel;
    private Dimension preferredSize = null;
    private int versionNumber = 1;
    static final long serialVersionUID = 9036432863170587296L;
    public static final String RB_KEY = "UpDownListBox.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    static int defaultWidth = 136;
    static int defaultHeight = 124;
    int inFillPanel = 0;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "buttonPlacement"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonPlacement.pd.txt")}}, {{"Name", "count"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonPlacement.pd.txt")}}, {{"Name", "defaultModelAttached"}, {"Description", Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayTransform"}, {"Description", RB.getStringResource((String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "initialItems"}, {"Description", RB.getStringResource((String)"initialItems.pd.txt")}}, {{"Name", "inputTransform"}, {"Description", RB.getStringResource((String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "items"}, {"Hidden", "true"}}, {{"Name", "keyboardSelectable"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"keyboardSelectable.pd.txt")}}, {{"Name", "multipleMode"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"multipleMode.pd.txt")}}, {{"Name", "outputTransform"}, {"Description", RB.getStringResource((String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "selectedIndex"}, {"Description", RB.getStringResource((String)"selectedIndex.pd.txt")}}, {{"Name", "selectedIndexes"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedIndexes.pd.txt")}}, {{"Name", "selectedItem"}, {"Description", RB.getStringResource((String)"selectedItem.pd.txt")}, {"Read method", "getSelectedItem"}}, {{"Name", "selectedItems"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItems.pd.txt")}, {"Read method", "getSelectedItems"}}, {{"Name", "selectionPrefix"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectionPrefix.pd.txt")}, {"Expert", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "136"}, {"Description", com.sas.RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", com.sas.RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}, {{"Name", "visibleRows"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public UpDownListBox() {
        this.initializeComponent();
        boolean designTime = this.isDesignTime();
        if (designTime) {
            this.preview();
        }
    }

    public UpDownListBox(int rows, boolean multipleMode, Placement buttonPlacement) {
        this(multipleMode, buttonPlacement);
    }

    public UpDownListBox(boolean multipleMode, Placement buttonPlacement) {
        this();
        this.setMultipleMode(multipleMode);
        this.setButtonPlacement(buttonPlacement);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.initialize();
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    public void addItems(Enumeration items) {
        this.initialize();
        this.listBox.addItems(items);
    }

    public void add(Object item) {
        this.initialize();
        this.listBox.add(item);
    }

    public void add(Object item, int pos) {
        this.initialize();
        this.listBox.add(item, pos);
    }

    public void add(Object[] items) {
        this.initialize();
        this.listBox.add(items);
    }

    public void add(String item) {
        this.initialize();
        this.listBox.add(item);
    }

    public void add(String item, int pos) {
        this.initialize();
        this.listBox.add(item, pos);
    }

    Dimension clone(Dimension d) {
        return new Dimension(d.width, d.height);
    }

    public void deselect(int index) {
        this.initialize();
        this.listBox.deselect(index);
    }

    public void deselectAll() {
        this.initialize();
        this.listBox.deselectAll();
    }

    public int findItemByPrefix(String prefix, int index) {
        this.initialize();
        return this.listBox.findItemByPrefix(prefix, index);
    }

    public TransformInterface getDisplayTransform() {
        this.initialize();
        return this.listBox.getDisplayTransform();
    }

    public String[] getInitialItems() {
        this.initialize();
        return this.listBox.getInitialItems();
    }

    public TransformInterface getInputTransform() {
        this.initialize();
        return this.listBox.getInputTransform();
    }

    public int getItemCount() {
        this.initialize();
        return this.listBox.getItemCount();
    }

    public String[] getItems() {
        this.initialize();
        return this.listBox.getItems();
    }

    public TransformInterface getOutputTransform() {
        this.initialize();
        return this.listBox.getOutputTransform();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.clone(this.preferredSize);
        }
        return super.getPreferredSize();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public int getSelectedIndex() {
        this.initialize();
        return this.listBox.getSelectedIndex();
    }

    public int[] getSelectedIndexes() {
        this.initialize();
        return this.listBox.getSelectedIndexes();
    }

    public String getSelectedItem() {
        this.initialize();
        return this.listBox.getSelectedItem();
    }

    public String[] getSelectedItems() {
        this.initialize();
        return this.listBox.getSelectedItems();
    }

    @Override
    public Object[] getSelectedObjects() {
        this.initialize();
        return this.listBox.getSelectedObjects();
    }

    public String getSelectionPrefix() {
        this.initialize();
        return this.listBox.getSelectionPrefix();
    }

    public int getVisibleIndex() {
        return this.listBox.getVisibleIndex();
    }

    public int getVisibleRows() {
        this.initialize();
        return this.listBox.getVisibleRows();
    }

    public boolean isKeyboardSelectable() {
        this.initialize();
        return this.listBox.isKeyboardSelectable();
    }

    public boolean isMultipleMode() {
        this.initialize();
        return this.listBox.isMultipleMode();
    }

    public void makeVisible(int index) {
        this.initialize();
        this.listBox.makeVisible(index);
    }

    public void remove(String item) {
        this.initialize();
        this.listBox.remove(item);
    }

    public void remove(Object item) {
        this.initialize();
        this.listBox.remove(item);
    }

    @Override
    public synchronized void remove(int position) {
        this.initialize();
        if (this.inFillPanel > 0) {
            super.remove(position);
        } else {
            this.listBox.remove(position);
        }
    }

    @Override
    public void removeAll() {
        this.initialize();
        if (this.inFillPanel > 0) {
            super.removeAll();
        } else {
            this.listBox.removeAll();
        }
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.initialize();
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    public void replaceItem(String newValue, int index) {
        this.initialize();
        this.listBox.replaceItem(newValue, index);
    }

    public void replaceItem(Object newValue, int index) {
        this.initialize();
        this.listBox.replaceItem(newValue, index);
    }

    public void select(int index) {
        this.initialize();
        this.listBox.select(index);
    }

    public void selectAll() {
        this.initialize();
        this.listBox.selectAll();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.initialize();
        this.listBox.setBackgroundColor(color);
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackgroundColor(color);
        }
        super.setBackgroundColor(color);
    }

    @Override
    public void setBackground(Color color) {
        this.initialize();
        this.listBox.setBackgroundColor(color);
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackgroundColor(color);
        }
        super.setBackground(color);
    }

    public void setDisplayTransform(TransformInterface transform) {
        this.initialize();
        this.listBox.setDisplayTransform(transform);
    }

    @Override
    public void setForeground(Color color) {
        this.initialize();
        this.listBox.setForegroundColor(color);
        if (this.buttonPanel != null) {
            this.buttonPanel.setForegroundColor(color);
        }
        super.setForeground(color);
    }

    public void setInputTransform(TransformInterface transform) {
        this.initialize();
        this.listBox.setInputTransform(transform);
    }

    public synchronized void setInitialItems(String[] initialItems) {
        this.initialize();
        this.listBox.setInitialItems(initialItems);
    }

    public synchronized void setItems(String[] items) {
        this.initialize();
        this.listBox.setItems(items);
    }

    public void setKeyboardSelectable(boolean state) {
        this.initialize();
        this.listBox.setKeyboardSelectable(state);
    }

    public void setMultipleMode(boolean state) {
        this.initialize();
        this.listBox.setMultipleMode(state);
    }

    public void setMultipleSelectionStyle(int style) {
        this.initialize();
        this.listBox.setMultipleSelectionStyle(style);
    }

    public void setOutputTransform(TransformInterface transform) {
        this.initialize();
        this.listBox.setOutputTransform(transform);
    }

    public void setSelectedIndex(int index) {
        this.initialize();
        this.listBox.setSelectedIndex(index);
    }

    public void setSelectedIndexes(int[] indexes) {
        this.initialize();
        this.listBox.setSelectedIndexes(indexes);
    }

    public void setSelectedItem(Object text) {
        this.initialize();
        this.listBox.setSelectedItem(text);
    }

    public void setSelectedItem(String text) {
        this.initialize();
        this.listBox.setSelectedItem(text);
    }

    public void setSelectedItems(Object[] items) {
        this.initialize();
        this.listBox.setSelectedItems(items);
    }

    public void setSelectedItems(String[] items) {
        this.initialize();
        this.listBox.setSelectedItems(items);
    }

    public void setSelectionPrefix(String prefix) {
        this.initialize();
        this.listBox.setSelectionPrefix(prefix);
    }

    @Override
    public synchronized void setSize(Dimension d) {
        this.initialize();
        super.setSize(d);
        this.preferredSize = this.clone(d);
        this.invalidate();
    }

    public synchronized void setSpinButtonVisible(boolean bool) {
        this.spinButton.setVisible(bool);
    }

    public synchronized boolean isSpinButtonVisible() {
        return this.spinButton.isVisible();
    }

    public void setVisibleRows(int rows) {
        this.initialize();
        this.listBox.setVisibleRows(rows);
    }

    public Placement getButtonPlacement() {
        return this.buttonPlacement;
    }

    static synchronized Vector IntArrayToVector(int[] a) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < a.length; ++i) {
            v.addElement(new Integer(a[i]));
        }
        return v;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.listBox) {
            this.processItemEvent(new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange()));
        }
    }

    public boolean isDefaultModelAttached() {
        return this.listBox.isDefaultModelAttached();
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void preview() {
        this.initialize();
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model == null) {
            this.attachModel((ModelInterface)new OrderedListCollection());
        } else {
            this.listBox.refresh();
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        this.listBox.refresh();
    }

    public synchronized void setButtonPlacement(Placement buttonPlacement) {
        if (this.buttonPlacement == buttonPlacement) {
            return;
        }
        if (buttonPlacement == null) {
            buttonPlacement = Placement.RIGHTSIDE_BOTTOM;
        }
        Placement old = buttonPlacement;
        this.buttonPlacement = buttonPlacement;
        this.firePropertyChange("buttonPlacement", (Object)old, (Object)buttonPlacement);
        this.layoutComponents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.upButton) {
            this.moveSelection(-1);
        } else if (obj == this.downButton) {
            this.moveSelection(1);
        }
    }

    @Override
    public synchronized void attachModel(ModelInterface model) {
        if (model == this.ociModel) {
            return;
        }
        this.initialize();
        ModelInterface oldModel = this.getModelInterface();
        this.ociModel = null;
        if (oldModel != null) {
            this.detachModel(oldModel);
        }
        super.attachModel(model);
        this.sciModel = (StaticOrderedCollectionInterface)model;
        if (model instanceof OrderedCollectionInterface) {
            this.ociModel = (OrderedCollectionInterface)model;
            this.ociModel.addContentsChangedListener((ContentsChangedListener)this);
        }
        this.synchronizeButtons();
        this.listBox.attachModel(model);
    }

    public synchronized void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() == this.ociModel) {
            this.synchronizeButtons();
        }
    }

    private void createComponents() {
        this.listBox = new ListBox();
        this.listBox.initialize();
        if (null == this.getModelInterface()) {
            OrderedListCollection olc = new OrderedListCollection();
            olc.initialize();
            this.attachModel((ModelInterface)olc);
        } else {
            this.ociModel = (OrderedCollectionInterface)this.getModelInterface();
        }
        this.hookup();
        this.listBox.setSize(new Dimension(defaultWidth, defaultHeight));
        this.layoutComponents();
    }

    @Override
    public synchronized void detachModel(ModelInterface model) {
        if (model != null && model == this.ociModel) {
            this.ociModel.removeContentsChangedListener((ContentsChangedListener)this);
            this.ociModel = null;
        }
        this.listBox.detachModel(model);
        super.detachModel(model);
    }

    @Override
    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation == 4 || representation == 1) {
            return 4;
        }
        return -1;
    }

    @Override
    public ModelInterface getModelInterface() {
        if (this.listBox == null) {
            return null;
        }
        return this.listBox.getModelInterface();
    }

    private void hookup() {
        this.listBox.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.listBox.addItemListener(this);
    }

    @Override
    public synchronized void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            super.initialize();
            if (this.listBox == null) {
                this.createComponents();
            } else if (this.ociModel != null) {
                this.attachModel((ModelInterface)this.ociModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void layoutComponents() {
        try {
            ++this.inFillPanel;
            this.removeAll();
            BorderLayout layout = new BorderLayout();
            this.setLayout(layout);
            String listBoxConstraint = "Center";
            if (this.buttonPanel == null) {
                this.buttonPanel = new Panel();
            } else {
                this.buttonPanel.removeAll();
            }
            if (this.spinButton == null) {
                this.spinButton = new SpinButton(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 1, 1);
                this.spinButton.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                this.spinButton.initialize();
                this.spinButton.swapButtonFunction();
            }
            if (Util.tracing) {
                System.out.println("SpinButton: " + this.spinButton);
            }
            AutoSizingGridLayout aLayout = null;
            if (this.buttonPlacement == Placement.LEFTSIDE_TOP || this.buttonPlacement == Placement.RIGHTSIDE_TOP || this.buttonPlacement == Placement.LEFTSIDE_BOTTOM || this.buttonPlacement == Placement.RIGHTSIDE_BOTTOM) {
                aLayout = new AutoSizingGridLayout(2, 1);
                aLayout.setUseRowRemainder(true);
                this.buttonPanel.setLayout((LayoutManager)aLayout);
            }
            if (this.buttonPlacement == Placement.TOP || this.buttonPlacement == Placement.BOTTOM || this.buttonPlacement == Placement.TOP_RIGHT || this.buttonPlacement == Placement.TOP_LEFT || this.buttonPlacement == Placement.BOTTOM_RIGHT || this.buttonPlacement == Placement.BOTTOM_LEFT) {
                if (this.spinButton.getOrientation() != 0) {
                    this.spinButton.setOrientation(0);
                    this.spinButton.swapButtonFunction();
                }
                this.spinButton.setArrowDirection(2);
                if (this.buttonPlacement == Placement.TOP || this.buttonPlacement == Placement.BOTTOM) {
                    this.buttonPanel.setLayout(new FlowLayout(1, 0, 0));
                } else if (this.buttonPlacement == Placement.TOP_RIGHT || this.buttonPlacement == Placement.BOTTOM_RIGHT) {
                    this.buttonPanel.setLayout(new FlowLayout(2, 0, 0));
                } else if (this.buttonPlacement == Placement.TOP_LEFT || this.buttonPlacement == Placement.BOTTOM_LEFT) {
                    this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
                }
                this.buttonPanel.add(this.spinButton);
            } else if (this.buttonPlacement == Placement.LEFTSIDE_TOP || this.buttonPlacement == Placement.RIGHTSIDE_TOP) {
                if (this.spinButton.getOrientation() != 1) {
                    this.spinButton.setOrientation(1);
                    this.spinButton.swapButtonFunction();
                }
                this.spinButton.setArrowDirection(2);
                aLayout.setRemainderRow(2);
                this.buttonPanel.add(this.spinButton);
            } else if (this.buttonPlacement == Placement.LEFTSIDE_BOTTOM || this.buttonPlacement == Placement.RIGHTSIDE_BOTTOM) {
                if (this.spinButton.getOrientation() != 1) {
                    this.spinButton.setOrientation(1);
                    this.spinButton.swapButtonFunction();
                }
                this.spinButton.setArrowDirection(2);
                aLayout.setRemainderRow(1);
                this.buttonPanel.add(new EmptyComponent());
                this.buttonPanel.add(this.spinButton);
            } else {
                if (this.spinButton.getOrientation() != 1) {
                    this.spinButton.setOrientation(1);
                    this.spinButton.swapButtonFunction();
                }
                this.spinButton.setArrowDirection(2);
                GridBagLayout gridBag = new GridBagLayout();
                this.buttonPanel.setLayout(gridBag);
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 1;
                EmptyComponent ec1 = new EmptyComponent();
                gridBag.setConstraints(ec1, c);
                this.buttonPanel.add(ec1);
                GridBagConstraints cs = new GridBagConstraints();
                cs.gridx = 0;
                cs.gridy = 1;
                cs.fill = 0;
                cs.weighty = 0.0;
                gridBag.setConstraints(this.spinButton, cs);
                this.buttonPanel.add(this.spinButton);
                EmptyComponent ec2 = new EmptyComponent();
                gridBag.setConstraints(ec2, c);
                this.buttonPanel.add(ec2);
            }
            String buttonConstraint = this.buttonPlacement == Placement.TOP || this.buttonPlacement == Placement.TOP_RIGHT || this.buttonPlacement == Placement.TOP_LEFT ? "North" : (this.buttonPlacement == Placement.BOTTOM || this.buttonPlacement == Placement.BOTTOM_RIGHT || this.buttonPlacement == Placement.BOTTOM_LEFT ? "South" : (this.buttonPlacement == Placement.LEFTSIDE_TOP || this.buttonPlacement == Placement.LEFTSIDE_BOTTOM || this.buttonPlacement == Placement.LEFTSIDE_CENTER ? "West" : "East"));
            this.add(listBoxConstraint, this.listBox);
            this.add(buttonConstraint, this.buttonPanel);
            this.synchronizeButtons();
            this.invalidate();
            this.validate();
        }
        finally {
            --this.inFillPanel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveSelection(int offset) {
        int[] selections = this.getSelectedIndexes();
        if (selections == null || selections.length == 0) {
            return;
        }
        try {
            if (this.ociModel instanceof EventGateInterface) {
                ((EventGateInterface)this.ociModel).disableEvents();
            }
            if (selections.length == 1) {
                Permuter.move((IndexedSetInterface)this.ociModel, (int)selections[0], (int)offset);
            } else {
                Permuter.move((IndexedSetInterface)this.ociModel, (int[])selections, (int)offset);
            }
            this.listBox.deselectAll();
            int i = 0;
            while (i < selections.length) {
                int n = i++;
                selections[n] = selections[n] + offset;
            }
            if (!(this.ociModel instanceof EventGateInterface)) {
                this.listBox.setSelectedIndexes(selections);
            }
            this.synchronizeButtons();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (this.ociModel instanceof EventGateInterface) {
                ((EventGateInterface)this.ociModel).enableEvents();
                this.listBox.setSelectedIndexes(selections);
            }
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (event.getSource() == this.listBox) {
            if ("selectedIndexes".equals(name)) {
                this.synchronizeButtons();
            }
            this.firePropertyChange(name, oldValue, newValue);
        } else if (event.getSource() == this.spinButton) {
            if ("value".equals(name) && oldValue != null && oldValue instanceof Integer && newValue != null && newValue instanceof Integer) {
                int oldVal = (Integer)oldValue;
                int newVal = (Integer)newValue;
                if (newVal != oldVal) {
                    this.moveSelection(newVal - oldVal);
                }
            }
        } else if (name.endsWith("abled")) {
            this.synchronizeButtons();
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropTarget(false);
        this.buttonPlacement = Placement.RIGHTSIDE_BOTTOM;
    }

    synchronized void synchronizeButtons() {
        boolean downButtonEnabled;
        boolean upButtonEnabled;
        int[] selections = this.getSelectedIndexes();
        int nSel = selections.length;
        if (this.ociModel == null) {
            if (this.spinButton != null) {
                this.spinButton.setEnabled(false);
            }
            return;
        }
        int nItems = this.ociModel.count();
        if (nSel == 0) {
            boolean value = false;
            upButtonEnabled = false;
            downButtonEnabled = false;
        } else {
            int first = selections[0];
            int last = selections[nSel - 1];
            Util.print((String)"{ ");
            for (int i = 0; i < nSel; ++i) {
                Util.print((String)(selections[i] + ", "));
            }
            Util.print((String)"}");
            int value = first;
            upButtonEnabled = first > 0;
            boolean bl = downButtonEnabled = last < nItems - 1;
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(upButtonEnabled);
            this.downButton.setEnabled(downButtonEnabled);
        } else {
            this.spinButton.setEnabled(upButtonEnabled || downButtonEnabled);
            this.spinButton.setDecrementEnabled(upButtonEnabled);
            this.spinButton.setIncrementEnabled(downButtonEnabled);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.buttonPlacement = null;
        this.buttons = null;
        this.spinButton = null;
        if (this.listBox != null) {
            this.hookup();
            this.setButtonPlacement(Placement.read(stream));
            if (this.versionNumber == 0) {
                if (this.buttonPlacement == Placement.TOP || this.buttonPlacement == Placement.BOTTOM) {
                    this.spinButton.setOrientation(0);
                    this.spinButton.setArrowDirection(2);
                } else {
                    this.spinButton.setOrientation(1);
                    this.spinButton.setArrowDirection(2);
                }
            }
            this.listBox.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.sciModel = (StaticOrderedCollectionInterface)this.getModelInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Component tempbuttons = this.buttons;
        Panel tempbuttonPanel = this.buttonPanel;
        SpinButton tempspinButton = this.spinButton;
        this.buttons = null;
        this.spinButton = null;
        try {
            stream.defaultWriteObject();
            this.buttonPlacement.write(stream);
        }
        finally {
            this.buttonPanel = tempbuttonPanel;
            this.buttons = tempbuttons;
            this.spinButton = tempspinButton;
        }
    }
}

