/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.Choice;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AssociationListInterface;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollection;
import com.sas.lang.DoubleData;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.StringDataInterface;
import com.sas.measures.Distance;
import com.sas.measures.MeasureInterface;
import com.sas.measures.Time;
import com.sas.text.Message;
import com.sas.util.IntegerRange;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.RB;
import com.sas.visuals.SpinBox;
import com.sas.visuals.SpinButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class UnitsBox
extends CompositePanel
implements DoubleDataInterface,
StringDataInterface,
MeasureInterface,
ContentsChangedListener {
    public static final String RB_KEY = "UnitsBox.";
    static final long serialVersionUID = 6040867900509794160L;
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.AssociationListInterface"};
    private AssociationListInterface units;
    private double value;
    private double currentScale;
    private Object currentUnits;
    private boolean textScaled;
    private boolean valueInvoked;
    private transient boolean textChanged;
    static int defaultWidth = 175;
    static int defaultHeight = 25;
    private TextField textField;
    private SpinButton spinButton;
    protected Choice choice;
    private IntegerRange integerRange;
    protected SpinBox spinBox;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "magnitude"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"magnitude.pd.txt")}}, {{"Name", "minimumMagnitude"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"minimumMagnitude.pd.txt")}}, {{"Name", "maximumMagnitude"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"maximumMagnitude.pd.txt")}}, {{"Name", "doubleData"}, {"Bound", "false"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"doubleData.pd.txt")}}, {{"Name", "text"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "unit"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"unit.pd.txt")}}, {{"Name", "displayedUnit"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayedUnit.pd.txt")}}, {{"Name", "unitsDisplayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"unitsDisplayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "currentUnits"}, {"Hidden", "true"}}, {{"Name", "textScaled"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public UnitsBox() {
        this.setUnits(Distance.makeUnitsAssociationList((int)Distance.FIXED_UNITS));
        this.setCurrentUnits(com.sas.measures.RB.getStringResource((String)"Distance.m.txt"));
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropTarget(false);
        this.value = 1.0;
        this.currentScale = 1.0;
        this.currentUnits = "";
        this.valueInvoked = false;
        this.createComponents();
        this.hookupComponents();
        this.layoutComponents();
        this.setMagnitude(1.0);
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        Util.setEnabledOnContainer(this, e);
    }

    @Override
    public void setForeground(Color color) {
        if (this.spinBox != null) {
            this.spinBox.setForegroundColor(color);
        }
        if (this.choice != null) {
            this.choice.setForegroundColor(color);
        }
        super.setForeground(color);
    }

    public void setUnits(AssociationListInterface newUnits) {
        if (newUnits != this.units) {
            if (this.units != null) {
                this.units.removeContentsChangedListener((ContentsChangedListener)this);
            }
            UnitsBox.validateUnits(newUnits);
            AssociationListInterface old = this.units;
            this.units = newUnits;
            if (this.units != null) {
                this.units.addContentsChangedListener((ContentsChangedListener)this);
            }
            if (this.units instanceof ModelInterface) {
                this.attachModel((ModelInterface)this.units);
            }
            this.updateUnits();
            this.firePropertyChange("units", old, this.units);
        }
    }

    protected void hookupComponents() {
        if (this.units != null) {
            this.units.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.units.addContentsChangedListener((ContentsChangedListener)this);
        }
        this.spinBox.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.choice.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void setTextScaled(boolean textScaled) {
    }

    public boolean getTextScaled() {
        return true;
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        this.setUnits((AssociationListInterface)model);
    }

    protected void updateUnits() {
        this.choice.detachModel(this.choice.getModelInterface());
        OrderedCollection choiceUnits = new OrderedCollection();
        choiceUnits.addItems(this.units.getKeys());
        this.choice.removeAll();
        this.choice.attachModel((ModelInterface)choiceUnits);
        this.choice.refresh((ModelInterface)choiceUnits);
        if (choiceUnits.count() > 0) {
            this.setDisplayedUnit(this.getCurrentUnits());
        }
        this.invalidate();
        this.validate();
    }

    public AssociationListInterface getUnits() {
        return this.units;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() == this.units) {
            UnitsBox.validateUnits(this.units);
            this.updateUnits();
        }
    }

    public static void validateUnits(AssociationListInterface unitList) {
        int unitValueIndex = -1;
        int len = unitList.count();
        for (int i = 0; i < len; ++i) {
            Number number = (Number)unitList.get(i);
            double d = number.doubleValue();
            if (d == 0.0) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidScale.ex.txt"));
            }
            if (d != 1.0) continue;
            unitValueIndex = i;
        }
        if (len > 0 && unitValueIndex == -1) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"noScaleUnits.ex.txt"));
        }
    }

    public String getText() {
        if (this.spinBox != null && this.choice != null) {
            return this.spinBox.getText() + " " + this.choice.getText();
        }
        return DoubleData.toString((double)this.value) + " " + (this.currentUnits != null ? this.currentUnits.toString() : "");
    }

    @Override
    public String toString() {
        return "com.sas.visuals.UnitsBox[" + this.getText() + "]";
    }

    protected static String toString(double d) {
        return DoubleData.toString((double)d);
    }

    /*
     * Exception decompiling
     */
    public void setText(String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCurrentUnits(Object unit) {
        this.setDisplayedUnit(unit);
    }

    public final Object getCurrentUnits() {
        return this.getDisplayedUnit();
    }

    public void setDisplayedUnit(Object unit) {
        for (int i = 0; i < this.units.count(); ++i) {
            if (!unit.equals(this.units.getKey(i))) continue;
            this.setDisplayedUnit(i);
            return;
        }
        Message exceptionMessage = new Message(RB.getResources(), "UnitsBox.invalidUnit.ex.txt", unit);
        throw new IllegalArgumentException(exceptionMessage.toString());
    }

    public Object getDisplayedUnit() {
        return this.currentUnits;
    }

    public final Object getPreferredUnits() {
        return this.getUnit();
    }

    public Object getUnit() {
        for (int index = 0; index < this.units.count(); ++index) {
            Number number = (Number)this.units.get(index);
            if (number.doubleValue() != 1.0) continue;
            return this.units.getKey(index);
        }
        return null;
    }

    public String getUnitName() {
        Object unit = this.getUnit();
        if (unit != null) {
            return (String)this.getUnit();
        }
        return null;
    }

    public final double getEquivalent(String unit) {
        return this.getMagnitude(unit);
    }

    public double getMagnitude(Object unit) {
        for (int i = 0; i < this.units.count(); ++i) {
            if (!unit.equals(this.units.getKey(i))) continue;
            Number scaleFactor = (Number)this.units.get(i);
            return this.getMagnitude() * scaleFactor.doubleValue();
        }
        Message exceptionMessage = new Message(RB.getResources(), "UnitsBox.invalidUnit.ex.txt", unit);
        throw new IllegalArgumentException(exceptionMessage.toString());
    }

    public double getCurrentScale() {
        return this.currentScale;
    }

    public void setDisplayedUnit(int i) {
        Object unit = null;
        if (i >= 0 && i < this.units.count()) {
            unit = this.units.getKey(i);
        }
        if (unit != null && !com.sas.util.Util.equal(unit, (Object)this.currentUnits)) {
            Object oldUnit = this.currentUnits;
            this.currentUnits = unit;
            this.currentScale = ((Number)this.units.get(i)).doubleValue();
            this.choice.setText(this.currentUnits.toString());
            this.firePropertyChange("displayedUnit", oldUnit, this.currentUnits);
            this.updateText();
        }
    }

    public void pickBestUnits() {
        double delta = Double.NaN;
        int bestUnit = -1;
        for (int i = 0; i < this.units.count(); ++i) {
            double d = ((Number)this.units.get(i)).doubleValue();
            if ((this.value != 0.0 || d != 1.0) && !Double.isNaN(delta) && !(Math.abs(d - this.value) < delta)) continue;
            bestUnit = i;
            delta = Math.abs(d - this.value);
        }
        if (bestUnit != -1) {
            this.setDisplayedUnit(bestUnit);
        }
    }

    public void setColumns(int nCols) {
        this.spinBox.setColumns(nCols);
        this.spinBox.invalidate();
        this.validate();
    }

    public void setMaximumMagnitude(double newMaximumMagnitude) {
        this.spinBox.setMaximumNumber(new Double(newMaximumMagnitude));
    }

    public double getMaximumMagnitude() {
        return this.spinBox.getMaximumNumber().doubleValue();
    }

    public void setMinimumMagnitude(double newMinimumMagnitude) {
        this.spinBox.setMinimumNumber(new Double(newMinimumMagnitude));
    }

    public double getMinimumMagnitude() {
        return this.spinBox.getMinimumNumber().doubleValue();
    }

    protected void updateMagnitude() {
        Double old = new Double(this.value);
        this.value = this.spinBox.getDoubleData() * this.currentScale;
        this.firePropertyChange("magnitude", old, new Double(this.value));
        if (!this.textChanged) {
            this.firePropertyChange("text", null, this.getText());
        }
    }

    public final double getDoubleData() {
        return this.getMagnitude();
    }

    public double getMagnitude() {
        return this.value;
    }

    public final void setDoubleData(double d) {
        this.setMagnitude(d);
    }

    public void setMagnitude(double d) {
        if (d != this.value) {
            double maximumMagnitude = this.getMaximumMagnitude();
            double minimumMagnitude = this.getMinimumMagnitude();
            if (d > maximumMagnitude) {
                d = maximumMagnitude;
            }
            if (d < minimumMagnitude) {
                d = minimumMagnitude;
            }
            if (d == this.value) {
                return;
            }
            Double old = new Double(this.value);
            this.value = d;
            this.firePropertyChange("magnitude", old, new Double(this.value));
            this.updateText();
        }
    }

    protected void updateText() {
        double scaled = this.value / this.currentScale;
        try {
            this.valueInvoked = true;
            this.spinBox.setDoubleData(scaled);
            if (!this.textChanged) {
                this.firePropertyChange("text", null, this.getText());
            }
        }
        finally {
            this.valueInvoked = false;
        }
    }

    @Override
    public void initialize() {
        if (this.spinBox != null) {
            return;
        }
        this.createComponents();
        this.hookupComponents();
        this.layoutComponents();
    }

    protected Choice newChoice() {
        Choice choice = new Choice();
        return choice;
    }

    protected SpinBox newSpinBox() {
        return new SpinBox();
    }

    protected void createComponents() {
        this.spinButton = null;
        this.textField = null;
        this.integerRange = null;
        this.spinBox = new SpinBox();
        this.spinBox.initialize();
        this.choice = this.newChoice();
        this.choice.initialize();
    }

    protected void layoutComponents() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 2, 6, 6);
        layout.setUseColumnRemainder(true);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        this.add(this.spinBox);
        this.add(this.choice);
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String property = event.getPropertyName();
        if (source == this.spinBox && "numberValue".equals(property) && !this.valueInvoked) {
            this.updateMagnitude();
        } else if (source == this.choice && "selectedIndex".equals(property)) {
            this.setDisplayedUnit(this.choice.getSelectedIndex());
        }
        super.propertyChange(event);
    }

    public TransformInterface getUnitsDisplayTransform() {
        this.initialize();
        return this.choice.getDisplayTransform();
    }

    public void setUnitsDisplayTransform(TransformInterface unitsDisplayTransform) {
        this.choice.setDisplayTransform(unitsDisplayTransform);
    }

    @Override
    public void setValidator(ValidationInterface validator) {
        this.spinBox.setValidator(validator);
    }

    @Override
    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        this.spinBox.setErrorHandler(errorHandler);
    }

    public static AssociationListInterface makeTimeUnits() {
        return Time.makeUnitsAssociationList();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.spinButton != null) {
            Container spinPanel = this.spinButton.getParent();
            spinPanel.remove(this.spinButton);
            spinPanel.remove(this.textField);
            this.remove(spinPanel);
            this.integerRange = null;
            this.spinButton = null;
            this.textField = null;
        }
        this.textChanged = false;
        if (this.spinBox == null) {
            this.spinBox = new SpinBox();
            this.spinBox.initialize();
            this.add((Component)this.spinBox, 0);
        }
        if (this.choice != null) {
            this.hookupComponents();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

