/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.BufferedPanel;
import com.sas.visuals.Dockable;
import com.sas.visuals.ToolbarBorder;
import com.sas.visuals.ToolbarLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;

public class Toolbar
extends BufferedPanel
implements Dockable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected boolean docked = true;
    protected boolean wrapped;

    public void setOrientation(int orientation) {
        ((ToolbarLayout)this.getLayout()).setOrientation(orientation);
    }

    public int getOrientation() {
        return ((ToolbarLayout)this.getLayout()).getOrientation();
    }

    public void setGap(int gap) {
        ((ToolbarLayout)this.getLayout()).setGap(gap);
    }

    public int getGap() {
        return ((ToolbarLayout)this.getLayout()).getGap();
    }

    public void setWrapped(boolean wrap) {
        ((ToolbarLayout)this.getLayout()).setWrapped(wrap);
    }

    public boolean isWrapped() {
        return ((ToolbarLayout)this.getLayout()).isWrapped();
    }

    @Override
    public Component add(Component comp) {
        int index = ((ToolbarLayout)this.getLayout()).elementCount();
        return super.add("" + index, comp);
    }

    public void add(int space) {
        ((ToolbarLayout)this.getLayout()).add(space);
    }

    public void add(int space, int pos) {
        ((ToolbarLayout)this.getLayout()).add(space, pos);
    }

    public void insert(int space, int pos) {
        this.add(space, pos);
    }

    @Override
    public Component add(Component comp, int pos) {
        return super.add("" + pos, comp);
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
    }

    public void remove(int space, int pos) {
        ((ToolbarLayout)this.getLayout()).remove(space, pos);
    }

    @Override
    public void dockNotify(Object object) {
        if ("West".equals(object) || "East".equals(object)) {
            this.setOrientation(0);
        } else {
            this.setOrientation(1);
        }
        this.setWrapped(this.wrapped);
        this.docked = true;
    }

    @Override
    public void undockNotify(Object object) {
        this.wrapped = this.isWrapped();
        this.setOrientation(1);
        this.setWrapped(true);
        this.docked = false;
    }

    @Override
    public boolean isDocked() {
        return this.docked;
    }

    @Override
    public LayoutManager getLayout() {
        LayoutManager layout = super.getLayout();
        if (layout == null || !(layout instanceof ToolbarLayout)) {
            layout = new ToolbarLayout();
            super.setLayout(layout);
        }
        return layout;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (!(layout instanceof ToolbarLayout)) {
            layout = new ToolbarLayout();
        }
        super.setLayout(layout);
    }

    public Toolbar() {
    }

    public Toolbar(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top * 2, insets.left * 2, insets.bottom * 2, insets.right * 2);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setBorder(new ToolbarBorder(this));
    }
}

