/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.DesignTimeDropResult;
import com.sas.DesignTimeDropTargetInterface;
import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.Panel;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AssociationList;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.Dictionary;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.graphics.ElasticComponentList;
import com.sas.graphics.IDEDnDManager;
import com.sas.idesupport.DesignTimeEventInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.Border;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.BoxLayout;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.RB;
import com.sas.visuals.SelectableInterface;
import com.sas.visuals.SelectionGroup;
import com.sas.visuals.SelectionGroupInterface;
import com.sas.visuals.TabBar;
import com.sas.visuals.TabBarInterface;
import com.sas.visuals.TabButtonInterface;
import com.sas.visuals.TabFolderInterface;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TabbedView
extends CompositePanel
implements DesignTimeDropTargetInterface,
ItemSelectable,
ItemListener,
ContainerListener,
ContentsChangedListener,
PropertyChangeListener,
VetoableChangeListener,
DesignTimeEventInterface,
ViewDefaultModelInterface {
    public static final String RB_KEY = "TabbedView.";
    static final long serialVersionUID = 1681768962271893259L;
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    private static final String defaultTabButtonClass = "com.sas.visuals.TabButton";
    private static final String defaultViewClass = "com.sas.visuals.TabFolder";
    private static final String viewName = "viewName";
    private transient Class tabButtonClass;
    private transient Class viewClass;
    private int initialSelectedIndex;
    private int counter;
    private boolean noPrevAdd;
    private String tabButtonClassName;
    private String viewClassName;
    private SelectionGroupInterface tabSelectionGroup;
    private OrderedCollection defaultModel;
    private Dictionary viewInfo;
    private InnerKeyHandler mInnerKeyHandler = new InnerKeyHandler();
    private TabBarInterface tabBar;
    private Panel mainContainer;
    private Map constraints;
    private transient boolean vetoExceptionThrown;
    private transient boolean viewerInvoked;
    private transient boolean modelInvoked;
    protected transient boolean internalAdd;
    protected transient boolean internalRemove;
    private transient ActionListener actionListener;
    private transient ItemListener itemListener;
    private TransformInterface displayTransform;
    private TransformInterface inputTransform;
    private TransformInterface outputTransform;
    private int modelType;
    private int style;
    private int orientation;
    private Border viewBorder;
    private static int defaultHeight = 148;
    private static int defaultWidth = 248;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "component"}, {"Hidden", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "item"}, {"Hidden", "true"}}, {{"Name", "orientation"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SideOrientationEditor"}}, {{"Name", "outputTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "selectedIndex"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}, {"Constrained", "true"}}, {{"Name", "selectedItem"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}, {"Constrained", "true"}}, {{"Name", "selectionGroup"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectionGroup")}}, {{"Name", "style"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"style.pd.txt")}, {"Property editor class", "com.sas.beans.editors._TabBarStyleEditor"}}, {{"Name", "tabBar"}, {"Hidden", "true"}}, {{"Name", "tabClass"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"tabClass.pd.txt")}, {"Expert", "true"}}, {{"Name", "tab"}, {"Hidden", "true"}}, {{"Name", "border"}, {"Expert", "true"}}, {{"Name", "viewBorder"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"viewBorder.pd.txt")}, {"Expert", "true"}}, {{"Name", "view"}, {"Hidden", "true"}}, {{"Name", "viewClass"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"viewClass.pd.txt")}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public TabbedView() {
    }

    public TabbedView(int orientation) {
        this.setOrientation(orientation);
    }

    public TabbedView(int orientation, int style) {
        this.setOrientation(orientation);
        this.setStyle(style);
    }

    public void add(TabButtonInterface tab, Container newView, Integer grpIndex) {
        this.add(tab, newView, grpIndex, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(TabButtonInterface tab, Container newView, Integer grpIndex, int index) {
        ModelInterface model;
        if (!this.modelInvoked && (model = this.getModelInterface()) != null && model instanceof OrderedCollectionInterface) {
            int mainIndex = index;
            if (index == -1) {
                mainIndex = this.tabSelectionGroup.count();
            }
            try {
                this.viewerInvoked = true;
                ((OrderedCollectionInterface)model).add(tab.getItem(), mainIndex);
            }
            finally {
                this.viewerInvoked = false;
            }
        }
        this.addInternal((java.awt.Component)((Object)tab), newView, grpIndex, index);
    }

    public void add(Container newView, Object item, Integer grpIndex) {
        this.add(newView, item, grpIndex, -1);
    }

    public void add(Container newView, Object item, Integer grpIndex, int index) {
        if (item == null) {
            return;
        }
        if (newView instanceof TabFolderInterface) {
            TabButtonInterface tab = ((TabFolderInterface)((Object)newView)).getTabButton();
            tab.setItem(item);
            this.add(tab, newView, grpIndex, index);
        } else {
            try {
                TabButtonInterface tab = (TabButtonInterface)this.tabButtonClass.newInstance();
                if (tab instanceof java.awt.Component) {
                    tab.setItem(item);
                    this.add(tab, newView, grpIndex, index);
                }
            }
            catch (InstantiationException classInstantiationException) {
                Util.println((String)"TabbedView: InstantiationException thrown in addItem( Object item, java.awt.Container newPanel, Integer grpIndex, int index ) for tabButtonClass");
            }
            catch (IllegalAccessException classIllegalAccessException) {
                Util.println((String)"TabbedView: IllegalAccessException thrown in addItem( Object item, java.awt.Container newPanel, Integer grpIndex, int index ) for tabButtonClass");
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    protected void addInternal(java.awt.Component tab, java.awt.Component view, Integer grpIndex, int index) {
        if (this.viewInfo.containsKey((Object)tab) && this.viewInfo.get((Object)tab) == view) {
            return;
        }
        if (tab.getParent() == this.tabBar) {
            java.awt.Component oldView = (java.awt.Component)this.viewInfo.get((Object)tab);
            this.viewInfo.removeAt((Object)tab);
            if (oldView != null && oldView.getParent() == this.mainContainer) {
                this.mainContainer.remove(oldView);
            }
            this.tabBar.remove(tab);
        }
        this.viewInfo.set((Object)tab, (Object)view);
        String vwName = viewName + this.counter++;
        this.constraints.put(view, vwName);
        this.mainContainer.add(view, vwName, index);
        this.tabBar.add(tab, grpIndex, index);
        tab.addKeyListener(this.mInnerKeyHandler);
        com.sas.beans.Util.addPropertyChangeListener((Object)tab, (PropertyChangeListener)this);
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        ((java.awt.Component)((Object)this.tabBar)).setVisible(true);
        ((Container)((Object)this.tabBar)).invalidate();
        ((Container)((Object)this.tabBar)).validate();
        ((Container)((Object)this.tabBar)).invalidate();
        this.mainContainer.invalidate();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    protected synchronized void addImpl(java.awt.Component comp, Object constraints, int index) {
        if (this.internalAdd) {
            super.addImpl(comp, constraints, index);
            return;
        }
        if (comp instanceof TabButtonInterface) {
            try {
                Object view;
                if (this.isDesignTime()) {
                    Component.beansSetDesignTime((boolean)true);
                    view = this.viewClass.newInstance();
                    Component.beansSetDesignTime((boolean)false);
                } else {
                    view = this.viewClass.newInstance();
                }
                if (view instanceof TabFolderInterface) {
                    ((TabFolderInterface)view).setTabButton((TabButtonInterface)((Object)comp));
                }
                if (constraints != null && constraints instanceof Integer) {
                    this.add((TabButtonInterface)((Object)comp), (Container)view, (Integer)constraints, index);
                } else if (constraints != null && constraints instanceof Container) {
                    this.add((TabButtonInterface)((Object)comp), (Container)constraints, new Integer(0), index);
                } else {
                    this.add((TabButtonInterface)((Object)comp), (Container)view, new Integer(0), index);
                }
                if (this.isDesignTime() && this.getParent() != null) {
                    IDEDnDManager.insertNewComponent(new Frame(), view);
                }
            }
            catch (InstantiationException classInstantiationException) {
                Util.println((String)"TabbedView: exception thrown in addView( Object item ) for viewClass");
            }
            catch (IllegalAccessException classIllegalAccessException) {
                Util.println((String)"TabbedView: exception thrown in addView( Object item ) for viewClass");
            }
        } else if (comp instanceof TabFolderInterface && comp instanceof Container) {
            Integer grpIndex = new Integer(0);
            if (constraints != null && constraints instanceof Integer) {
                grpIndex = (Integer)constraints;
            }
            this.add(((TabFolderInterface)((Object)comp)).getTabButton(), (Container)comp, grpIndex, index);
        } else if (comp instanceof Container) {
            if (constraints == null) {
                int adjustedIndex = index;
                if (index == -1) {
                    adjustedIndex = this.tabSelectionGroup.count();
                }
                this.add((Container)comp, "Tab " + ++adjustedIndex, new Integer(0), index);
            } else if (constraints instanceof TabButtonInterface) {
                this.add((TabButtonInterface)constraints, (Container)comp, new Integer(0), index);
            } else {
                this.add((Container)comp, constraints, new Integer(0), index);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addItem(Object item) {
        this.addItem(item, -1);
    }

    public void addItem(Object item, int index) {
        try {
            Object view;
            if (this.isDesignTime()) {
                Component.beansSetDesignTime((boolean)true);
                view = this.viewClass.newInstance();
                Component.beansSetDesignTime((boolean)false);
            } else {
                view = this.viewClass.newInstance();
            }
            this.add((Container)view, item, new Integer(0), index);
            if (this.isDesignTime() && this.getParent() != null) {
                IDEDnDManager.insertNewComponent(new Frame(), view);
            }
        }
        catch (InstantiationException classInstantiationException) {
            Util.println((String)"TabbedView: exception thrown in addView( Object item ) for viewClass");
        }
        catch (IllegalAccessException classIllegalAccessException) {
            Util.println((String)"TabbedView: exception thrown in addView( Object item ) for viewClass");
        }
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void contentsChanged(ContentsChangedEvent evt) {
        try {
            Object eSource = evt.getSource();
            ModelInterface model = this.getModelInterface();
            if (!this.viewerInvoked && eSource == model && model instanceof OrderedCollectionInterface) {
                if (evt instanceof CollectionChangedInfo) {
                    CollectionChangedInfo evtInfo = (CollectionChangedInfo)evt;
                    this.modelInvoked = true;
                    if (evtInfo.howChanged == HowChanged.ADDED) {
                        this.addItem(evtInfo.whatChanged, evtInfo.start);
                    } else if (evtInfo.howChanged == HowChanged.REMOVED) {
                        int startIndex;
                        for (int i = startIndex = evtInfo.end - 1; i >= evtInfo.start; --i) {
                            this.modelInvoked = true;
                            Container view = this.getView(i);
                            this.remove(i);
                            if (!this.isDesignTime() || view == null || this.getParent() == null) continue;
                            IDEDnDManager.removeComponentFromIDE(new Frame(), view);
                        }
                    } else if (evtInfo.howChanged == HowChanged.REPLACED) {
                        Object modelItem = ((OrderedCollectionInterface)model).get(evtInfo.start);
                        TabButtonInterface tab = (TabButtonInterface)this.tabSelectionGroup.get(evtInfo.start);
                        tab.setItem(modelItem);
                        ((java.awt.Component)((Object)tab)).invalidate();
                        ((java.awt.Component)((Object)this.tabBar)).invalidate();
                        this.validate();
                    } else if (evtInfo.howChanged == HowChanged.OTHER || evtInfo.howChanged == HowChanged.REORDERED) {
                        this.refreshOrderedCollection((StaticOrderedCollectionInterface)((OrderedCollectionInterface)model));
                    }
                } else {
                    this.refreshOrderedCollection((StaticOrderedCollectionInterface)((OrderedCollectionInterface)model));
                }
            }
        }
        finally {
            this.viewerInvoked = false;
            this.modelInvoked = false;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model == this.defaultModel) {
            this.defaultModel.removeAll();
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
    }

    @Override
    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation == 4) {
            try {
                Class<Container> container = Container.class;
                Class dropElementClass = GlobalInfoTable.loadClass((String)((String)data.elementAt(0)));
                if (container.isAssignableFrom(dropElementClass)) {
                    ElasticComponentList.setDropSite(this);
                    return 2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Util.println((String)"TabbedView: exception thrown in dragOver(point, representation, keyState, data) for DropElement Class name");
            }
            ElasticComponentList.setDropSite(null);
            return 4;
        }
        return super.dragOver(point, representation, keyState, data);
    }

    @Override
    public DesignTimeDropResult drop(Point point, int representation, int keyState, Vector data) {
        if (representation == 4) {
            try {
                Class<Container> container = Container.class;
                Class dropElementClass = GlobalInfoTable.loadClass((String)((String)data.elementAt(0)));
                if (container.isAssignableFrom(dropElementClass)) {
                    DesignTimeDropResult retcode = new DesignTimeDropResult();
                    retcode.container = this;
                    retcode.location = new Rectangle(point);
                    return retcode;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Util.println((String)"TabbedView: exception thrown in drop(point, representation, keyState, data) for DropElement Class name");
            }
            return null;
        }
        return super.drop(point, representation, keyState, data);
    }

    @Override
    public Object getDesignTimeEventHandler(AWTEvent event) {
        Object eSource = event.getSource();
        if (Util.equal((Object)((java.awt.Component)eSource).getParent(), (Object)this.tabBar) && event instanceof MouseEvent) {
            ((java.awt.Component)eSource).dispatchEvent(event);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public TransformInterface getDisplayTransform() {
        return this.tabSelectionGroup.getDisplayTransform();
    }

    public int getIndex(Container view) {
        int tabIndex = -1;
        java.awt.Component[] comps = this.mainContainer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!view.equals(comps[i])) continue;
            tabIndex = i;
            break;
        }
        return tabIndex;
    }

    public int getInitialSelectedIndex() {
        int tabCount = this.getTabCount();
        if (this.initialSelectedIndex < tabCount) {
            return this.initialSelectedIndex;
        }
        return tabCount;
    }

    public TransformInterface getInputTransform() {
        return this.tabSelectionGroup.getInputTransform();
    }

    public Object getItem(Container view) {
        TabButtonInterface tab = (TabButtonInterface)this.viewInfo.getKey((Object)view);
        Object item = tab.getItem();
        Object newItem = null;
        TransformInterface outputTransform = this.tabSelectionGroup.getOutputTransform();
        if (outputTransform == null) {
            return item;
        }
        try {
            newItem = outputTransform.transform(item);
        }
        catch (TransformException te) {
            Util.println((String)" TabbedView::getItem( java.awt.Container view ) OutputTransform failed ");
        }
        return newItem;
    }

    public Object getItem(int index) {
        return this.tabSelectionGroup.getItem(index);
    }

    public int getTabCount() {
        return this.tabSelectionGroup.count();
    }

    public int getModelType() {
        return -1;
    }

    public int getOrientation() {
        return this.tabBar.getOrientation();
    }

    public TransformInterface getOutputTransform() {
        return this.tabSelectionGroup.getOutputTransform();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public int getSelectedIndex() {
        return this.tabSelectionGroup.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.tabSelectionGroup.getSelectedItem();
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.tabBar.getSelectedObjects();
    }

    public SelectionGroupInterface getSelectionGroup() {
        return this.tabBar.getSelectionGroup();
    }

    public int getStyle() {
        return this.tabBar.getStyle();
    }

    public TabButtonInterface getTab(Container view) {
        return (TabButtonInterface)this.viewInfo.getKey((Object)view);
    }

    public TabButtonInterface getTab(int index) {
        return (TabButtonInterface)this.tabSelectionGroup.get(index);
    }

    public TabButtonInterface getTab(Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        if (index == -1) {
            return null;
        }
        return (TabButtonInterface)this.tabSelectionGroup.get(index);
    }

    public TabBarInterface getTabBar() {
        return this.tabBar;
    }

    public LayoutManager getTabBarLayout() {
        return this.tabBar.getLayout();
    }

    public Class getTabButtonClass() {
        return this.tabButtonClass;
    }

    public Container getView(Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        if (index == -1) {
            return null;
        }
        TabButtonInterface tab = (TabButtonInterface)this.tabSelectionGroup.get(index);
        return (Container)this.viewInfo.get((Object)tab);
    }

    public Container getView(TabButtonInterface tab) {
        return (Container)this.viewInfo.get((Object)tab);
    }

    public Container getView(int index) {
        return (Container)this.mainContainer.getComponent(index);
    }

    public BorderInterface getViewBorder() {
        return this.mainContainer.getBorder();
    }

    public Class getViewClass() {
        return this.viewClass;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isDesignTime() && this.noPrevAdd && this.getTabCount() == 0) {
            this.noPrevAdd = false;
            this.defaultModel.add((Object)RB.getStringResource((String)"TabBar.", (String)"defaultTab1.txt"));
            this.defaultModel.add((Object)RB.getStringResource((String)"TabBar.", (String)"defaultTab2.txt"));
        }
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (e.getStateChange() == 1 && source == this.tabSelectionGroup && e.getItem() != null && this.mainContainer.getComponentCount() > 0) {
            int selectedIndex = this.tabSelectionGroup.getSelectedIndex();
            TabButtonInterface tab = (TabButtonInterface)this.tabSelectionGroup.get(selectedIndex);
            Container currentContainer = (Container)this.viewInfo.get((Object)tab);
            int viewCount = this.mainContainer.getComponentCount();
            for (int i = 0; i < viewCount; ++i) {
                java.awt.Component comp = this.mainContainer.getComponent(i);
                if (comp == currentContainer) continue;
                comp.setVisible(false);
            }
            currentContainer.setVisible(true);
            ((CardLayout)this.mainContainer.getLayout()).show(this.mainContainer, (String)this.constraints.get(currentContainer));
            this.mainContainer.validate();
            this.processEvent(new ActionEvent(this, 1001, tab.getActionCommand()));
            this.processEvent(new ItemEvent(this, 701, e.getItem(), e.getStateChange()));
        }
    }

    public void next() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < this.tabSelectionGroup.count() - 1) {
            this.setSelectedIndex(selectedIndex + 1);
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (this.isShowing()) {
            Graphics cg;
            Rectangle cr;
            this.getBorder().drawInRect(g, 0, 0, this.getSize().width, this.getSize().height);
            boolean mainPaint = false;
            if (this.mainContainer != null && this.mainContainer.isVisible() && (cr = this.mainContainer.getBounds()).intersects(clip)) {
                cg = g.create(cr.x, cr.y, cr.width, cr.height);
                this.mainContainer.paint(cg);
                mainPaint = true;
            }
            if (this.tabBar != null && ((Container)((Object)this.tabBar)).isVisible()) {
                cr = ((Container)((Object)this.tabBar)).getBounds();
                if (mainPaint) {
                    g.setClip(cr);
                }
                if (cr.intersects(clip)) {
                    cg = g.create(cr.x, cr.y, cr.width, cr.height);
                    ((Container)((Object)this.tabBar)).paint(cg);
                } else if (mainPaint && this.mainContainer.isVisible()) {
                    this.repaint();
                }
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        String propertyName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (event.getSource() == this.tabSelectionGroup) {
            if (Util.equal((Object)propertyName, (Object)"selectedIndex")) {
                this.firePropertyChange("selectedIndex", oldValue, newValue);
            } else if (Util.equal((Object)propertyName, (Object)"selectedItem")) {
                this.firePropertyChange("selectedItem", oldValue, newValue);
            } else if (Util.equal((Object)propertyName, (Object)"inputTransform")) {
                this.firePropertyChange("inputTransform", oldValue, newValue);
            } else if (Util.equal((Object)propertyName, (Object)"outputTransform")) {
                this.firePropertyChange("outputTransform", oldValue, newValue);
            } else if (Util.equal((Object)propertyName, (Object)"displayTransform")) {
                this.firePropertyChange("displayTransform", oldValue, newValue);
            }
        } else if (event.getSource() == this.tabBar) {
            if (Util.equal((Object)propertyName, (Object)"orientation")) {
                ((BoxLayout)this.getLayout()).changeOrientation((java.awt.Component)((Object)this.tabBar), this.tabBar.getOrientation());
                this.mainContainer.invalidate();
                this.invalidate();
                this.validate();
                this.repaint();
                this.firePropertyChange("orientation", event.getOldValue(), event.getNewValue());
            } else if (Util.equal((Object)propertyName, (Object)"style")) {
                this.mainContainer.invalidate();
                this.invalidate();
                this.validate();
                this.repaint();
                this.firePropertyChange("style", event.getOldValue(), event.getNewValue());
            }
        } else if (event.getSource() == this.mainContainer.getBorder()) {
            BoxLayout layout = (BoxLayout)this.getLayout();
            BorderInterface border = this.mainContainer.getBorder();
            Insets insets = border.getInsets((java.awt.Component)this);
            layout.setTopBorder(-insets.top);
            layout.setBottomBorder(-insets.bottom);
            layout.setLeftBorder(-insets.left);
            layout.setRightBorder(-insets.right);
            this.invalidate();
            this.validate();
            this.repaint();
            this.firePropertyChange("viewBorder", null, border);
        }
    }

    public void previous() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex > 0) {
            this.setSelectedIndex(selectedIndex - 1);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        TabButtonInterface tab;
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.tabSelectionGroup != null) {
            this.tabSelectionGroup.addVetoableChangeListener(this);
            com.sas.beans.Util.addPropertyChangeListener((Object)this.tabSelectionGroup, (PropertyChangeListener)this);
        }
        if (this.tabBar != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.tabBar, (PropertyChangeListener)this);
        }
        com.sas.beans.Util.addPropertyChangeListener((Object)this.mainContainer.getBorder(), (PropertyChangeListener)this);
        if (this.defaultModel == null) {
            this.defaultModel = new OrderedCollection();
            this.defaultModel.initialize();
            if (this.getModelInterface() == null) {
                int count = this.tabSelectionGroup.count();
                for (int i = 0; i < count; ++i) {
                    tab = (TabButtonInterface)this.tabSelectionGroup.get(i);
                    this.defaultModel.add(tab.getItem(), i);
                }
                this.setModelInterface((ModelInterface)this.defaultModel);
            }
        }
        if (this.getModelInterface() == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
        this.noPrevAdd = false;
        try {
            this.viewClass = GlobalInfoTable.loadClass((String)this.viewClassName);
            this.tabButtonClass = GlobalInfoTable.loadClass((String)this.tabButtonClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Util.println((String)"TabbedView: ClassNotFoundException thrown in readObject()");
        }
        this.mainContainer.removeContainerListener(this);
        ((Container)((Object)this.tabBar)).removeContainerListener(this);
        this.removeContainerListener(this);
        int viewCount = this.mainContainer.getComponentCount();
        int index = 0;
        if (this.initialSelectedIndex < viewCount && this.initialSelectedIndex >= 0) {
            index = this.initialSelectedIndex;
        }
        if (viewCount > 0) {
            tab = (TabButtonInterface)this.tabSelectionGroup.get(index);
            Container currentContainer = (Container)this.viewInfo.get((Object)tab);
            for (int i = 0; i < viewCount; ++i) {
                java.awt.Component comp = this.mainContainer.getComponent(i);
                if (comp == currentContainer) continue;
                comp.setVisible(false);
            }
            currentContainer.setVisible(true);
        }
    }

    @Override
    public void validateObject() {
        super.validateObject();
        if (this.initialSelectedIndex < this.getTabCount() && this.initialSelectedIndex >= 0) {
            this.setSelectedIndex(this.initialSelectedIndex);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            if (model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
            StaticOrderedCollectionInterface orderedModel = (StaticOrderedCollectionInterface)model;
            try {
                this.refreshOrderedCollection(orderedModel);
            }
            finally {
                this.modelInvoked = false;
            }
        } else {
            this.modelInvoked = true;
            this.removeAll();
        }
    }

    public synchronized void refreshOrderedCollection(StaticOrderedCollectionInterface orderedModel) {
        int i;
        int modelCount;
        int selectedIndex = this.getSelectedIndex();
        SelectableInterface origSelected = null;
        if (selectedIndex != -1) {
            origSelected = (SelectableInterface)this.tabSelectionGroup.get(selectedIndex);
        }
        if ((modelCount = orderedModel.count()) == 0) {
            this.modelInvoked = true;
            this.removeAll();
            return;
        }
        int tabCount = this.tabSelectionGroup.count();
        int endPos = modelCount;
        AssociationList addList = new AssociationList();
        OrderedCollection removeList = new OrderedCollection();
        for (int i2 = 0; i2 < endPos; ++i2) {
            Object newItem = orderedModel.get(i2);
            SelectableInterface oldTab = null;
            if (i2 < tabCount && Util.equal((Object)newItem, (Object)(oldTab = (SelectableInterface)this.tabSelectionGroup.get(i2)).getItem())) continue;
            SelectableInterface newTab = null;
            for (int j = 0; j < tabCount; ++j) {
                SelectableInterface object = (SelectableInterface)this.tabSelectionGroup.get(j);
                if (!Util.equal((Object)object.getItem(), (Object)newItem) || addList.contains((Object)object)) continue;
                newTab = object;
                break;
            }
            if (newTab != null) {
                addList.set((Object)new Integer(i2), newTab);
                if (oldTab == null || removeList.contains((Object)oldTab)) continue;
                removeList.add((Object)oldTab);
                continue;
            }
            if (oldTab != null) {
                oldTab.setItem(newItem);
                continue;
            }
            addList.set((Object)new Integer(i2), newItem);
        }
        int removeCount = removeList.count();
        for (int i3 = 0; i3 < removeCount; ++i3) {
            java.awt.Component tab = (java.awt.Component)removeList.get(i3);
            java.awt.Component oldView = (java.awt.Component)this.viewInfo.get((Object)tab);
            this.tabBar.remove(tab);
            if (oldView == null || oldView.getParent() != this.mainContainer) continue;
            this.mainContainer.remove(oldView);
        }
        int addCount = addList.count();
        for (i = 0; i < addCount; ++i) {
            Object addItem = addList.get(i);
            Integer addIndex = (Integer)addList.getKey(i);
            if (addItem instanceof TabButtonInterface) {
                int grpIndex = this.tabBar.getTabGroupIndex((TabButtonInterface)addItem);
                java.awt.Component view = (java.awt.Component)this.viewInfo.get((Object)((java.awt.Component)addItem));
                String vwName = (String)this.constraints.get(view);
                if (vwName == null) {
                    vwName = viewName + this.counter++;
                    this.constraints.put(view, vwName);
                }
                this.tabBar.add((java.awt.Component)addItem, new Integer(grpIndex), addIndex);
                ((java.awt.Component)addItem).addKeyListener(this.mInnerKeyHandler);
                this.mainContainer.add(view, vwName, addIndex);
                continue;
            }
            this.modelInvoked = true;
            this.addItem(addItem, addIndex);
        }
        for (i = endPos; i < tabCount; ++i) {
            this.modelInvoked = true;
            this.remove(i);
        }
        ((java.awt.Component)((Object)this.tabBar)).invalidate();
        this.invalidate();
        this.validate();
        if (origSelected != null && this.tabSelectionGroup.contains(origSelected)) {
            this.tabSelectionGroup.select(origSelected);
        } else {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public synchronized void remove(java.awt.Component comp) {
        if (this.internalRemove) {
            this.constraints.remove(comp);
            super.remove(comp);
            return;
        }
        this.constraints.remove(comp);
        if (!this.viewInfo.contains((Object)comp) && !this.viewInfo.containsKey((Object)comp)) {
            return;
        }
        Object view = null;
        Object tab = null;
        if (comp instanceof TabButtonInterface) {
            tab = comp;
            view = this.viewInfo.get((Object)comp);
        } else if (comp instanceof Container) {
            tab = this.viewInfo.getKey((Object)comp);
            view = comp;
        } else {
            throw new IllegalArgumentException();
        }
        ModelInterface model = this.getModelInterface();
        if (!this.modelInvoked && model != null && model instanceof OrderedCollectionInterface) {
            this.viewerInvoked = true;
            if (view != null && tab != null) {
                ((OrderedCollectionInterface)model).remove(((TabButtonInterface)tab).getItem());
            }
        }
        if (tab != null && view != null) {
            this.viewInfo.removeAt(tab);
            this.mainContainer.remove((java.awt.Component)view);
            this.tabBar.remove((java.awt.Component)tab);
            ((Container)((Object)this.tabBar)).invalidate();
            ((Container)((Object)this.tabBar)).validate();
            ((Container)((Object)this.tabBar)).invalidate();
            this.mainContainer.invalidate();
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void remove(int index) {
        if (this.internalRemove) {
            super.remove(index);
        } else {
            this.remove(this.getView(index));
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    @Override
    public synchronized void removeAll() {
        ModelInterface model = this.getModelInterface();
        if (!this.modelInvoked && model != null && model instanceof OrderedCollectionInterface) {
            this.viewerInvoked = true;
            ((OrderedCollectionInterface)model).removeAll();
        }
        this.constraints.clear();
        this.mainContainer.removeAll();
        this.tabBar.removeAll();
        this.tabSelectionGroup.removeAll();
        this.viewInfo.removeAll();
    }

    public synchronized void removeItem(Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        if (index == -1) {
            return;
        }
        this.remove((java.awt.Component)this.tabSelectionGroup.get(index));
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    public void select(java.awt.Component component) {
        if (component instanceof TabButtonInterface) {
            this.tabSelectionGroup.select((TabButtonInterface)((Object)component));
        } else if (component instanceof Container) {
            try {
                TabButtonInterface tabButton = (TabButtonInterface)this.viewInfo.getKey((Object)component);
                this.tabSelectionGroup.select(tabButton);
            }
            catch (NoSuchElementException e) {
                System.out.println(" TabbedView::select(" + component + ") " + e);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setBackground(Color background) {
        if (background != this.getBackground()) {
            super.setBackground(background);
            this.mainContainer.setBackground(null);
            Enumeration viewE = this.viewInfo.getItems();
            while (viewE.hasMoreElements()) {
                java.awt.Component view = (java.awt.Component)viewE.nextElement();
                view.setBackground(null);
            }
            ((java.awt.Component)((Object)this.tabBar)).setBackground(null);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        if (foreground != this.getForeground()) {
            super.setForeground(foreground);
            this.mainContainer.setForeground(null);
            Enumeration viewE = this.viewInfo.getItems();
            while (viewE.hasMoreElements()) {
                java.awt.Component view = (java.awt.Component)viewE.nextElement();
                view.setForeground(null);
            }
            ((java.awt.Component)((Object)this.tabBar)).setForeground(null);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.vetoExceptionThrown = false;
        this.modelInvoked = false;
        this.viewerInvoked = false;
        this.noPrevAdd = true;
        this.counter = 1;
        this.initialSelectedIndex = 0;
        this.viewInfo = new Dictionary();
        this.constraints = new HashMap();
        this.viewClassName = defaultViewClass;
        this.tabButtonClassName = defaultTabButtonClass;
        this.viewClass = GlobalInfoTable._loadClass((String)defaultViewClass);
        this.tabButtonClass = GlobalInfoTable._loadClass((String)defaultTabButtonClass);
        this.mainContainer = new Panel();
        this.mainContainer.setLayout(new CardLayout());
        BorderInterface border = this.mainContainer.getBorder();
        border.setStyle(4);
        Insets insets = border.getInsets((java.awt.Component)this);
        this.tabBar = new TabBar();
        this.tabBar.setRowBorder(border);
        this.tabBar.setTabButtonClass(this.tabButtonClass);
        com.sas.beans.Util.addPropertyChangeListener((Object)this.tabBar, (PropertyChangeListener)this);
        this.setLayout(new BoxLayout(-insets.top, -insets.bottom, -insets.right, -insets.left));
        super.addImpl((Container)((Object)this.tabBar), new Integer(4), 0);
        super.addImpl(this.mainContainer, new Integer(0), 1);
        this.setIDEDnDDropBarrier(false);
        this.mainContainer.setIDEDnDDropTarget(false);
        ((TabBar)this.tabBar).setIDEDnDDropTarget(false);
        this.tabSelectionGroup = this.tabBar.getSelectionGroup();
        this.tabSelectionGroup.addItemListener(this);
        ((SelectionGroup)this.tabSelectionGroup).addVetoableChangeListener(this);
        com.sas.beans.Util.addPropertyChangeListener((Object)this.tabSelectionGroup, (PropertyChangeListener)this);
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    public void setDisplayTransform(TransformInterface transform) {
        this.tabSelectionGroup.setDisplayTransform(transform);
    }

    public void setInitialSelectedIndex(int initIndex) {
        if (initIndex != this.initialSelectedIndex) {
            int oldIndex = this.initialSelectedIndex;
            this.initialSelectedIndex = initIndex;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"initialSelectedIndex", (int)oldIndex, (int)initIndex);
        }
    }

    public void setInputTransform(TransformInterface transform) {
        this.tabSelectionGroup.setInputTransform(transform);
    }

    public void setOrientation(int orient) {
        this.tabBar.setOrientation(orient);
    }

    public void setOutputTransform(TransformInterface transform) {
        this.tabSelectionGroup.setOutputTransform(transform);
    }

    public void setSelectedIndex(int index) {
        this.tabSelectionGroup.setSelectedIndex(index);
    }

    public void setSelectedItem(Object item) {
        if (item != null && !item.equals(this.getSelectedItem())) {
            this.tabSelectionGroup.setSelectedItem(item);
        }
    }

    public void setStyle(int s) {
        this.tabBar.setStyle(s);
    }

    public synchronized void setTabBar(TabBarInterface newTabBar) {
        if (newTabBar != null && !newTabBar.equals(this.tabBar)) {
            this.removeAll();
            super.remove(0);
            TabBarInterface prevBar = this.tabBar;
            this.tabBar = newTabBar;
            this.tabSelectionGroup = this.tabBar.getSelectionGroup();
            if (prevBar != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)prevBar, (PropertyChangeListener)this);
            }
            if (this.tabBar != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.tabBar, (PropertyChangeListener)this);
            }
            super.addImpl((java.awt.Component)((Object)this.tabBar), new Integer(this.tabBar.getOrientation()), 0);
            this.firePropertyChange("tabBar", prevBar, this.tabBar);
        }
    }

    public void setTabButtonClass(Class tClass) {
        if (tClass != null && tClass != this.tabButtonClass) {
            Class oldTabButtonClass = this.tabButtonClass;
            try {
                Class tabButtonInterfaceClass = GlobalInfoTable.loadClass((String)"com.sas.visuals.TabButtonInterface");
                Class<java.awt.Component> componentClass = java.awt.Component.class;
                if (!componentClass.isAssignableFrom(tClass) || !tabButtonInterfaceClass.isAssignableFrom(tClass)) {
                    return;
                }
                this.tabButtonClass = tClass;
                this.tabButtonClassName = this.tabButtonClass.getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("TabbedView: exception thrown in setTabButtonClass()");
                return;
            }
            this.firePropertyChange("tabButtonClass", oldTabButtonClass, this.tabButtonClass);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            ((java.awt.Component)((Object)this.tabBar)).setEnabled(enabled);
            this.mainContainer.setEnabled(enabled);
        }
    }

    public void setTabEnabled(boolean enabled, Object item) {
        this.tabBar.setTabEnabled(enabled, item);
    }

    public void setTabEnabled(boolean enabled, int index) {
        this.tabBar.setTabEnabled(enabled, index);
    }

    public void setTabVisible(boolean visible, Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        this.setTabVisible(visible, index);
    }

    public void setTabVisible(boolean visible, int index) {
        if (!visible) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex == index && selectedIndex < this.tabSelectionGroup.count() - 1) {
                this.next();
            } else if (selectedIndex == index && selectedIndex > 0) {
                this.previous();
            }
        }
        this.tabBar.setTabVisible(visible, index);
    }

    public void setViewBorder(BorderInterface newBorder) {
        BorderInterface prevBorder = this.getViewBorder();
        if (newBorder != prevBorder && newBorder != null) {
            this.tabBar.setRowBorder(newBorder);
            this.mainContainer.setBorder(newBorder);
            BoxLayout layout = (BoxLayout)this.getLayout();
            Insets insets = newBorder.getInsets((java.awt.Component)this);
            layout.setTopBorder(-insets.top);
            layout.setBottomBorder(-insets.bottom);
            layout.setLeftBorder(-insets.left);
            layout.setRightBorder(-insets.right);
            this.invalidate();
            this.validate();
            this.repaint();
            if (prevBorder != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)prevBorder, (PropertyChangeListener)this);
            }
            if (newBorder != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)newBorder, (PropertyChangeListener)this);
            }
            this.firePropertyChange("viewBorder", prevBorder, newBorder);
        }
    }

    public void setViewClass(Class vClass) {
        if (vClass != null && vClass != this.viewClass) {
            Class oldViewClass = this.viewClass;
            Class<Container> containerClass = Container.class;
            if (!containerClass.isAssignableFrom(vClass)) {
                return;
            }
            this.viewClass = vClass;
            this.viewClassName = this.viewClass.getName();
            this.firePropertyChange("viewClass", oldViewClass, this.viewClass);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        try {
            if (!this.vetoExceptionThrown) {
                this.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
            this.vetoExceptionThrown = false;
        }
        catch (PropertyVetoException e) {
            this.vetoExceptionThrown = true;
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListener);
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private class InnerKeyHandler
    implements KeyListener {
        private InnerKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent p0) {
            if (p0.getSource() instanceof TabButtonInterface) {
                if (p0.getKeyCode() == 37) {
                    int nextIndex = TabbedView.this.getSelectedIndex() - 1;
                    if (nextIndex < 0) {
                        nextIndex = TabbedView.this.getTabCount() - 1;
                    }
                    TabbedView.this.setSelectedIndex(nextIndex);
                    TabButtonInterface ti = TabbedView.this.getTab(TabbedView.this.getSelectedIndex());
                    if (ti instanceof java.awt.Component) {
                        ((java.awt.Component)((Object)ti)).requestFocus();
                    }
                } else if (p0.getKeyCode() == 39) {
                    int nextIndex = TabbedView.this.getSelectedIndex() + 1;
                    if (nextIndex >= TabbedView.this.getTabCount()) {
                        nextIndex = 0;
                    }
                    TabbedView.this.setSelectedIndex(nextIndex);
                    TabButtonInterface ti = TabbedView.this.getTab(TabbedView.this.getSelectedIndex());
                    if (ti instanceof java.awt.Component) {
                        ((java.awt.Component)((Object)ti)).requestFocus();
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent p0) {
        }

        @Override
        public void keyTyped(KeyEvent p0) {
        }
    }
}

