/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.RB;
import com.sas.visuals.TabBorder;
import com.sas.visuals.TabButtonInterface;
import com.sas.visuals.TabButtonModel;
import com.sas.visuals.ToggleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TabButton
extends ToggleButton
implements TabButtonInterface {
    public static final String RB_KEY = "TabButton.";
    static final long serialVersionUID = 4176305727366107158L;
    public static final int NONE = 0;
    protected int orientation;
    private static int defaultHeight = 23;
    private static int defaultWidth = 75;

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "orientation"}, {"Property editor class", "com.sas.beans.editors._SideOrientationEditor"}}};
        ebi.propertyMetadata = propertyMetadata;
        ebi.defaultInputPropertyName = "selected";
        ebi.defaultOutputPropertyName = "selected";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    public TabButton() {
        this(null, null, false);
        if (this.isDesignTime()) {
            this.setItem(RB.getStringResource((String)RB_KEY, (String)"defaultText.txt"));
        }
    }

    public TabButton(String txt) {
        this(txt, null, false);
    }

    public TabButton(IconInterface defaultImg) {
        this(null, defaultImg, false);
    }

    public TabButton(String txt, IconInterface defaultImg) {
        this(txt, defaultImg, false);
    }

    public TabButton(String txt, IconInterface defaultImg, boolean selected) {
        this.setBackground(null);
        this.setBorderPainted(true);
        this.setBorder(new TabBorder(4));
        this.getBorder().setStyle(1);
        this.setDefaultIcon(defaultImg);
        this.setButtonModel(new TabButtonModel(this));
        this.setFocusPainted(true);
        this.setOrientation(4);
        this.setTextPosition(2);
        this.setTransparent(false);
        this.setItem(txt);
        this.setInsets(new Insets(6, 6, 6, 6));
        this.setSelected(selected);
        this.setContentShift(new Point(0, 0));
    }

    @Override
    protected void buttonModelPressed(ButtonModelInterface btnModel) {
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isSelected();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    protected void paintBackground(Graphics g) {
        Dimension size = this.getSize();
        Insets borderInsets = this.getBorder().getInsets((Component)this);
        Color prevColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(borderInsets.left, borderInsets.top, size.width - borderInsets.left - borderInsets.right, size.height - borderInsets.top - borderInsets.bottom);
        g.setColor(prevColor);
    }

    @Override
    public void setOrientation(int orient) {
        if (this.orientation != orient) {
            int oldOrient = this.orientation;
            this.orientation = orient;
            BorderInterface border = this.getBorder();
            if (border instanceof TabBorder) {
                ((TabBorder)border).setOrientation(this.orientation);
            }
            this.repaint();
            this.firePropertyChange("orientation", new Integer(oldOrient), new Integer(this.orientation));
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        ButtonModelInterface btnModel = this.getButtonModel();
        if (!(btnModel instanceof TabButtonModel)) {
            TabButtonModel newBtnModel = new TabButtonModel(this);
            newBtnModel.setSelectionGroup(btnModel.getSelectionGroup());
            newBtnModel.setSelected(btnModel.isSelected());
            newBtnModel.setPressed(btnModel.isPressed());
            newBtnModel.setArmed(btnModel.isArmed());
            newBtnModel.setActionCommand(btnModel.getActionCommand());
            newBtnModel.setDisabled(btnModel.isDisabled());
            newBtnModel.setKeyAccelerator(btnModel.getKeyAccelerator());
            this.setButtonModel(newBtnModel);
        }
        if (this.contentShift != null && this.contentShift.equals(new Point(1, 1))) {
            this.contentShift = new Point(0, 0);
        }
    }

    @Override
    public String toString() {
        return super.toString() + this.getText();
    }
}

