/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.models.IncrementInterface;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import com.sas.util.IntegerRange;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.RB;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class SpinButton
extends Component
implements Adjustable,
AlarmListener,
PropertyChangeListener,
IncrementInterface,
ViewDefaultModelInterface {
    static final long serialVersionUID = 2259662757882653756L;
    static final String RB_KEY = "SpinButton.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.models.BoundedNumberInterface"};
    protected Alarm valueChangeAlarm;
    private transient Rectangle topLeftRectangle;
    private transient Rectangle bottomRightRectangle;
    private transient Rectangle arrowRectangle;
    private transient Rectangle incrementRectangle;
    private transient Rectangle decrementRectangle;
    private transient boolean incrementMouseClick;
    private transient boolean decrementMouseClick;
    private transient boolean incrementRaised;
    private transient boolean decrementRaised;
    private transient BaseBorder buttonBorder;
    private transient AdjustmentListener adjustmentListener;
    protected long startInterval;
    protected long delay;
    private boolean swapped;
    private boolean incrementEnabled;
    private boolean decrementEnabled;
    private boolean cycleValue;
    private IntegerRange defaultModel;
    private int minimum;
    private int maximum;
    private int unitIncrement;
    private int blockIncrement;
    private int value;
    private int buttonGap;
    private int orientation;
    private int arrowDirection;
    private boolean resized;
    protected BoundedNumberInterface defaultRangeModel;
    public static final int UP_DOWN = 2;
    public static final int LEFT_RIGHT = 3;
    private static int defaultWidth = 16;
    private static int defaultHeight = 22;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Hidden", "true"}}, {{"Name", "blockIncrement"}, {"Hidden", "true"}}, {{"Name", "blockIncrementNumber"}, {"Hidden", "true"}}, {{"Name", "buttonGap"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"buttonGapSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonGap.pd.txt")}}, {{"Name", "cycleOn"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"cycleOn.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"cycleOn.pd.txt")}}, {{"Name", "decrementEnabled"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"decrementEnabled.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"decrementEnabled.pd.txt")}}, {{"Name", "incrementEnabled"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"incrementEnabled.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"incrementEnabled.pd.txt")}}, {{"Name", "maximum"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"maximumSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"maximum.pd.txt")}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"minimumSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"minimum.pd.txt")}, {"Expert", "true"}}, {{"Name", "unitIncrement"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"unitIncrementSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"unitIncrement.pd.txt")}, {"Expert", "true"}}, {{"Name", "value"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"valueSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"value.pd.txt")}}, {{"Name", "visibleAmount"}, {"Hidden", "true"}}, {{"Name", "orientation"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"orientationSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors._AdjustableOrientationEditor"}}, {{"Name", "arrowDirection"}, {"Property editor class", "com.sas.beans.editors._SpinButtonArrowDirectionEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "numberValue";
        ebi.defaultOutputPropertyName = "numberValue";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public SpinButton() {
        this.enableEvents(276L);
    }

    public SpinButton(int value, int min, int max, int unit, int block, int orient) {
        this();
        ((BoundedLong)this.defaultRangeModel).setValues((long)value, (long)min, (long)max, (long)unit, (long)block);
        this.setOrientation(orient);
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    private void calculateButtonLayout() {
        Dimension buttonSize = this.getSize();
        if (this.orientation == 0) {
            buttonSize.width = buttonSize.width % 2 == 0 ? buttonSize.width / 2 - this.buttonGap / 2 - this.buttonGap % 2 : buttonSize.width / 2 - this.buttonGap / 2;
            this.topLeftRectangle.x = 0;
            this.topLeftRectangle.y = 0;
            this.topLeftRectangle.height = buttonSize.height;
            this.topLeftRectangle.width = buttonSize.width;
            this.bottomRightRectangle.x = buttonSize.width + this.buttonGap;
            this.bottomRightRectangle.y = 0;
            this.bottomRightRectangle.height = buttonSize.height;
            this.bottomRightRectangle.width = buttonSize.width;
            if (this.arrowDirection == 2) {
                int arrowHeight = buttonSize.height / 3;
                int arrowBase = arrowHeight * 2 - 1;
                if (arrowBase > buttonSize.width / 2) {
                    arrowBase = buttonSize.width / 2;
                    if (arrowBase % 2 == 0) {
                        ++arrowBase;
                    }
                    arrowHeight = arrowBase / 2 + 1;
                }
                this.arrowRectangle.x = buttonSize.width / 2 - (arrowBase / 2 + 1);
                this.arrowRectangle.y = buttonSize.height / 2 - (arrowHeight / 2 + 1);
                this.arrowRectangle.width = arrowBase;
                this.arrowRectangle.height = arrowHeight;
            } else {
                int arrowHeight = buttonSize.width / 3;
                int arrowBase = arrowHeight * 2 - 1;
                if (arrowBase > buttonSize.height / 2) {
                    arrowBase = buttonSize.height / 2;
                    if (arrowBase % 2 == 0) {
                        ++arrowBase;
                    }
                    arrowHeight = arrowBase / 2 + 1;
                }
                this.arrowRectangle.x = buttonSize.width / 2 - (arrowHeight / 2 + 1);
                this.arrowRectangle.y = buttonSize.height / 2 - (arrowBase / 2 + 1);
                this.arrowRectangle.width = arrowHeight;
                this.arrowRectangle.height = arrowBase;
            }
        } else {
            buttonSize.height = buttonSize.height % 2 == 0 ? buttonSize.height / 2 - this.buttonGap / 2 - this.buttonGap % 2 : buttonSize.height / 2 - this.buttonGap / 2;
            this.topLeftRectangle.x = 0;
            this.topLeftRectangle.y = 0;
            this.topLeftRectangle.height = buttonSize.height;
            this.topLeftRectangle.width = buttonSize.width;
            this.bottomRightRectangle.x = 0;
            this.bottomRightRectangle.y = buttonSize.height + this.buttonGap;
            this.bottomRightRectangle.height = buttonSize.height;
            this.bottomRightRectangle.width = buttonSize.width;
            if (this.arrowDirection == 3) {
                int arrowHeight = buttonSize.width / 3;
                int arrowBase = arrowHeight * 2 - 1;
                if (arrowBase > buttonSize.height / 2) {
                    arrowBase = buttonSize.height / 2;
                    if (arrowBase % 2 == 0) {
                        ++arrowBase;
                    }
                    arrowHeight = arrowBase / 2 + 1;
                }
                this.arrowRectangle.x = buttonSize.width / 2 - (arrowHeight / 2 + 1);
                this.arrowRectangle.y = buttonSize.height / 2 - (arrowBase / 2 + 1);
                this.arrowRectangle.width = arrowHeight;
                this.arrowRectangle.height = arrowBase;
            } else {
                int arrowHeight = buttonSize.height / 3;
                int arrowBase = arrowHeight * 2 - 1;
                if (arrowBase > buttonSize.width / 2) {
                    arrowBase = buttonSize.width / 2;
                    if (arrowBase % 2 == 0) {
                        ++arrowBase;
                    }
                    arrowHeight = arrowBase / 2 + 1;
                }
                this.arrowRectangle.x = buttonSize.width / 2 - (arrowBase / 2 + 1);
                this.arrowRectangle.y = buttonSize.height / 2 - (arrowHeight / 2 + 1);
                this.arrowRectangle.width = arrowBase;
                this.arrowRectangle.height = arrowHeight;
            }
        }
    }

    protected void checkEnabled() {
        if (!this.isEnabled()) {
            return;
        }
        boolean incEnabled = true;
        boolean decEnabled = true;
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && !this.cycleValue) {
            Number newValue = model.getNumberValue();
            Number min = model.getMinimumNumber();
            Number max = model.getMaximumNumber();
            if (newValue instanceof Integer) {
                if (newValue.intValue() >= max.intValue()) {
                    incEnabled = false;
                }
                if (newValue.intValue() <= min.intValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Double) {
                if (newValue.doubleValue() >= max.doubleValue()) {
                    incEnabled = false;
                }
                if (newValue.doubleValue() <= min.doubleValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Float) {
                if (newValue.floatValue() >= max.floatValue()) {
                    incEnabled = false;
                }
                if (newValue.floatValue() <= min.floatValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Byte) {
                if (newValue.byteValue() >= max.byteValue()) {
                    incEnabled = false;
                }
                if (newValue.byteValue() <= min.byteValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Long) {
                if (newValue.longValue() >= max.longValue()) {
                    incEnabled = false;
                }
                if (newValue.longValue() <= min.longValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Short) {
                if (newValue.shortValue() >= max.shortValue()) {
                    incEnabled = false;
                }
                if (newValue.shortValue() <= min.shortValue()) {
                    decEnabled = false;
                }
            }
        }
        this.setIncrementEnabled(incEnabled);
        this.setDecrementEnabled(decEnabled);
    }

    @Override
    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void detachModel(ModelInterface model) {
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)this);
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultRangeModel);
        }
    }

    public void fireAlarm(AlarmEvent evt) {
        long interval = this.valueChangeAlarm.getInterval();
        if (interval > 100L) {
            this.valueChangeAlarm.setInterval(interval - 100L);
        }
        if (!this.incrementRaised && this.incrementEnabled) {
            this.incrementBy(1, 0);
            this.processEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
            return;
        }
        if (!this.decrementRaised && this.decrementEnabled) {
            this.incrementBy(-1, 0);
            this.processEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
            return;
        }
    }

    public Alarm getAlarm() {
        return this.valueChangeAlarm;
    }

    public int getArrowDirection() {
        return this.arrowDirection;
    }

    @Override
    public final int getBlockIncrement() {
        return this.getBlockIncrementNumber().intValue();
    }

    public int getButtonGap() {
        return this.buttonGap;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public final int getMaximum() {
        return this.getMaximumNumber().intValue();
    }

    @Override
    public final int getMinimum() {
        return this.getMinimumNumber().intValue();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 0) {
            return new Dimension(22, 12);
        }
        return new Dimension(12, 22);
    }

    public long getStartInterval() {
        return this.startInterval;
    }

    void fireBooleanPropertyChange(String propertyName, boolean currentState) {
        if (currentState) {
            this.firePropertyChange(propertyName, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(propertyName, Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public final int getUnitIncrement() {
        return this.getUnitIncrementNumber().intValue();
    }

    @Override
    public final int getValue() {
        return this.getNumberValue().intValue();
    }

    @Override
    public int getVisibleAmount() {
        return 0;
    }

    public boolean isCycleOn() {
        return this.cycleValue;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultRangeModel == this.getModelInterface();
    }

    public boolean isDecrementEnabled() {
        return this.decrementEnabled;
    }

    public boolean isIncrementEnabled() {
        return this.incrementEnabled;
    }

    public Number incrementBy(int increment, int incrementType) {
        IncrementInterface model = (IncrementInterface)this.getModelInterface();
        if (model != null) {
            Number oldValue = this.getNumberValue();
            if (this.cycleValue) {
                Number max = this.getMaximumNumber();
                Number min = this.getMinimumNumber();
                if (max.equals(oldValue) && increment > 0) {
                    Number newValue = new Long(max.longValue() + 1L);
                    if (max instanceof Double) {
                        newValue = new Double(max.doubleValue() + 1.0);
                    }
                    this.setNumberValue(newValue);
                    return this.getNumberValue();
                }
                if (min.equals(oldValue) && increment < 0) {
                    Number newValue = new Long(min.longValue() - 1L);
                    if (min instanceof Double) {
                        newValue = new Double(min.doubleValue() - 1.0);
                    }
                    this.setNumberValue(newValue);
                    return this.getNumberValue();
                }
            }
            return model.incrementBy(increment, incrementType);
        }
        return this.getNumberValue();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.calculateButtonLayout();
        this.buttonBorder.setStyle(4);
        int lightSource = 10;
        if (this.incrementRaised) {
            lightSource = 5;
        }
        this.buttonBorder.drawInRect(g, this.incrementRectangle, lightSource);
        lightSource = this.decrementRaised ? 5 : 10;
        this.buttonBorder.drawInRect(g, this.decrementRectangle, lightSource);
        if (this.orientation == 0) {
            if (this.arrowDirection == 2) {
                if (this.incrementRectangle == this.topLeftRectangle) {
                    this.paintArrow(g, this.arrowRectangle, 8, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                    this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                    this.paintArrow(g, this.arrowRectangle, 4, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                    this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
                } else {
                    this.paintArrow(g, this.arrowRectangle, 8, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                    this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                    this.paintArrow(g, this.arrowRectangle, 4, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                    this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
                }
            } else if (this.incrementRectangle == this.topLeftRectangle) {
                this.paintArrow(g, this.arrowRectangle, 1, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                this.paintArrow(g, this.arrowRectangle, 2, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
            } else {
                this.paintArrow(g, this.arrowRectangle, 1, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                this.paintArrow(g, this.arrowRectangle, 2, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
            }
        } else if (this.arrowDirection == 3) {
            if (this.incrementRectangle == this.topLeftRectangle) {
                this.paintArrow(g, this.arrowRectangle, 1, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                this.paintArrow(g, this.arrowRectangle, 2, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
            } else {
                this.paintArrow(g, this.arrowRectangle, 1, this.decrementRaised, this.decrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
                this.paintArrow(g, this.arrowRectangle, 2, this.incrementRaised, this.incrementEnabled && this.isEnabled());
                this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
            }
        } else if (this.incrementRectangle == this.topLeftRectangle) {
            this.paintArrow(g, this.arrowRectangle, 4, this.incrementRaised, this.incrementEnabled && this.isEnabled());
            this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
            this.paintArrow(g, this.arrowRectangle, 8, this.decrementRaised, this.decrementEnabled && this.isEnabled());
            this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
        } else {
            this.paintArrow(g, this.arrowRectangle, 4, this.decrementRaised, this.decrementEnabled && this.isEnabled());
            this.arrowRectangle.translate(this.bottomRightRectangle.x, this.bottomRightRectangle.y);
            this.paintArrow(g, this.arrowRectangle, 8, this.incrementRaised, this.incrementEnabled && this.isEnabled());
            this.arrowRectangle.translate(-this.bottomRightRectangle.x, -this.bottomRightRectangle.y);
        }
    }

    private void paintArrow(Graphics g, Rectangle arrowBounds, int direction, boolean raised, boolean enabled) {
        Polygon arrow = new Polygon();
        if (!raised) {
            arrowBounds.translate(1, 1);
        }
        switch (direction) {
            case 4: {
                arrow.addPoint(arrowBounds.x + arrowBounds.width / 2, arrowBounds.y - 1);
                arrow.addPoint(arrowBounds.x - 1, arrowBounds.y + arrowBounds.height);
                arrow.addPoint(arrowBounds.x + 1 + arrowBounds.width, arrowBounds.y + arrowBounds.height);
                break;
            }
            case 8: {
                arrow.addPoint(arrowBounds.x + arrowBounds.width / 2, arrowBounds.y + arrowBounds.height);
                arrow.addPoint(arrowBounds.x, arrowBounds.y);
                arrow.addPoint(arrowBounds.x + arrowBounds.width, arrowBounds.y);
                break;
            }
            case 2: {
                arrow.addPoint(arrowBounds.x + arrowBounds.width, arrowBounds.y + arrowBounds.height / 2);
                arrow.addPoint(arrowBounds.x, arrowBounds.y - 1);
                arrow.addPoint(arrowBounds.x, arrowBounds.y + arrowBounds.height);
                break;
            }
            case 1: {
                arrow.addPoint(arrowBounds.x, arrowBounds.y + arrowBounds.height / 2);
                arrow.addPoint(arrowBounds.x + arrowBounds.width, arrowBounds.y - 1);
                arrow.addPoint(arrowBounds.x + arrowBounds.width, arrowBounds.y + arrowBounds.height);
            }
        }
        if (!raised) {
            arrowBounds.translate(-1, -1);
        }
        if (enabled) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.gray);
        }
        g.fillPolygon(arrow);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            super.processMouseEvent(evt);
            return;
        }
        switch (evt.getID()) {
            case 501: {
                if (this.incrementRectangle.contains(evt.getX(), evt.getY()) && this.incrementEnabled) {
                    this.incrementRaised = false;
                    this.incrementMouseClick = true;
                    this.valueChangeAlarm.setInterval(this.startInterval);
                    this.valueChangeAlarm.setDelay(this.delay);
                    if (this.startInterval > 0L) {
                        this.valueChangeAlarm.start();
                    }
                }
                if (this.decrementRectangle.contains(evt.getX(), evt.getY()) && this.decrementEnabled) {
                    this.decrementRaised = false;
                    this.decrementMouseClick = true;
                    this.valueChangeAlarm.setInterval(this.startInterval);
                    this.valueChangeAlarm.setDelay(this.delay);
                    if (this.startInterval > 0L) {
                        this.valueChangeAlarm.start();
                    }
                }
                this.repaint();
                break;
            }
            case 502: {
                if (!this.incrementRaised) {
                    this.incrementRaised = true;
                    if (this.incrementEnabled) {
                        this.incrementBy(1, 0);
                        this.processEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
                    }
                    this.valueChangeAlarm.stop();
                }
                if (!this.decrementRaised) {
                    this.decrementRaised = true;
                    if (this.decrementEnabled) {
                        this.incrementBy(-1, 0);
                        this.processEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
                    }
                    this.valueChangeAlarm.stop();
                }
                this.incrementMouseClick = false;
                this.decrementMouseClick = false;
                this.repaint();
                break;
            }
            case 504: {
                if (this.incrementMouseClick) {
                    this.valueChangeAlarm.setInterval(this.startInterval);
                    this.valueChangeAlarm.setDelay(this.delay);
                    if (this.startInterval > 0L) {
                        this.valueChangeAlarm.start();
                    }
                    this.incrementRaised = false;
                    this.repaint();
                }
                if (!this.decrementMouseClick) break;
                this.valueChangeAlarm.setInterval(this.startInterval);
                this.valueChangeAlarm.setDelay(this.delay);
                if (this.startInterval > 0L) {
                    this.valueChangeAlarm.start();
                }
                this.decrementRaised = false;
                this.repaint();
                break;
            }
            case 505: {
                if (this.incrementMouseClick) {
                    this.valueChangeAlarm.stop();
                    this.incrementRaised = true;
                    this.repaint();
                }
                if (!this.decrementMouseClick) break;
                this.valueChangeAlarm.stop();
                this.decrementRaised = true;
                this.repaint();
            }
        }
        super.processMouseEvent(evt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (eSource == this.getModelInterface() && propName != null && oldValue != null && oldValue instanceof Number && newValue != null && newValue instanceof Number) {
            Integer oldIntegerValue = new Integer(((Number)oldValue).intValue());
            Integer newIntegerValue = new Integer(((Number)newValue).intValue());
            if (propName.equals("minimumNumber")) {
                this.checkEnabled();
                this.firePropertyChange("minimum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("maximumNumber")) {
                this.checkEnabled();
                this.firePropertyChange("maximum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("numberValue")) {
                this.checkEnabled();
                this.firePropertyChange("value", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("blockIncrementNumber")) {
                this.firePropertyChange("blockIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("unitIncrementNumber")) {
                this.firePropertyChange("unitIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("adjustmentL" == key) {
                this.addAdjustmentListener((AdjustmentListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.defaultRangeModel == null) {
            this.defaultRangeModel = new BoundedLong();
            ((BoundedLong)this.defaultRangeModel).initialize();
            ModelInterface oldModel = this.getModelInterface();
            if (oldModel == null) {
                Long newValue = new Long(this.value);
                Long max = new Long(this.maximum);
                Long min = new Long(this.minimum);
                Long unit = new Long(this.unitIncrement);
                Long block = new Long(this.blockIncrement);
                Long incrementDefault = new Long(1L);
                int range = this.maximum - this.minimum;
                if (range > 0 && this.blockIncrement > range) {
                    block = incrementDefault;
                }
                if (range > 0 && this.unitIncrement > range) {
                    unit = incrementDefault;
                }
                ((BoundedLong)this.defaultRangeModel).setNumberValues((Number)newValue, (Number)min, (Number)max, (Number)unit, (Number)block);
                this.setModelInterface((ModelInterface)((BoundedLong)this.defaultRangeModel));
            } else if (oldModel instanceof IntegerRange) {
                IntegerRange oldRange = (IntegerRange)oldModel;
                int range = oldRange.getMaximum() - oldRange.getMinimum();
                Long incrementDefault = new Long(1L);
                Number newValue = oldRange.getNumberValue();
                Number min = oldRange.getMinimumNumber();
                Number max = oldRange.getMaximumNumber();
                Number unit = oldRange.getUnitIncrementNumber();
                Number block = oldRange.getBlockIncrementNumber();
                if (range > 0 && block.intValue() > range) {
                    block = incrementDefault;
                }
                if (range > 0 && unit.intValue() > range) {
                    unit = incrementDefault;
                }
                ((BoundedLong)this.defaultRangeModel).setNumberValues(newValue, min, max, unit, block);
                this.setModelInterface((ModelInterface)((BoundedLong)this.defaultRangeModel));
            }
            this.defaultModel = null;
        }
        this.incrementMouseClick = false;
        this.decrementMouseClick = false;
        this.incrementRaised = true;
        this.decrementRaised = true;
        this.topLeftRectangle = new Rectangle();
        this.bottomRightRectangle = new Rectangle();
        if (this.swapped) {
            this.incrementRectangle = this.bottomRightRectangle;
            this.decrementRectangle = this.topLeftRectangle;
        } else {
            this.incrementRectangle = this.topLeftRectangle;
            this.decrementRectangle = this.bottomRightRectangle;
        }
        this.arrowRectangle = new Rectangle();
        this.buttonBorder = new BaseBorder();
        if (this.valueChangeAlarm == null) {
            this.valueChangeAlarm = new Alarm();
        }
        this.valueChangeAlarm.addAlarmListener((AlarmListener)this);
        if (this.startInterval == 0L && this.delay == 0L) {
            this.startInterval = 500L;
            this.delay = 400L;
        }
        if (this.arrowDirection != 2 && this.arrowDirection != 3) {
            this.arrowDirection = this.orientation == 0 ? 3 : 2;
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null && model instanceof BoundedNumberInterface) {
            Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)this);
            BoundedNumberInterface boundedNumber = (BoundedNumberInterface)model;
            Integer integerValue = new Integer(boundedNumber.getNumberValue().intValue());
            Integer integerMax = new Integer(boundedNumber.getMaximumNumber().intValue());
            Integer integerMin = new Integer(boundedNumber.getMinimumNumber().intValue());
            Integer integerBlock = new Integer(boundedNumber.getBlockIncrementNumber().intValue());
            Integer integerUnit = new Integer(boundedNumber.getUnitIncrementNumber().intValue());
            this.firePropertyChange("value", integerValue, integerValue);
            this.firePropertyChange("maximum", integerMax, integerMax);
            this.firePropertyChange("minimum", integerMin, integerMin);
            this.firePropertyChange("blockIncrement", integerBlock, integerBlock);
            this.firePropertyChange("unitIncrement", integerUnit, integerUnit);
            this.firePropertyChange("numberValue", boundedNumber.getNumberValue(), boundedNumber.getNumberValue());
            this.firePropertyChange("maximumNumber", boundedNumber.getMaximumNumber(), boundedNumber.getMaximumNumber());
            this.firePropertyChange("minimumNumber", boundedNumber.getMinimumNumber(), boundedNumber.getMinimumNumber());
            this.firePropertyChange("blockIncrementNumber", boundedNumber.getBlockIncrementNumber(), boundedNumber.getBlockIncrementNumber());
            this.firePropertyChange("unitIncrementNumber", boundedNumber.getUnitIncrementNumber(), boundedNumber.getUnitIncrementNumber());
            Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
            this.checkEnabled();
        }
    }

    public void setArrowDirection(int d) {
        if (d != this.arrowDirection) {
            Integer oldD = new Integer(this.arrowDirection);
            this.arrowDirection = d;
            this.repaint();
            this.firePropertyChange("arrowDirection", oldD, new Integer(this.arrowDirection));
        }
    }

    @Override
    public final void setBlockIncrement(int block) {
        this.setBlockIncrementNumber(new Integer(block));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.repaint();
    }

    public void setButtonGap(int gap) {
        if (this.getButtonGap() != gap) {
            int oldButtonGap = this.buttonGap;
            this.buttonGap = gap;
            this.repaint();
            this.firePropertyChange("buttonGap", new Integer(oldButtonGap), new Integer(this.buttonGap));
        }
    }

    public void setCycleOn(boolean cycle) {
        if (this.cycleValue != cycle) {
            this.cycleValue = cycle;
            if (this.isEnabled()) {
                this.setIncrementEnabled(true);
                this.setDecrementEnabled(true);
            }
            this.fireBooleanPropertyChange("cycleOn", this.cycleValue);
        }
    }

    public void setDecrementEnabled(boolean decrEnabled) {
        if (this.decrementEnabled != decrEnabled) {
            this.decrementEnabled = decrEnabled;
            this.repaint();
            this.fireBooleanPropertyChange("decrementEnabled", this.decrementEnabled);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.swapped = false;
        this.incrementMouseClick = false;
        this.decrementMouseClick = false;
        this.incrementRaised = true;
        this.decrementRaised = true;
        this.incrementEnabled = true;
        this.decrementEnabled = true;
        this.buttonGap = 0;
        this.orientation = 1;
        this.topLeftRectangle = new Rectangle();
        this.bottomRightRectangle = new Rectangle();
        this.incrementRectangle = this.topLeftRectangle;
        this.decrementRectangle = this.bottomRightRectangle;
        this.arrowRectangle = new Rectangle();
        this.setBackground(SystemColor.control);
        this.setTransparent(false);
        this.minimum = 0;
        this.maximum = 100;
        this.unitIncrement = 1;
        this.blockIncrement = 10;
        this.value = 0;
        this.delay = 400L;
        this.startInterval = 500L;
        this.valueChangeAlarm = new Alarm();
        this.valueChangeAlarm.setDelay(this.delay);
        this.valueChangeAlarm.setInterval(this.startInterval);
        this.valueChangeAlarm.addAlarmListener((AlarmListener)this);
        this.defaultModel = null;
        this.defaultRangeModel = new BoundedLong();
        this.setModelInterface((ModelInterface)this.defaultRangeModel);
        this.arrowDirection = 2;
        this.buttonBorder = new BaseBorder();
    }

    public synchronized void setAlarm(Alarm alarm) {
    }

    public void setDelay(long d) {
        if (d != this.delay) {
            long oldDelay = this.delay;
            this.delay = d;
            this.firePropertyChange("delay", new Long(oldDelay), new Long(this.delay));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.checkEnabled();
        }
    }

    public void setIncrementEnabled(boolean incrEnabled) {
        if (this.incrementEnabled != incrEnabled) {
            this.incrementEnabled = incrEnabled;
            this.repaint();
            this.fireBooleanPropertyChange("incrementEnabled", this.incrementEnabled);
        }
    }

    @Override
    public final void setMaximum(int max) {
        this.setMaximumNumber(new Long(max));
    }

    @Override
    public final void setMinimum(int min) {
        this.setMinimumNumber(new Long(min));
    }

    public synchronized void setOrientation(int orient) {
        if (this.getOrientation() != orient) {
            int oldOrientation = this.orientation;
            if (orient != 0) {
                this.incrementRectangle = this.topLeftRectangle;
                this.decrementRectangle = this.bottomRightRectangle;
                this.swapped = false;
                this.orientation = 1;
            } else {
                this.incrementRectangle = this.bottomRightRectangle;
                this.decrementRectangle = this.topLeftRectangle;
                this.swapped = true;
                this.orientation = 0;
            }
            if (this.arrowDirection == 2) {
                this.setArrowDirection(3);
            } else {
                this.setArrowDirection(2);
            }
            Dimension size = this.getSize();
            this.setSize(size.height, size.width);
            this.repaint();
            this.firePropertyChange("orientation", new Integer(oldOrientation), new Integer(this.orientation));
        }
    }

    public synchronized void setStartInterval(long interval) {
        if (interval != this.startInterval) {
            long oldInterval = this.startInterval;
            this.startInterval = interval;
            this.firePropertyChange("startInterval", new Long(oldInterval), new Long(this.startInterval));
        }
    }

    @Override
    public final void setUnitIncrement(int unit) {
        this.setUnitIncrementNumber(new Long(unit));
    }

    @Override
    public final void setValue(int newValue) {
        this.setNumberValue(new Long(newValue));
    }

    public Number getUnitIncrementNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getUnitIncrementNumber();
        }
        return null;
    }

    public Number getBlockIncrementNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getBlockIncrementNumber();
        }
        return null;
    }

    public Number getMaximumNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getMaximumNumber();
        }
        return null;
    }

    public Number getMinimumNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getMinimumNumber();
        }
        return null;
    }

    public Number getNumberValue() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getNumberValue();
        }
        return null;
    }

    public synchronized void setMaximumNumber(Number max) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && max != null) {
            model.setMaximumNumber(max);
        }
    }

    public synchronized void setMinimumNumber(Number min) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && min != null) {
            model.setMinimumNumber(min);
        }
    }

    public synchronized void setBlockIncrementNumber(Number block) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && block != null) {
            model.setBlockIncrementNumber(block);
        }
    }

    public synchronized void setUnitIncrementNumber(Number unit) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && unit != null) {
            model.setUnitIncrementNumber(unit);
        }
    }

    public synchronized void setNumberValue(Number newValue) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && newValue != null) {
            Number oldValue = model.getNumberValue();
            if (this.cycleValue) {
                Number max = model.getMaximumNumber();
                Number min = model.getMinimumNumber();
                if (oldValue instanceof Integer) {
                    if (newValue.intValue() > max.intValue()) {
                        newValue = min;
                    } else if (newValue.intValue() < min.intValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Double) {
                    if (newValue.doubleValue() > max.doubleValue()) {
                        newValue = min;
                    } else if (newValue.doubleValue() < min.doubleValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Float) {
                    if (newValue.floatValue() > max.floatValue()) {
                        newValue = min;
                    } else if (newValue.floatValue() < min.floatValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Byte) {
                    if (newValue.byteValue() > max.byteValue()) {
                        newValue = min;
                    } else if (newValue.byteValue() < min.byteValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Short) {
                    if (newValue.shortValue() > max.shortValue()) {
                        newValue = min;
                    } else if (newValue.shortValue() < min.shortValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Long) {
                    if (newValue.longValue() > max.longValue()) {
                        newValue = min;
                    } else if (newValue.longValue() < min.longValue()) {
                        newValue = max;
                    }
                }
            }
            model.setNumberValue(newValue);
        }
    }

    @Override
    public void setVisibleAmount(int amount) {
    }

    public synchronized int swapButtonFunction() {
        if (this.incrementRectangle == this.topLeftRectangle) {
            this.incrementRectangle = this.bottomRightRectangle;
            this.decrementRectangle = this.topLeftRectangle;
            this.swapped = true;
            return 1;
        }
        this.incrementRectangle = this.topLeftRectangle;
        this.decrementRectangle = this.bottomRightRectangle;
        this.swapped = false;
        return 0;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "adjustmentL", this.adjustmentListener);
        s.writeObject(null);
    }
}

