/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.TextField;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.lang.DoubleData;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.FloatData;
import com.sas.lang.StringDataInterface;
import com.sas.models.BoundedDouble;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.util.Alarm;
import com.sas.util.Countable;
import com.sas.util.IndexedGetInterface;
import com.sas.util.IntegerRange;
import com.sas.util.PrefixPredicate;
import com.sas.util.Util;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.RB;
import com.sas.visuals.SpinButton;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.TextComponent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;

public class SpinBox
extends CompositeContainer
implements Adjustable,
ItemSelectable,
AdjustmentListener,
StringDataInterface,
DoubleDataInterface,
ContentsChangedListener {
    public static final String RB_KEY = "SpinBox.";
    static final long serialVersionUID = 8622081177453794884L;
    protected SpinButton spinBtn;
    protected TextField text;
    protected double precision;
    protected NumberFormat numberFormat;
    protected boolean numberFormatSet;
    private IntegerRange defaultModel;
    private double scale;
    private double scaledValue;
    protected BoundedNumberInterface defaultRangeModel;
    protected boolean precisionDisplayed;
    protected transient boolean textInvoked;
    protected transient boolean valueInvoked;
    protected transient PrefixPredicate prefixPredicate;
    protected transient ArrowKeyAdapter arrowKeyAdapter;
    protected transient ItemTextAdapter itemTextAdapter;
    protected transient AdjustmentListener adjustmentListener;
    protected transient ItemListener itemListener;
    protected TransformInterface displayTransform;
    private static int defaultWidth = 124;
    private static int defaultHeight = 23;
    private static String[] requiredInterface1String = new String[]{"com.sas.models.BoundedNumberInterface"};
    private static String[] requiredInterface2String = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    public static final int UP_DOWN = 2;
    public static final int LEFT_RIGHT = 3;

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Hidden", "true"}}, {{"Name", "columns"}, {"Expert", "true"}}, {{"Name", "blockIncrement"}, {"Hidden", "true"}}, {{"Name", "blockIncrementNumber"}, {"Hidden", "true"}}, {{"Name", "maximum"}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Expert", "true"}}, {{"Name", "precisionDisplayed"}, {"Hidden", "true"}}, {{"Name", "precision"}, {"Hidden", "true"}}, {{"Name", "unitIncrement"}, {"Expert", "true"}}, {{"Name", "value"}, {"Expert", "true"}}, {{"Name", "visibleAmount"}, {"Hidden", "true"}}};
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object eSource = e.getSource();
        if (this.adjustmentListener != null && (eSource == this || eSource == this.spinBtn)) {
            this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, e.getID(), e.getAdjustmentType(), e.getValue()));
        }
    }

    public synchronized void contentsChanged(ContentsChangedEvent e) {
        ModelInterface model = this.getModelInterface();
        if (e.getSource() == model && model instanceof IndexedGetInterface) {
            int curIndex;
            IndexedGetInterface collection = (IndexedGetInterface)model;
            int count = collection.count() - 1;
            if (count < 0) {
                count = 1;
            }
            if ((curIndex = this.spinBtn.getValue()) <= count) {
                Object item = collection.get(curIndex);
                try {
                    if (this.displayTransform != null) {
                        item = this.displayTransform.transform(item);
                    }
                }
                catch (TransformException exc) {
                    System.out.println("TransformException in contentsChanged " + (Object)((Object)exc));
                }
                if (item != null && Util.unequal((Object)this.getText(), (Object)item.toString())) {
                    this.text.setText(item.toString());
                }
            }
            this.setMaximum(count);
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model instanceof BoundedNumberInterface) {
            this.spinBtn.detachModel(model);
        } else if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultRangeModel);
        }
    }

    public Alarm getAlarm() {
        return this.spinBtn.getAlarm();
    }

    public int getArrowDirection() {
        return this.spinBtn.getArrowDirection();
    }

    public long getDelay() {
        return this.spinBtn.getDelay();
    }

    public long getStartInterval() {
        return this.spinBtn.getStartInterval();
    }

    @Override
    public int getBlockIncrement() {
        return this.spinBtn.getBlockIncrement();
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public final double getDoubleData() {
        return this.getNumberValue().doubleValue();
    }

    @Override
    public int getMaximum() {
        return this.spinBtn.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.spinBtn.getMinimum();
    }

    public Number getBlockIncrementNumber() {
        return this.spinBtn.getBlockIncrementNumber();
    }

    public Number getMaximumNumber() {
        return this.spinBtn.getMaximumNumber();
    }

    public Number getMinimumNumber() {
        return this.spinBtn.getMinimumNumber();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(2);
        requiredInterfaces.addElement(requiredInterface1String);
        requiredInterfaces.addElement(requiredInterface2String);
        return requiredInterfaces;
    }

    public Number getUnitIncrementNumber() {
        return this.spinBtn.getUnitIncrementNumber();
    }

    public Number getNumberValue() {
        return this.spinBtn.getNumberValue();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public int getOrientation() {
        return this.spinBtn.getOrientation();
    }

    public double getPrecision() {
        return this.precision;
    }

    @Override
    public Object[] getSelectedObjects() {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof StaticOrderedCollectionInterface) {
            Object[] selectedItem = new Object[]{((StaticOrderedCollectionInterface)model).get(this.getValue())};
            return selectedItem;
        }
        return null;
    }

    public String getText() {
        return this.text.getText();
    }

    @Override
    public int getUnitIncrement() {
        return this.spinBtn.getUnitIncrement();
    }

    @Override
    public int getValue() {
        return this.spinBtn.getValue();
    }

    @Override
    public int getVisibleAmount() {
        return this.spinBtn.getVisibleAmount();
    }

    public boolean isCycleOn() {
        return this.spinBtn.isCycleOn();
    }

    public boolean isPrecisionDisplayed() {
        return this.precisionDisplayed;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String name = event.getPropertyName();
        if (eSource == this.spinBtn && name != null) {
            Object newValue = event.getNewValue();
            if (Util.equal((Object)name, (Object)"numberValue")) {
                if (!this.textInvoked && newValue != null && newValue instanceof Number) {
                    this.updateText((Number)newValue);
                }
                this.firePropertyChange("doubleData", event.getOldValue(), newValue);
                this.firePropertyChange(name, event.getOldValue(), newValue);
            } else if (Util.equal((Object)name, (Object)"value") || Util.equal((Object)name, (Object)"maximumNumber") || Util.equal((Object)name, (Object)"minimumNumber") || Util.equal((Object)name, (Object)"unitIncrementNumber") || Util.equal((Object)name, (Object)"blockIncrementNumber") || Util.equal((Object)name, (Object)"maximum") || Util.equal((Object)name, (Object)"minimum") || Util.equal((Object)name, (Object)"unitIncrement") || Util.equal((Object)name, (Object)"blockIncrement") || Util.equal((Object)name, (Object)"alarm") || Util.equal((Object)name, (Object)"cycleOn") || Util.equal((Object)name, (Object)"arrowDirection") || Util.equal((Object)name, (Object)"orientation")) {
                this.firePropertyChange(name, event.getOldValue(), newValue);
            }
        } else if (eSource == this.text && name != null) {
            if (Util.equal((Object)name, (Object)"text") && !this.valueInvoked) {
                this.updateValue(this.text.getText());
            }
            if (Util.equal((Object)name, (Object)"text") || Util.equal((Object)name, (Object)"columns")) {
                this.firePropertyChange(name, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        ModelInterface model;
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("adjustmentL" == key) {
                this.addAdjustmentListener((AdjustmentListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.defaultRangeModel == null) {
            this.defaultModel = null;
            this.defaultRangeModel = new BoundedDouble();
            ((BoundedDouble)this.defaultRangeModel).initialize();
            ((BoundedDouble)this.defaultRangeModel).setUnitIncrement(this.scale);
            ((BoundedDouble)this.defaultRangeModel).setValue(this.scaledValue);
            ((BoundedDouble)this.defaultRangeModel).setMaximum(Double.MAX_VALUE);
            ((BoundedDouble)this.defaultRangeModel).setMinimum(-1.7976931348623157E308);
            model = this.getModelInterface();
            if (model instanceof IntegerRange) {
                this.setModelInterface((ModelInterface)((BoundedDouble)this.defaultRangeModel));
            }
        }
        this.arrowKeyAdapter = new ArrowKeyAdapter();
        this.arrowKeyAdapter.setSpinButton(this.spinBtn);
        this.text.addKeyListener(this.arrowKeyAdapter);
        this.itemTextAdapter = new ItemTextAdapter();
        model = this.getModelInterface();
        if (model instanceof StaticOrderedCollectionInterface) {
            int index = this.spinBtn.getValue();
            if (index < ((Countable)model).count()) {
                Object item = ((StaticOrderedCollectionInterface)model).get(index);
                try {
                    if (this.displayTransform != null) {
                        item = this.displayTransform.transform(item);
                    }
                }
                catch (TransformException e) {
                    System.out.println("TransformException in readObject " + (Object)((Object)e));
                }
                if (item != null) {
                    this.text.setText(item.toString());
                }
            }
            this.text.addTextListener(this.itemTextAdapter);
            this.itemTextAdapter.setCollection((StaticOrderedCollectionInterface)model);
        }
        this.prefixPredicate = new PrefixPredicate(" ");
        this.textInvoked = false;
        this.valueInvoked = false;
        this.spinBtn.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.text.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        if (this.isPrecisionDisplayed() && !this.numberFormatSet) {
            this.numberFormat = new DecimalFormat();
            if (this.precision == 0.0 || this.precision == 1.0) {
                ((DecimalFormat)this.numberFormat).applyPattern("#0");
            } else {
                double multiplier = 1.0 / this.precision;
                Long precisionNumber = new Long(Math.round(multiplier));
                String precisionString = ((Object)precisionNumber).toString();
                int stringLength = precisionString.length() - 1;
                String formatString = "#0";
                if (stringLength > 0) {
                    formatString = formatString + ".";
                    for (int i = 0; i < stringLength; ++i) {
                        formatString = formatString + "#";
                    }
                }
                ((DecimalFormat)this.numberFormat).applyPattern(formatString);
                this.numberFormatSet = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(ModelInterface model) {
        if (model instanceof ValidationInterface) {
            this.setValidator((ValidationInterface)model);
        } else {
            this.setValidator(null);
        }
        if (model instanceof BoundedNumberInterface) {
            if (this.itemTextAdapter != null) {
                this.text.removeTextListener(this.itemTextAdapter);
            }
            this.spinBtn.setModelInterface(model);
            try {
                this.valueInvoked = true;
                Number newNumberValue = this.spinBtn.getNumberValue();
                String newText = null;
                newText = this.numberFormat != null && this.numberFormat instanceof DecimalFormat ? this.numberFormat.format(newNumberValue) : (newNumberValue instanceof Double ? DoubleData.toString((Double)((Double)newNumberValue)) : (newNumberValue instanceof Float ? FloatData.toString((Float)((Float)newNumberValue)) : newNumberValue.toString()));
                this.text.setText(newText);
            }
            finally {
                this.valueInvoked = false;
            }
        }
        if (model instanceof StaticOrderedCollectionInterface) {
            int value;
            if (this.itemTextAdapter != null) {
                this.text.removeTextListener(this.itemTextAdapter);
                this.text.addTextListener(this.itemTextAdapter);
                this.itemTextAdapter.setCollection((StaticOrderedCollectionInterface)model);
            }
            Object item = null;
            int count = ((Countable)model).count();
            if (count > (value = this.spinBtn.getValue())) {
                item = ((StaticOrderedCollectionInterface)model).get(value);
            } else if (count < 0) {
                item = ((StaticOrderedCollectionInterface)model).get(0);
            }
            if (--count < 0) {
                count = 1;
            }
            int itemIndex = 0;
            if (item != null) {
                itemIndex = ((StaticOrderedCollectionInterface)model).getIndex(item, 0);
            }
            BoundedLong boundedLong = new BoundedLong(0L, 0L, (long)count, 1L, 1L);
            this.spinBtn.setModelInterface((ModelInterface)boundedLong);
            try {
                if (this.displayTransform != null) {
                    item = this.displayTransform.transform(item);
                }
            }
            catch (TransformException e) {
                System.out.println("TransformException in refresh " + (Object)((Object)e));
            }
            if (item != null) {
                this.text.setText(item.toString());
            } else {
                this.text.setText("");
            }
            this.spinBtn.setCycleOn(true);
            if (model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
        }
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void setAlarm(Alarm alarm) {
        this.spinBtn.setAlarm(alarm);
    }

    public void setArrowDirection(int d) {
        this.spinBtn.setArrowDirection(d);
        this.invalidate();
        this.validate();
    }

    @Override
    public void setBlockIncrement(int block) {
        this.spinBtn.setBlockIncrement(block);
    }

    public void setColumns(int cols) {
        this.text.setColumns(cols);
    }

    public void setCycleOn(boolean cycle) {
        this.spinBtn.setCycleOn(cycle);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        AutoSizingGridLayout layout = new AutoSizingGridLayout();
        this.spinBtn = new SpinButton();
        this.text = new TextField();
        this.defaultModel = null;
        this.defaultRangeModel = new BoundedDouble();
        this.itemTextAdapter = new ItemTextAdapter();
        this.arrowKeyAdapter = new ArrowKeyAdapter();
        this.arrowKeyAdapter.setSpinButton(this.spinBtn);
        this.prefixPredicate = new PrefixPredicate(" ");
        this.spinBtn.initialize();
        this.text.initialize();
        ((BoundedDouble)this.defaultRangeModel).initialize();
        this.precision = 1.0;
        this.precisionDisplayed = false;
        layout.setRemainderColumn(1);
        layout.setUseColumnRemainder(true);
        layout.setFillCell(true);
        this.numberFormatSet = true;
        ((BoundedDouble)this.defaultRangeModel).setUnitIncrement(1.0);
        ((BoundedDouble)this.defaultRangeModel).setValue(0.0);
        ((BoundedDouble)this.defaultRangeModel).setMaximum(Double.MAX_VALUE);
        ((BoundedDouble)this.defaultRangeModel).setMinimum(-1.7976931348623157E308);
        this.text.setColumns(5);
        this.text.addKeyListener(this.arrowKeyAdapter);
        this.text.setText("0");
        this.spinBtn.setOrientation(1);
        Dimension spinSize = this.spinBtn.getPreferredSize();
        this.spinBtn.setSize(spinSize.width, 0);
        this.spinBtn.addAdjustmentListener(this);
        this.text.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.spinBtn.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.setLayout((LayoutManager)layout);
        this.setModelInterface((ModelInterface)this.defaultRangeModel);
        this.setIDEDnDDropBarrier(true);
        this.setIDEDnDDropTarget(false);
        this.add(this.text);
        this.add(this.spinBtn);
    }

    @Override
    public void setForeground(Color color) {
        if (this.text != null) {
            this.text.setForegroundColor(color);
        }
        super.setForeground(color);
    }

    public void setDelay(long delay) {
        this.spinBtn.setDelay(delay);
    }

    public void setStartInterval(long startInterval) {
        this.spinBtn.setStartInterval(startInterval);
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (Util.unequal((Object)transform, (Object)this.displayTransform)) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            ModelInterface model = this.getModelInterface();
            if (model instanceof StaticOrderedCollectionInterface) {
                int value = this.spinBtn.getValue();
                Object item = ((StaticOrderedCollectionInterface)model).get(value);
                try {
                    if (this.displayTransform != null) {
                        item = this.displayTransform.transform(item);
                    }
                }
                catch (TransformException e) {
                    System.out.println("TransformException in refresh " + (Object)((Object)e));
                }
                if (item != null) {
                    this.text.setText(item.toString());
                } else {
                    this.text.setText("");
                }
            }
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    public final void setDoubleData(double d) {
        this.setNumberValue(new Double(d));
    }

    @Override
    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.spinBtn.setEnabled(e);
            this.text.setEnabled(e);
        }
    }

    @Override
    public void setMaximum(int max) {
        this.spinBtn.setMaximum(max);
    }

    @Override
    public void setMinimum(int min) {
        this.spinBtn.setMinimum(min);
    }

    public void setBlockIncrementNumber(Number block) {
        this.spinBtn.setBlockIncrementNumber(block);
    }

    public void setMaximumNumber(Number max) {
        this.spinBtn.setMaximumNumber(max);
    }

    public void setMinimumNumber(Number min) {
        this.spinBtn.setMinimumNumber(min);
    }

    public void setUnitIncrementNumber(Number unit) {
        this.spinBtn.setUnitIncrementNumber(unit);
    }

    public void setNumberValue(Number value) {
        this.spinBtn.setNumberValue(value);
    }

    public void setNumberFormat(NumberFormat nf) {
        if (nf != this.numberFormat) {
            NumberFormat oldFormat = this.numberFormat;
            this.numberFormat = nf;
            this.numberFormatSet = true;
            this.updateText(this.getNumberValue());
            this.firePropertyChange("numberFormat", oldFormat, this.numberFormat);
        }
    }

    public void setOrientation(int orient) {
        this.spinBtn.setOrientation(orient);
        this.invalidate();
        this.validate();
    }

    public void setPrecision(double p) {
        if (p != this.precision) {
            double oldPrecision = this.precision;
            this.precision = p;
            boolean formatChanged = false;
            NumberFormat newFormat = this.getNumberFormat();
            if (newFormat == null) {
                newFormat = new DecimalFormat();
                formatChanged = true;
            }
            if (this.precision == 0.0 || this.precision == 1.0) {
                ((DecimalFormat)newFormat).applyPattern("#0");
            } else {
                double multiplier = 1.0 / this.precision;
                Long precisionNumber = new Long(Math.round(multiplier));
                String precisionString = ((Object)precisionNumber).toString();
                int stringLength = precisionString.length() - 1;
                String formatString = "#0";
                if (stringLength > 0) {
                    formatString = formatString + ".";
                    for (int i = 0; i < stringLength; ++i) {
                        formatString = formatString + "#";
                    }
                }
                ((DecimalFormat)newFormat).applyPattern(formatString);
            }
            if (formatChanged) {
                this.setNumberFormat(newFormat);
            }
            this.firePropertyChange("precision", new Double(oldPrecision), new Double(this.precision));
        }
    }

    public void setPrecisionDisplayed(boolean b) {
        if (b != this.precisionDisplayed) {
            this.precisionDisplayed = b;
            this.updateText(this.getNumberValue());
            this.firePropertyChange("precisionDisplayed", new Boolean(!b), new Boolean(b));
        }
    }

    public void setText(String txt) {
        this.text.setText(txt);
    }

    @Override
    public void setUnitIncrement(int unit) {
        this.spinBtn.setUnitIncrement(unit);
    }

    @Override
    public void setValue(int val) {
        this.spinBtn.setValue(val);
    }

    @Override
    public void setValidator(ValidationInterface validator) {
        super.setValidator(validator);
        this.text.setValidator(validator);
    }

    @Override
    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        super.setErrorHandler(errorHandler);
        this.text.setErrorHandler(errorHandler);
    }

    @Override
    public void setVisibleAmount(int amt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateText(Number newValue) {
        ModelInterface model = this.getModelInterface();
        if (model instanceof StaticOrderedCollectionInterface) {
            Object item = null;
            int index = newValue.intValue();
            if (index < ((Countable)model).count()) {
                item = ((StaticOrderedCollectionInterface)model).get(index);
            }
            if (item != null) {
                try {
                    try {
                        if (this.displayTransform != null) {
                            item = this.displayTransform.transform(item);
                        }
                    }
                    catch (TransformException e) {
                        System.out.println("TransformException in updateText " + (Object)((Object)e));
                    }
                    if (item != null) {
                        this.valueInvoked = true;
                        this.text.setText(item.toString());
                    }
                }
                finally {
                    this.valueInvoked = false;
                }
                if (this.itemListener != null) {
                    ItemEvent evt = new ItemEvent(this, 701, item, 1);
                    this.itemListener.itemStateChanged(evt);
                }
            }
        } else if (model instanceof BoundedNumberInterface) {
            BoundedNumberInterface numberRange = (BoundedNumberInterface)model;
            String valueText = null;
            valueText = this.numberFormat != null ? this.numberFormat.format(newValue) : (newValue instanceof Double ? DoubleData.toString((Double)((Double)newValue)) : (newValue instanceof Float ? FloatData.toString((Float)((Float)newValue)) : newValue.toString()));
            if (valueText != null) {
                try {
                    this.valueInvoked = true;
                    this.text.setText(valueText);
                }
                finally {
                    this.valueInvoked = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValue(String txt) {
        ModelInterface model = this.getModelInterface();
        if (model instanceof StaticOrderedCollectionInterface) {
            int index;
            this.prefixPredicate.setPrefix(txt);
            Enumeration e = ((StaticOrderedCollectionInterface)model).getItems();
            if (this.displayTransform != null) {
                e = new EnumerationTransform(e, this.displayTransform);
            }
            if ((index = this.prefixPredicate.findItemByPrefix(e, 0)) >= 0) {
                try {
                    this.textInvoked = true;
                    this.spinBtn.setValue(index);
                    if (this.adjustmentListener != null) {
                        this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, index));
                    }
                }
                finally {
                    this.textInvoked = false;
                }
                if (this.itemListener != null) {
                    ItemEvent evt = new ItemEvent(this, 701, ((StaticOrderedCollectionInterface)model).get(index), 1);
                    this.itemListener.itemStateChanged(evt);
                }
            }
        } else if (model instanceof BoundedNumberInterface) {
            BoundedNumberInterface numberRange = (BoundedNumberInterface)model;
            Number value = numberRange.getNumberValue();
            Number txtValue = null;
            try {
                txtValue = this.numberFormat != null ? (Number)this.numberFormat.parse(txt) : (Number)(value instanceof Long ? (Number)new Long(txt) : (Number)new Double(DoubleData.valueOf((String)txt)));
            }
            catch (ParseException e) {
                System.out.println("ParseException for " + txt);
                try {
                    this.valueInvoked = true;
                    DecimalFormat formatter = new DecimalFormat();
                    this.text.setText(formatter.format(value));
                }
                finally {
                    this.valueInvoked = false;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException for " + txt);
                try {
                    this.valueInvoked = true;
                    DecimalFormat formatter = new DecimalFormat();
                    this.text.setText(formatter.format(value));
                }
                finally {
                    this.valueInvoked = false;
                }
            }
            if (txtValue != null) {
                try {
                    this.textInvoked = true;
                    this.spinBtn.setNumberValue(txtValue);
                    if (this.adjustmentListener != null) {
                        this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, txtValue.intValue()));
                    }
                }
                finally {
                    this.textInvoked = false;
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "adjustmentL", this.adjustmentListener);
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    class ArrowKeyAdapter
    implements KeyListener {
        SpinButton spinBtn;

        public void setSpinButton(SpinButton sBtn) {
            this.spinBtn = sBtn;
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 40 && this.spinBtn.isDecrementEnabled()) {
                this.spinBtn.incrementBy(-1, 0);
                SpinBox.this.adjustmentValueChanged(new AdjustmentEvent(this.spinBtn, 601, 2, this.spinBtn.getValue()));
            } else if (keyCode == 38 && this.spinBtn.isIncrementEnabled()) {
                this.spinBtn.incrementBy(1, 0);
                SpinBox.this.adjustmentValueChanged(new AdjustmentEvent(this.spinBtn, 601, 1, this.spinBtn.getValue()));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class ItemTextAdapter
    implements TextListener {
        StaticOrderedCollectionInterface collection;
        PrefixPredicate predicate = new PrefixPredicate(" ");

        public void setCollection(StaticOrderedCollectionInterface c) {
            this.collection = c;
        }

        @Override
        public void textValueChanged(TextEvent e) {
            int index;
            if (this.collection == null) {
                return;
            }
            Object eSource = e.getSource();
            String txt = null;
            if (eSource instanceof TextComponent) {
                txt = ((TextComponent)eSource).getText();
            } else if (eSource instanceof StringDataInterface) {
                txt = ((StringDataInterface)eSource).getText();
            }
            if (txt == null) {
                return;
            }
            TransformInterface transform = SpinBox.this.getDisplayTransform();
            this.predicate.setPrefix(txt.trim());
            if (txt.length() == 0) {
                return;
            }
            Enumeration enumer = this.collection.getItems();
            if (transform != null) {
                enumer = new EnumerationTransform(enumer, transform);
            }
            if ((index = this.predicate.findItemByPrefix(enumer, 0)) >= 0 && index < this.collection.count()) {
                Object item = this.collection.get(index);
                try {
                    if (transform != null) {
                        item = transform.transform(item);
                    }
                }
                catch (TransformException excp) {
                    System.out.println("TransformException in textValueChanged " + (Object)((Object)excp));
                }
                if (item != null && !item.toString().equals(txt)) {
                    SpinBox.this.text.setText(item.toString());
                }
            }
        }
    }
}

