/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.awt.util.Util;
import com.sas.visuals.ButtonListenerInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.SliderInterface;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class SliderListener
extends Component
implements ButtonListenerInterface,
ActionListener {
    static final long serialVersionUID = 6873461102193804276L;
    protected ButtonModelInterface model;
    protected ButtonModelInterface incrementModel;
    protected ButtonModelInterface decrementModel;
    protected SliderInterface trackArea;
    protected Point pressedPoint;
    protected Point offset;

    public SliderListener(ButtonModelInterface btnModel, ButtonModelInterface incModel, ButtonModelInterface decModel, SliderInterface area) {
        this.model = btnModel;
        this.trackArea = area;
        this.incrementModel = incModel;
        this.incrementModel.addActionListener(this);
        this.decrementModel = decModel;
        this.decrementModel.addActionListener(this);
        this.offset = new Point();
    }

    public ButtonModelInterface getIncrementButtonModel() {
        return this.incrementModel;
    }

    public ButtonModelInterface getDecrementButtonModel() {
        return this.decrementModel;
    }

    @Override
    public ButtonModelInterface getButtonModel() {
        return this.model;
    }

    @Override
    public void setButtonModel(ButtonModelInterface btnModel) {
        if (btnModel != this.model) {
            ButtonModelInterface oldModel = btnModel;
            this.model = btnModel;
            this.firePropertyChange("buttonModel", oldModel, this.model);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.pressedPoint == null) {
            return;
        }
        Object eSource = evt.getSource();
        if (eSource == this.incrementModel) {
            if (!this.trackArea.getIncrementBounds().contains(this.pressedPoint)) {
                this.incrementModel.setRollover(false);
                this.incrementModel.setArmed(false);
            }
        } else if (eSource == this.decrementModel && !this.trackArea.getDecrementBounds().contains(this.pressedPoint)) {
            this.decrementModel.setRollover(false);
            this.decrementModel.setArmed(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.model != null && evt.getKeyCode() == 32) {
            this.model.setArmed(true);
            this.model.setPressed(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (this.model != null && evt.getKeyCode() == 32) {
            this.model.setPressed(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Point evtPoint = evt.getPoint();
        if (this.model.isPressed() && !this.model.isDisabled()) {
            evtPoint.translate(-this.offset.x, -this.offset.y);
            this.trackArea.setThumbPosition(evtPoint);
        } else if (this.incrementModel.isPressed()) {
            this.pressedPoint = evtPoint;
            if (this.trackArea.getIncrementBounds().contains(evtPoint)) {
                this.incrementModel.setRollover(true);
                this.incrementModel.setArmed(true);
            } else {
                this.incrementModel.setRollover(false);
                this.incrementModel.setArmed(false);
            }
        } else if (this.decrementModel.isPressed()) {
            this.pressedPoint = evtPoint;
            if (this.trackArea.getDecrementBounds().contains(evtPoint)) {
                this.decrementModel.setRollover(true);
                this.decrementModel.setArmed(true);
            } else {
                this.decrementModel.setRollover(false);
                this.decrementModel.setArmed(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.incrementModel.isPressed() || this.decrementModel.isPressed() || this.model.isPressed()) {
            return;
        }
        this.pressedPoint = evt.getPoint();
        if (Util.isRightMouseButton(evt) && !this.model.isDisabled()) {
            this.trackArea.setThumbPosition(this.pressedPoint);
            this.model.setArmed(true);
            this.model.setPressed(true);
            this.offset.x = 0;
            this.offset.y = 0;
        } else if (this.trackArea.getIncrementBounds().contains(this.pressedPoint)) {
            this.incrementModel.setArmed(true);
            this.incrementModel.setPressed(true);
        } else if (this.trackArea.getDecrementBounds().contains(this.pressedPoint)) {
            this.decrementModel.setArmed(true);
            this.decrementModel.setPressed(true);
        } else {
            this.model.setArmed(true);
            this.model.setPressed(true);
            Point thumbPt = this.trackArea.getThumbPosition();
            this.offset.x = this.pressedPoint.x - thumbPt.x;
            this.offset.y = this.pressedPoint.y - thumbPt.y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.incrementModel.isPressed()) {
            this.incrementModel.setPressed(false);
        } else if (this.decrementModel.isPressed()) {
            this.decrementModel.setPressed(false);
        } else {
            this.model.setPressed(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        Point evtPoint = evt.getPoint();
        if (this.trackArea.getIncrementBounds().contains(evtPoint)) {
            this.incrementModel.setRollover(true);
        } else if (this.trackArea.getDecrementBounds().contains(evtPoint)) {
            this.decrementModel.setRollover(true);
        } else {
            this.model.setRollover(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        Point evtPoint = evt.getPoint();
        if (this.trackArea.getIncrementBounds().contains(evtPoint)) {
            this.incrementModel.setRollover(false);
        } else if (this.trackArea.getDecrementBounds().contains(evtPoint)) {
            this.decrementModel.setRollover(false);
        } else {
            this.model.setRollover(false);
        }
    }
}

