/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.AWTEventMulticaster2;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.OrderedCollection;
import com.sas.util.transforms.CompositeTransform;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.RB;
import com.sas.visuals.SelectableInterface;
import com.sas.visuals.SelectableInterfaceToItemTransform;
import com.sas.visuals.SelectionGroupInterface;
import java.awt.AWTEventMulticaster;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SelectionGroup
extends OrderedCollection
implements PropertyChangeListener,
SelectionGroupInterface {
    static final long serialVersionUID = -1551756698888183122L;
    public static String RB_KEY = "SelectionGroup.";
    private boolean deselectable;
    private SelectableInterface currentSelection;
    private transient boolean currentSet;
    private transient boolean removeSet;
    private transient ItemListener itemListener;
    private TransformInterface displayTransform;
    private TransformInterface inputTransform;
    private TransformInterface outputTransform;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "deselectable"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"deselectableSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"deselectable.pd.txt")}}, {{"Name", "displayTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"displayTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"inputTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "items"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"items.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"items.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ComponentNameEnumerationEditor"}}, {{"Name", "itemsData"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"itemsData.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"itemsData.pd.txt")}}, {{"Name", "outputTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"outputTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "selectedIndex"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}}, {{"Name", "selectedItem"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    public void add(Object selectableObject) {
        this.add(selectableObject, this.count());
    }

    public synchronized void add(Object selectableObject, int index) {
        SelectableInterface selectable = (SelectableInterface)selectableObject;
        if (!this.contains(selectableObject)) {
            ButtonModelInterface btnModel = selectable.getButtonModel();
            if (btnModel == null) {
                return;
            }
            super.add(selectableObject, index);
            SelectionGroupInterface oldSelectionGroup = btnModel.getSelectionGroup();
            if (oldSelectionGroup != null) {
                oldSelectionGroup.remove(selectable);
            }
            btnModel.setSelectionGroup(this);
            if (this.currentSelection == null && !this.deselectable) {
                this.currentSelection = selectable;
                btnModel.setSelected(true);
                this.firePropertyChange("selectedItem", null, this.currentSelection.getItem());
                this.firePropertyChange("selectedIndex", null, new Integer(0));
            } else {
                btnModel.setSelected(false);
            }
            selectable.setDisplayTransform(this.displayTransform);
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void addItems(Enumeration items) {
        this.addItems(items, this.count());
    }

    public synchronized void addItems(Enumeration items, int index) {
        try {
            ButtonModelInterface btnModel;
            SelectableInterface selectable;
            Vector<SelectableInterface> tmpItems = new Vector<SelectableInterface>();
            while (items.hasMoreElements()) {
                selectable = (SelectableInterface)items.nextElement();
                if (this.contains(selectable) || tmpItems.contains(selectable)) continue;
                tmpItems.addElement(selectable);
                btnModel = selectable.getButtonModel();
                SelectionGroupInterface oldSelectionGroup = btnModel.getSelectionGroup();
                if (oldSelectionGroup != null) {
                    oldSelectionGroup.remove(selectable);
                }
                btnModel.setSelectionGroup(this);
                btnModel.setSelected(false);
                selectable.setDisplayTransform(this.displayTransform);
            }
            super.addItems(tmpItems.elements(), index);
            if (this.currentSelection == null && !this.deselectable && tmpItems.size() > 0) {
                selectable = (SelectableInterface)tmpItems.elementAt(0);
                btnModel = selectable.getButtonModel();
                this.currentSelection = selectable;
                btnModel.setSelected(true);
                this.firePropertyChange("selectedItem", null, this.currentSelection.getItem());
                this.firePropertyChange("selectedIndex", null, new Integer(0));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public synchronized boolean containsItem(Object item) {
        if (item == null) {
            return false;
        }
        Object itemData = item;
        if (this.inputTransform == null) {
            itemData = item;
        } else {
            try {
                itemData = this.inputTransform.transform(itemData);
            }
            catch (TransformException te) {
                return false;
            }
        }
        Enumeration items = this.getItems();
        while (items.hasMoreElements()) {
            SelectableInterface object = (SelectableInterface)items.nextElement();
            if (!com.sas.util.Util.equal((Object)object.getItem(), (Object)itemData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.currentSelection != null) {
            Object[] items = new Object[]{this.currentSelection};
            return items;
        }
        return null;
    }

    @Override
    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    @Override
    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    @Override
    public synchronized Enumeration getItemsData() {
        SelectableInterfaceToItemTransform itemTransform = new SelectableInterfaceToItemTransform();
        CompositeTransform outputItemTransform = new CompositeTransform((TransformInterface)itemTransform, this.outputTransform);
        return new EnumerationTransform(this.getItems(), (TransformInterface)outputItemTransform);
    }

    @Override
    public Object getItem(int index) {
        SelectableInterface selectableObject = (SelectableInterface)this.get(index);
        Object item = selectableObject.getItem();
        Object newItem = null;
        if (this.outputTransform == null) {
            return item;
        }
        try {
            newItem = this.outputTransform.transform(item);
        }
        catch (TransformException te) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"transform.ex.txt"));
        }
        return newItem;
    }

    @Override
    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.outputTransform) {
            this.firePropertyChange("outputTransform", null, this.outputTransform);
        } else if (event.getSource() == this.inputTransform) {
            this.firePropertyChange("inputTransform", null, this.inputTransform);
        } else if (event.getSource() == this.displayTransform) {
            this.firePropertyChange("displayTransform", null, this.displayTransform);
        }
    }

    @Override
    public void setDisplayTransform(TransformInterface transform) {
        if (this.displayTransform != transform) {
            TransformInterface oldTransform = this.displayTransform;
            if (oldTransform != null) {
                Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            this.displayTransform = transform;
            if (this.displayTransform != null) {
                Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)this);
            }
            Enumeration items = this.getItems();
            while (items.hasMoreElements()) {
                SelectableInterface object = (SelectableInterface)items.nextElement();
                object.setDisplayTransform(this.displayTransform);
            }
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    @Override
    public void setInputTransform(TransformInterface transform) {
        if (this.inputTransform != transform) {
            TransformInterface oldTransform = this.inputTransform;
            if (oldTransform != null) {
                Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            this.inputTransform = transform;
            if (this.inputTransform != null) {
                Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)this);
            }
            this.firePropertyChange("inputTransform", oldTransform, this.inputTransform);
        }
    }

    @Override
    public void setOutputTransform(TransformInterface transform) {
        if (this.outputTransform != transform) {
            TransformInterface oldTransform = this.outputTransform;
            if (oldTransform != null) {
                Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            this.outputTransform = transform;
            if (this.outputTransform != null) {
                Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)this);
            }
            this.firePropertyChange("outputTransform", oldTransform, this.outputTransform);
        }
    }

    @Override
    public int getIndex(SelectableInterface selectableObject) {
        return this.getIndex(selectableObject, 0);
    }

    @Override
    public synchronized int getItemIndex(Object item) {
        Object itemData = item;
        if (this.inputTransform == null) {
            itemData = item;
        } else {
            try {
                itemData = this.inputTransform.transform(itemData);
            }
            catch (TransformException te) {
                return -1;
            }
        }
        int i = 0;
        Enumeration items = this.getItems();
        while (items.hasMoreElements()) {
            SelectableInterface object = (SelectableInterface)items.nextElement();
            if (com.sas.util.Util.equal((Object)object.getItem(), (Object)itemData)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object getSelectedItem() {
        Object newItem = null;
        if (this.outputTransform == null) {
            if (this.currentSelection != null) {
                return this.currentSelection.getItem();
            }
            return null;
        }
        if (this.currentSelection != null) {
            try {
                newItem = this.outputTransform.transform(this.currentSelection.getItem());
            }
            catch (TransformException transformException) {}
        } else {
            try {
                newItem = this.outputTransform.transform(null);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return newItem;
    }

    @Override
    public int getSelectedIndex() {
        if (this.currentSelection != null) {
            return this.getIndex(this.currentSelection, 0);
        }
        return -1;
    }

    @Override
    public boolean isDeselectable() {
        return this.deselectable;
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public synchronized boolean remove(Object selectableObject) {
        int index = this.getIndex(selectableObject, 0);
        if (index > -1) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public synchronized void removeAll() {
        for (int i = this.count() - 1; i >= 0; --i) {
            this.removeAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object removeAt(int index) {
        Object item = this.get(index);
        if (!this.removeSet) {
            try {
                this.removeSet = true;
                super.removeAt(index);
                SelectableInterface selectable = (SelectableInterface)item;
                ButtonModelInterface btnModel = selectable.getButtonModel();
                btnModel.setSelectionGroup(null);
                if (com.sas.util.Util.equal((Object)selectable, (Object)this.currentSelection)) {
                    if (this.count() > 0) {
                        this.select((SelectableInterface)this.get(this.count() - 1));
                    } else {
                        this.currentSelection = null;
                    }
                }
            }
            finally {
                this.removeSet = false;
            }
        }
        return item;
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    @Override
    public void select(SelectableInterface selectableObject) {
        try {
            if (selectableObject == null) {
                this.fireVetoableChange("selectedIndex", new Integer(this.getSelectedIndex()), new Integer(-1));
                this.fireVetoableChange("selectedItem", this.getSelectedItem(), null);
            } else {
                int newIndex = this.getIndex(selectableObject);
                this.fireVetoableChange("selectedIndex", new Integer(this.getSelectedIndex()), new Integer(newIndex));
                this.fireVetoableChange("selectedItem", this.getSelectedItem(), this.getItem(newIndex));
            }
        }
        catch (PropertyVetoException e) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"propertyVeto.ex.txt"));
            return;
        }
        if (this.contains(selectableObject) || selectableObject == null) {
            int oldSelectedIndex = this.getSelectedIndex();
            Object oldSelectedItem = this.getSelectedItem();
            if (selectableObject != null) {
                ButtonModelInterface newBtnModel = selectableObject.getButtonModel();
                if (selectableObject != this.currentSelection) {
                    if (this.currentSelection != null) {
                        ButtonModelInterface oldBtnModel = this.currentSelection.getButtonModel();
                        oldBtnModel.setSelected(false);
                    }
                    if (newBtnModel != null) {
                        newBtnModel.setSelected(true);
                    }
                    this.currentSelection = selectableObject;
                    this.processItemEvent(new ItemEvent(this, 701, oldSelectedItem, 2));
                    this.processItemEvent(new ItemEvent(this, 701, this.getSelectedItem(), 1));
                    this.firePropertyChange("selectedItem", oldSelectedItem, this.getSelectedItem());
                    this.firePropertyChange("selectedIndex", new Integer(oldSelectedIndex), new Integer(this.getSelectedIndex()));
                } else if (this.deselectable) {
                    newBtnModel.setSelected(false);
                    this.currentSelection = null;
                    this.processItemEvent(new ItemEvent(this, 701, null, 2));
                    this.firePropertyChange("selectedItem", oldSelectedItem, this.getSelectedItem());
                    this.firePropertyChange("selectedIndex", new Integer(oldSelectedIndex), new Integer(this.getSelectedIndex()));
                }
            } else if (this.currentSelection != null && this.deselectable) {
                ButtonModelInterface oldBtnModel = this.currentSelection.getButtonModel();
                oldBtnModel.setSelected(false);
                this.currentSelection = null;
                this.firePropertyChange("selectedItem", oldSelectedItem, this.getSelectedItem());
                this.firePropertyChange("selectedIndex", new Integer(oldSelectedIndex), new Integer(this.getSelectedIndex()));
            }
        }
    }

    public void set(int index, Object selectableObject) {
        SelectableInterface selectable = (SelectableInterface)selectableObject;
        super.set(index, (Object)selectable);
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.displayTransform = null;
        this.inputTransform = null;
        this.outputTransform = null;
        this.currentSelection = null;
        this.deselectable = false;
        this.currentSet = false;
    }

    @Override
    public void setDeselectable(boolean deselect) {
        if (deselect != this.deselectable) {
            this.deselectable = deselect;
            this.firePropertyChange("deselectable", new Boolean(!this.deselectable), new Boolean(this.deselectable));
            if (this.currentSelection == null && this.count() > 0) {
                this.select((SelectableInterface)this.get(0));
            }
        }
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        Object item = null;
        if (this.inputTransform == null) {
            item = selectedItem;
        } else {
            try {
                item = this.inputTransform.transform(selectedItem);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (item == null) {
            this.select(null);
            return;
        }
        int selIndex = -1;
        for (int i = 0; i < this.count(); ++i) {
            Object itemData = ((SelectableInterface)this.get(i)).getItem();
            if (itemData == null || !com.sas.util.Util.equal((Object)itemData, (Object)item)) continue;
            selIndex = i;
            break;
        }
        if (selIndex >= 0) {
            this.select((SelectableInterface)this.get(selIndex));
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index != this.getSelectedIndex()) {
            if (index >= 0) {
                this.select((SelectableInterface)this.get(index));
            } else if (this.isDeselectable()) {
                this.select(null);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.displayTransform != null) {
            Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)this);
        }
        if (this.inputTransform != null) {
            Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)this);
        }
        if (this.outputTransform != null) {
            Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)this);
        }
    }
}

