/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class ScrollbarLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = 5136995273478952019L;
    public static final String CENTER = "Center";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    protected Component[] _scrollbar = new Component[2];
    protected Component _contents = null;
    protected int _location = this._location;

    public ScrollbarLayout() {
        this(10);
    }

    public ScrollbarLayout(int location) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (NORTH.equalsIgnoreCase(name) || SOUTH.equalsIgnoreCase(name) || EAST.equalsIgnoreCase(name) || WEST.equalsIgnoreCase(name)) {
            if (comp instanceof Adjustable) {
                Adjustable sb = (Adjustable)((Object)comp);
                int orientation = sb.getOrientation();
                if (orientation == 0) {
                    this._scrollbar[0] = comp;
                } else {
                    this._scrollbar[1] = comp;
                }
            }
        } else if (CENTER.equalsIgnoreCase(name)) {
            this._contents = comp;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int x = 0;
        int y = 0;
        int width = size.width;
        int height = size.height;
        int cX = x + insets.left;
        int cY = y + insets.top;
        int cWidth = width - (insets.left + insets.right);
        int cHeight = height - (insets.top + insets.bottom);
        Dimension hSize = this._scrollbar[0] != null ? (this._scrollbar[0].isVisible() ? this._scrollbar[0].getPreferredSize() : new Dimension(0, 0)) : new Dimension(0, 0);
        Dimension vSize = this._scrollbar[1] != null ? (this._scrollbar[1].isVisible() ? this._scrollbar[1].getPreferredSize() : new Dimension(0, 0)) : new Dimension(0, 0);
        if (this._scrollbar[0] != null && this._scrollbar[0].isVisible()) {
            if ((this._location & 1) != 0) {
                if ((this._location & 4) != 0) {
                    this._scrollbar[0].setBounds(x + vSize.width + insets.left, y + insets.top, width - (insets.right + insets.left + vSize.width), hSize.height);
                } else {
                    this._scrollbar[0].setBounds(x + insets.left, y + insets.top, width - (insets.right + insets.left + vSize.width), hSize.height);
                }
                cY += hSize.height;
            } else if ((this._location & 4) != 0) {
                this._scrollbar[0].setBounds(x + vSize.width + insets.left, y + height - (hSize.height + insets.bottom), width - (insets.right + insets.left + vSize.width), hSize.height);
            } else {
                this._scrollbar[0].setBounds(x + insets.left, y + height - (hSize.height + insets.bottom), width - (insets.right + insets.left + vSize.width), hSize.height);
            }
            cHeight -= hSize.height;
            this._scrollbar[0].validate();
        }
        if (this._scrollbar[1] != null && this._scrollbar[1].isVisible()) {
            if ((this._location & 4) != 0) {
                if ((this._location & 1) != 0) {
                    this._scrollbar[1].setBounds(x + insets.left, y + insets.top + hSize.height, vSize.width, height - (hSize.height + insets.top + insets.bottom));
                } else {
                    this._scrollbar[1].setBounds(x + insets.left, y + insets.top, vSize.width, height - (hSize.height + insets.bottom));
                }
                cX += vSize.width;
            } else if ((this._location & 1) != 0) {
                this._scrollbar[1].setBounds(x + width - (vSize.width + insets.right), y + insets.top + hSize.height, vSize.width, height - (hSize.height + insets.top + insets.bottom));
            } else {
                this._scrollbar[1].setBounds(x + width - (vSize.width + insets.right), y + insets.top, vSize.width, height - (hSize.height + insets.top + insets.bottom));
            }
            cWidth -= vSize.width;
            this._scrollbar[1].validate();
        }
        if (this._contents != null) {
            this._contents.setBounds(cX, cY, cWidth, cHeight);
            this._contents.validate();
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension cSize = null;
        Dimension hSize = null;
        Dimension vSize = null;
        if (this._contents != null && this._contents.isVisible()) {
            cSize = this._contents.getMinimumSize();
        }
        if (this._scrollbar[0] != null && this._scrollbar[0].isVisible()) {
            hSize = this._scrollbar[0].getMinimumSize();
        }
        if (this._scrollbar[1] != null && this._scrollbar[1].isVisible()) {
            vSize = this._scrollbar[1].getMinimumSize();
        }
        return this.layoutSize(parent, cSize, hSize, vSize);
    }

    private Dimension layoutSize(Container parent, Dimension cSize, Dimension hSize, Dimension vSize) {
        int width = 0;
        if (cSize != null) {
            width = cSize.width;
        }
        if (hSize != null) {
            width = Math.max(width, hSize.width);
        }
        if (vSize != null) {
            width += vSize.width;
        }
        int height = 0;
        if (cSize != null) {
            height = cSize.height;
        }
        if (vSize != null) {
            height = Math.max(height, vSize.height);
        }
        if (hSize != null) {
            height += hSize.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension cSize = null;
        Dimension hSize = null;
        Dimension vSize = null;
        if (this._contents != null && this._contents.isVisible()) {
            cSize = this._contents.getPreferredSize();
        }
        if (this._scrollbar[0] != null && this._scrollbar[0].isVisible()) {
            hSize = this._scrollbar[0].getPreferredSize();
        }
        if (this._scrollbar[1] != null && this._scrollbar[1].isVisible()) {
            vSize = this._scrollbar[1].getPreferredSize();
        }
        return this.layoutSize(parent, cSize, hSize, vSize);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp.equals(this._contents)) {
            this._contents = null;
        } else if (comp.equals(this._scrollbar[1])) {
            this._scrollbar[1] = null;
        } else if (comp.equals(this._scrollbar[0])) {
            this._scrollbar[0] = null;
        }
    }
}

