/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Container;
import java.awt.Dimension;

class ScrollbarButtonLayout
extends AutoSizingGridLayout {
    static final long serialVersionUID = 8844995022646442950L;
    int orientation;

    public ScrollbarButtonLayout(int rows, int cols, int hgap, int vgap, boolean fillCell, boolean useRowRemainder, boolean useColumnRemainder) {
        super(rows, cols, hgap, vgap, fillCell, useRowRemainder, useColumnRemainder);
        this.orientation = rows == 0 || rows > cols ? 1 : 0;
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
        int nrows = this.getRows();
        int ncols = this.getColumns();
        if (this.orientation == 0) {
            if (nrows > ncols) {
                this.setColumns(nrows);
            }
            this.setRows(1);
        } else if (this.orientation == 1) {
            if (ncols > nrows) {
                this.setRows(ncols);
            }
            this.setColumns(1);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int[] getPreferredColumnWidths(Container parent, int ncols) {
        int ncomponents = parent.getComponentCount();
        int[] columnWidths = new int[ncols];
        for (int col = 0; col < ncols; ++col) {
            for (int i = 0; i < ncomponents; ++i) {
                int column = i % ncols;
                if (column != col) continue;
                Dimension size = parent.getComponent(i).getPreferredSize();
                if (size.width <= columnWidths[column]) continue;
                columnWidths[column] = size.width;
            }
        }
        if (this.orientation == 0 && ncols > 0) {
            Dimension parentSize = parent.getSize();
            int componentSize = columnWidths[0] + columnWidths[ncols - 1];
            if (parentSize.width < componentSize) {
                int halfParentSize;
                columnWidths[0] = halfParentSize = parentSize.width / 2;
                columnWidths[ncols - 1] = halfParentSize;
            }
        }
        return columnWidths;
    }

    protected int[] getPreferredRowHeights(Container parent, int nrows, int ncols) {
        int ncomponents = parent.getComponentCount();
        int[] rowHeights = new int[nrows];
        for (int row = 0; row < nrows; ++row) {
            for (int i = 0; i < ncomponents; ++i) {
                int componentRow = i / ncols;
                if (componentRow != row) continue;
                Dimension size = parent.getComponent(i).getPreferredSize();
                if (size.height <= rowHeights[componentRow]) continue;
                rowHeights[componentRow] = size.height;
            }
        }
        if (this.orientation == 1 && nrows > 0) {
            Dimension parentSize = parent.getSize();
            int componentSize = rowHeights[0] + rowHeights[nrows - 1];
            if (parentSize.height < componentSize) {
                int halfParentSize;
                rowHeights[0] = halfParentSize = parentSize.height / 2;
                rowHeights[nrows - 1] = halfParentSize;
            }
        }
        return rowHeights;
    }
}

